/*
// $Id: //open/dev/farrago/src/org/eigenbase/dmv/DmvResponse.java#4 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2007-2009 The Eigenbase Project
// Copyright (C) 2007-2009 SQLstream, Inc.
// Copyright (C) 2007-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.dmv;

import java.util.*;

import javax.jmi.reflect.*;

import org.eigenbase.jmi.*;


/**
 * DmvResponse represents the result of a DMV query.
 *
 * @author John Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/dmv/DmvResponse.java#4 $
 */
public class DmvResponse
{
    //~ Instance fields --------------------------------------------------------

    private final Collection<RefObject> searchResult;

    private final JmiDependencyGraph transformationResult;

    //~ Constructors -----------------------------------------------------------

    public DmvResponse(
        Collection<RefObject> searchResult,
        JmiDependencyGraph transformationResult)
    {
        this.searchResult = searchResult;
        this.transformationResult = transformationResult;
    }

    //~ Methods ----------------------------------------------------------------

    public Collection<RefObject> getSearchResult()
    {
        return searchResult;
    }

    public JmiDependencyGraph getTransformationResult()
    {
        return transformationResult;
    }
}

// End DmvResponse.java
