// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// To regenerate run the gen script in src/coreclr/tools/Common/JitInterface/ThunkGenerator
// and follow the instructions in docs/project/updating-jitinterface.md

#include "standardpch.h"
#include "icorjitinfo.h"
#include "superpmi-shim-counter.h"
#include "icorjitcompiler.h"
#include "spmiutil.h"


bool interceptor_ICJI::isIntrinsic(
          CORINFO_METHOD_HANDLE ftn)
{
    mcs->AddCall("isIntrinsic");
    return original_ICorJitInfo->isIntrinsic(ftn);
}

bool interceptor_ICJI::notifyMethodInfoUsage(
          CORINFO_METHOD_HANDLE ftn)
{
    mcs->AddCall("notifyMethodInfoUsage");
    return original_ICorJitInfo->notifyMethodInfoUsage(ftn);
}

uint32_t interceptor_ICJI::getMethodAttribs(
          CORINFO_METHOD_HANDLE ftn)
{
    mcs->AddCall("getMethodAttribs");
    return original_ICorJitInfo->getMethodAttribs(ftn);
}

void interceptor_ICJI::setMethodAttribs(
          CORINFO_METHOD_HANDLE ftn,
          CorInfoMethodRuntimeFlags attribs)
{
    mcs->AddCall("setMethodAttribs");
    original_ICorJitInfo->setMethodAttribs(ftn, attribs);
}

void interceptor_ICJI::getMethodSig(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_SIG_INFO* sig,
          CORINFO_CLASS_HANDLE memberParent)
{
    mcs->AddCall("getMethodSig");
    original_ICorJitInfo->getMethodSig(ftn, sig, memberParent);
}

bool interceptor_ICJI::getMethodInfo(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_METHOD_INFO* info,
          CORINFO_CONTEXT_HANDLE context)
{
    mcs->AddCall("getMethodInfo");
    return original_ICorJitInfo->getMethodInfo(ftn, info, context);
}

bool interceptor_ICJI::haveSameMethodDefinition(
          CORINFO_METHOD_HANDLE meth1Hnd,
          CORINFO_METHOD_HANDLE meth2Hnd)
{
    mcs->AddCall("haveSameMethodDefinition");
    return original_ICorJitInfo->haveSameMethodDefinition(meth1Hnd, meth2Hnd);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getTypeDefinition(
          CORINFO_CLASS_HANDLE type)
{
    mcs->AddCall("getTypeDefinition");
    return original_ICorJitInfo->getTypeDefinition(type);
}

CorInfoInline interceptor_ICJI::canInline(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd)
{
    mcs->AddCall("canInline");
    return original_ICorJitInfo->canInline(callerHnd, calleeHnd);
}

void interceptor_ICJI::beginInlining(
          CORINFO_METHOD_HANDLE inlinerHnd,
          CORINFO_METHOD_HANDLE inlineeHnd)
{
    mcs->AddCall("beginInlining");
    original_ICorJitInfo->beginInlining(inlinerHnd, inlineeHnd);
}

void interceptor_ICJI::reportInliningDecision(
          CORINFO_METHOD_HANDLE inlinerHnd,
          CORINFO_METHOD_HANDLE inlineeHnd,
          CorInfoInline inlineResult,
          const char* reason)
{
    mcs->AddCall("reportInliningDecision");
    original_ICorJitInfo->reportInliningDecision(inlinerHnd, inlineeHnd, inlineResult, reason);
}

bool interceptor_ICJI::canTailCall(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE declaredCalleeHnd,
          CORINFO_METHOD_HANDLE exactCalleeHnd,
          bool fIsTailPrefix)
{
    mcs->AddCall("canTailCall");
    return original_ICorJitInfo->canTailCall(callerHnd, declaredCalleeHnd, exactCalleeHnd, fIsTailPrefix);
}

void interceptor_ICJI::reportTailCallDecision(
          CORINFO_METHOD_HANDLE callerHnd,
          CORINFO_METHOD_HANDLE calleeHnd,
          bool fIsTailPrefix,
          CorInfoTailCall tailCallResult,
          const char* reason)
{
    mcs->AddCall("reportTailCallDecision");
    original_ICorJitInfo->reportTailCallDecision(callerHnd, calleeHnd, fIsTailPrefix, tailCallResult, reason);
}

void interceptor_ICJI::getEHinfo(
          CORINFO_METHOD_HANDLE ftn,
          unsigned EHnumber,
          CORINFO_EH_CLAUSE* clause)
{
    mcs->AddCall("getEHinfo");
    original_ICorJitInfo->getEHinfo(ftn, EHnumber, clause);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getMethodClass(
          CORINFO_METHOD_HANDLE method)
{
    mcs->AddCall("getMethodClass");
    return original_ICorJitInfo->getMethodClass(method);
}

void interceptor_ICJI::getMethodVTableOffset(
          CORINFO_METHOD_HANDLE method,
          unsigned* offsetOfIndirection,
          unsigned* offsetAfterIndirection,
          bool* isRelative)
{
    mcs->AddCall("getMethodVTableOffset");
    original_ICorJitInfo->getMethodVTableOffset(method, offsetOfIndirection, offsetAfterIndirection, isRelative);
}

bool interceptor_ICJI::resolveVirtualMethod(
          CORINFO_DEVIRTUALIZATION_INFO* info)
{
    mcs->AddCall("resolveVirtualMethod");
    return original_ICorJitInfo->resolveVirtualMethod(info);
}

CORINFO_METHOD_HANDLE interceptor_ICJI::getUnboxedEntry(
          CORINFO_METHOD_HANDLE ftn,
          bool* requiresInstMethodTableArg)
{
    mcs->AddCall("getUnboxedEntry");
    return original_ICorJitInfo->getUnboxedEntry(ftn, requiresInstMethodTableArg);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getDefaultComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    mcs->AddCall("getDefaultComparerClass");
    return original_ICorJitInfo->getDefaultComparerClass(elemType);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getDefaultEqualityComparerClass(
          CORINFO_CLASS_HANDLE elemType)
{
    mcs->AddCall("getDefaultEqualityComparerClass");
    return original_ICorJitInfo->getDefaultEqualityComparerClass(elemType);
}

void interceptor_ICJI::expandRawHandleIntrinsic(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    mcs->AddCall("expandRawHandleIntrinsic");
    original_ICorJitInfo->expandRawHandleIntrinsic(pResolvedToken, callerHandle, pResult);
}

bool interceptor_ICJI::isIntrinsicType(
          CORINFO_CLASS_HANDLE classHnd)
{
    mcs->AddCall("isIntrinsicType");
    return original_ICorJitInfo->isIntrinsicType(classHnd);
}

CorInfoCallConvExtension interceptor_ICJI::getUnmanagedCallConv(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig,
          bool* pSuppressGCTransition)
{
    mcs->AddCall("getUnmanagedCallConv");
    return original_ICorJitInfo->getUnmanagedCallConv(method, callSiteSig, pSuppressGCTransition);
}

bool interceptor_ICJI::pInvokeMarshalingRequired(
          CORINFO_METHOD_HANDLE method,
          CORINFO_SIG_INFO* callSiteSig)
{
    mcs->AddCall("pInvokeMarshalingRequired");
    return original_ICorJitInfo->pInvokeMarshalingRequired(method, callSiteSig);
}

bool interceptor_ICJI::satisfiesMethodConstraints(
          CORINFO_CLASS_HANDLE parent,
          CORINFO_METHOD_HANDLE method)
{
    mcs->AddCall("satisfiesMethodConstraints");
    return original_ICorJitInfo->satisfiesMethodConstraints(parent, method);
}

void interceptor_ICJI::methodMustBeLoadedBeforeCodeIsRun(
          CORINFO_METHOD_HANDLE method)
{
    mcs->AddCall("methodMustBeLoadedBeforeCodeIsRun");
    original_ICorJitInfo->methodMustBeLoadedBeforeCodeIsRun(method);
}

void interceptor_ICJI::getGSCookie(
          GSCookie* pCookieVal,
          GSCookie** ppCookieVal)
{
    mcs->AddCall("getGSCookie");
    original_ICorJitInfo->getGSCookie(pCookieVal, ppCookieVal);
}

void interceptor_ICJI::setPatchpointInfo(
          PatchpointInfo* patchpointInfo)
{
    mcs->AddCall("setPatchpointInfo");
    original_ICorJitInfo->setPatchpointInfo(patchpointInfo);
}

PatchpointInfo* interceptor_ICJI::getOSRInfo(
          unsigned* ilOffset)
{
    mcs->AddCall("getOSRInfo");
    return original_ICorJitInfo->getOSRInfo(ilOffset);
}

void interceptor_ICJI::resolveToken(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    mcs->AddCall("resolveToken");
    original_ICorJitInfo->resolveToken(pResolvedToken);
}

void interceptor_ICJI::findSig(
          CORINFO_MODULE_HANDLE module,
          unsigned sigTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    mcs->AddCall("findSig");
    original_ICorJitInfo->findSig(module, sigTOK, context, sig);
}

void interceptor_ICJI::findCallSiteSig(
          CORINFO_MODULE_HANDLE module,
          unsigned methTOK,
          CORINFO_CONTEXT_HANDLE context,
          CORINFO_SIG_INFO* sig)
{
    mcs->AddCall("findCallSiteSig");
    original_ICorJitInfo->findCallSiteSig(module, methTOK, context, sig);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getTokenTypeAsHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken)
{
    mcs->AddCall("getTokenTypeAsHandle");
    return original_ICorJitInfo->getTokenTypeAsHandle(pResolvedToken);
}

int interceptor_ICJI::getStringLiteral(
          CORINFO_MODULE_HANDLE module,
          unsigned metaTOK,
          char16_t* buffer,
          int bufferSize,
          int startIndex)
{
    mcs->AddCall("getStringLiteral");
    return original_ICorJitInfo->getStringLiteral(module, metaTOK, buffer, bufferSize, startIndex);
}

size_t interceptor_ICJI::printObjectDescription(
          CORINFO_OBJECT_HANDLE handle,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    mcs->AddCall("printObjectDescription");
    return original_ICorJitInfo->printObjectDescription(handle, buffer, bufferSize, pRequiredBufferSize);
}

CorInfoType interceptor_ICJI::asCorInfoType(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("asCorInfoType");
    return original_ICorJitInfo->asCorInfoType(cls);
}

const char* interceptor_ICJI::getClassNameFromMetadata(
          CORINFO_CLASS_HANDLE cls,
          const char** namespaceName)
{
    mcs->AddCall("getClassNameFromMetadata");
    return original_ICorJitInfo->getClassNameFromMetadata(cls, namespaceName);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getTypeInstantiationArgument(
          CORINFO_CLASS_HANDLE cls,
          unsigned index)
{
    mcs->AddCall("getTypeInstantiationArgument");
    return original_ICorJitInfo->getTypeInstantiationArgument(cls, index);
}

size_t interceptor_ICJI::printClassName(
          CORINFO_CLASS_HANDLE cls,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    mcs->AddCall("printClassName");
    return original_ICorJitInfo->printClassName(cls, buffer, bufferSize, pRequiredBufferSize);
}

bool interceptor_ICJI::isValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("isValueClass");
    return original_ICorJitInfo->isValueClass(cls);
}

uint32_t interceptor_ICJI::getClassAttribs(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getClassAttribs");
    return original_ICorJitInfo->getClassAttribs(cls);
}

const char* interceptor_ICJI::getClassAssemblyName(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getClassAssemblyName");
    return original_ICorJitInfo->getClassAssemblyName(cls);
}

void* interceptor_ICJI::LongLifetimeMalloc(
          size_t sz)
{
    mcs->AddCall("LongLifetimeMalloc");
    return original_ICorJitInfo->LongLifetimeMalloc(sz);
}

void interceptor_ICJI::LongLifetimeFree(
          void* obj)
{
    mcs->AddCall("LongLifetimeFree");
    original_ICorJitInfo->LongLifetimeFree(obj);
}

bool interceptor_ICJI::getIsClassInitedFlagAddress(
          CORINFO_CLASS_HANDLE cls,
          CORINFO_CONST_LOOKUP* addr,
          int* offset)
{
    mcs->AddCall("getIsClassInitedFlagAddress");
    return original_ICorJitInfo->getIsClassInitedFlagAddress(cls, addr, offset);
}

size_t interceptor_ICJI::getClassThreadStaticDynamicInfo(
          CORINFO_CLASS_HANDLE clr)
{
    mcs->AddCall("getClassThreadStaticDynamicInfo");
    return original_ICorJitInfo->getClassThreadStaticDynamicInfo(clr);
}

size_t interceptor_ICJI::getClassStaticDynamicInfo(
          CORINFO_CLASS_HANDLE clr)
{
    mcs->AddCall("getClassStaticDynamicInfo");
    return original_ICorJitInfo->getClassStaticDynamicInfo(clr);
}

bool interceptor_ICJI::getStaticBaseAddress(
          CORINFO_CLASS_HANDLE cls,
          bool isGc,
          CORINFO_CONST_LOOKUP* addr)
{
    mcs->AddCall("getStaticBaseAddress");
    return original_ICorJitInfo->getStaticBaseAddress(cls, isGc, addr);
}

unsigned interceptor_ICJI::getClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getClassSize");
    return original_ICorJitInfo->getClassSize(cls);
}

unsigned interceptor_ICJI::getHeapClassSize(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getHeapClassSize");
    return original_ICorJitInfo->getHeapClassSize(cls);
}

bool interceptor_ICJI::canAllocateOnStack(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("canAllocateOnStack");
    return original_ICorJitInfo->canAllocateOnStack(cls);
}

unsigned interceptor_ICJI::getClassAlignmentRequirement(
          CORINFO_CLASS_HANDLE cls,
          bool fDoubleAlignHint)
{
    mcs->AddCall("getClassAlignmentRequirement");
    return original_ICorJitInfo->getClassAlignmentRequirement(cls, fDoubleAlignHint);
}

unsigned interceptor_ICJI::getClassGClayout(
          CORINFO_CLASS_HANDLE cls,
          uint8_t* gcPtrs)
{
    mcs->AddCall("getClassGClayout");
    return original_ICorJitInfo->getClassGClayout(cls, gcPtrs);
}

unsigned interceptor_ICJI::getClassNumInstanceFields(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getClassNumInstanceFields");
    return original_ICorJitInfo->getClassNumInstanceFields(cls);
}

CORINFO_FIELD_HANDLE interceptor_ICJI::getFieldInClass(
          CORINFO_CLASS_HANDLE clsHnd,
          int32_t num)
{
    mcs->AddCall("getFieldInClass");
    return original_ICorJitInfo->getFieldInClass(clsHnd, num);
}

GetTypeLayoutResult interceptor_ICJI::getTypeLayout(
          CORINFO_CLASS_HANDLE typeHnd,
          CORINFO_TYPE_LAYOUT_NODE* treeNodes,
          size_t* numTreeNodes)
{
    mcs->AddCall("getTypeLayout");
    return original_ICorJitInfo->getTypeLayout(typeHnd, treeNodes, numTreeNodes);
}

bool interceptor_ICJI::checkMethodModifier(
          CORINFO_METHOD_HANDLE hMethod,
          const char* modifier,
          bool fOptional)
{
    mcs->AddCall("checkMethodModifier");
    return original_ICorJitInfo->checkMethodModifier(hMethod, modifier, fOptional);
}

CorInfoHelpFunc interceptor_ICJI::getNewHelper(
          CORINFO_CLASS_HANDLE classHandle,
          bool* pHasSideEffects)
{
    mcs->AddCall("getNewHelper");
    return original_ICorJitInfo->getNewHelper(classHandle, pHasSideEffects);
}

CorInfoHelpFunc interceptor_ICJI::getNewArrHelper(
          CORINFO_CLASS_HANDLE arrayCls)
{
    mcs->AddCall("getNewArrHelper");
    return original_ICorJitInfo->getNewArrHelper(arrayCls);
}

CorInfoHelpFunc interceptor_ICJI::getCastingHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fThrowing)
{
    mcs->AddCall("getCastingHelper");
    return original_ICorJitInfo->getCastingHelper(pResolvedToken, fThrowing);
}

CorInfoHelpFunc interceptor_ICJI::getSharedCCtorHelper(
          CORINFO_CLASS_HANDLE clsHnd)
{
    mcs->AddCall("getSharedCCtorHelper");
    return original_ICorJitInfo->getSharedCCtorHelper(clsHnd);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getTypeForBox(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getTypeForBox");
    return original_ICorJitInfo->getTypeForBox(cls);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getTypeForBoxOnStack(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getTypeForBoxOnStack");
    return original_ICorJitInfo->getTypeForBoxOnStack(cls);
}

CorInfoHelpFunc interceptor_ICJI::getBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getBoxHelper");
    return original_ICorJitInfo->getBoxHelper(cls);
}

CorInfoHelpFunc interceptor_ICJI::getUnBoxHelper(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getUnBoxHelper");
    return original_ICorJitInfo->getUnBoxHelper(cls);
}

CORINFO_OBJECT_HANDLE interceptor_ICJI::getRuntimeTypePointer(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getRuntimeTypePointer");
    return original_ICorJitInfo->getRuntimeTypePointer(cls);
}

bool interceptor_ICJI::isObjectImmutable(
          CORINFO_OBJECT_HANDLE objPtr)
{
    mcs->AddCall("isObjectImmutable");
    return original_ICorJitInfo->isObjectImmutable(objPtr);
}

bool interceptor_ICJI::getStringChar(
          CORINFO_OBJECT_HANDLE strObj,
          int index,
          uint16_t* value)
{
    mcs->AddCall("getStringChar");
    return original_ICorJitInfo->getStringChar(strObj, index, value);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getObjectType(
          CORINFO_OBJECT_HANDLE objPtr)
{
    mcs->AddCall("getObjectType");
    return original_ICorJitInfo->getObjectType(objPtr);
}

bool interceptor_ICJI::getReadyToRunHelper(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_LOOKUP_KIND* pGenericLookupKind,
          CorInfoHelpFunc id,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_CONST_LOOKUP* pLookup)
{
    mcs->AddCall("getReadyToRunHelper");
    return original_ICorJitInfo->getReadyToRunHelper(pResolvedToken, pGenericLookupKind, id, callerHandle, pLookup);
}

void interceptor_ICJI::getReadyToRunDelegateCtorHelper(
          CORINFO_RESOLVED_TOKEN* pTargetMethod,
          mdToken targetConstraint,
          CORINFO_CLASS_HANDLE delegateType,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_LOOKUP* pLookup)
{
    mcs->AddCall("getReadyToRunDelegateCtorHelper");
    original_ICorJitInfo->getReadyToRunDelegateCtorHelper(pTargetMethod, targetConstraint, delegateType, callerHandle, pLookup);
}

CorInfoInitClassResult interceptor_ICJI::initClass(
          CORINFO_FIELD_HANDLE field,
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONTEXT_HANDLE context)
{
    mcs->AddCall("initClass");
    return original_ICorJitInfo->initClass(field, method, context);
}

void interceptor_ICJI::classMustBeLoadedBeforeCodeIsRun(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("classMustBeLoadedBeforeCodeIsRun");
    original_ICorJitInfo->classMustBeLoadedBeforeCodeIsRun(cls);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getBuiltinClass(
          CorInfoClassId classId)
{
    mcs->AddCall("getBuiltinClass");
    return original_ICorJitInfo->getBuiltinClass(classId);
}

CorInfoType interceptor_ICJI::getTypeForPrimitiveValueClass(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getTypeForPrimitiveValueClass");
    return original_ICorJitInfo->getTypeForPrimitiveValueClass(cls);
}

CorInfoType interceptor_ICJI::getTypeForPrimitiveNumericClass(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getTypeForPrimitiveNumericClass");
    return original_ICorJitInfo->getTypeForPrimitiveNumericClass(cls);
}

bool interceptor_ICJI::canCast(
          CORINFO_CLASS_HANDLE child,
          CORINFO_CLASS_HANDLE parent)
{
    mcs->AddCall("canCast");
    return original_ICorJitInfo->canCast(child, parent);
}

TypeCompareState interceptor_ICJI::compareTypesForCast(
          CORINFO_CLASS_HANDLE fromClass,
          CORINFO_CLASS_HANDLE toClass)
{
    mcs->AddCall("compareTypesForCast");
    return original_ICorJitInfo->compareTypesForCast(fromClass, toClass);
}

TypeCompareState interceptor_ICJI::compareTypesForEquality(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    mcs->AddCall("compareTypesForEquality");
    return original_ICorJitInfo->compareTypesForEquality(cls1, cls2);
}

bool interceptor_ICJI::isMoreSpecificType(
          CORINFO_CLASS_HANDLE cls1,
          CORINFO_CLASS_HANDLE cls2)
{
    mcs->AddCall("isMoreSpecificType");
    return original_ICorJitInfo->isMoreSpecificType(cls1, cls2);
}

bool interceptor_ICJI::isExactType(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("isExactType");
    return original_ICorJitInfo->isExactType(cls);
}

TypeCompareState interceptor_ICJI::isGenericType(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("isGenericType");
    return original_ICorJitInfo->isGenericType(cls);
}

TypeCompareState interceptor_ICJI::isNullableType(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("isNullableType");
    return original_ICorJitInfo->isNullableType(cls);
}

TypeCompareState interceptor_ICJI::isEnum(
          CORINFO_CLASS_HANDLE cls,
          CORINFO_CLASS_HANDLE* underlyingType)
{
    mcs->AddCall("isEnum");
    return original_ICorJitInfo->isEnum(cls, underlyingType);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getParentType(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getParentType");
    return original_ICorJitInfo->getParentType(cls);
}

CorInfoType interceptor_ICJI::getChildType(
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_CLASS_HANDLE* clsRet)
{
    mcs->AddCall("getChildType");
    return original_ICorJitInfo->getChildType(clsHnd, clsRet);
}

bool interceptor_ICJI::isSDArray(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("isSDArray");
    return original_ICorJitInfo->isSDArray(cls);
}

unsigned interceptor_ICJI::getArrayRank(
          CORINFO_CLASS_HANDLE cls)
{
    mcs->AddCall("getArrayRank");
    return original_ICorJitInfo->getArrayRank(cls);
}

CorInfoArrayIntrinsic interceptor_ICJI::getArrayIntrinsicID(
          CORINFO_METHOD_HANDLE ftn)
{
    mcs->AddCall("getArrayIntrinsicID");
    return original_ICorJitInfo->getArrayIntrinsicID(ftn);
}

void* interceptor_ICJI::getArrayInitializationData(
          CORINFO_FIELD_HANDLE field,
          uint32_t size)
{
    mcs->AddCall("getArrayInitializationData");
    return original_ICorJitInfo->getArrayInitializationData(field, size);
}

CorInfoIsAccessAllowedResult interceptor_ICJI::canAccessClass(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_HELPER_DESC* pAccessHelper)
{
    mcs->AddCall("canAccessClass");
    return original_ICorJitInfo->canAccessClass(pResolvedToken, callerHandle, pAccessHelper);
}

size_t interceptor_ICJI::printFieldName(
          CORINFO_FIELD_HANDLE field,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    mcs->AddCall("printFieldName");
    return original_ICorJitInfo->printFieldName(field, buffer, bufferSize, pRequiredBufferSize);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getFieldClass(
          CORINFO_FIELD_HANDLE field)
{
    mcs->AddCall("getFieldClass");
    return original_ICorJitInfo->getFieldClass(field);
}

CorInfoType interceptor_ICJI::getFieldType(
          CORINFO_FIELD_HANDLE field,
          CORINFO_CLASS_HANDLE* structType,
          CORINFO_CLASS_HANDLE memberParent)
{
    mcs->AddCall("getFieldType");
    return original_ICorJitInfo->getFieldType(field, structType, memberParent);
}

unsigned interceptor_ICJI::getFieldOffset(
          CORINFO_FIELD_HANDLE field)
{
    mcs->AddCall("getFieldOffset");
    return original_ICorJitInfo->getFieldOffset(field);
}

void interceptor_ICJI::getFieldInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_ACCESS_FLAGS flags,
          CORINFO_FIELD_INFO* pResult)
{
    mcs->AddCall("getFieldInfo");
    original_ICorJitInfo->getFieldInfo(pResolvedToken, callerHandle, flags, pResult);
}

uint32_t interceptor_ICJI::getThreadLocalFieldInfo(
          CORINFO_FIELD_HANDLE field,
          bool isGCtype)
{
    mcs->AddCall("getThreadLocalFieldInfo");
    return original_ICorJitInfo->getThreadLocalFieldInfo(field, isGCtype);
}

void interceptor_ICJI::getThreadLocalStaticBlocksInfo(
          CORINFO_THREAD_STATIC_BLOCKS_INFO* pInfo)
{
    mcs->AddCall("getThreadLocalStaticBlocksInfo");
    original_ICorJitInfo->getThreadLocalStaticBlocksInfo(pInfo);
}

void interceptor_ICJI::getThreadLocalStaticInfo_NativeAOT(
          CORINFO_THREAD_STATIC_INFO_NATIVEAOT* pInfo)
{
    mcs->AddCall("getThreadLocalStaticInfo_NativeAOT");
    original_ICorJitInfo->getThreadLocalStaticInfo_NativeAOT(pInfo);
}

bool interceptor_ICJI::isFieldStatic(
          CORINFO_FIELD_HANDLE fldHnd)
{
    mcs->AddCall("isFieldStatic");
    return original_ICorJitInfo->isFieldStatic(fldHnd);
}

int interceptor_ICJI::getArrayOrStringLength(
          CORINFO_OBJECT_HANDLE objHnd)
{
    mcs->AddCall("getArrayOrStringLength");
    return original_ICorJitInfo->getArrayOrStringLength(objHnd);
}

void interceptor_ICJI::getBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          unsigned int* cILOffsets,
          uint32_t** pILOffsets,
          ICorDebugInfo::BoundaryTypes* implicitBoundaries)
{
    mcs->AddCall("getBoundaries");
    original_ICorJitInfo->getBoundaries(ftn, cILOffsets, pILOffsets, implicitBoundaries);
}

void interceptor_ICJI::setBoundaries(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cMap,
          ICorDebugInfo::OffsetMapping* pMap)
{
    mcs->AddCall("setBoundaries");
    original_ICorJitInfo->setBoundaries(ftn, cMap, pMap);
}

void interceptor_ICJI::getVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t* cVars,
          ICorDebugInfo::ILVarInfo** vars,
          bool* extendOthers)
{
    mcs->AddCall("getVars");
    original_ICorJitInfo->getVars(ftn, cVars, vars, extendOthers);
}

void interceptor_ICJI::setVars(
          CORINFO_METHOD_HANDLE ftn,
          uint32_t cVars,
          ICorDebugInfo::NativeVarInfo* vars)
{
    mcs->AddCall("setVars");
    original_ICorJitInfo->setVars(ftn, cVars, vars);
}

void interceptor_ICJI::reportRichMappings(
          ICorDebugInfo::InlineTreeNode* inlineTreeNodes,
          uint32_t numInlineTreeNodes,
          ICorDebugInfo::RichOffsetMapping* mappings,
          uint32_t numMappings)
{
    mcs->AddCall("reportRichMappings");
    original_ICorJitInfo->reportRichMappings(inlineTreeNodes, numInlineTreeNodes, mappings, numMappings);
}

void interceptor_ICJI::reportMetadata(
          const char* key,
          const void* value,
          size_t length)
{
    mcs->AddCall("reportMetadata");
    original_ICorJitInfo->reportMetadata(key, value, length);
}

void* interceptor_ICJI::allocateArray(
          size_t cBytes)
{
    mcs->AddCall("allocateArray");
    return original_ICorJitInfo->allocateArray(cBytes);
}

void interceptor_ICJI::freeArray(
          void* array)
{
    mcs->AddCall("freeArray");
    original_ICorJitInfo->freeArray(array);
}

CORINFO_ARG_LIST_HANDLE interceptor_ICJI::getArgNext(
          CORINFO_ARG_LIST_HANDLE args)
{
    mcs->AddCall("getArgNext");
    return original_ICorJitInfo->getArgNext(args);
}

CorInfoTypeWithMod interceptor_ICJI::getArgType(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args,
          CORINFO_CLASS_HANDLE* vcTypeRet)
{
    mcs->AddCall("getArgType");
    return original_ICorJitInfo->getArgType(sig, args, vcTypeRet);
}

int interceptor_ICJI::getExactClasses(
          CORINFO_CLASS_HANDLE baseType,
          int maxExactClasses,
          CORINFO_CLASS_HANDLE* exactClsRet)
{
    mcs->AddCall("getExactClasses");
    return original_ICorJitInfo->getExactClasses(baseType, maxExactClasses, exactClsRet);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getArgClass(
          CORINFO_SIG_INFO* sig,
          CORINFO_ARG_LIST_HANDLE args)
{
    mcs->AddCall("getArgClass");
    return original_ICorJitInfo->getArgClass(sig, args);
}

CorInfoHFAElemType interceptor_ICJI::getHFAType(
          CORINFO_CLASS_HANDLE hClass)
{
    mcs->AddCall("getHFAType");
    return original_ICorJitInfo->getHFAType(hClass);
}

bool interceptor_ICJI::runWithErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter)
{
    mcs->AddCall("runWithErrorTrap");
    return original_ICorJitInfo->runWithErrorTrap(function, parameter);
}

bool interceptor_ICJI::runWithSPMIErrorTrap(
          ICorJitInfo::errorTrapFunction function,
          void* parameter)
{
    mcs->AddCall("runWithSPMIErrorTrap");
    return original_ICorJitInfo->runWithSPMIErrorTrap(function, parameter);
}

void interceptor_ICJI::getEEInfo(
          CORINFO_EE_INFO* pEEInfoOut)
{
    mcs->AddCall("getEEInfo");
    original_ICorJitInfo->getEEInfo(pEEInfoOut);
}

const char16_t* interceptor_ICJI::getJitTimeLogFilename()
{
    mcs->AddCall("getJitTimeLogFilename");
    return original_ICorJitInfo->getJitTimeLogFilename();
}

mdMethodDef interceptor_ICJI::getMethodDefFromMethod(
          CORINFO_METHOD_HANDLE hMethod)
{
    mcs->AddCall("getMethodDefFromMethod");
    return original_ICorJitInfo->getMethodDefFromMethod(hMethod);
}

size_t interceptor_ICJI::printMethodName(
          CORINFO_METHOD_HANDLE ftn,
          char* buffer,
          size_t bufferSize,
          size_t* pRequiredBufferSize)
{
    mcs->AddCall("printMethodName");
    return original_ICorJitInfo->printMethodName(ftn, buffer, bufferSize, pRequiredBufferSize);
}

const char* interceptor_ICJI::getMethodNameFromMetadata(
          CORINFO_METHOD_HANDLE ftn,
          const char** className,
          const char** namespaceName,
          const char** enclosingClassNames,
          size_t maxEnclosingClassNames)
{
    mcs->AddCall("getMethodNameFromMetadata");
    return original_ICorJitInfo->getMethodNameFromMetadata(ftn, className, namespaceName, enclosingClassNames, maxEnclosingClassNames);
}

unsigned interceptor_ICJI::getMethodHash(
          CORINFO_METHOD_HANDLE ftn)
{
    mcs->AddCall("getMethodHash");
    return original_ICorJitInfo->getMethodHash(ftn);
}

bool interceptor_ICJI::getSystemVAmd64PassStructInRegisterDescriptor(
          CORINFO_CLASS_HANDLE structHnd,
          SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR* structPassInRegDescPtr)
{
    mcs->AddCall("getSystemVAmd64PassStructInRegisterDescriptor");
    return original_ICorJitInfo->getSystemVAmd64PassStructInRegisterDescriptor(structHnd, structPassInRegDescPtr);
}

void interceptor_ICJI::getSwiftLowering(
          CORINFO_CLASS_HANDLE structHnd,
          CORINFO_SWIFT_LOWERING* pLowering)
{
    mcs->AddCall("getSwiftLowering");
    original_ICorJitInfo->getSwiftLowering(structHnd, pLowering);
}

void interceptor_ICJI::getFpStructLowering(
          CORINFO_CLASS_HANDLE structHnd,
          CORINFO_FPSTRUCT_LOWERING* pLowering)
{
    mcs->AddCall("getFpStructLowering");
    original_ICorJitInfo->getFpStructLowering(structHnd, pLowering);
}

uint32_t interceptor_ICJI::getThreadTLSIndex(
          void** ppIndirection)
{
    mcs->AddCall("getThreadTLSIndex");
    return original_ICorJitInfo->getThreadTLSIndex(ppIndirection);
}

int32_t* interceptor_ICJI::getAddrOfCaptureThreadGlobal(
          void** ppIndirection)
{
    mcs->AddCall("getAddrOfCaptureThreadGlobal");
    return original_ICorJitInfo->getAddrOfCaptureThreadGlobal(ppIndirection);
}

void* interceptor_ICJI::getHelperFtn(
          CorInfoHelpFunc ftnNum,
          void** ppIndirection)
{
    mcs->AddCall("getHelperFtn");
    return original_ICorJitInfo->getHelperFtn(ftnNum, ppIndirection);
}

void interceptor_ICJI::getFunctionEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          CORINFO_CONST_LOOKUP* pResult,
          CORINFO_ACCESS_FLAGS accessFlags)
{
    mcs->AddCall("getFunctionEntryPoint");
    original_ICorJitInfo->getFunctionEntryPoint(ftn, pResult, accessFlags);
}

void interceptor_ICJI::getFunctionFixedEntryPoint(
          CORINFO_METHOD_HANDLE ftn,
          bool isUnsafeFunctionPointer,
          CORINFO_CONST_LOOKUP* pResult)
{
    mcs->AddCall("getFunctionFixedEntryPoint");
    original_ICorJitInfo->getFunctionFixedEntryPoint(ftn, isUnsafeFunctionPointer, pResult);
}

void* interceptor_ICJI::getMethodSync(
          CORINFO_METHOD_HANDLE ftn,
          void** ppIndirection)
{
    mcs->AddCall("getMethodSync");
    return original_ICorJitInfo->getMethodSync(ftn, ppIndirection);
}

CorInfoHelpFunc interceptor_ICJI::getLazyStringLiteralHelper(
          CORINFO_MODULE_HANDLE handle)
{
    mcs->AddCall("getLazyStringLiteralHelper");
    return original_ICorJitInfo->getLazyStringLiteralHelper(handle);
}

CORINFO_MODULE_HANDLE interceptor_ICJI::embedModuleHandle(
          CORINFO_MODULE_HANDLE handle,
          void** ppIndirection)
{
    mcs->AddCall("embedModuleHandle");
    return original_ICorJitInfo->embedModuleHandle(handle, ppIndirection);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::embedClassHandle(
          CORINFO_CLASS_HANDLE handle,
          void** ppIndirection)
{
    mcs->AddCall("embedClassHandle");
    return original_ICorJitInfo->embedClassHandle(handle, ppIndirection);
}

CORINFO_METHOD_HANDLE interceptor_ICJI::embedMethodHandle(
          CORINFO_METHOD_HANDLE handle,
          void** ppIndirection)
{
    mcs->AddCall("embedMethodHandle");
    return original_ICorJitInfo->embedMethodHandle(handle, ppIndirection);
}

CORINFO_FIELD_HANDLE interceptor_ICJI::embedFieldHandle(
          CORINFO_FIELD_HANDLE handle,
          void** ppIndirection)
{
    mcs->AddCall("embedFieldHandle");
    return original_ICorJitInfo->embedFieldHandle(handle, ppIndirection);
}

void interceptor_ICJI::embedGenericHandle(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool fEmbedParent,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_GENERICHANDLE_RESULT* pResult)
{
    mcs->AddCall("embedGenericHandle");
    original_ICorJitInfo->embedGenericHandle(pResolvedToken, fEmbedParent, callerHandle, pResult);
}

void interceptor_ICJI::getLocationOfThisType(
          CORINFO_METHOD_HANDLE context,
          CORINFO_LOOKUP_KIND* pLookupKind)
{
    mcs->AddCall("getLocationOfThisType");
    original_ICorJitInfo->getLocationOfThisType(context, pLookupKind);
}

void interceptor_ICJI::getAddressOfPInvokeTarget(
          CORINFO_METHOD_HANDLE method,
          CORINFO_CONST_LOOKUP* pLookup)
{
    mcs->AddCall("getAddressOfPInvokeTarget");
    original_ICorJitInfo->getAddressOfPInvokeTarget(method, pLookup);
}

void* interceptor_ICJI::GetCookieForPInvokeCalliSig(
          CORINFO_SIG_INFO* szMetaSig,
          void** ppIndirection)
{
    mcs->AddCall("GetCookieForPInvokeCalliSig");
    return original_ICorJitInfo->GetCookieForPInvokeCalliSig(szMetaSig, ppIndirection);
}

bool interceptor_ICJI::canGetCookieForPInvokeCalliSig(
          CORINFO_SIG_INFO* szMetaSig)
{
    mcs->AddCall("canGetCookieForPInvokeCalliSig");
    return original_ICorJitInfo->canGetCookieForPInvokeCalliSig(szMetaSig);
}

CORINFO_JUST_MY_CODE_HANDLE interceptor_ICJI::getJustMyCodeHandle(
          CORINFO_METHOD_HANDLE method,
          CORINFO_JUST_MY_CODE_HANDLE** ppIndirection)
{
    mcs->AddCall("getJustMyCodeHandle");
    return original_ICorJitInfo->getJustMyCodeHandle(method, ppIndirection);
}

void interceptor_ICJI::GetProfilingHandle(
          bool* pbHookFunction,
          void** pProfilerHandle,
          bool* pbIndirectedHandles)
{
    mcs->AddCall("GetProfilingHandle");
    original_ICorJitInfo->GetProfilingHandle(pbHookFunction, pProfilerHandle, pbIndirectedHandles);
}

void interceptor_ICJI::getCallInfo(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          CORINFO_RESOLVED_TOKEN* pConstrainedResolvedToken,
          CORINFO_METHOD_HANDLE callerHandle,
          CORINFO_CALLINFO_FLAGS flags,
          CORINFO_CALL_INFO* pResult)
{
    mcs->AddCall("getCallInfo");
    original_ICorJitInfo->getCallInfo(pResolvedToken, pConstrainedResolvedToken, callerHandle, flags, pResult);
}

bool interceptor_ICJI::getStaticFieldContent(
          CORINFO_FIELD_HANDLE field,
          uint8_t* buffer,
          int bufferSize,
          int valueOffset,
          bool ignoreMovableObjects)
{
    mcs->AddCall("getStaticFieldContent");
    return original_ICorJitInfo->getStaticFieldContent(field, buffer, bufferSize, valueOffset, ignoreMovableObjects);
}

bool interceptor_ICJI::getObjectContent(
          CORINFO_OBJECT_HANDLE obj,
          uint8_t* buffer,
          int bufferSize,
          int valueOffset)
{
    mcs->AddCall("getObjectContent");
    return original_ICorJitInfo->getObjectContent(obj, buffer, bufferSize, valueOffset);
}

CORINFO_CLASS_HANDLE interceptor_ICJI::getStaticFieldCurrentClass(
          CORINFO_FIELD_HANDLE field,
          bool* pIsSpeculative)
{
    mcs->AddCall("getStaticFieldCurrentClass");
    return original_ICorJitInfo->getStaticFieldCurrentClass(field, pIsSpeculative);
}

CORINFO_VARARGS_HANDLE interceptor_ICJI::getVarArgsHandle(
          CORINFO_SIG_INFO* pSig,
          void** ppIndirection)
{
    mcs->AddCall("getVarArgsHandle");
    return original_ICorJitInfo->getVarArgsHandle(pSig, ppIndirection);
}

bool interceptor_ICJI::canGetVarArgsHandle(
          CORINFO_SIG_INFO* pSig)
{
    mcs->AddCall("canGetVarArgsHandle");
    return original_ICorJitInfo->canGetVarArgsHandle(pSig);
}

InfoAccessType interceptor_ICJI::constructStringLiteral(
          CORINFO_MODULE_HANDLE module,
          mdToken metaTok,
          void** ppValue)
{
    mcs->AddCall("constructStringLiteral");
    return original_ICorJitInfo->constructStringLiteral(module, metaTok, ppValue);
}

InfoAccessType interceptor_ICJI::emptyStringLiteral(
          void** ppValue)
{
    mcs->AddCall("emptyStringLiteral");
    return original_ICorJitInfo->emptyStringLiteral(ppValue);
}

uint32_t interceptor_ICJI::getFieldThreadLocalStoreID(
          CORINFO_FIELD_HANDLE field,
          void** ppIndirection)
{
    mcs->AddCall("getFieldThreadLocalStoreID");
    return original_ICorJitInfo->getFieldThreadLocalStoreID(field, ppIndirection);
}

CORINFO_METHOD_HANDLE interceptor_ICJI::GetDelegateCtor(
          CORINFO_METHOD_HANDLE methHnd,
          CORINFO_CLASS_HANDLE clsHnd,
          CORINFO_METHOD_HANDLE targetMethodHnd,
          DelegateCtorArgs* pCtorData)
{
    mcs->AddCall("GetDelegateCtor");
    return original_ICorJitInfo->GetDelegateCtor(methHnd, clsHnd, targetMethodHnd, pCtorData);
}

void interceptor_ICJI::MethodCompileComplete(
          CORINFO_METHOD_HANDLE methHnd)
{
    mcs->AddCall("MethodCompileComplete");
    original_ICorJitInfo->MethodCompileComplete(methHnd);
}

bool interceptor_ICJI::getTailCallHelpers(
          CORINFO_RESOLVED_TOKEN* callToken,
          CORINFO_SIG_INFO* sig,
          CORINFO_GET_TAILCALL_HELPERS_FLAGS flags,
          CORINFO_TAILCALL_HELPERS* pResult)
{
    mcs->AddCall("getTailCallHelpers");
    return original_ICorJitInfo->getTailCallHelpers(callToken, sig, flags, pResult);
}

bool interceptor_ICJI::convertPInvokeCalliToCall(
          CORINFO_RESOLVED_TOKEN* pResolvedToken,
          bool mustConvert)
{
    mcs->AddCall("convertPInvokeCalliToCall");
    return original_ICorJitInfo->convertPInvokeCalliToCall(pResolvedToken, mustConvert);
}

bool interceptor_ICJI::notifyInstructionSetUsage(
          CORINFO_InstructionSet instructionSet,
          bool supportEnabled)
{
    mcs->AddCall("notifyInstructionSetUsage");
    return original_ICorJitInfo->notifyInstructionSetUsage(instructionSet, supportEnabled);
}

void interceptor_ICJI::updateEntryPointForTailCall(
          CORINFO_CONST_LOOKUP* entryPoint)
{
    mcs->AddCall("updateEntryPointForTailCall");
    original_ICorJitInfo->updateEntryPointForTailCall(entryPoint);
}

void interceptor_ICJI::allocMem(
          AllocMemArgs* pArgs)
{
    mcs->AddCall("allocMem");
    original_ICorJitInfo->allocMem(pArgs);
}

void interceptor_ICJI::reserveUnwindInfo(
          bool isFunclet,
          bool isColdCode,
          uint32_t unwindSize)
{
    mcs->AddCall("reserveUnwindInfo");
    original_ICorJitInfo->reserveUnwindInfo(isFunclet, isColdCode, unwindSize);
}

void interceptor_ICJI::allocUnwindInfo(
          uint8_t* pHotCode,
          uint8_t* pColdCode,
          uint32_t startOffset,
          uint32_t endOffset,
          uint32_t unwindSize,
          uint8_t* pUnwindBlock,
          CorJitFuncKind funcKind)
{
    mcs->AddCall("allocUnwindInfo");
    original_ICorJitInfo->allocUnwindInfo(pHotCode, pColdCode, startOffset, endOffset, unwindSize, pUnwindBlock, funcKind);
}

void* interceptor_ICJI::allocGCInfo(
          size_t size)
{
    mcs->AddCall("allocGCInfo");
    return original_ICorJitInfo->allocGCInfo(size);
}

void interceptor_ICJI::setEHcount(
          unsigned cEH)
{
    mcs->AddCall("setEHcount");
    original_ICorJitInfo->setEHcount(cEH);
}

void interceptor_ICJI::setEHinfo(
          unsigned EHnumber,
          const CORINFO_EH_CLAUSE* clause)
{
    mcs->AddCall("setEHinfo");
    original_ICorJitInfo->setEHinfo(EHnumber, clause);
}

bool interceptor_ICJI::logMsg(
          unsigned level,
          const char* fmt,
          va_list args)
{
    mcs->AddCall("logMsg");
    return original_ICorJitInfo->logMsg(level, fmt, args);
}

int interceptor_ICJI::doAssert(
          const char* szFile,
          int iLine,
          const char* szExpr)
{
    mcs->AddCall("doAssert");
    return original_ICorJitInfo->doAssert(szFile, iLine, szExpr);
}

void interceptor_ICJI::reportFatalError(
          CorJitResult result)
{
    mcs->AddCall("reportFatalError");
    original_ICorJitInfo->reportFatalError(result);
}

JITINTERFACE_HRESULT interceptor_ICJI::getPgoInstrumentationResults(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema** pSchema,
          uint32_t* pCountSchemaItems,
          uint8_t** pInstrumentationData,
          ICorJitInfo::PgoSource* pPgoSource,
          bool* pDynamicPgo)
{
    mcs->AddCall("getPgoInstrumentationResults");
    return original_ICorJitInfo->getPgoInstrumentationResults(ftnHnd, pSchema, pCountSchemaItems, pInstrumentationData, pPgoSource, pDynamicPgo);
}

JITINTERFACE_HRESULT interceptor_ICJI::allocPgoInstrumentationBySchema(
          CORINFO_METHOD_HANDLE ftnHnd,
          ICorJitInfo::PgoInstrumentationSchema* pSchema,
          uint32_t countSchemaItems,
          uint8_t** pInstrumentationData)
{
    mcs->AddCall("allocPgoInstrumentationBySchema");
    return original_ICorJitInfo->allocPgoInstrumentationBySchema(ftnHnd, pSchema, countSchemaItems, pInstrumentationData);
}

void interceptor_ICJI::recordCallSite(
          uint32_t instrOffset,
          CORINFO_SIG_INFO* callSig,
          CORINFO_METHOD_HANDLE methodHandle)
{
    mcs->AddCall("recordCallSite");
    original_ICorJitInfo->recordCallSite(instrOffset, callSig, methodHandle);
}

void interceptor_ICJI::recordRelocation(
          void* location,
          void* locationRW,
          void* target,
          uint16_t fRelocType,
          int32_t addlDelta)
{
    mcs->AddCall("recordRelocation");
    original_ICorJitInfo->recordRelocation(location, locationRW, target, fRelocType, addlDelta);
}

uint16_t interceptor_ICJI::getRelocTypeHint(
          void* target)
{
    mcs->AddCall("getRelocTypeHint");
    return original_ICorJitInfo->getRelocTypeHint(target);
}

uint32_t interceptor_ICJI::getExpectedTargetArchitecture()
{
    mcs->AddCall("getExpectedTargetArchitecture");
    return original_ICorJitInfo->getExpectedTargetArchitecture();
}

uint32_t interceptor_ICJI::getJitFlags(
          CORJIT_FLAGS* flags,
          uint32_t sizeInBytes)
{
    mcs->AddCall("getJitFlags");
    return original_ICorJitInfo->getJitFlags(flags, sizeInBytes);
}

