/*
------------------------------------------------------------------------------
denef - Decode NEF image files
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------
*/

#include <iostream.h>
#include <math.h>
#include <stdlib.h>

#include "interp.h"

static const char *rcsid="$Id: interp_null.cc,v 1.3 2000/09/18 07:51:43 daniel Exp $";

// Simple 'Null' interpolator - Just copies NEF data directly to output
// w/ appropriate colors

nullInterpolator::nullInterpolator()
{
}

nullInterpolator::~nullInterpolator()
{
}

int
nullInterpolator::Fringe() const
{
    return 0;
}

int
nullInterpolator::Max_Width() const
{
    return 10000000;
}

int
nullInterpolator::Max_Height() const
{
    return 10000000;
}

void
nullInterpolator::Interpolate(const nefImageData &nef,
			       int xofs, int yofs,
			       int width, int height,
			       fullImageData &result,
			       int rxofs, int ryofs)
{
    /* This function takes a chunk of the NEF data and creates the decoded
       image from it.

       Essentially non-existant algorithm
    */

    for (int y=0; y<height; ++y) {
	const short *pn  = nef.Data(xofs, yofs + y - 1);
	const short *p   = nef.Data(xofs, yofs + y    );
	const short *ps  = nef.Data(xofs, yofs + y + 1);

	bool green_pixel = (y & 1);

	double r=0,g=0,b=0;

	for (int x=0; x<width;
	     ++x, ++pn, ++p, ++ps, green_pixel = !green_pixel) {
	    if (green_pixel) {
		r = 0;
		g = p[0];
		b = 0;
	    } else {
		g=0;
		if (y & 1) {
		    r = p[0];
		    b=0;
		} else {
		    b = p[0];
		    r=0;
		}
	    }

	    rgbTriple &res = result(rxofs+x, ryofs+y);

	    res.r = r / (double)nef.Max_Value();
	    res.g = g / (double)nef.Max_Value();
	    res.b = b / (double)nef.Max_Value();
	}
    }

}

