# Deb-o-Matic - Package build path cleaner
#
# Copyright (C) 2009 Alessio Treglia
# Copyright (C) 2009-2025 Luca Falavigna
#
# Authors: Alessio Treglia <quadrispro@ubuntu.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option), any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
#
# Delete all files generated by previous build.

import os


class DebomaticModule_BuildCleaner:

    def __init__(self):
        self.after = ['Lintian', 'Piuparts']
        self.before = ['Repository']

    def pre_build(self, args):
        if args.opts.has_section('buildcleaner'):
            if args.opts.getboolean('buildcleaner', 'testbuild'):
                return
        exts_to_clean = ['.deb', '.ddeb', '.gz', '.bz2', '.xz', '.dsc',
                         '.changes', '.build', '.buildlog', '.buildinfo',
                         '.contents', '.lintian', '.piuparts', '.blhc',
                         '.autopkgtest', '.udeb']
        pkg_build_path = ('%(directory)s/pool/%(package)s' %
                          {'directory': args.directory,
                           'package': args.package})
        for filename in os.listdir(pkg_build_path):
            name, ext = os.path.splitext(filename)
            if ext in exts_to_clean:
                os.remove(os.path.join(pkg_build_path, filename))

    def post_build(self, args):
        exts_to_clean = ['.deb', '.ddeb', '.udeb', '.changes',
                         '.gz', '.bz2', '.xz', '.dsc']
        pkg_build_path = ('%(directory)s/pool/%(package)s' %
                          {'directory': args.directory,
                           'package': args.package})
        if args.opts.has_section('buildcleaner'):
            if args.opts.getboolean('buildcleaner', 'testbuild'):
                for filename in os.listdir(pkg_build_path):
                    name, ext = os.path.splitext(filename)
                    if ext in exts_to_clean:
                        os.remove(os.path.join(pkg_build_path, filename))
