/***************************************
  $Header: /home/amb/CVS/cxref/cpp/config.h,v 1.11 2004-11-06 17:30:46 amb Exp $

  System configuration header file config.h.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file consists of parts taken from GCC.

  GNU CC is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

/* The configure script output. */

#include "autoconfig.h"


/* An unmodified file from the gcc distribution. */

#include "gansidecl.h"


/* The package name for internationalisation. */

#define PACKAGE "gcc"


/* This describes the machine the compiler is hosted on
   (to sufficient accuracy for the pre-processor to compile). */

#define BITS_PER_UNIT 8

#define HOST_BITS_PER_INT (SIZEOF_INT*BITS_PER_UNIT)

#define HOST_BITS_PER_LONG (SIZEOF_LONG*BITS_PER_UNIT)

#define HOST_BITS_PER_LONGLONG (SIZEOF_LONG_LONG*BITS_PER_UNIT)

#define BITS_PER_WORD (SIZEOF_LONG*BITS_PER_UNIT)


/* Define results of standard character escape sequences. */

#if defined(mvs)
#define TARGET_BELL	47
#define TARGET_BS	22
#define TARGET_TAB	5
#define TARGET_NEWLINE	21
#define TARGET_VT	11
#define TARGET_FF	12
#define TARGET_CR	13
#else
#define TARGET_BELL    007
#define TARGET_BS      010
#define TARGET_TAB     011
#define TARGET_NEWLINE 012
#define TARGET_VT      013
#define TARGET_FF      014
#define TARGET_CR      015
#endif


/* Need this for AIX apparently. */

#if defined(_AIX)
#pragma alloca
#endif


/* Exit codes. */

#ifndef FATAL_EXIT_CODE
#define FATAL_EXIT_CODE 33	/* gcc command understands this. */
#endif

#ifndef SUCCESS_EXIT_CODE
#define SUCCESS_EXIT_CODE 0	/* 0 means success on Unix. */
#endif


/* Function prototypes for cccp.c malloc wrapper etc. */

#include <sys/types.h>

PTR xmalloc PROTO((size_t));
PTR xrealloc PROTO((PTR, size_t));
PTR xcalloc PROTO((size_t, size_t));
char *xstrdup PROTO((const char *));


#endif /* CONFIG_H */
