#include "ipstore"

void IPStore::clearoldest() {
    time_t oldest_time = time(0) + 100;
    StoreMap::iterator oldest_entry;
    bool found = false;
    static int lock;

    mutex_lock(&lock);

    dump();
    
    // Find oldest entry.
    for (StoreMap::iterator iter = store.begin();
	 iter != store.end();
	 iter++) {
	if ((*iter).second.lastaccess < oldest_time) {
	    oldest_time = (*iter).second.lastaccess;
	    oldest_entry = iter;
	    found = true;
	}
    }

    // Kill it if we got it.
    if (found) {
	if (config.debug()) {
	    Timestamp tm((*oldest_entry).second.lastaccess);
	    debugmsg("Erasing oldest IP store entry: " << 
		     inet2string(oldest_entry->first) << " on " <<
		     tm.desc() << '\n');
	}
	store.erase(oldest_entry);
    }

    mutex_unlock(&lock);
    dump();
}
