#include "socket"

Socket const &Socket::operator=(Socket const &other) {
    if (this != &other) {

	#ifdef SOCKET_DEBUG
	if (*_refcount == 1) {
	    debugmsg("Socket: destroying for assignment " << description()
		     << '\n');
	} else {
	    debugmsg("Socket: subtracting for assignment " << description()
		     << '\n');
	}
	#endif
	
	(*_refcount)--;
	if (! *_refcount) {
	    delete _refcount;
	    delete _basesocket;
	}

	_refcount = other._refcount;
	(*_refcount)++;
	_basesocket = other._basesocket;

	#ifdef SOCKET_DEBUG
	debugmsg("Socket: assigned " << description() << '\n');
	#endif
    }
    
    return *this;
}
