#include "balancer"

void Balancer::addbackend (Backend const &b,
			   bool is_up, bool is_live, bool do_check) {
    debugmsg(Mstr("Adding back end ") + b.description() + " to list\n");
    
    Mutex::lock(&backends);
    backends.push_back (b);    
    backends[backends.size() - 1].up(is_up);
    backends[backends.size() - 1].live(is_live);
    backends[backends.size() - 1].balancerindex(backends.size() - 1);
    Mutex::unlock(&backends);

    if (do_check) {
	debugmsg(Mstr("Verifying configured back end\n"));
	backends[backends.size() - 1].check();
    }

    debugmsg(Mstr("Back end ") + b.description() + " added to list\n");
}
