#include "mutex"
#include "error/error"

void Mutex::plock(void *target) {
    mapIterator iter = s_lock.find(target);
    if (iter == s_lock.end()) {
	// No such lock yet, create the mutex
        if (int res = pthread_mutex_init(&s_lock[target], 0))
            throw Error(string("Failed to initialize static mutex: ") +
			strerror(res));
    }
    
    if (int res = pthread_mutex_lock(&s_lock[target]))
        throw Error(string("Failed to obtain mutex lock: ") +
		    strerror(res));
}

