/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class DateTimeValue
extends CalendarValue {
    private int year;
    private byte month;
    private byte day;
    private byte hour;
    private byte minute;
    private byte second;
    private int microsecond;

    public static DateTimeValue getCurrentDateTime(XPathContext xPathContext) {
        Controller controller;
        if (xPathContext == null || (controller = xPathContext.getController()) == null) {
            return new DateTimeValue(new GregorianCalendar(), true);
        }
        return controller.getCurrentDateTime();
    }

    public DateTimeValue(Calendar calendar, boolean bl) {
        int n = calendar.get(0);
        this.year = calendar.get(1);
        if (n == 0) {
            this.year = 1 - this.year;
        }
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        this.hour = (byte)calendar.get(11);
        this.minute = (byte)calendar.get(12);
        this.second = (byte)calendar.get(13);
        this.microsecond = calendar.get(14) * 1000;
        if (bl) {
            int n2 = (calendar.get(15) + calendar.get(16)) / 60000;
            this.setTimezoneInMinutes(n2);
        }
    }

    public DateTimeValue(DateValue dateValue, TimeValue timeValue) throws XPathException {
        boolean bl;
        SecondsDurationValue secondsDurationValue = (SecondsDurationValue)dateValue.getComponent(7);
        SecondsDurationValue secondsDurationValue2 = (SecondsDurationValue)timeValue.getComponent(7);
        boolean bl2 = bl = secondsDurationValue != null || secondsDurationValue2 != null;
        if (secondsDurationValue != null && secondsDurationValue2 != null && !secondsDurationValue.equals(secondsDurationValue2)) {
            DynamicError dynamicError = new DynamicError("Supplied date and time are in different timezones");
            dynamicError.setErrorCode("FORG0008");
            throw dynamicError;
        }
        this.year = (int)((IntegerValue)dateValue.getComponent(1)).longValue();
        this.month = (byte)((IntegerValue)dateValue.getComponent(2)).longValue();
        this.day = (byte)((IntegerValue)dateValue.getComponent(3)).longValue();
        this.hour = (byte)((IntegerValue)timeValue.getComponent(4)).longValue();
        this.minute = (byte)((IntegerValue)timeValue.getComponent(5)).longValue();
        BigDecimal bigDecimal = ((DecimalValue)timeValue.getComponent(6)).getValue();
        this.second = (byte)bigDecimal.intValue();
        this.microsecond = bigDecimal.multiply(BigDecimal.valueOf(1000000L)).intValue() % 1000000;
        if (bl) {
            if (secondsDurationValue == null) {
                secondsDurationValue = secondsDurationValue2;
            }
            this.setTimezoneInMinutes((int)(secondsDurationValue.getLengthInMicroseconds() / 60000000L));
        }
    }

    public DateTimeValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Whitespace.trimWhitespace(charSequence).toString(), "-:.+TZ", true);
        try {
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short", charSequence);
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if ("+".equals(string)) {
                this.badDate("Date may not start with '+' sign", charSequence);
            } else if ("-".equals(string)) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            this.year = Integer.parseInt(string) * n;
            if (string.length() < 4) {
                this.badDate("Year is less than four digits", charSequence);
            }
            if (string.length() > 4 && string.charAt(0) == '0') {
                this.badDate("When year exceeds 4 digits, leading zeroes are not allowed", charSequence);
            }
            if (this.year == 0) {
                this.badDate("Year zero is not allowed", charSequence);
            }
            if (n < 0) {
                ++this.year;
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after year", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Month must be two digits", charSequence);
            }
            this.month = (byte)Integer.parseInt(string);
            if (this.month < 1 || this.month > 12) {
                this.badDate("Month is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after month", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Day must be two digits", charSequence);
            }
            this.day = (byte)Integer.parseInt(string);
            if (this.day < 1 || this.day > 31) {
                this.badDate("Day is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"T".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after day", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Hour must be two digits", charSequence);
            }
            this.hour = (byte)Integer.parseInt(string);
            if (this.hour > 24) {
                this.badDate("Hour is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after hour", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Minute must be two digits", charSequence);
            }
            this.minute = (byte)Integer.parseInt(string);
            if (this.minute > 59) {
                this.badDate("Minute is out of range", charSequence);
            }
            if (this.hour == 24 && this.minute != 0) {
                this.badDate("If hour is 24, minute must be 00", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after minute", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Second must be two digits", charSequence);
            }
            this.second = (byte)Integer.parseInt(string);
            if (this.second > 59) {
                this.badDate("Second is out of range", charSequence);
            }
            if (this.hour == 24 && this.second != 0) {
                this.badDate("If hour is 24, second must be 00", charSequence);
            }
            int n2 = 0;
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2;
                if (n3 == 9) {
                    this.badDate("Characters after the end", charSequence);
                }
                if (".".equals(string2 = (String)stringTokenizer.nextElement())) {
                    if (n3 != 0) {
                        this.badDate("Decimal separator occurs twice", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    double d = Double.parseDouble('.' + string);
                    this.microsecond = (int)Math.round(d * 1000000.0);
                    if (this.hour == 24 && this.microsecond != 0) {
                        this.badDate("If hour is 24, fractional seconds must be 0", charSequence);
                    }
                    n3 = 1;
                    continue;
                }
                if ("Z".equals(string2)) {
                    if (n3 > 1) {
                        this.badDate("Z cannot occur here", charSequence);
                    }
                    n2 = 0;
                    n3 = 9;
                    this.setTimezoneInMinutes(0);
                    continue;
                }
                if ("+".equals(string2) || "-".equals(string2)) {
                    if (n3 > 1) {
                        this.badDate(string2 + " cannot occur here", charSequence);
                    }
                    n3 = 2;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone", charSequence);
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badDate("Timezone hour must be two digits", charSequence);
                    }
                    if ((n2 = Integer.parseInt(string)) > 14) {
                        this.badDate("Timezone is out of range (-14:00 to +14:00)", charSequence);
                    }
                    n2 *= 60;
                    if (!"-".equals(string2)) continue;
                    n2 = -n2;
                    continue;
                }
                if (":".equals(string2)) {
                    if (n3 != 2) {
                        this.badDate("Misplaced ':'", charSequence);
                    }
                    n3 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n4 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits", charSequence);
                    }
                    if (n4 > 59) {
                        this.badDate("Timezone minute is out of range", charSequence);
                    }
                    if (n2 < 0) {
                        n4 = -n4;
                    }
                    if (Math.abs(n2) == 840 && n4 != 0) {
                        this.badDate("Timezone is out of range (-14:00 to +14:00)", charSequence);
                    }
                    this.setTimezoneInMinutes(n2 += n4);
                    continue;
                }
                this.badDate("Timezone format is incorrect", charSequence);
            }
            if (n3 == 2 || n3 == 3) {
                this.badDate("Timezone incomplete", charSequence);
            }
            boolean bl = false;
            if (this.hour == 24) {
                this.hour = 0;
                bl = true;
            }
            if (!DateValue.isValidDate(this.year, this.month, this.day)) {
                this.badDate("Non-existent date", charSequence);
            }
            if (bl) {
                DateValue dateValue = DateValue.tomorrow(this.year, this.month, this.day);
                this.year = dateValue.getYear();
                this.month = dateValue.getMonth();
                this.day = dateValue.getDay();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component", charSequence);
        }
    }

    private void badDate(String string, CharSequence charSequence) throws XPathException {
        ValidationException validationException = new ValidationException("Invalid dateTime value " + Err.wrap(charSequence, 4) + " (" + string + ")");
        validationException.setErrorCode("FORG0001");
        throw validationException;
    }

    public DateTimeValue(int n, byte by, byte by2, byte by3, byte by4, byte by5, int n2, int n3) {
        this.year = n;
        this.month = by;
        this.day = by2;
        this.hour = by3;
        this.minute = by4;
        this.second = by5;
        this.microsecond = n2;
        this.setTimezoneInMinutes(n3);
    }

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public DateTimeValue toDateTime() {
        return this;
    }

    public DateTimeValue normalize(Configuration configuration) {
        if (this.hasTimezone()) {
            return (DateTimeValue)this.adjustTimezone(0);
        }
        DateTimeValue dateTimeValue = (DateTimeValue)this.copy();
        dateTimeValue.setTimezoneInMinutes(configuration.getImplicitTimezone());
        return (DateTimeValue)dateTimeValue.adjustTimezone(0);
    }

    public ComparisonKey getComparisonKey(Configuration configuration) {
        return new ComparisonKey(519, this.normalize(configuration));
    }

    public BigDecimal toJulianInstant() {
        int n = DateValue.getJulianDayNumber(this.year, this.month, this.day);
        long l = (long)n * 86400L;
        BigDecimal bigDecimal = BigDecimal.valueOf(l += ((long)this.hour * 60L + (long)this.minute) * 60L + (long)this.second);
        if (this.microsecond == 0) {
            return bigDecimal;
        }
        return bigDecimal.add(BigDecimal.valueOf(this.microsecond).divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 6));
    }

    public static DateTimeValue fromJulianInstant(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.toBigInteger();
        BigDecimal bigDecimal2 = bigDecimal.subtract(new BigDecimal(bigInteger)).multiply(DecimalValue.BIG_DECIMAL_ONE_MILLION);
        long l = bigInteger.longValue();
        long l2 = l / 86400L;
        DateValue dateValue = DateValue.dateFromJulianDayNumber((int)l2);
        byte by = (byte)((l %= 86400L) / 3600L);
        byte by2 = (byte)((l %= 3600L) / 60L);
        return new DateTimeValue(dateValue.getYear(), dateValue.getMonth(), dateValue.getDay(), by, by2, (byte)(l %= 60L), bigDecimal2.intValue(), 0);
    }

    public GregorianCalendar getCalendar() {
        int n = this.hasTimezone() ? this.getTimezoneInMinutes() * 60000 : 0;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n, "LLL");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.setLenient(false);
        int n2 = this.year;
        if (this.year <= 0) {
            n2 = 1 - this.year;
            gregorianCalendar.set(0, 0);
        }
        gregorianCalendar.set(n2, this.month - 1, this.day, this.hour, this.minute, this.second);
        gregorianCalendar.set(14, this.microsecond / 1000);
        gregorianCalendar.set(15, n);
        gregorianCalendar.set(16, 0);
        return gregorianCalendar;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 519: 
            case 643: {
                return this;
            }
            case 521: {
                return new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes());
            }
            case 520: {
                return new TimeValue(this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
            }
            case 523: {
                return new GYearValue(this.year, this.getTimezoneInMinutes());
            }
            case 522: {
                return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
            }
            case 526: {
                return new GMonthValue(this.month, this.getTimezoneInMinutes());
            }
            case 524: {
                return new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
            }
            case 525: {
                return new GDayValue(this.day, this.getTimezoneInMinutes());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert dateTime to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(30);
        int n = this.year;
        if (this.year <= 0) {
            fastStringBuffer.append('-');
            n = -n + 1;
        }
        DateTimeValue.appendString(fastStringBuffer, n, n > 9999 ? (n + "").length() : 4);
        fastStringBuffer.append('-');
        DateTimeValue.appendTwoDigits(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        DateTimeValue.appendTwoDigits(fastStringBuffer, this.day);
        fastStringBuffer.append('T');
        DateTimeValue.appendTwoDigits(fastStringBuffer, this.hour);
        fastStringBuffer.append(':');
        DateTimeValue.appendTwoDigits(fastStringBuffer, this.minute);
        fastStringBuffer.append(':');
        DateTimeValue.appendTwoDigits(fastStringBuffer, this.second);
        if (this.microsecond != 0) {
            fastStringBuffer.append('.');
            int n2 = this.microsecond;
            int n3 = 100000;
            while (n2 > 0) {
                int n4 = n2 / n3;
                fastStringBuffer.append((char)(n4 + 48));
                n2 %= n3;
                n3 /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DATE_TIME_TYPE;
    }

    public CalendarValue copy() {
        return new DateTimeValue(this.year, this.month, this.day, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
    }

    public CalendarValue adjustTimezone(int n) {
        DateValue dateValue;
        if (!this.hasTimezone()) {
            CalendarValue calendarValue = this.copy();
            calendarValue.setTimezoneInMinutes(n);
            return calendarValue;
        }
        int n2 = this.getTimezoneInMinutes();
        if (n2 == n) {
            return this;
        }
        int n3 = n - n2;
        int n4 = this.hour;
        int n5 = this.minute;
        if ((n5 += n3) < 0 || n5 > 59) {
            n4 = (int)((double)n4 + Math.floor((double)n5 / 60.0));
            n5 = (n5 + 1440) % 60;
        }
        if (n4 >= 0 && n4 < 24) {
            return new DateTimeValue(this.year, this.month, this.day, (byte)n4, (byte)n5, this.second, this.microsecond, n);
        }
        DateTimeValue dateTimeValue = this;
        while (n4 < 0) {
            dateValue = DateValue.yesterday(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
            dateTimeValue = new DateTimeValue(dateValue.getYear(), dateValue.getMonth(), dateValue.getDay(), (byte)(n4 += 24), (byte)n5, this.second, this.microsecond, n);
        }
        if (n4 > 23) {
            dateValue = DateValue.tomorrow(this.year, this.month, this.day);
            return new DateTimeValue(dateValue.getYear(), dateValue.getMonth(), dateValue.getDay(), (byte)(n4 -= 24), (byte)n5, this.second, this.microsecond, n);
        }
        return dateTimeValue;
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            long l = ((SecondsDurationValue)durationValue).getLengthInMicroseconds();
            BigDecimal bigDecimal = BigDecimal.valueOf(l).divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 6);
            BigDecimal bigDecimal2 = this.toJulianInstant();
            bigDecimal2 = bigDecimal2.add(bigDecimal);
            DateTimeValue dateTimeValue = DateTimeValue.fromJulianInstant(bigDecimal2);
            dateTimeValue.setTimezoneInMinutes(this.getTimezoneInMinutes());
            return dateTimeValue;
        }
        if (durationValue instanceof MonthDurationValue) {
            int n = ((MonthDurationValue)durationValue).getLengthInMonths();
            int n2 = this.month - 1 + n;
            int n3 = this.year + n2 / 12;
            if ((n2 %= 12) < 0) {
                n2 += 12;
                --n3;
            }
            ++n2;
            int n4 = this.day;
            while (!DateValue.isValidDate(n3, n2, n4)) {
                --n4;
            }
            return new DateTimeValue(n3, (byte)n2, (byte)n4, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
        }
        DynamicError dynamicError = new DynamicError("DateTime arithmetic is not supported on xs:duration, only on its subtypes");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        if (!(calendarValue instanceof DateTimeValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a dateTime, but the second is not");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        return super.subtract(calendarValue, xPathContext);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(Date.class)) {
            return this.getCalendar().getTime();
        }
        if (clazz.isAssignableFrom(GregorianCalendar.class)) {
            return this.getCalendar();
        }
        if (clazz.isAssignableFrom(DateTimeValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of dateTime to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.year > 0 ? this.year : this.year - 1);
            }
            case 2: {
                return new IntegerValue(this.month);
            }
            case 3: {
                return new IntegerValue(this.day);
            }
            case 4: {
                return new IntegerValue(this.hour);
            }
            case 5: {
                return new IntegerValue(this.minute);
            }
            case 6: {
                BigDecimal bigDecimal = BigDecimal.valueOf(this.microsecond);
                bigDecimal = bigDecimal.divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 4);
                bigDecimal = bigDecimal.add(BigDecimal.valueOf(this.second));
                return new DecimalValue(bigDecimal);
            }
            case 11: {
                return new IntegerValue(this.microsecond);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return SecondsDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60 * 1000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for dateTime: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateTimeValue)) {
            throw new ClassCastException("DateTime values are not comparable to " + object.getClass());
        }
        return this.compareTo((DateTimeValue)object, new Configuration());
    }

    public int compareTo(CalendarValue calendarValue, Configuration configuration) {
        if (!(calendarValue instanceof DateTimeValue)) {
            throw new ClassCastException("DateTime values are not comparable to " + calendarValue.getClass());
        }
        DateTimeValue dateTimeValue = (DateTimeValue)calendarValue;
        if (this.getTimezoneInMinutes() == dateTimeValue.getTimezoneInMinutes()) {
            if (this.year != dateTimeValue.year) {
                return this.year - dateTimeValue.year;
            }
            if (this.month != dateTimeValue.month) {
                return this.month - dateTimeValue.month;
            }
            if (this.day != dateTimeValue.day) {
                return this.day - dateTimeValue.day;
            }
            if (this.hour != dateTimeValue.hour) {
                return this.hour - dateTimeValue.hour;
            }
            if (this.minute != dateTimeValue.minute) {
                return this.minute - dateTimeValue.minute;
            }
            if (this.second != dateTimeValue.second) {
                return this.second - dateTimeValue.second;
            }
            if (this.microsecond != dateTimeValue.microsecond) {
                return this.microsecond - dateTimeValue.microsecond;
            }
            return 0;
        }
        return this.normalize(configuration).compareTo(dateTimeValue.normalize(configuration), configuration);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        if (this.hasTimezone()) {
            return this.getCalendar().getTime().hashCode();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = (gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000;
        DateTimeValue dateTimeValue = (DateTimeValue)this.adjustTimezone(n);
        return dateTimeValue.getCalendar().getTime().hashCode();
    }
}

