/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 0a2c3f27-f43b-4dfe-9c48-8e1dfde67e89
 * 
 */

#ifndef   _CM_CONFIGSOURCE_H_
#define   _CM_CONFIGSOURCE_H_

#include <string>
#include <stdexcept>

class Path;
class ConfigSource
{

public:
  static ConfigSource* Create(std::string const &url)throw(std::exception *);
  static ConfigSource* Create(Path const &location, ConfigSource const *) throw (std::exception *);
  static bool Verbose();
  static void Verbose(bool const &);
  virtual std::string url(bool const &) const = 0;

  /* retrieve a tree */
  virtual void get (std::string const &) const throw(std::exception *) = 0 ;
  /* update from the same or a different source */
  virtual void update (std::string const &) const throw(std::exception *)= 0;
  /* changes against the same or a different source */
  virtual int changes (std::string const &) const throw(std::exception *){return 0;}
  /* missing repository patches against the same or a different source */
  virtual int missing (std::string const &) const throw(std::exception *){return 0;}
  /* mark a sub tree to be ignored by its parent - 
   * called on the parent object */
  virtual void ignore (ConfigSource const *, std::string const &) const throw (std::exception *) = 0;

    virtual std::string treeVersion(std::string const &where) const = 0;
 protected:
    void run (std::string const &command, std::string const &type) const;
    int run_query (std::string const &command, std::string const &type) const;
 private:
    static bool Verbose_;
};

#endif /* _CM_CONFIGSOURCE_H_ */
