dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2006 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.57)

AC_DEFUN([CL_TIMES_CLOCK],
[AC_REQUIRE([CL_GETTIMEOFDAY])dnl
if test $ac_cv_func_gettimeofday = no -a $ac_cv_func_ftime = no; then
AC_CHECK_FUNC(times, , no_times=1)dnl
if test -z "$no_times"; then
AC_CACHE_CHECK(for times return value, cl_cv_func_times_return, [
AC_TRY_RUN([
#include <stdlib.h> /* needed for exit() */
#include <sys/types.h>
#include <time.h> /* needed for CLK_TCK */
#ifndef CLK_TCK
#include <sys/time.h> /* needed for CLK_TCK on SYSV PTX */
#endif
#include <sys/times.h>
int main ()
{ struct tms buffer;
  clock_t result1;
  clock_t result2;
  int ticks;
  result1 = times(&buffer);
  if ((result1 == (clock_t)0) || (result1 == (clock_t)(-1))) exit(1);
  sleep(1);
  result2 = times(&buffer);
  if ((result2 == (clock_t)0) || (result2 == (clock_t)(-1))) exit(1);
  ticks = result2 - result1;
  exit(!((ticks >= CLK_TCK/2) && (ticks <= 3*CLK_TCK/2)));
}], cl_cv_func_times_return=yes, cl_cv_func_times_return=no,
dnl When cross-compiling, don't assume anything.
cl_cv_func_times_return="guessing no")
])
case "$cl_cv_func_times_return" in
  *yes) AC_DEFINE(HAVE_TIMES_CLOCK,,[have the times() function and it returns the real time, but do not have the gettimeofday() or ftime() function]) ;;
  *no)  ;;
esac
fi
fi
])
