#ifndef TICTACTOEGAME_H
#define TICTACTOEGAME_H

// Include necessary CL header files
#include <ClanLib/display.h>
#include <ClanLib/core.h>

#define BLANK_CELL 0
#define PLAYER_CELL 1
#define COMPUTER_CELL 2

#define CELLSIDE 100

class TicTacToeGame {

public:
	TicTacToeGame();
	~TicTacToeGame();

	void loadGraphics();	// Load the game graphics
	void paint();			// Paint the board and moves
	void run();				// Game loop
	void handleMousePress(const CL_InputEvent &key);

	void computerMove();	// Game AI
	void checkWinner();		// If someone has won, fill board with their piece
	int findWinner();		// Actually determine if someone has won
	void resetGame();		// Clear the board

private:
	bool alive, playing;
	CL_Surface *board, *o, *x, *menu;
	CL_Slot mousePress;
	int cells[3][3];
};

#endif