# CiviCRM 5.9.0

Released January 2, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Api3 - Add uf_user contact search param
  ([13230](https://github.com/civicrm/civicrm-core/pull/13230))**

  The Contact.get API can now be filtered by whether a contact is associated
  with a CMS user.

- **[dev/core#217](https://lab.civicrm.org/dev/core/issues/217) Allow
  replacement of PrevNextCache implementation (for search screens)
  ([13168](https://github.com/civicrm/civicrm-core/pull/13168) and
  [12665](https://github.com/civicrm/civicrm-core/pull/12665))**

  This change makes it possible to use Redis to store the prev-next cache used
  by contact-search screens by updating the setting "PrevNext Cache" on the
  Administer -> Misc page.

- **[dev/core#371](https://lab.civicrm.org/dev/core/issues/371) Be
  environmentally friendly. Remove the sentence: "Please print this page for
  your records." from the various CiviCRM tpls. We like trees!
  ([13156](https://github.com/civicrm/civicrm-core/pull/13156))**

  This change removes the sentence "Please print this page for your records."
  from the Thank You page for online contribution and event registration pages.

- **[dev/core#561](https://lab.civicrm.org/dev/core/issues/561) Replace
  jcalendar instances with datepicker
  ([13206](https://github.com/civicrm/civicrm-core/pull/13206),
  [13208](https://github.com/civicrm/civicrm-core/pull/13208),
  [13203](https://github.com/civicrm/civicrm-core/pull/13203),
  [13196](https://github.com/civicrm/civicrm-core/pull/13196) and
  [13198](https://github.com/civicrm/civicrm-core/pull/13198)) - Continues Work
  Towards**

  These changes switch fields that store dates from jcalendar to use the
  datepicker in the following places: the pledge payment form, the tagged
  contributions custom search, the activity custom search form, the price field
  form and the Event Aggregate Custom search.

- **[dev/core#11](https://lab.civicrm.org/dev/core/issues/11) Email - send now
  error screen should display earlier
  ([13207](https://github.com/civicrm/civicrm-core/pull/13207))**

  From the results of an advanced search one can select the action option "Email -
  send now (to 50 or less)" this change improves user experience by throwing an
  error if a user tries to select more than 50 contacts and this action (when
  displaying the results as contributions or memberships).

- **[dev/core#505](https://lab.civicrm.org/dev/core/issues/505) Allow for
  Extensions to set the CRM Type and PHP Type when dealing with unusual MySQL
  Types ([13059](https://github.com/civicrm/civicrm-core/pull/13059))**

  This change makes it so extension authors can specify phpType and crmType
  in their xml files.

- **[dev-core#565](https://lab.civicrm.org/dev/core/issues/565) Make subject
  field of Note, inline editable in contact summary page
  ([13190](https://github.com/civicrm/civicrm-core/pull/13190))**

  This change makes it so that users can inline edit note fields on the contact
  summary page.

- **Make world_region translate on advanced search field
  ([13212](https://github.com/civicrm/civicrm-core/pull/13212))**

  This change ensures that on the Advanced Search Form the world region field
  gets translated.

- **Fix Job Log entries containing links so they will display properly
  ([12659](https://github.com/civicrm/civicrm-core/pull/12659))**

  This change improves the links and general html formating of the log for
  the geocode scheduled job.

- **Upgrade to Quickform 3.2.16
  ([224](https://github.com/civicrm/civicrm-packages/pull/224))**

  This change updates Quickform from  3.2.11 to 3.2.16.

- **Fix Export when full group by mode is used
  ([13124](https://github.com/civicrm/civicrm-core/pull/13124))**

  This change improves performance when exporting.

- **[dev/cloud-native/issues#18](https://lab.civicrm.org/dev/cloud-native/issues/18)
  Soften messages for read-only extensionsDir
  ([13100](https://github.com/civicrm/civicrm-core/pull/13100))**

  This change makes it so that if the extensions directory is "Read Only" the
  help text that appears is a notice instead of a warning.

### CiviContribute

- **[dev/core#518](https://lab.civicrm.org/dev/core/issues/518) Lybunt
  performance improvement
  ([13088](https://github.com/civicrm/civicrm-core/pull/13088))**

  This change improves performance of the LYBUNT report.

- **Lybunt report - improve developer support for debugging this report
  ([13087](https://github.com/civicrm/civicrm-core/pull/13087))**

  This change makes it so that the developer tab on the Lybunt report shows
  group queries.

- **[dev/core#536](https://lab.civicrm.org/dev/core/issues/536) Contribution tab
  is slow to render for contacts with many contributions (in large database)
  ([13149](https://github.com/civicrm/civicrm-core/pull/13149))**

  This change improves performance of the Contributions tab on contact records.

- **Set default financial_type_id for creating new payment processors (form &
  api) ([13181](https://github.com/civicrm/civicrm-core/pull/13181))**

  This change makes it so that the required field "Financial Account" on the
  "New Payment Processor" form defaults to "Payment Processor Account".

### CiviMail

- **Display message template title on deletion form
  ([13058](https://github.com/civicrm/civicrm-core/pull/13058))**

  This change improves user experience when deleting Message Templates by
  displaying the Message Template name in the Deletion Confirmation popup.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#606](https://lab.civicrm.org/dev/core/issues/606) Wrong
  redirection when view/editing Option Groups inside a modal
  ([13312](https://github.com/civicrm/civicrm-core/pull/13312))**

  This resolves a regression on saving a new option value in the context of
  editing something else (like creating an event or editing a contact).  While
  the form would open as a modal on top of unsaved work, saving the new option
  would cause the parent window to redirect, losing your work on the parent
  screen.

- **[dev/core#594](https://lab.civicrm.org/dev/core/issues/594) WYSIWYG Editor
  affected in CiviCRM 5.8.0
  ([13361](https://github.com/civicrm/civicrm-core/pull/13361))

  This resolves a bug causing an invalid setting when changing WYSIWYG editors.

- **[dev/core#125](https://lab.civicrm.org/dev/core/issues/125) Invalid link to
  custom-fields documentation
  ([13199](https://github.com/civicrm/civicrm-core/pull/13199))**

  This change fixes the link to the Custom Fields documentation on the Custom
  Group form to point to the correct documentation page.

- **[dev/core#372](https://lab.civicrm.org/dev/core/issues/372) 5.6.alpha1
  notice ([13079](https://github.com/civicrm/civicrm-core/pull/13079))**

  This change fixes a bug where editing an activity that had no details would
  result in a notice error.

- **[dev/core#406](https://lab.civicrm.org/dev/core/issues/406) 5.5.2: Import is
  not happy on PHP-7.2 (Countable)
  ([13133](https://github.com/civicrm/civicrm-core/pull/13133))**

  This change fixes a "PHP Warning:  count():" warning for users running PHP 7.2
  when importing.

- **[dev/core#442](https://lab.civicrm.org/dev/core/issues/442) Misc form issues
  ([13197](https://github.com/civicrm/civicrm-core/pull/13197))**

  This change makes a variety of small styling improvements including: On the
  New Individual form, in the "Tags and Groups" section aligning the Tags and
  Groups boxes properly and using text inputs instead to text areas on the word
  replacements form.

- **[dev/core/482](https://lab.civicrm.org/dev/core/issues/482) New
  Organization: There is no possible to add another website after deleting
  ([13169](https://github.com/civicrm/civicrm-core/pull/13169)) -- Work
  towards**

  When adding a new contact via the "New Individual", "New Organization" etc
  forms, or editing a contact, the website section allows a user to delete a
  website field even if it's the only one left. After deleting the last website
  field, the user would not able to add a new one. This change makes Website work
  like Phone Number, Email, and IM: one cannot delete the last website field.

- **[dev/core#503](https://lab.civicrm.org/dev/core/issues/503) Editing Rich
  Text custom field on relationship non-functional
  ([13076](https://github.com/civicrm/civicrm-core/pull/13076))**

  This fixes a bug where editing a Note/RichTextEditor custom field on a
  relationship would result in the HTML tags being encoded into the content and
  piling up each time one edits the field.  Now, HTML tags to not get
  encoded.

- **[dev/core#525](https://lab.civicrm.org/dev/core/issues/525) Extraneous
  br-tags in rendered note-fields
  ([13101](https://github.com/civicrm/civicrm-core/pull/13101))**

  This change fixes a bug where note fields were being rendered with extra blank
  lines so that blank lines are not duplicated.

- **[dev/core#527](https://lab.civicrm.org/dev/core/issues/527) Non translatable
  fields in profile schema
  ([13110](https://github.com/civicrm/civicrm-core/pull/13110))**

  This change makes the "Public Title" field on the profile form translatable.

- **[dev/core#529](https://lab.civicrm.org/dev/core/issues/529) Editing smart
  group removes search criteria unless criteria tabs are opened first
  ([13217](https://github.com/civicrm/civicrm-core/pull/13217))**

  This change ensures that when editing smart groups the previously selected
  criteria is respected regardless of whether or not the criteria tabs are
  opened first.

- **[dev/core#540](https://lab.civicrm.org/dev/core/issues/540) Civicrm Contact
  Dashboard returns fatal error
  ([13140](https://github.com/civicrm/civicrm-core/pull/13140))**

  This fixes the 'Cannot determine api action for
  CRM_Contribute_Form_Search.CRM_Core_Action "NO DESCRIPTION SET"' error when
  visiting a url like https://dmaster.demo.civicrm.org/civicrm/user?reset=1.

- **[dev/core#559](https://lab.civicrm.org/dev/core/issues/559) AngularJS module
  crmUi has an unstated dependency on ui.utils
  ([13180](https://github.com/civicrm/civicrm-core/pull/13180))**

  This change decleares crmUi's dependency on ui.Utils so that developers do not
  have to do so when creating custom AngularJS base pages.

- **[dev/core#573](https://lab.civicrm.org/dev/core/issues/573) State field
  displays too small
  ([13223](https://github.com/civicrm/civicrm-core/pull/13223))**

  This change fixes the styling of select 2's on front facing forms so that
  the text is centered and the select 2 is approximately the same size as a text
  box.

- **Add custom search handling for jcalendar converstion.
  ([13209](https://github.com/civicrm/civicrm-core/pull/13209))**

  This change fixes smart groups created using the last activity custom search
  and event aggregate custom search and a date field (post the jcalendar
  conversion).

- **[CRM-19115](https://issues.civicrm.org/jira/browse/CRM-19115) PHP and MySQL
  timezones mismatch over API but not in UI
  ([13220](https://github.com/civicrm/civicrm-core/pull/13220) and
  [13218](https://github.com/civicrm/civicrm-core/pull/13218))**

  This change makes it so the curl request for `System.check` reports that
  `checkMysqlTime` passes because the PHP time and MySQL time are aligned.

- **[dev/core#557](https://lab.civicrm.org/dev/core/issues/557) Prevent jump
  when revealing help sections on "Administer CiviCRM" screen
  ([13173](https://github.com/civicrm/civicrm-core/pull/13173))**

  On the "Administer CiviCRM" screen, this change makes it so that when one
  opens a help section the page no longer jumps to the anchor.

- **Api3 profile:submit - fix handling of greeting fields
  ([13161](https://github.com/civicrm/civicrm-core/pull/13161))**

  This change ensures that the Api3 call Profile.submit works with a custom
  greeting selected. Specifically this change fixes a bug when using the Layout
  Editor extension and attempting to save a custom greeting.

- **Avoid permission checking on getOrganizationNames
  ([13162](https://github.com/civicrm/civicrm-core/pull/13162))**

  This change ensures that users with contribution permissions can use
  the Bookkeeping Transactions Report.

- **[CRM-21427](https://issues.civicrm.org/jira/browse/CRM-21427) Websites are
  removed from the contact if their type is empty
  ([13097](https://github.com/civicrm/civicrm-core/pull/13097))**

  This change fixes a bug where on the contact form, attempting to save
  multiple websites of the same type would result in a validation error so that
  one can save multiple websites of the same type on a contact record.

- **[dev/core#526](https://lab.civicrm.org/dev/core/issues/526) Feedback cannot
  be translated when saving Contribution Page forms in languages other than
  English ([13102](https://github.com/civicrm/civicrm-core/pull/13102))**

  This change fixes an untranslated string on part of the success message on
  saving a Contribution settings form.

- **Add merge link to duplicate contact popup
  ([13081](https://github.com/civicrm/civicrm-core/pull/13081))**

  This change adds a "Merge: link to the "Similar Contact Found" popup.  This
  link had been inadvertently removed.

- **Fix continue / break warning under PHP 7.3
  ([228](https://github.com/civicrm/civicrm-packages/pull/228) and
  [13066](https://github.com/civicrm/civicrm-core/pull/13066))**

  This changes fix some  "Did you mean to use 'continue 2'?" PHP warnings issued
  for users on PHP 7.3.

- **Php 7.2 fix notice on countable
  ([229](https://github.com/civicrm/civicrm-packages/pull/229))**

  This change fixes an enotice for users on PHP 7.2 configured to show warnings.

- **Fix php7.2 notices on trying to count null
  ([13111](https://github.com/civicrm/civicrm-core/pull/13111))**

  These changes fix a number of countable warning messages in PHP 7.2 for sites
  configured to show warnings.

- **Fix warning error on php 7.2 ([13107](https://github.com/civicrm/civicrm-core/pull/13107))**

  This change fixes a countable warning for users on php 7.2 with sites
  configured to show warnings.

- **[dev/core#337](https://lab.civicrm.org/dev/core/issues/337) Fix Search 
  Range for custom field of types Money, Float and Int using widget types Select and Radio
  ([13314](https://github.com/civicrm/civicrm-core/pull/13314) and 
  [13384](https://github.com/civicrm/civicrm-core/pull/13384))**

  This fixes an issue where the search forms would not behave properly when trying
  to search by range for custom fields of type Money, Float and Int where the html
  widget was set to Select or Radio.

- **[dev/core#619](https://lab.civicrm.org/dev/core/issues/619) Fix Regression 
  for custom contact refrence fields on address entity
  ([13385](https://github.com/civicrm/civicrm-core/pull/13385))**

  This fixes a regression whereby custom fields of type contact reference when attached
  to address fields were not outputting any results due to work done previously to fix
  the same type of fields on on behalf of profiles.

### CiviCase

- **[dev/core#321](https://lab.civicrm.org/dev/core/issues/321) Prevent
  duplicate entries in civicrm_entity_file
  ([12650](https://github.com/civicrm/civicrm-core/pull/12650))**

  This change fixes a bug where editing a case activity with an attachment would
  result in a duplicate entry in the civicrm_entity_file table.

- **[dev/core#563](https://lab.civicrm.org/dev/core/issues/563) Duplicate Case
  manager role ([13188](https://github.com/civicrm/civicrm-core/pull/13188))**

  This fixes a bug where editing a case manager would result in a duplicate
  case manager role being created.

- **[dev/core#467](https://lab.civicrm.org/dev/core/issues/467) Case Start Date
  and End Date don't work properly in Batch Update
  ([13095](https://github.com/civicrm/civicrm-core/pull/13095))**

  This change fixes a bug when attempting to batch update a case start date or
  end date would result in a undefined index error so that no undefined index
  error is thrown and one can select the start and end dates for cases
  on the batch update form appropriately.

### CiviContribute

- **[dev/core#407](https://lab.civicrm.org/dev/core/issues/407) Error with
  currency localization when recording a payment
  ([13226](https://github.com/civicrm/civicrm-core/pull/13226))**

  This change fixes a bug for users in localities where commas are used for the
  decimal place and periods for the thousand separator: saving price set
  information on the membership tab for a contribution page would result in an
  error.

- **[dev/core#528](https://lab.civicrm.org/dev/core/issues/528) Advanced Search ->
  Contribution Tab and Contribution Dashboard returns a fatal error.
  ([13112](https://github.com/civicrm/civicrm-core/pull/13112))**

  This change fixes a network error when opening the Contributions tab on the
  Advanced Search.

- **[dev/core#532](https://lab.civicrm.org/dev/core/issues/532) Multi-select
  field not respected in batch search
  ([13121](https://github.com/civicrm/civicrm-core/pull/13121))**

  This resolves a problem where the batch transaction search would fail if
  multiple Financial Type options were selected.

- **[dev/core#153](https://lab.civicrm.org/dev/core/issues/153) Pending Pay
  Later /w Custom payment method
  ([13098](https://github.com/civicrm/civicrm-core/pull/13098))**

  This change fixes a bug where using a custom payment method to make a pending
  pay later contribution would result in a contribution that one could not
  record payments against.

- **[dev/core#193](https://lab.civicrm.org/dev/core/issues/193) Order API Throw
  an error when adding tax amount on line items
  ([13091](https://github.com/civicrm/civicrm-core/pull/13091))**

  This change fixes a bug where the Order API would fail when doing a create order
  with taxes enabled.

- **[dev/core#513](https://lab.civicrm.org/dev/core/issues/513) Contribution
  Transact API - Use the payment processor payment method instead of the
  payment_type field
  ([13073](https://github.com/civicrm/civicrm-core/pull/13073))**

  This change makes it so that the Contribute.Transact API retrieves the payment
  instrument ID from the payment processor rather than assuming it from the
  payment type.

- **Set currency template variable from contribution pages
  ([13157](https://github.com/civicrm/civicrm-core/pull/13157))**

  This change ensures that the currencyId smarty variable gets populated on
  contribution pages.

- **Fix metadata on cancel_reason so it is an exportable field
  ([12775](https://github.com/civicrm/civicrm-core/pull/12775))**

  When searching for contributions, this change makes the "Cancel Reason"
  criteria searchable so that it can be exported.

- **Fix php 7.2 notice
  ([13132](https://github.com/civicrm/civicrm-core/pull/13132))**

  This change fixes a countable notice on the Contribution View page in PHP 7.2
  for sites configured to show warnings.

### CiviEvent

- **Update name of icon from pencil to wrench in EventInfo help
  ([13119](https://github.com/civicrm/civicrm-core/pull/13119))**

  This change updates the help text on the Event info page to refer to the
  wrench icon as a wrench (instead of as a pencil).

- **Fix Configure Event help grammar
  ([13118](https://github.com/civicrm/civicrm-core/pull/13118))**

  This change improves the grammar of the Configure Event help text.

### CiviMail

- **[dev/core#498](https://lab.civicrm.org/dev/core/issues/498) Undefined index
  in mailing report for mailing_modified_date; and room for refactoring
  ([13194](https://github.com/civicrm/civicrm-core/pull/13194))**

  This change fixes an undefined index notice on the mailing modified date that
  was showing up on all mailing reports.

- **[CRM-19751](https://issues.civicrm.org/jira/browse/CRM-19751) Once "multiple
  bulk" setting, cannot search for opt out or on hold contacts
  ([12942](https://github.com/civicrm/civicrm-core/pull/12942))**

  For users with the setting "Enable multiple bulk email address for a contact"
  enabled this change updates the Advanced search form "Email On Hold" field to
  be a select that lists the Email on Hold options enabled by this setting
  ("No", "On Hold Bounce", "On Hold Opt Out"). Users with the setting "Enable
  multiple bulk email address for a contact" enabled should edit any existing
  smart groups they have that filter on the "Email On Hold" field.

- **[dev/mail#23](https://lab.civicrm.org/dev/mail/issues/23) Bounce processing
  doesn't catch pattern 'user doesn't exist'
  ([13200](https://github.com/civicrm/civicrm-core/pull/13200))**

  This change makes it so that the bounce pattern 'user doesn't exist' is
  registered as an invalid bounce type.

- **Fix accidental scroll when saving/deleting CiviMail draft
  ([13085](https://github.com/civicrm/civicrm-core/pull/13085))**

  This change fixes a bug where when working on a CiviMail draft, clicking save
  or delete draft would result in the page scrolling to the top, so that the
  page does not scroll when you click Save or Delete Draft.

### CiviMember

- **[dev/core#511](https://lab.civicrm.org/dev/core/issues/511) Membership
  Dashboard shows incorrect month
 ([13072](https://github.com/civicrm/civicrm-core/pull/13072))**

  This change ensures that the Membership Dashboard shows the correct current
  month.

### Drupal Integration

- **[dev/drupal#31](https://lab.civicrm.org/dev/drupal/issues/31) CiviMember
  Role sync is no longer syncing Pending memberships
  ([543](https://github.com/civicrm/civicrm-drupal/pull/543))**

  This change fixes a bug where the Drupal module CiviMember Role sync was not
  syncing memberships for the role sync rule "Add when status is set to
  Pending" so that this rule works as expected.

## <a name="misc"></a>Miscellany

- **Update npm dependencies to fix audit issues
  ([13195](https://github.com/civicrm/civicrm-core/pull/13195))**

  This change updates several dependencies including: karma from 2.0.2 to
  3.1.1, jasmine-core from 3.1.0 to 3.3.0 and karma-jasmine from 1.1.2 to 2.0.1.

- **Fix PHP7.2 warning when re-generating schema files
  ([232](https://github.com/civicrm/civicrm-packages/pull/232))**

  This change fixes a warning when regenerating schema files (running either
  ./bin/setup.sh -Dg or ./bin/regen.sh) for users on PHP 7.2.

- **Add \Civi\Token\TokenProcessor::getContextValues()
  ([13214](https://github.com/civicrm/civicrm-core/pull/13214))**

- **Prototype for metadata based fields on search screens.
  ([13013](https://github.com/civicrm/civicrm-core/pull/13013))**

- **(NFC) Add in unit test of dev/core#93 expansion to allow order by of more t…
  ([13077](https://github.com/civicrm/civicrm-core/pull/13077))**

- **Fix test name because it is not running & doesn't pass :-(
  ([13143](https://github.com/civicrm/civicrm-core/pull/13143))**

- **Trivial code cleanup
  ([13166](https://github.com/civicrm/civicrm-core/pull/13166))**

- **[NFC] Extract getUserCheckSum function
  ([13167](https://github.com/civicrm/civicrm-core/pull/13167))**

- **(NFC) Regenerate DAO Checksums after changes to codegen
  ([13204](https://github.com/civicrm/civicrm-core/pull/13204))**

- **Export code cleanup -remove meaningless code
  ([13083](https://github.com/civicrm/civicrm-core/pull/13083))**

- **Export code cleanup - remove silly function
  ([13122](https://github.com/civicrm/civicrm-core/pull/13122))**

- **Export class cleanup - remove some unnecessary code
  ([13120](https://github.com/civicrm/civicrm-core/pull/13120))**

- **Test support for fixing dev/core#397 including adding Rule api
  ([13179](https://github.com/civicrm/civicrm-core/pull/13179))**

- **Unit test set up tweak - Set trxn_id & invoice_id in tests as needed rather
  than by default.
  ([13146](https://github.com/civicrm/civicrm-core/pull/13146))**

- **Fixes to enable UserDashboard tests to all run
  ([13147](https://github.com/civicrm/civicrm-core/pull/13147))**

- **[REF] Rename recently added getUrlVariables getFormVariables function…
  ([13225](https://github.com/civicrm/civicrm-core/pull/13225))**

- **[REF] refactor shared search functions in pre-Process
  ([13210](https://github.com/civicrm/civicrm-core/pull/13210))**

- **(REF) Allow subclasses of AbstractTokenSubscriber to override the
  determination of active tokens.
  ([13186](https://github.com/civicrm/civicrm-core/pull/13186))**

- **Activity tab code refactor
  ([12557](https://github.com/civicrm/civicrm-core/pull/12557))**

- **Export code cleanup - only construct one metadata array with all types of
  metadata ([13126](https://github.com/civicrm/civicrm-core/pull/13126))**

- **Export code clean up - extract build row & getTransformed row off to
  ExportProcessor
  ([13117](https://github.com/civicrm/civicrm-core/pull/13117))**

- **Export code cleanup - Use getComponentPaymentFields from processorClass
  ([13082](https://github.com/civicrm/civicrm-core/pull/13082))**

- **Flatten fix ([13176](https://github.com/civicrm/civicrm-core/pull/13176))**

- **Extract getContributionBalance function, use that rather than wrapper…
  ([13151](https://github.com/civicrm/civicrm-core/pull/13151))**

- **[dev/core#562](https://lab.civicrm.org/dev/core/issues/562) Remove instances
  of $dao->free ([13192](https://github.com/civicrm/civicrm-core/pull/13192)) -
  Work towards**

- **Displayvalue fixes
  ([13175](https://github.com/civicrm/civicrm-core/pull/13175))**

- **Typos, simplify if statement
  ([13233](https://github.com/civicrm/civicrm-core/pull/13233))**

- **Remove Defunct Templates from CiviMail
  ([13201](https://github.com/civicrm/civicrm-core/pull/13201))**

- **Minor Contact BAO code cleanup
  ([13115](https://github.com/civicrm/civicrm-core/pull/13115))**

- **Trigger post hook on Event Copy
  ([12990](https://github.com/civicrm/civicrm-core/pull/12990))**

- **CRM_Core_I18n::setLocale should change $tsLocale for getLocale() to work
  correctly ([13050](https://github.com/civicrm/civicrm-core/pull/13050))**

- **(RFC) Fix Locale Test by re-setting the locale used to en_US and by
  resetting the I18n singleton
  ([13246](https://github.com/civicrm/civicrm-core/pull/13246))**

- **(NFC) Update Copyrite year to be 2019
  ([13267](https://github.com/civicrm/civicrm-core/pull/13267))**

- **(NFC) whitespace header fixes
  ([13271](https://github.com/civicrm/civicrm-core/pull/13271))**

- **Fix PHP7.2 Count error on test testImportParserWtihEmployeeOfRelationship
  ([13315](https://github.com/civicrm/civicrm-core/pull/13315))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt, Eli Lisseck; Agileware - Agileware
Team, Francis Whittle; Australian Greens - Seamus Lee; Christian Wach; CiviCRM -
Coleman Watts, Tim Otten; CompuCorp - Omar Abu Hussein; Coop SymbioTIC -
Guillaume Boudrias, Mathieu Lutfy; Francesc Bassas i Bullich; Fuzion - Jitendra
Purohit; Ginkgo Street Labs - Frank Gómez; JMA Consulting - Joe Murray, Monish
Deb; John Kingsnorth; Joinery - Allen Shaw; Ken West; Lemniscus - Noah Miller;
MJW Consulting - Matthew Wire; Pradeep Nayak; Ray Wright; Squiffle Consulting -
Aidan Saunders; Systopia - Thomas Leichtfuss; Tiotsop Gerest; Wikimedia
Foundation - Eileen McNaughton, Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Brooks Digital - Spencer Brooks; Chandana Bandara; CompuCorp - Alessandro
Verdura; Fuzion - Luke Stewart; iXiam - Luciano Spiegel; Korlon - Stuart Gaston;
Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; Paul Barmak; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
