/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2012 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

#include "cdw_task.h"
#include "gettext.h"
#include "cdw_string.h"
#include "cdw_main_window.h"
#include "cdw_debug.h"
#include "cdw_form.h"
#include "cdw_growisofs_options.h"
#include "cdw_ext_tools.h"


static cdw_task_t *local_task = (cdw_task_t *) NULL;

enum {
	f_growisofs_other_l,
	f_growisofs_other_i };



static FIELD *page_growisofs_fields[CDW_GROWISOFS_OPTIONS_N_FIELDS + 1]; /* +1 for last field == NULL */


cdw_rv_t cdw_growisofs_options_form(cdw_form_t *cdw_form, void *cdw_task, int first_col, __attribute__((unused)) int second_col, int width_wide, __attribute__((unused)) int width_narrow)
{
	cdw_task_t *task = (cdw_task_t *) cdw_task;
	local_task = task;
	cdw_form->fields = page_growisofs_fields;

	cdw_form_descr_t descr[] = {
		/*     type       begin_y  begin_x   n_cols     n_lines  field enum            data1                                       data2 */

		/* 2TRANS: this is a label for input field: "Other options passed to growisofs */
		{ CDW_WIDGET_LABEL,  1,  first_col,  width_wide,     1,  f_growisofs_other_l,  _("Other growisofs options:"),                 0 },
		{ CDW_WIDGET_INPUT,  2,  first_col,  width_wide - 3, 1,  f_growisofs_other_i,  task->burn.growisofs.other_growisofs_options,  0 },

		/* guard */
		{ -1,                0,  0,          0,              0,  0,                   (void *) NULL,                                  0 }};

	cdw_rv_t crv = cdw_form_description_to_fields(descr, cdw_form);
	if (crv != CDW_OK) {
		cdw_vdm ("ERROR: failed to convert form description to form\n");
		return CDW_ERROR;
	} else {
		return CDW_OK;
	}
}





cdw_rv_t cdw_growisofs_options_validate(cdw_form_t *cdw_form, int *fi)
{
	char *s = cdw_ncurses_get_field_string(*(cdw_form->fields + f_growisofs_other_i));
	cdw_rv_t crv = cdw_string_security_parser(s, (char *) NULL);
	if (crv != CDW_OK) {
		*fi = f_growisofs_other_i;
		return CDW_NO;
	}

	return CDW_OK;
}





cdw_rv_t cdw_growisofs_options_save(cdw_form_t *cdw_form, cdw_task_t *task)
{
	cdw_string_set(&(task->burn.growisofs.other_growisofs_options), cdw_ncurses_get_field_string(*(cdw_form->fields + f_growisofs_other_i)));

	return CDW_OK;
}

