/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _INTERP_NAMES_H
#define _INTERP_NAMES_H

/*
** $Id: INTERP_F.H,v 1.13 2002/10/07 20:44:37 almgren Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_NBINTERP    nbinterp
#    define FORT_CBINTERP    cbinterp
#    define FORT_CCINTERP    ccinterp
#    define FORT_LINCCINTERP linccinterp
#    define FORT_CQINTERP    cqinterp
#    define FORT_CCINTERP2   ccinterp2
#    define FORT_PCINTERP    pcinterp
#    define FORT_PROTECT_INTERP    printerp
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_NBINTERP    NBINTERP
#    define FORT_CBINTERP    CBINTERP
#    define FORT_CCINTERP    CCINTERP
#    define FORT_LINCCINTERP LINCCINTERP
#    define FORT_CQINTERP    CQINTERP
#    define FORT_CCINTERP2   CCINTERP2
#    define FORT_PCINTERP    PCINTERP
#    define FORT_PROTECT_INTERP    PRINTERP
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_NBINTERP    nbinterp
#    define FORT_CBINTERP    cbinterp
#    define FORT_CCINTERP    ccinterp
#    define FORT_LINCCINTERP linccinterp
#    define FORT_CQINTERP    cqinterp
#    define FORT_CCINTERP2   ccinterp2
#    define FORT_PCINTERP    pcinterp
#    define FORT_PROTECT_INTERP    printerp
#  else
#    define FORT_NBINTERP    nbinterp_
#    define FORT_CBINTERP    cbinterp_
#    define FORT_CCINTERP    ccinterp_
#    define FORT_LINCCINTERP linccinterp_
#    define FORT_CQINTERP    cqinterp_
#    define FORT_CCINTERP2   ccinterp2_
#    define FORT_PCINTERP    pcinterp_
#    define FORT_PROTECT_INTERP    printerp_
#  endif
#  endif

#include <ArrayLim.H>

extern "C"
{
    void FORT_NBINTERP (const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                        ARLIM_P(cblo), ARLIM_P(cbhi),
                        Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                        ARLIM_P(fblo), ARLIM_P(fbhi),
                        D_DECL(const int* lrx,const int* lry,const int* lrz),
                        const int* nvar, Real* slope, const int* num_slope);
      
    void FORT_CBINTERP (const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                        ARLIM_P(cblo), ARLIM_P(cbhi),
                        Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                        ARLIM_P(fblo), ARLIM_P(fbhi),
                        D_DECL(const int* lrx,const int* lry,const int* lrz),
                        const int* nvar, Real* slope, const int* num_slope,
                        Real* strip, const int* strip_lo, const int* strip_hi);

    void FORT_CCINTERP (Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                        ARLIM_P(fblo), ARLIM_P(fbhi),
                        const int* nvar,
                        D_DECL(const int* lrx,const int* lry,const int* lrz),
                        const Real* crse, const int* clo, const int* chi,
                        ARLIM_P(cblo), ARLIM_P(cbhi),
                        const int* fslo, const int* fshi,
                        Real* cslope, const int* clen,
                        Real* fslope, Real* fdat, const int* flen,
                        Real* voff,
                        const int* bc, const int* lim_slope,
                        D_DECL(const Real* fvcx,const Real* fvcy, const Real* fvcz),
                        D_DECL(const Real* cvcx,const Real* cvcy, const Real* cvcz),
                        Real* cmax, Real* cmin, Real* alpha);

    void FORT_CCINTERP2 (Real* fine, const int* flo, const int* fhi,
                         ARLIM_P(fblo), ARLIM_P(fbhi),
                         const int* nvar,
                         D_DECL(const int* lrx,const int* lry,const int* lrz),
                         const Real* crse, const int* clo, const int* chi,
                         ARLIM_P(cblo), ARLIM_P(cbhi),
                         const int* fslo, const int* fshi,
                         Real* cslope, const int* clen,
                         Real* fslope, Real* fdat, const int* flen,
                         Real* voff,
                         const int* bc, const int* lim_slope,
                         D_DECL(const Real* fvcx,const Real* fvcy, const Real* fvcz),
                         D_DECL(const Real* cvcx,const Real* cvcy, const Real* cvcz));

    void FORT_LINCCINTERP (Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                           const int* fblo, const int* fbhi,
                           ARLIM_P(fvcblo), ARLIM_P(fvcbhi),
                           const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                           ARLIM_P(cvcblo), ARLIM_P(cvcbhi),
                           Real* ucc_xslopes, Real* lcc_xslopes,
                           Real* xslope_factors,
                           Real* ucc_yslopes, Real* lcc_yslopes,
                           Real* yslope_factors,
#if (BL_SPACEDIM==3)
                           Real* ucc_zslopes, Real* lcc_zslopes,
                           Real* zslope_factors,
#endif
                           ARLIM_P(csblo), ARLIM_P(csbhi),
                           const int* csblo, const int* csbhi,
                           const int* nvar,
                           D_DECL(const int* lrx,const int* lry,const int* lrz),
                           const int* bc, const int* lim_limit,
                           D_DECL(const Real* fvcx,const Real* fvcy, const Real* fvcz),
                           D_DECL(const Real* cvcx,const Real* cvcy, const Real* cvcz),
                           D_DECL(const Real* voffx,const Real* voffy, const Real* voffz));

    void FORT_CQINTERP (Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                        ARLIM_P(fblo), ARLIM_P(fbhi),
                        const int* nvar,
                        D_DECL(const int* lrx,const int* lry,const int* lrz),
                        const Real* crse, const int* clo, const int* chi,
                        ARLIM_P(cblo), ARLIM_P(cbhi),
                        const int* fslo, const int* fshi,
                        Real* cslope, const int* clen,
                        Real* fslope, Real* fdat, const int* flen,
                        Real* voff,
                        const int* bc, const int* lim_slope,
                        D_DECL(const Real* fvcx,const Real* fvcy, const Real* fvcz),
                        D_DECL(const Real* cvcx,const Real* cvcy, const Real* cvcz));

    void FORT_PCINTERP (const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                        const int* cblo, const int* cbhi,
                        Real*  fine, ARLIM_P(flo), ARLIM_P(fhi),
                        const int* fblo, const int* fbhi,
                        const int* longdir,
                        D_DECL(const int* lrx,const int* lry,const int* lrz),
                        const int* nvar, Real* strip,
                        const int* strip_lo, const int* strip_hi);

    void FORT_PROTECT_INTERP (      Real* fine, ARLIM_P(flo), ARLIM_P(fhi),
                              const  int* fblo, const int* fbhi,
                              const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                              const  int* cblo, const int* cbhi,
#if (BL_SPACEDIM == 2)
                              const Real* fvcx, const Real* fvcy,
                              ARLIM_P(fblo), ARLIM_P(fbhi),
                              const Real* cvcx, const Real* cvcy,
                              ARLIM_P(cblo), ARLIM_P(cbhi),
#endif
                              Real* state, ARLIM_P(slo), ARLIM_P(shi),
                              const int* nvar,
                              D_DECL(const int* lrx,const int* lry,const int* lrz),
                              const int* bc); 
  }
#endif

#endif /*_INTERP_NAMES_H*/
