#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <fstream>
#include <iostream>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
#include <cstring>

#include <unistd.h>

namespace AuthN {
namespace Utils {
namespace File {

bool makedir(const std::string& name) {
  struct stat st;
  if(stat(name.c_str(),&st) == 0) {
    if(!S_ISDIR(st.st_mode)) return true;
  } else {
    if(mkdir(name.c_str(),S_IRWXU) != 0) return true;
  }
  return false;
}

static bool cleandir(const std::string& path,int& err) {
  errno = 0;
  DIR* dir = opendir(path.c_str());
  if(!dir) { err = errno; return false; };
  for(;;) {
    struct dirent* d = ::readdir(dir);
    if(!d) break;
    if(strcmp(d->d_name,".") == 0) continue;
    if(strcmp(d->d_name,"..") == 0) continue;
    std::string npath = path + "/" + d->d_name;
    errno = 0;
    if(::remove(npath.c_str()) == 0) continue;
    if(errno != ENOTEMPTY) { err = errno; closedir(dir); return false; };
    if(!cleandir(npath,err)) { closedir(dir); return false; };
    errno = 0;
    if(::remove(npath.c_str()) != 0) { err = errno; closedir(dir); return false; };
  };
  closedir(dir);
  err = 0;
  return true;
}

bool removedir(const std::string& name) {
  int res = 0; int err = 0;
  struct stat st;
  if(stat(name.c_str(),&st) != 0) return true;
  if(!S_ISDIR(st.st_mode)) return true;
  res = ::rmdir(name.c_str());
  err = errno;
  if(err == ENOTEMPTY) {
    if(cleandir(name,err)) {
      errno = 0;
      res = ::rmdir(name.c_str());
      if (res == -1) err = errno;
    };
  };
  if(err == 0) return true;
/*
  DIR* d=::opendir(name.c_str());
  if(d == NULL) { return true; };
  ::closedir(d);
  if(::remove(name.c_str()) != 0){ return true; }
*/
  return false;
}

bool file_exist(const std::string& dir_name, const std::string& file_name) {
  bool ret = false;
  DIR* dir;
  dir = opendir(dir_name.c_str());
  if(!dir) { return false; };
  for(;;) {
    struct dirent* d = ::readdir(dir);
    if(!d) break;
    if(strcmp(d->d_name,".") == 0) continue;
    if(strcmp(d->d_name,"..") == 0) continue;
    std::string file = dir_name + "/" + d->d_name;
    if(file == file_name) { ret = true; break; }
  }
  closedir(dir);
  return ret;
}

bool file_exist(const std::string& file_location) {
  struct stat st;
  if(stat(file_location.c_str(),&st) != 0) return false;
  if(!S_ISREG(st.st_mode)) return false;
  return true;
}

bool dir_exist(const std::string& dir_location) {
  struct stat st;
  if(stat(dir_location.c_str(),&st) != 0) return false;
  if(!S_ISDIR(st.st_mode)) return false;
  return true;
}

bool movefile(const std::string& source, const std::string& destination) {
  int res;
  res = rename(source.c_str(), destination.c_str());
  if(res == 0) return true;
  else return false;
}

}
}
}
