/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "NewbieWindow.h"
#include "ExtensionWindow.h"

#include <QString>
#include <QFileDialog>
#include <QMessageBox>
#include <QFileInfo>
#include<iostream>


NewbieWindow::NewbieWindow(QMainWindow * dad) : QMainWindow(dad)
{
    ui.setupUi(this);
    this->dad = dad;
//    ui.ApplicationPushButton->setDisabled(true);
//    ui.ComponentPushButton->setDisabled(true);
//    ui.viewerPushButton->setDisabled(true);
}

void NewbieWindow::devDirectoryToolButtonClicked() {
    QString fileName = QFileDialog::getExistingDirectory( this, tr("Set the development directory"));
    ui.devDirectoryLineEdit->setText(fileName);
}

void NewbieWindow::cancelClicked() {
    this->dad->show();
    this->close();

}

void NewbieWindow::actionButtonClicked() {
    QString enteredDir = ui.devDirectoryLineEdit->text();
    QFileInfo devDir(enteredDir);
    if ((enteredDir == "") || (!devDir.isDir())) {
        QMessageBox::warning(this, tr("Before going further..."), tr("Please select a valid development directory\n"));
        return;
    }
	ExtensionWindow * win = new ExtensionWindow(this, ui.devDirectoryLineEdit->text(), Action);
    win->show();
    this->hide();
//    QMessageBox::warning(this, "Newbie Window", "Action Button Clicked");
}

void NewbieWindow::applicationButtonClicked() {
    QMessageBox::warning(this, "Newbie Window", "The <i>Application</i> is not implemented yet, sorry...\n");
}

void NewbieWindow::componentButtonClicked() {
    QString enteredDir = ui.devDirectoryLineEdit->text();
    QFileInfo devDir(enteredDir);
    if ((enteredDir == "") || (!devDir.isDir())) {
        QMessageBox::warning(this, tr("Before going further..."), tr("Please select a valid development directory\n"));
        return;
    }
//    QMessageBox::warning(this, "Newbie Window", "Component Button Clicked");
	ExtensionWindow * win = new ExtensionWindow(this, ui.devDirectoryLineEdit->text(), Component);
	win->show();
	this->hide();

}

void NewbieWindow::viewerButtonClicked() {
    QMessageBox::warning(this, "Newbie Window", "The <i>Viewer</i> is not implemented yet, sorry...\n");
}
