/*
 * VocaloSysUtil.java
 * Copyright (c) 2009 kbinani
 *
 * This file is part of com.boare.vsq.
 *
 * com.boare.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * com.boare.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package com.boare.vsq;

import java.util.*;
import java.text.*;
import java.io.*;
import com.boare.corlib.*;

public class VocaloSysUtil {
    // レジストリを取得するツールのexeファイルをbase64エンコードしたもの。
    // 初回実行時に、一時ディレクトリにexeを展開して起動する
    private static final String UTIL_EXE = "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";

    private static boolean s_initialized = false;

    private static String s_dll_path2 = "";
    private static String s_editor_path2 = "";
    private static String s_voicedbdir2 = "";
    private static Vector<SingerConfig> s_installed_singers2 = new Vector<SingerConfig>();
    private static Vector<SingerConfig> s_singer_configs2 = new Vector<SingerConfig>();

    private static String s_dll_path1 = "";
    private static String s_editor_path1 = "";
    private static String s_voicedbdir1 = "";
    private static Vector<SingerConfig> s_installed_singers1 = new Vector<SingerConfig>();
    private static Vector<SingerConfig> s_singer_configs1 = new Vector<SingerConfig>();

    private static final int MAX_SINGERS = 0x4000;

    static{
        System.out.println( "VocaloSysUtil; static ctor." );
        String logfile = "";
        try{
            File exe = File.createTempFile( "util", ".exe" );
            FileOutputStream fs = new FileOutputStream( exe );
            fs.write( Base64.decode( UTIL_EXE ) );
            fs.close();
            File log = File.createTempFile( "reg", ".txt" );
            logfile = log.getAbsolutePath();
            Process p = Runtime.getRuntime().exec( "\"" + exe.getAbsolutePath() + "\" \"" + logfile + "\"" );
            p.waitFor();
            exe.delete();
        }catch( Exception ex ){
            System.out.println( "ex=" + ex );
            logfile = "";
        }
        init_vocalo1( logfile );
        init_vocalo2( logfile );
        (new File( logfile )).delete();
    }

    /// <summary>
    /// Gets the name of original singer of specified program change.
    /// </summary>
    /// <param name="singer"></param>
    /// <returns></returns>
    public static String getOriginalSinger1( String singer ) {
        String voiceidstr = "";
        int c = s_singer_configs1.size();
        for ( int i = 0; i < c; i++ ) {
            if ( singer.equals( s_singer_configs1.get( i ).VOICENAME ) ) {
                voiceidstr = s_singer_configs1.get( i ).VOICEIDSTR;
                break;
            }
        }
        if ( voiceidstr.equals( "" ) ) {
            return "";
        }
        c = s_installed_singers1.size();
        for ( int i = 0; i < c; i++ ) {
            if ( voiceidstr.equals( s_installed_singers1.get( i ).VOICEIDSTR ) ) {
                return s_installed_singers1.get( i ).VOICENAME;
            }
        }
        return "";
    }

    /// <summary>
    /// Gets the name of original singer of specified program change.
    /// </summary>
    /// <param name="singer"></param>
    /// <returns></returns>
    public static String getOriginalSinger2( String singer ) {
        String voiceidstr = "";
        int c = s_singer_configs2.size();
        for ( int i = 0; i < c; i++ ) {
            if ( singer.equals( s_singer_configs2.get( i ).VOICENAME ) ) {
                voiceidstr = s_singer_configs2.get( i ).VOICEIDSTR;
                break;
            }
        }
        if ( voiceidstr.equals( "" ) ) {
            return "";
        }
        c = s_installed_singers2.size();
        for ( int i = 0; i < c; i++ ) {
            if ( voiceidstr.equals( s_installed_singers2.get( i ).VOICEIDSTR ) ) {
                return s_installed_singers2.get( i ).VOICENAME;
            }
        }
        return "";
    }

    /// <summary>
    /// Gets the voice language of specified program change
    /// </summary>
    /// <param name="name">name of singer</param>
    /// <returns></returns>
    private static int getLanguageFromName( String name ) {
        if( name.equals( "MEIKO" ) ||
            name.equals( "KAITO" ) ||
            name.equals( "Miku" ) ||
            name.equals( "Rin" ) ||
            name.equals( "Len" ) ||
            name.equals( "Rin_ACT2" ) ||
            name.equals( "Len_ACT2" ) ||
            name.equals( "Gackpoid" ) ||
            name.equals( "Luka_JPN" ) ||
            name.equals( "Megpoid" ) ){
            return VsqVoiceLanguage.Japanese;
        }else if( name.equals( "Sweet_Ann" ) ||
                  name.equals( "Prima" ) ||
                  name.equals( "Luka_ENG" ) ){
            return VsqVoiceLanguage.English;
        }
        return VsqVoiceLanguage.Default;
    }

    public static VsqID getSingerID1( String singer_name ) {
        VsqID ret = new VsqID( 0 );
        ret.type = VsqIDType.Singer;
        SingerConfig sc = null;
        int c = s_singer_configs1.size();
        for ( int i = 0; i < c; i++ ) {
            if ( s_singer_configs1.get( i ).VOICENAME.equals( singer_name ) ) {
                sc = s_singer_configs1.get( i );
                break;
            }
        }
        if ( sc == null ) {
            sc = new SingerConfig();
        }
        int lang = 0;
        for ( SingerConfig sc2 : s_installed_singers1 ) {
            if ( sc.VOICEIDSTR.equals( sc2.VOICEIDSTR ) ) {
                lang = (int)getLanguageFromName( sc.VOICENAME );
                break;
            }
        }
        ret.iconHandle = new IconHandle();
        ret.iconHandle.iconID = "$0701" + (new DecimalFormat( "0000" )).format( sc.program );
        ret.iconHandle.IDS = sc.VOICENAME;
        ret.iconHandle.index = 0;
        ret.iconHandle.language = lang;
        ret.iconHandle.length = 1;
        ret.iconHandle.original = sc.original;
        ret.iconHandle.program = sc.program;
        ret.iconHandle.caption = "";
        return ret;
    }

    public static VsqID getSingerID2( String singer_name ) {
        VsqID ret = new VsqID( 0 );
        ret.type = VsqIDType.Singer;
        SingerConfig sc = null;
        int c = s_singer_configs2.size();
        for ( int i = 0; i < c; i++ ) {
            if ( s_singer_configs2.get( i ).VOICENAME.equals( singer_name ) ) {
                sc = s_singer_configs2.get( i );
                break;
            }
        }
        if ( sc == null ) {
            sc = new SingerConfig();
        }
        int lang = 0;
        for( SingerConfig sc2 : s_installed_singers2 ) {
            if ( sc.VOICEIDSTR.equals( sc2.VOICEIDSTR ) ) {
                lang = (int)getLanguageFromName( sc.VOICENAME );
                break;
            }
        }
        ret.iconHandle = new IconHandle();
        ret.iconHandle.iconID = "$0701" + (new DecimalFormat( "0000" )).format( sc.program );
        ret.iconHandle.IDS = sc.VOICENAME;
        ret.iconHandle.index = 0;
        ret.iconHandle.language = lang;
        ret.iconHandle.length = 1;
        ret.iconHandle.original = sc.original;
        ret.iconHandle.program = sc.program;
        ret.iconHandle.caption = "";
        return ret;
    }

    public static SingerConfig[] getSingerConfigs1() {
        return s_singer_configs1.toArray( new SingerConfig[]{} );
    }

    public static SingerConfig[] getSingerConfigs2() {
        return s_singer_configs2.toArray( new SingerConfig[]{} );
    }

    public static double getAmplifyCoeffFromPanLeft( int pan ) {
        return pan / -64.0 + 1.0;
    }

    public static double getAmplifyCoeffFromPanRight( int pan ) {
        return pan / 64.0 + 1.0;
    }

    public static double getAmplifyCoeffFromFeder( int feder ) {
        return Math.exp( -1.26697245e-02 + 1.18448420e-01 * feder / 10.0 );
    }

    public static String getEditorPath2() {
        return s_editor_path2;
    }

    public static String getEditorPath1() {
        return s_editor_path1;
    }

    public static String getDllPathVsti2() {
        return s_dll_path2;
    }

    public static String getDllPathVsti1() {
        return s_dll_path1;
    }

    /// <summary>
    /// VOCALOID1システムのプロパティを取得
    /// </summary>
    private static void init_vocalo1( String logfile ) {
        try{
            StreamReader sr = new StreamReader( logfile );
            Vector<String> lines = new Vector<String>();
            String line;
            while( (line = sr.readLine()) != null ){
                lines.add( line );
            }
            sr.close();

            // vocaloid1 dll path
            // HKLM\\SOFTWARE\\VOCALOID\\APPLICATIONで始まる行を取得
            Vector<String> v1application = new Vector<String>();
            for( String s : lines ){
                if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID\\APPLICATION\\" ) ){
                    v1application.add( s );
                }
            }
            for( String s : v1application ){
                s = s.substring( "HKLM\\SOFTWARE\\VOCALOID\\APPLICATION\\".length() );
                String[] spl_tab = s.split( "\t" );
                String[] spl_separator = spl_tab[0].split( "\\\\" );
                if( spl_separator.length == 1 && spl_tab[1].equals( "PATH" ) ){
                    String name = spl_tab[2];
                    if( name.toLowerCase().endsWith( "\\vocaloid.dll" ) ){
                        s_dll_path1 = name;
System.out.println( "s_dll_path1=" + name );
                    }else if( name.toLowerCase().endsWith( "\\vocaloid.exe" ) ){
                        s_editor_path1 = name;
System.out.println( "s_editor_path1=" + name );
                    }
                }
            }

            // voicedbdir for vocaloid1
            Vector<String> v1database = new Vector<String>();
            for( String s : lines ){
                if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID\\DATABASE\\VOICE\\" ) ){
                    v1database.add( s );
                }else if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID\\DATABASE\\VOICE\tVOICEDIR" ) ){
                    s = s.substring( "HKLM\\SOFTWARE\\VOCALOID\\DATABASE\\VOICE\tVOICEDIR\t".length() );
                    s_voicedbdir1 = s;
System.out.println( "s_voicedbdir1=" + s_voicedbdir1 );
                }
            }
            Vector<String> singer_voiceidstrs = new Vector<String>();
            Vector<String> vvoice_keys = new Vector<String>();
            Vector<SingerConfig> vvoice_values = new Vector<SingerConfig>();
            for( String s : v1database ){
                // HKLM\SOFTWARE\VOCALOID\DATABASE\VOICE\BLFEA6N2HTSKXLD7\vvoice vvoice1
                s = s.substring( "HKLM\\SOFTWARE\\VOCALOID\\DATABASE\\VOICE\\".length() );
                String[] spl_tab = s.split( "\t" );
                String[] spl_separator = spl_tab[0].split( "\\\\" );
                if( spl_separator.length == 2 && spl_separator[1].equals( "vvoice" ) ){
                    // s=BLFEA6N2HTSKXLD7\vvoice       vvoice1
                    String[] spl = s.split( "\\\\" );
                    s = spl[0];
                    if( !singer_voiceidstrs.contains( s ) ){
                        singer_voiceidstrs.add( s );
System.out.println( "s=" + s );
                    }
                }
            }
            // インストールされた歌手の.vvdを読みにいく
            // installdir以下の、拡張子.vvdのファイルを探す
            for( String voiceidstr : singer_voiceidstrs ){
                File installdir = new File( Path.combine( s_voicedbdir1, voiceidstr ) );
System.out.println( "installdir=" + installdir );
                for( File file : installdir.listFiles( new FileFilterWithExtension( ".vvd" ) ) ){
                    SingerConfig config = SingerConfig.readSingerConfig( file.getAbsolutePath(), 0 ); //とりあえずプログラムチェンジは0
                    s_installed_singers1.add( config );
System.out.println( "config=" + config.toString() );
                }
                // vvoice*.vvdを読みにいく。
                for( String s : v1database ){
                    String search = "HKLM\\SOFTWARE\\VOCALOID\\DATABASE\\VOICE\\" + voiceidstr + "\\vvoice\t";
                    if( s.startsWith( search ) ){
                        String vvd = s.substring( search.length() );
                        File file = new File( Path.combine( s_voicedbdir1, vvd.trim() + ".vvd" ) );
                        if( file.exists() ){
                            vvoice_keys.add( vvd );
                            SingerConfig sc = SingerConfig.readSingerConfig( file.getAbsolutePath(), 0 );
                            vvoice_values.add( sc );
System.out.println( "sc=" + sc.toString() );
                        }
                    }
                }
            }

            // voice.mapを読み込んで、s_singer_configs1のプログラムチェンジを更新する
            String map = Path.combine( s_voicedbdir1, "voice.map" );
            if ( (new File( map )).exists() ) {
                RandomAccessFile fs = new RandomAccessFile( map, "r" );
                byte[] dat = new byte[8];
                fs.seek( 0x20 );
                for ( int i = 0; i < MAX_SINGERS; i++ ) {
                    fs.read( dat, 0, 8 );
                    long value = makelong_le( dat );
                    if ( value >= 1 ) {
                        int c = vvoice_keys.size();
                        for ( int j = 0; j < c; j++ ) {
                            if ( vvoice_keys.get( j ).equals( "vvoice" + value ) ) {
                                vvoice_values.get( j ).program = i;
                            }
                        }
                    }
                }
            }

            // s_installed_singers1のSingerConfigのProgramとOriginalを適当に頒番する
            int c = s_installed_singers1.size();
            for ( int i = 0; i < c; i++ ) {
                s_installed_singers1.get( i ).program = i;
                s_installed_singers1.get( i ).original = i;
            }

            // s_singer_configs1を更新
            c = vvoice_values.size();
            int c2 = s_installed_singers1.size();
            for ( int i = 0; i < c; i++ ) {
                for ( int j = 0; j < c2; j++ ) {
                    if ( vvoice_values.get( i ).VOICEIDSTR.equals( s_installed_singers1.get( j ).VOICEIDSTR ) ){
                        vvoice_values.get( i ).original = s_installed_singers1.get( j ).program;
                        break;
                    }
                }
                s_singer_configs1.add( vvoice_values.get( i ) );
            }
        }catch( Exception ex ){
            System.out.println( "ex=" + ex );
        }
    }

    /// <summary>
    /// VOCALOID2システムのプロパティを取得
    /// </summary>
    private static void init_vocalo2( String logfile ) {
        try{
            StreamReader sr = new StreamReader( logfile );
            Vector<String> lines = new Vector<String>();
            String line;
            while( (line = sr.readLine()) != null ){
                lines.add( line );
            }
            sr.close();

            // vocaloid1 dll path
            // HKLM\\SOFTWARE\\VOCALOID\\APPLICATIONで始まる行を取得
            Vector<String> v2application = new Vector<String>();
            for( String s : lines ){
                if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID2\\APPLICATION\\" ) ){
                    v2application.add( s );
                }
            }
            for( String s : v2application ){
                s = s.substring( "HKLM\\SOFTWARE\\VOCALOID2\\APPLICATION\\".length() );
                String[] spl_tab = s.split( "\t" );
                String[] spl_separator = spl_tab[0].split( "\\\\" );
                if( spl_separator.length == 1 && spl_tab[1].equals( "PATH" ) ){
                    String name = spl_tab[2];
                    if( name.toLowerCase().endsWith( "\\vocaloid2.dll" ) ){
                        s_dll_path2 = name;
System.out.println( "s_dll_path2=" + name );
                    }else if( name.toLowerCase().endsWith( "\\vocaloid2.exe" ) ){
                        s_editor_path2 = name;
System.out.println( "s_editor_path2=" + name );
                    }
                }
            }

            // voicedbdir for vocaloid1
            Vector<String> v2database = new Vector<String>();
            for( String s : lines ){
                if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\\" ) ){
                    v2database.add( s );
                }else if( s.toUpperCase().startsWith( "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\tVOICEDIR" ) ){
                    s = s.substring( "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\tVOICEDIR\t".length() );
                    s_voicedbdir2 = s;
System.out.println( "s_voicedbdir2=" + s_voicedbdir2 );
                }
            }
            Vector<String> singer_voiceidstrs = new Vector<String>();
            Vector<String> vvoice_keys = new Vector<String>();
            Vector<SingerConfig> vvoice_values = new Vector<SingerConfig>();
            for( String s : v2database ){
                // HKLM\SOFTWARE\VOCALOID\DATABASE\VOICE\BLFEA6N2HTSKXLD7\vvoice vvoice1
                s = s.substring( "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\\".length() );
                String[] spl_tab = s.split( "\t" );
                String[] spl_separator = spl_tab[0].split( "\\\\" );
                if( spl_separator.length == 2 && spl_separator[1].equals( "vvoice" ) ){
                    // s=BLFEA6N2HTSKXLD7\vvoice       vvoice1
                    String[] spl = s.split( "\\\\" );
                    s = spl[0];
                    if( !singer_voiceidstrs.contains( s ) ){
                        singer_voiceidstrs.add( s );
System.out.println( "s=" + s );
                    }
                }
            }
            // インストールされた歌手の.vvdを読みにいく
            // installdir以下の、拡張子.vvdのファイルを探す
            for( String voiceidstr : singer_voiceidstrs ){
                //HKLM\SOFTWARE\VOCALOID2\DATABASE\VOICE\BHHN4EF9BRWTNHAB	INSTALLDIR	
                String dir = "";
                for( String s : v2database ){
                    String search = "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\\" + voiceidstr + "\tINSTALLDIR\t";
                    if( s.startsWith( search ) ){
                        dir = s.substring( search.length() );
                        break;
                    }
                }
                File installdir = new File( Path.combine( dir, voiceidstr ) );
System.out.println( "installdir=" + installdir );
                for( File file : installdir.listFiles( new FileFilterWithExtension( ".vvd" ) ) ){
                    SingerConfig config = SingerConfig.readSingerConfig( file.getAbsolutePath(), 0 ); //とりあえずプログラムチェンジは0
                    config.VOICEIDSTR = voiceidstr;
                    s_installed_singers2.add( config );
System.out.println( "config=" + config.toString() );
                }
                // vvoice*.vvdを読みにいく。
                for( String s : v2database ){
                    String search = "HKLM\\SOFTWARE\\VOCALOID2\\DATABASE\\VOICE\\" + voiceidstr + "\\vvoice\t";
                    if( s.startsWith( search ) ){
                        String vvd = s.substring( search.length() );
                        File file = new File( Path.combine( s_voicedbdir2, vvd.trim() + ".vvd" ) );
                        if( file.exists() ){
                            vvoice_keys.add( vvd );
                            SingerConfig sc = SingerConfig.readSingerConfig( file.getAbsolutePath(), 0 );
                            vvoice_values.add( sc );
System.out.println( "sc=" + sc.toString() );
                        }
                    }
                }
            }

            // voice.mapを読み込んで、s_singer_configs1のプログラムチェンジを更新する
            String map = Path.combine( s_voicedbdir2, "voice.map" );
            if ( (new File( map )).exists() ) {
                RandomAccessFile fs = new RandomAccessFile( map, "r" );
                byte[] dat = new byte[8];
                fs.seek( 0x20 );
                for ( int i = 0; i < MAX_SINGERS; i++ ) {
                    fs.read( dat, 0, 8 );
                    long value = makelong_le( dat );
                    if ( value >= 1 ) {
                        int c = vvoice_keys.size();
                        for ( int j = 0; j < c; j++ ) {
                            if ( vvoice_keys.get( j ).equals( "vvoice" + value ) ) {
                                vvoice_values.get( j ).program = i;
                            }
                        }
                    }
                }
            }

            // s_installed_singers1のSingerConfigのProgramとOriginalを適当に頒番する
            int c = s_installed_singers2.size();
            for ( int i = 0; i < c; i++ ) {
                s_installed_singers2.get( i ).program = i;
                s_installed_singers2.get( i ).original = i;
            }

            // s_singer_configs1を更新
            c = vvoice_values.size();
            int c2 = s_installed_singers2.size();
            for ( int i = 0; i < c; i++ ) {
                for ( int j = 0; j < c2; j++ ) {
                    if ( vvoice_values.get( i ).VOICEIDSTR.equals( s_installed_singers2.get( j ).VOICEIDSTR ) ){
                        vvoice_values.get( i ).original = s_installed_singers2.get( j ).program;
                        break;
                    }
                }
                s_singer_configs2.add( vvoice_values.get( i ) );
            }
        }catch( Exception ex ){
            System.out.println( "ex=" + ex );
        }
    }

    /* /// <summary>
    /// VOCALOID2システムのプロパティを取得
    /// </summary>
    private static void init_vocalo2() {
        // 最初はvstiとeditorのパスを取得
        RegistryKey v2application = Registry.LocalMachine.OpenSubKey( "SOFTWARE\\VOCALOID2\\APPLICATION", false );
        if ( v2application == null ) {
            v2application = Registry.LocalMachine.OpenSubKey( "SOFTWARE\\VOCALOID2_DEMO\\APPLICATION", false );
        }
        if ( v2application != null ) {
            string[] keys = v2application.GetSubKeyNames();
            for ( int i = 0; i < keys.Length; i++ ) {
                RegistryKey key = v2application.OpenSubKey( keys[i], false );
                if ( key != null ) {
                    string name = (string)key.GetValue( "PATH" );
                    if ( name.ToLower().EndsWith( "\\vocaloid2.dll" ) ) {
                        s_dll_path2 = name;
                    } else if ( name.ToLower().EndsWith( "\\vocaloid2_demo.dll" ) ) {
                        s_dll_path2 = name;
                    } else if ( name.ToLower().EndsWith( "\\vocaloid2.exe" ) ) {
                        s_editor_path2 = name;
                    }
                    key.Close();
                }
            }
            v2application.Close();
        }

        // 歌声データベースを取得
        RegistryKey v2database = Registry.LocalMachine.OpenSubKey( "SOFTWARE\\VOCALOID2\\DATABASE\\VOICE", false );
        if ( v2database != null ) {
            // データベース（というよりもvoice.map）が保存されているパスを取得
            s_voicedbdir2 = (string)v2database.GetValue( "VOICEDIR", "" );
            // インストールされている歌手のVOICEIDSTRを列挙
            string[] singer_voiceidstrs = v2database.GetSubKeyNames();
            List<string> vvoice_keys = new List<string>();
            List<SingerConfig> vvoice_values = new List<SingerConfig>();
            foreach ( string voiceidstr in singer_voiceidstrs ) {
                RegistryKey singer = v2database.OpenSubKey( voiceidstr );
                if ( singer == null ) {
                    continue;
                }
                string installdir = (string)singer.GetValue( "INSTALLDIR", "" );
#if DEBUG
                Console.WriteLine( "installdir=" + installdir );
#endif
                RegistryKey vvoice = singer.OpenSubKey( "vvoice" );
                if ( vvoice != null ) {
                    string[] vvoices = vvoice.GetValueNames();

                    // インストールされた歌手の.vvdを読みにいく
                    // installdir以下の、拡張子.vvdのファイルを探す
                    foreach ( string file in Directory.GetFiles( Path.Combine( installdir, voiceidstr ), "*.vvd" ) ) {
                        SingerConfig config = SingerConfig.readSingerConfig( file, 0 ); //とりあえずプログラムチェンジは0
                        s_installed_singers2.Add( config );
                    }

                    // vvoice*.vvdを読みにいく。場所は、installdirではなく、s_voicedbdir2
                    foreach ( string s in vvoices ) {
                        string file = Path.Combine( s_voicedbdir2, s + ".vvd" );
                        if ( File.Exists( file ) ) {
                            SingerConfig config = SingerConfig.readSingerConfig( file, 0 );
                            vvoice_keys.Add( s );
                            vvoice_values.Add( config );
                        }
                    }
                }
                singer.Close();
            }

            // voice.mapを読み込んで、s_singer_configs2のプログラムチェンジを更新する
            string map = Path.Combine( s_voicedbdir2, "voice.map" );
            if ( File.Exists( map ) ) {
                using ( FileStream fs = new FileStream( map, FileMode.Open, FileAccess.Read ) ) {
                    byte[] dat = new byte[8];
                    fs.Seek( 0x20, SeekOrigin.Begin );
                    for ( int i = 0; i < MAX_SINGERS; i++ ) {
                        fs.Read( dat, 0, 8 );
                        ulong value = makelong_le( dat );
                        if ( value >= 1 ) {
#if DEBUG
                            Console.WriteLine( "value=" + value );
#endif
                            for ( int j = 0; j < vvoice_keys.Count; j++ ) {
                                if ( vvoice_keys[j] == "vvoice" + value ) {
                                    vvoice_values[j].Program = i;
                                }
                            }
                        }
                    }
                }
            }

            // s_installed_singers2のSingerConfigのProgramとOriginalを適当に頒番する
            for ( int i = 0; i < s_installed_singers2.Count; i++ ) {
                s_installed_singers2[i].Program = i;
                s_installed_singers2[i].Original = i;
            }

            // s_singer_configs2を更新
            for ( int i = 0; i < vvoice_values.Count; i++ ) {
                for ( int j = 0; j < s_installed_singers2.Count; j++ ) {
                    if ( vvoice_values[i].VOICEIDSTR == s_installed_singers2[j].VOICEIDSTR ) {
                        vvoice_values[i].Original = s_installed_singers2[j].Program;
                        break;
                    }
                }
                s_singer_configs2.Add( vvoice_values[i] );
            }
            v2database.Close();
        }
    }
*/
    /// <summary>
    /// Transform the byte array(length=8) to unsigned long, assuming that the byte array is little endian.
    /// </summary>
    /// <param name="oct"></param>
    /// <returns></returns>
    private static long makelong_le( byte[] oct ) {
        return (0xff & oct[7]) << 56 | (0xff & oct[6]) << 48 | (0xff & oct[5]) << 40 | (0xff & oct[4]) << 32 | (0xff & oct[3]) << 24 | (0xff & oct[2]) << 16 | (0xff & oct[1]) << 8 | (0xff & oct[0]);
    }
}
