+++
title = "Pyramid2"
+++

### Pyramid2

A truncated pyramid with rectangular base.

<img src="/img/draw/ff/3d/Pyramid2.png" width="30%" >
<img src="/img/draw/ff/2d/Pyramid2_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Pyramid2_xz.svg" width="30%">

#### Constructor

```python
Pyramid2(L, W, H, alpha)
```

Parameters:
- L, edge length of the base
- W, edge width of the base
- H, height
- alpha, dihedral angle $\alpha$ between the base and a side face.

Constraint:

$H \le \dfrac{\tan\alpha}{2} min(L,W)$

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [Pyramid2]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron
provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=H\Big[LW-\dfrac{(L+W)H}{\tan\alpha}+\dfrac{4}{3}\dfrac{H^2}{\tan^2\alpha}\Big]. $$

#### Related shapes

More special:
- [Pyramid4](/ref/sample/particle/ff/hard/pyramid4), if $L=W$.
- [Box](/ref/sample/particle/ff/hard/box), if $\alpha=90^{\circ}$.

#### Example

Scattering by uncorrelated, oriented pyramids for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Pyramid2.png">

Generated by {{% ref-ex "ff/Pyramid2.py" %}}.

#### History

Was named "AnisoPyramid" up to BornAgain 1.19.

Agrees with the "In plane anisotropic pyramid" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.38-2.39;
[Renaud 2009](/lit/renaud2009), Eq. 216-217],
except for different parametrization. This is *not* the "Anisotropic pyramid"
of FitGISAXS, which is a true pyramid with an off-center apex [[Babonneau 2013](/lit/babonneau2013)].
