//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/Particle/Mesocrystal.h
//! @brief     Defines class Mesocrystal.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_SAMPLE_PARTICLE_MESOCRYSTAL_H
#define BORNAGAIN_SAMPLE_PARTICLE_MESOCRYSTAL_H

#include "Sample/Particle/IParticle.h"

class IFormFactor;
class Crystal;

//! A particle with a crystalline inner structure, made of smaller particles,
//! and an outer shape described by a particle form factor.

class Mesocrystal : public IParticle {
public:
    Mesocrystal(const Crystal& crystal, const IFormFactor& formfactor);
    ~Mesocrystal() override;

    Mesocrystal* clone() const override;
    std::string className() const final { return "Mesocrystal"; }
    std::vector<const INode*> nodeChildren() const override;

#ifndef SWIG
    const IFormFactor* outerShape() const
    {
        return m_meso_formfactor.get();
    }
    const Crystal& particleStructure() const;

    std::string validate() const override
    {
        return "";
    }

    Span zSpan() const override;

private:
    Mesocrystal(Crystal* crystal, IFormFactor* formfactor);

    const std::unique_ptr<Crystal> m_crystal;             //!< Crystalline inner structure
    const std::unique_ptr<IFormFactor> m_meso_formfactor; //!< Outer shape of the mesocrystal

#endif // SWIG
};

#endif // BORNAGAIN_SAMPLE_PARTICLE_MESOCRYSTAL_H
