/*
   birthday

   Birthday/Anniversary display on login

   (c) 1996 AS Mortimer

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  You may also
    distribute it under the Artistic License, as comes with Perl.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You should also have recieved a copy of the Artistic license with
    this program.

   $Id: birthday.h,v 1.4 2005/09/02 19:32:48 andymort Exp $
*/

/* ========== Configuration section */

#if defined(DOS)
#  define DEFAULT_FILE "bdays.lst"
#  define DOSDEFDIR    "c:\\personal\\"
#else
#  define DEFAULT_FILE ".birthdays"
#endif

/* standard time to warn in advance, when no explicit w flag is given. */
#define DEF_WARN 21
/* maximum time to warn in advance when no M flag is given */
#define MAX_WARN 500 /* ie, a year */
/* minimum time to warn in advance when no m flag */
#define MIN_WARN 0

/* ========== Required includes */

#include "xmalloc.h"
#include <stdio.h>
#include "getopt.h"

/* ========== Global constants and data types */

/* error codes */

#define EC_     -1      /* unknown error */
#define EC_NOFILE       3

/* month lengths etc */

#define isleapyear(y) ((y)%4==0 && ((y)%100 != 0 || (y)%400 == 0))
extern const unsigned MLENDAT[];
#define mlen(m,y) (MLENDAT[(m)-1] != -1 ? MLENDAT[(m)-1] : (isleapyear((y)) ? 29 : 28))
#define before(a,b) ((a).month < (b).month || ((a).month == (b).month && (a).day < (b).day))
#define ydelta(a,b) ((int) (b).year - (a).year + before((a),(b)))
#define warnperiod(ev) ((ev).warn<iMinWarn?iMinWarn:((ev).warn>iMaxWarn?iMaxWarn:(ev).warn))

/* -------- modifier flags */

#define F_MTYPE 0x07
#define F_TBIRTHDAY 1
#define F_TANNIVERSARY 2
#define F_TEVENT 3
#define F_TMESSAGE 4

/* flags processed immediately on encountering */
#define F_MIMMEDIATE 0x24
#define F_WTIME_P 0x08
#define F_FORDAYS 0x16
#define F_TODATE 0x24

struct _ftable {char *txt; unsigned flag;};

extern const struct _ftable FTABLE[];

struct date {
  unsigned day;
  unsigned month;
  unsigned year;
};

struct event {
  char *text;
  struct date date;
  struct date enddate;
  int warn;
  unsigned fromtoday;
};

typedef int (*prnfunc)(const char *);

/* ========== */

struct event *readlist(char *fname, const struct date *today);
unsigned delta(struct date *, const struct date *today);
void do_cal(struct event *evl, const struct date *today);
unsigned ddiff(struct date *D1, struct date *D2, const struct date *today);
void liststrings(struct event *evl, prnfunc outf, const struct date *today);
char *tdelta(struct date *d, const struct date *today);
char *ttime(int yr, int mn, int wk, int dy);
void scan_date( const char *str, struct date *date);

/* ========== Global Variables */

extern struct date today;
extern int iDWarn;
extern int iMaxWarn;
extern int iMinWarn;

extern int iCLines;
extern int iCWidth;
extern int iCWeeks;
extern int iCTotal;
