;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_test.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --flatten --all-features -S -o - | filecheck %s

(module
 ;; CHECK:      (type $2 (func (result i32)))

 ;; CHECK:      (type $1 (func))

 ;; CHECK:      (type $ii (func (param i32 i32)))
 (type $ii (func (param i32 i32)))
 (type $1 (func))
 (type $2 (func (result i32)))
 ;; CHECK:      (type $3 (func (param i32) (result i32)))
 (type $3 (func (param i32) (result i32)))
 ;; CHECK:      (type $none_=>_f32 (func (result f32)))

 ;; CHECK:      (type $4 (func (param i64 i64) (result i64)))
 (type $4 (func (param i64 i64) (result i64)))
 ;; CHECK:      (type $none_=>_anyref (func (result anyref)))

 ;; CHECK:      (global $x (mut i32) (i32.const 0))
 (global $x (mut i32) (i32.const 0))
 (table 1 1 funcref)
 (elem (i32.const 0) $call-me)
 ;; CHECK:      (memory $0 10)
 (memory $0 10)
 ;; CHECK:      (table $0 1 1 funcref)

 ;; CHECK:      (elem (i32.const 0) $call-me)

 ;; CHECK:      (func $a1
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local.set $0
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a1
  (drop (i32.add (i32.const 0) (i32.const 1)))
 )
 ;; CHECK:      (func $a2 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local.set $0
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a2 (result i32)
  (i32.add (i32.const 0) (i32.const 1))
 )
 ;; CHECK:      (func $a3 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a3 (result i32)
  (i32.add
   (i32.const 0)
   (block (result i32)
    (i32.const 1)
   )
  )
 )
 ;; CHECK:      (func $a4
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a4
  (drop
   (i32.add
    (i32.const 0)
    (block (result i32)
     (i32.const 1)
    )
   )
  )
 )
 ;; CHECK:      (func $a5 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $block0
 ;; CHECK-NEXT:   (local.set $2
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $3
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $4
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a5 (result i32)
  (i32.add
   (block (result i32)
    (i32.const 0)
   )
   (block (result i32)
    (i32.const 1)
   )
  )
 )
 ;; CHECK:      (func $a6 (result i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $2
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $3
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $block1
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $6
 ;; CHECK-NEXT:   (local.get $5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $7
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:    (local.get $6)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $7)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a6 (result i32)
  (local $x i32)
  (i32.add
   (block (result i32)
    (local.tee $x
     (i32.const 0)
    )
   )
   (block (result i32)
    (local.tee $x
     (i32.const 1)
    )
   )
  )
 )
 ;; CHECK:      (func $a7 (result i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (block $block2
 ;; CHECK-NEXT:    (local.set $x
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $1
 ;; CHECK-NEXT:     (local.get $x)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (local.get $1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (block $block3
 ;; CHECK-NEXT:    (local.set $x
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $4
 ;; CHECK-NEXT:     (local.get $x)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $5
 ;; CHECK-NEXT:     (local.get $4)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $6
 ;; CHECK-NEXT:    (local.get $5)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $7
 ;; CHECK-NEXT:    (i32.add
 ;; CHECK-NEXT:     (local.get $3)
 ;; CHECK-NEXT:     (local.get $6)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $8
 ;; CHECK-NEXT:    (local.get $7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $9
 ;; CHECK-NEXT:   (local.get $8)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $9)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a7 (result i32)
  (local $x i32)
  (block (result i32)
   (i32.add
    (block (result i32)
     (local.tee $x
      (i32.const 0)
     )
    )
    (block (result i32)
     (local.tee $x
      (i32.const 1)
     )
    )
   )
  )
 )
 ;; CHECK:      (func $a8 (result i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (local $10 i32)
 ;; CHECK-NEXT:  (block $outer
 ;; CHECK-NEXT:   (block $inner
 ;; CHECK-NEXT:    (block $block
 ;; CHECK-NEXT:     (local.set $1
 ;; CHECK-NEXT:      (i32.const -1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (br $inner)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (local.set $2
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (br $outer)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (local.set $3
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $4
 ;; CHECK-NEXT:     (local.get $3)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (block $block4
 ;; CHECK-NEXT:     (local.set $2
 ;; CHECK-NEXT:      (i32.const 2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (br $outer)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (local.set $x
 ;; CHECK-NEXT:      (i32.const 3)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $5
 ;; CHECK-NEXT:      (local.get $x)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $6
 ;; CHECK-NEXT:      (local.get $5)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $7
 ;; CHECK-NEXT:     (local.get $6)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $8
 ;; CHECK-NEXT:     (i32.add
 ;; CHECK-NEXT:      (local.get $4)
 ;; CHECK-NEXT:      (local.get $7)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $1
 ;; CHECK-NEXT:     (local.get $8)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $9
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $2
 ;; CHECK-NEXT:    (local.get $9)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $10
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $10)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a8 (result i32)
  (local $x i32)
  (block $outer (result i32)
   (block $inner (result i32)
    (i32.add
     (block (result i32)
      (br $inner
       (i32.const -1)
      )
      (br $outer
       (i32.const 0)
      )
      (i32.const 1)
     )
     (block (result i32)
      (br $outer
       (i32.const 2)
      )
      (local.tee $x
       (i32.const 3)
      )
     )
    )
   )
  )
 )
 ;; CHECK:      (func $a9 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (loop $outer
 ;; CHECK-NEXT:   (loop $inner
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (br_if $outer
 ;; CHECK-NEXT:      (i32.const -1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $0
 ;; CHECK-NEXT:      (i32.add
 ;; CHECK-NEXT:       (i32.const 0)
 ;; CHECK-NEXT:       (i32.const 1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $1
 ;; CHECK-NEXT:      (local.get $0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (local.get $1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $3
 ;; CHECK-NEXT:     (local.get $2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $6
 ;; CHECK-NEXT:   (local.get $5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $6)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a9 (result i32)
  (loop $outer (result i32)
   (loop $inner (result i32)
    (br_if $outer (i32.const -1))
    (i32.add
     (i32.const 0)
     (i32.const 1)
    )
   )
  )
 )
 ;; CHECK:      (func $a10 (result i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (local $10 i32)
 ;; CHECK-NEXT:  (block $outer
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $outer
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $2
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $outer
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 5)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $outer
 ;; CHECK-NEXT:    (local.get $5)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $6
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $6)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 6)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $7
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $8
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $outer
 ;; CHECK-NEXT:    (local.get $8)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $9
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $9)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (i32.const 8)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $outer)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $10
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $10)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a10 (result i32)
  (local $x i32)
  (block $outer (result i32)
   (drop (br_if $outer (i32.const 0) (i32.const 1)))
   (drop (br_if $outer (local.tee $x (i32.const 2)) (i32.const 3)))
   (drop (br_if $outer (i32.const 4) (local.tee $x (i32.const 5))))
   (drop (br_if $outer (local.tee $x (i32.const 6)) (local.tee $x (i32.const 7))))
   (br $outer (i32.const 8))
  )
 )
 ;; CHECK:      (func $a11
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a11
  (if (i32.const 0)
   (drop (i32.const 1))
  )
 )
 ;; CHECK:      (func $a12 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a12 (result i32)
  (if (result i32) (i32.const 0)
   (i32.const 1)
   (i32.const 2)
  )
 )
 ;; CHECK:      (func $a13 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (block $x
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (local.set $0
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $1
 ;; CHECK-NEXT:     (local.get $0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (br_table $x
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (if
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (local.set $2
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $2
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $4
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a13 (result i32)
  (block $x i32
   (if i32
    (br_table $x (i32.const 2) (i32.const 0))
    (i32.const 0)
    (i32.const 1)
   )
  )
 )
 ;; CHECK:      (func $a14 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_table $block
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $2
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a14 (result i32)
  (block i32
   (select
    (i32.const 0) (i32.const 1) (br_table 0 (i32.const 7) (i32.const 1))
   )
  )
 )
 ;; CHECK:      (func $a15
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 f32)
 ;; CHECK-NEXT:  (local $2 f32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.load16_u
 ;; CHECK-NEXT:     (i32.const 53)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (block $label$3
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $2
 ;; CHECK-NEXT:      (local.get $1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (local.get $2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $a15
  (if
   (i32.load16_u
    (i32.const 53)
   )
   (unreachable)
   (drop
    (block $label$3 (result f32)
     (unreachable)
    )
   )
  )
 )
 ;; CHECK:      (func $a16 (result i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (block $label$1
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (block $label$2
 ;; CHECK-NEXT:    (local.set $x
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (i32.eqz
 ;; CHECK-NEXT:     (local.get $3)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $label$1
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $6
 ;; CHECK-NEXT:    (local.get $5)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $6)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $7
 ;; CHECK-NEXT:   (local.get $5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $7)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a16 (result i32)
  (local $x i32)
  (block $label$1 (result i32)
   (drop
    (br_if $label$1
     (local.tee $x ;; set here, then it is undone later, but this value is used, not the contents of $x!
      (i32.const 1)
     )
     (i32.eqz ;; 0 into 1, so take the br_if
      (block $label$2 (result i32)
       (local.set $x
        (i32.const 0) ;; undo the above tee
       )
       (i32.const 0)
      )
     )
    )
   )
   (i32.const 0)
  )
 )
 ;; CHECK:      (func $a17 (result f32)
 ;; CHECK-NEXT:  (local $var$0 f32)
 ;; CHECK-NEXT:  (local $1 f32)
 ;; CHECK-NEXT:  (local $2 f32)
 ;; CHECK-NEXT:  (local $3 f32)
 ;; CHECK-NEXT:  (local $4 f32)
 ;; CHECK-NEXT:  (local $5 f32)
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $var$0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $var$0
 ;; CHECK-NEXT:   (f32.const -137438953472)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $2
 ;; CHECK-NEXT:   (local.get $var$0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $3
 ;; CHECK-NEXT:   (local.get $var$0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $4
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $5
 ;; CHECK-NEXT:   (f32.max
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a17 (result f32)
  (local $var$0 f32)
  (f32.max
   (local.get $var$0)
   (select
    (local.tee $var$0
     (f32.const -137438953472)
    )
    (local.get $var$0)
    (i32.const 0)
   )
  )
 )
 ;; CHECK:      (func $a18 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $label$1
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $label$1
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.load
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $a18 (result i32)
  (block $label$1 (result i32)
   (i32.load16_s
    (drop ;; an unreachable drop. one we move its contents outside, it should stay unreachable
     (br_if $label$1
      (i32.const 1)
      (unreachable)
     )
    )
   )
  )
 )
 ;; CHECK:      (func $a19 (result f32)
 ;; CHECK-NEXT:  (block $label$0
 ;; CHECK-NEXT:   (block $label$1
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (return
 ;; CHECK-NEXT:     (f32.const 4289944320)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (select
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 65535)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $a19 (result f32)
  (block $label$0
   (block $label$1
    (drop
     (select
      (unreachable) ;; move this out, so it happens before the return
      (return
       (f32.const 4289944320)
      )
      (i32.const 65535)
     )
    )
   )
  )
 )
 ;; CHECK:      (func $call-me (param $0 i32) (param $1 i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $call-me (param $0 i32) (param $1 i32)
  (nop)
 )
 ;; CHECK:      (func $code-to-kill
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (block $out
 ;; CHECK-NEXT:   (br $out)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_table $out $out $out $out
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (call $code-to-kill)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $out1
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $out3
 ;; CHECK-NEXT:     (return)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out4
 ;; CHECK-NEXT:   (br_table $out4 $out4 $out4 $out4
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out5
 ;; CHECK-NEXT:   (br_if $out5
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $block4
 ;; CHECK-NEXT:     (if
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:      (block
 ;; CHECK-NEXT:       (block $out8
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (drop
 ;; CHECK-NEXT:         (i32.const 0)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (block
 ;; CHECK-NEXT:       (block $out9
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (drop
 ;; CHECK-NEXT:         (i32.const 0)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $out11
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (local.get $1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (local.get $2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $out13
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $4
 ;; CHECK-NEXT:     (local.get $3)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (local.get $4)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $out15
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $6
 ;; CHECK-NEXT:     (local.get $5)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (local.get $6)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out16
 ;; CHECK-NEXT:   (block $in
 ;; CHECK-NEXT:    (br_if $out16
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $block11
 ;; CHECK-NEXT:     (block $out18
 ;; CHECK-NEXT:      (block $in19
 ;; CHECK-NEXT:       (br_if $in19
 ;; CHECK-NEXT:        (i32.const 1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 10)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out20
 ;; CHECK-NEXT:   (block $in21
 ;; CHECK-NEXT:    (br_table $out20 $in21
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out22
 ;; CHECK-NEXT:   (block $in23
 ;; CHECK-NEXT:    (br_table $in23 $out22
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $block13
 ;; CHECK-NEXT:     (block $out25
 ;; CHECK-NEXT:      (block $in26
 ;; CHECK-NEXT:       (br_table $in26 $in26
 ;; CHECK-NEXT:        (i32.const 1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 10)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $block15
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 10)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 42)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (return
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (return)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (loop $loop-in18
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $out29
 ;; CHECK-NEXT:   (loop $in30
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (br_if $out29
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (block $block20
 ;; CHECK-NEXT:     (loop $in32
 ;; CHECK-NEXT:      (block
 ;; CHECK-NEXT:       (br_if $in32
 ;; CHECK-NEXT:        (i32.const 1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (i32.const 10)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call $call-me
 ;; CHECK-NEXT:     (i32.const 123)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call $call-me
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call $call-me
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call_indirect $0 (type $ii)
 ;; CHECK-NEXT:     (i32.const 123)
 ;; CHECK-NEXT:     (i32.const 456)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const -2)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call_indirect $0 (type $ii)
 ;; CHECK-NEXT:     (i32.const 139)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const -3)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call_indirect $0 (type $ii)
 ;; CHECK-NEXT:     (i32.const 246)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const -4)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (call_indirect $0 (type $ii)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 11)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 22)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.load
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 33)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.store
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 44)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.store
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 55)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.store
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 66)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.eqz
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 77)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.add
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 88)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.add
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 99)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.add
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 100)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (select
 ;; CHECK-NEXT:     (i32.const 123)
 ;; CHECK-NEXT:     (i32.const 456)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 101)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (select
 ;; CHECK-NEXT:     (i32.const 123)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 456)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 102)
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (select
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (i32.const 123)
 ;; CHECK-NEXT:     (i32.const 456)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 1337)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $code-to-kill
  (local $x i32)
  (block $out
   (br $out)
   (drop
    (i32.const 0)
   )
   (if
    (i32.const 1)
    (drop
     (i32.const 2)
    )
   )
   (br_table $out $out $out $out
    (i32.const 3)
   )
   (call $code-to-kill)
  )
  (if
   (i32.const 0)
   (block $out1
    (unreachable)
    (drop
     (i32.const 0)
    )
   )
  )
  (if
   (i32.const 0)
   (block $out3
    (return)
    (drop
     (i32.const 0)
    )
   )
  )
  (block $out4
   (br_table $out4 $out4 $out4 $out4
    (i32.const 4)
   )
   (drop
    (i32.const 0)
   )
  )
  (block $out5
   (br_if $out5
    (i32.const 3)
   )
   (drop
    (i32.const 0)
   )
  )
  (if
   (i32.const 0)
   (block $block4
    (if
     (i32.const 0)
     (block $out8
      (unreachable)
      (drop
       (i32.const 0)
      )
     )
     (block $out9
      (unreachable)
      (drop
       (i32.const 0)
      )
     )
    )
    (drop
     (i32.const 0)
    )
   )
  )
  (if
   (i32.const 0)
   (drop
    (block $out11 (result i32)
     (br $out11
      (unreachable)
     )
     (drop
      (i32.const 0)
     )
     (unreachable)
    )
   )
  )
  (if
   (i32.const 0)
   (drop
    (block $out13 (result i32)
     (br_if $out13
      (unreachable)
      (i32.const 0)
     )
     (drop
      (i32.const 0)
     )
     (unreachable)
    )
   )
  )
  (if
   (i32.const 0)
   (drop
    (block $out15 (result i32)
     (br_if $out15
      (unreachable)
      (unreachable)
     )
     (drop
      (i32.const 0)
     )
     (unreachable)
    )
   )
  )
  (block $out16
   (block $in
    (br_if $out16
     (i32.const 1)
    )
   )
   (unreachable)
  )
  (if
   (i32.const 0)
   (block $block11
    (block $out18
     (block $in19
      (br_if $in19
       (i32.const 1)
      )
     )
     (unreachable)
    )
    (drop
     (i32.const 10)
    )
   )
  )
  (block $out20
   (block $in21
    (br_table $out20 $in21
     (i32.const 1)
    )
   )
   (unreachable)
  )
  (block $out22
   (block $in23
    (br_table $in23 $out22
     (i32.const 1)
    )
   )
   (unreachable)
  )
  (if
   (i32.const 0)
   (block $block13
    (block $out25
     (block $in26
      (br_table $in26 $in26
       (i32.const 1)
      )
     )
     (unreachable)
    )
    (drop
     (i32.const 10)
    )
   )
  )
  (if
   (i32.const 0)
   (block $block15
    (drop
     (i32.const 10)
    )
    (drop
     (i32.const 42)
    )
    (unreachable)
    (return
     (unreachable)
    )
    (unreachable)
    (return)
   )
  )
  (if
   (i32.const 0)
   (loop $loop-in18
    (unreachable)
   )
  )
  (block $out29
   (loop $in30
    (br_if $out29
     (i32.const 1)
    )
    (unreachable)
   )
  )
  (if
   (i32.const 0)
   (block $block20
    (loop $in32
     (br_if $in32
      (i32.const 1)
     )
     (unreachable)
    )
    (drop
     (i32.const 10)
    )
   )
  )
  (if
   (i32.const 1)
   (call $call-me
    (i32.const 123)
    (unreachable)
   )
  )
  (if
   (i32.const 2)
   (call $call-me
    (unreachable)
    (i32.const 0)
   )
  )
  (if
   (i32.const 3)
   (call $call-me
    (unreachable)
    (unreachable)
   )
  )
  (if
   (i32.const -1)
   (call_indirect (type $ii)
    (i32.const 123)
    (i32.const 456)
    (unreachable)
   )
  )
  (if
   (i32.const -2)
   (call_indirect (type $ii)
    (i32.const 139)
    (unreachable)
    (i32.const 0)
   )
  )
  (if
   (i32.const -3)
   (call_indirect (type $ii)
    (i32.const 246)
    (unreachable)
    (unreachable)
   )
  )
  (if
   (i32.const -4)
   (call_indirect (type $ii)
    (unreachable)
    (unreachable)
    (unreachable)
   )
  )
  (if
   (i32.const 11)
   (local.set $x
    (unreachable)
   )
  )
  (if
   (i32.const 22)
   (drop
    (i32.load
     (unreachable)
    )
   )
  )
  (if
   (i32.const 33)
   (i32.store
    (i32.const 0)
    (unreachable)
   )
  )
  (if
   (i32.const 44)
   (i32.store
    (unreachable)
    (i32.const 0)
   )
  )
  (if
   (i32.const 55)
   (i32.store
    (unreachable)
    (unreachable)
   )
  )
  (if
   (i32.const 66)
   (drop
    (i32.eqz
     (unreachable)
    )
   )
  )
  (if
   (i32.const 77)
   (drop
    (i32.add
     (unreachable)
     (i32.const 0)
    )
   )
  )
  (if
   (i32.const 88)
   (drop
    (i32.add
     (i32.const 0)
     (unreachable)
    )
   )
  )
  (if
   (i32.const 99)
   (i32.add
    (unreachable)
    (unreachable)
   )
  )
  (if
   (i32.const 100)
   (drop
    (select
     (i32.const 123)
     (i32.const 456)
     (unreachable)
    )
   )
  )
  (if
   (i32.const 101)
   (drop
    (select
     (i32.const 123)
     (unreachable)
     (i32.const 456)
    )
   )
  )
  (if
   (i32.const 102)
   (drop
    (select
     (unreachable)
     (i32.const 123)
     (i32.const 456)
    )
   )
  )
  (drop
   (i32.const 1337)
  )
 )
 ;; CHECK:      (func $killer
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 1000)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $killer (type $1)
  (unreachable)
  (drop
   (i32.const 1000)
  )
 )
 ;; CHECK:      (func $target
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 2000)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $target (type $1)
  (drop
   (i32.const 2000)
  )
 )
 ;; CHECK:      (func $typed-block-none-then-unreachable (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $top-typed
 ;; CHECK-NEXT:   (block $switch$0
 ;; CHECK-NEXT:    (return
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (br $switch$0)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $typed-block-none-then-unreachable (type $2) (result i32)
  (block $top-typed (result i32)
   (block $switch$0
    (return
     (i32.const 0)
    )
    (br $switch$0)
   )
   (return
    (i32.const 1)
   )
  )
 )
 ;; CHECK:      (func $typed-block-remove-br-changes-type (param $$$0 i32) (result i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (block $switch$7
 ;; CHECK-NEXT:    (block $switch-default$10
 ;; CHECK-NEXT:     (block $switch-case$9
 ;; CHECK-NEXT:      (block $switch-case$8
 ;; CHECK-NEXT:       (br_table $switch-case$9 $switch-case$8 $switch-default$10
 ;; CHECK-NEXT:        (i32.const -1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $1
 ;; CHECK-NEXT:      (local.get $$$0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (return
 ;; CHECK-NEXT:      (local.get $1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (br $switch$7)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (local.get $$$0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (return
 ;; CHECK-NEXT:     (local.get $2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $4
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $typed-block-remove-br-changes-type (type $3) (param $$$0 i32) (result i32)
  (block $switch$7
   (block $switch-default$10
    (block $switch-case$9
     (block $switch-case$8
      (br_table $switch-case$9 $switch-case$8 $switch-default$10
       (i32.const -1)
      )
     )
    )
    (return
     (local.get $$$0)
    )
    (br $switch$7)
   )
   (return
    (local.get $$$0)
   )
  )
  (return
   (i32.const 0)
  )
 )
 ;; CHECK:      (func $global
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (global.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (global.set $x
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $global (type $1)
  (unreachable)
  (drop
   (global.get $x)
  )
  (global.set $x
   (i32.const 1)
  )
 )
 ;; CHECK:      (func $ret (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ret (type $2) (result i32)
  (return
   (i32.const 0)
  )
  (nop)
  (i32.const 0)
 )
 ;; CHECK:      (func $unreachable-br (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $out
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $out)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unreachable-br (type $2) (result i32)
  (block $out (result i32)
   (br $out
    (br $out
     (i32.const 0)
    )
   )
  )
 )
 ;; CHECK:      (func $unreachable-br-loop (result i32)
 ;; CHECK-NEXT:  (loop $out
 ;; CHECK-NEXT:   (br $out)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $unreachable-br-loop (type $2) (result i32)
  (loop $out
   (br $out)
  )
 )
 ;; CHECK:      (func $unreachable-block-ends-switch (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $label$0
 ;; CHECK-NEXT:   (block $label$3
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (br_table $label$3
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 19)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unreachable-block-ends-switch (type $2) (result i32)
  (block $label$0 (result i32)
   (block $label$3
    (nop)
    (br_table $label$3
     (unreachable)
    )
    (unreachable)
   )
   (i32.const 19)
  )
 )
 ;; CHECK:      (func $unreachable-block-ends-br_if (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $label$0
 ;; CHECK-NEXT:   (block $label$2
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (br_if $label$2
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 19)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unreachable-block-ends-br_if (result i32)
  (block $label$0 (result i32)
   (block $label$2
    (nop)
    (br_if $label$2
     (unreachable)
    )
    (unreachable)
   )
   (i32.const 19)
  )
 )
 ;; CHECK:      (func $unreachable-brs-3 (result i32)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (block $label$0
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 18)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $label$0)
 ;; CHECK-NEXT:   (memory.grow
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (local.set $0
 ;; CHECK-NEXT:    (i32.const 21)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unreachable-brs-3 (result i32)
  (block $label$0 (result i32)
   (br $label$0
    (memory.grow
     (br $label$0
      (i32.const 18)
     )
    )
   )
   (i32.const 21)
  )
 )
 ;; CHECK:      (func $unreachable-brs-4 (param $var$0 i32) (result i32)
 ;; CHECK-NEXT:  (local $1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (block $label$0
 ;; CHECK-NEXT:   (block $label$1
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (local.set $1
 ;; CHECK-NEXT:     (i32.const 4104)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (br_if $label$0
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (i32.const 4)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $label$0)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (local.set $1
 ;; CHECK-NEXT:    (i32.const 16)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $4
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $5
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unreachable-brs-4 (param $var$0 i32) (result i32)
  (i32.add
   (i32.const 1)
   (block $label$0 (result i32)
    (br $label$0
     (block $label$1 (result i32)
      (drop
       (br_if $label$0
        (i32.const 4104)
        (unreachable)
       )
      )
      (i32.const 4)
     )
    )
    (i32.const 16)
   )
  )
 )
 ;; CHECK:      (func $call-unreach (param $var$0 i64) (param $var$1 i64) (result i64)
 ;; CHECK-NEXT:  (local $2 i64)
 ;; CHECK-NEXT:  (local $3 i64)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i64)
 ;; CHECK-NEXT:  (local $6 i64)
 ;; CHECK-NEXT:  (local $7 i64)
 ;; CHECK-NEXT:  (local $8 i64)
 ;; CHECK-NEXT:  (local $9 i64)
 ;; CHECK-NEXT:  (local $10 i64)
 ;; CHECK-NEXT:  (local $11 i64)
 ;; CHECK-NEXT:  (local $12 i64)
 ;; CHECK-NEXT:  (local $13 i64)
 ;; CHECK-NEXT:  (local $14 i64)
 ;; CHECK-NEXT:  (local $15 i64)
 ;; CHECK-NEXT:  (local $16 i64)
 ;; CHECK-NEXT:  (local $17 i64)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (local.get $var$0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (i64.eqz
 ;; CHECK-NEXT:     (local.get $3)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (block $label$0
 ;; CHECK-NEXT:      (local.set $5
 ;; CHECK-NEXT:       (local.get $var$1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.set $6
 ;; CHECK-NEXT:       (local.get $5)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $7
 ;; CHECK-NEXT:      (local.get $6)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $16
 ;; CHECK-NEXT:      (local.get $7)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (block $label$1
 ;; CHECK-NEXT:      (local.set $8
 ;; CHECK-NEXT:       (local.get $var$0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.set $9
 ;; CHECK-NEXT:       (i64.sub
 ;; CHECK-NEXT:        (local.get $8)
 ;; CHECK-NEXT:        (i64.const 1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (block $block
 ;; CHECK-NEXT:       (local.set $10
 ;; CHECK-NEXT:        (local.get $var$0)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (local.set $2
 ;; CHECK-NEXT:        (local.get $10)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (nop)
 ;; CHECK-NEXT:       (local.set $11
 ;; CHECK-NEXT:        (local.get $2)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (local.set $12
 ;; CHECK-NEXT:        (local.get $11)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.set $13
 ;; CHECK-NEXT:       (local.get $12)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (i64.mul
 ;; CHECK-NEXT:       (local.get $13)
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (call $call-unreach
 ;; CHECK-NEXT:       (local.get $9)
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $15
 ;; CHECK-NEXT:      (local.get $14)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.set $16
 ;; CHECK-NEXT:      (local.get $15)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $17
 ;; CHECK-NEXT:   (local.get $16)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $17)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call-unreach (param $var$0 i64) (param $var$1 i64) (result i64)
  (local $2 i64)
  (if (result i64)
   (i64.eqz
    (local.get $var$0)
   )
   (block $label$0 (result i64)
    (local.get $var$1)
   )
   (block $label$1 (result i64)
    (call $call-unreach
     (i64.sub
      (local.get $var$0)
      (i64.const 1)
     )
     (i64.mul
      (block $block (result i64)
       (local.set $2
        (local.get $var$0)
       )
       (nop)
       (local.get $2)
      )
      (unreachable)
     )
    )
   )
  )
 )

  ;; flatten-specific
  ;; CHECK:      (func $test-flatten
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (local $18 i32)
  ;; CHECK-NEXT:  (local $19 i32)
  ;; CHECK-NEXT:  (local $20 i32)
  ;; CHECK-NEXT:  (local $21 i32)
  ;; CHECK-NEXT:  (local $22 i32)
  ;; CHECK-NEXT:  (local $23 i32)
  ;; CHECK-NEXT:  (local $24 i32)
  ;; CHECK-NEXT:  (local $25 i32)
  ;; CHECK-NEXT:  (local $26 i32)
  ;; CHECK-NEXT:  (local $27 i32)
  ;; CHECK-NEXT:  (local $28 i32)
  ;; CHECK-NEXT:  (local $29 i32)
  ;; CHECK-NEXT:  (local $30 i32)
  ;; CHECK-NEXT:  (local $31 i32)
  ;; CHECK-NEXT:  (local $32 i32)
  ;; CHECK-NEXT:  (local $33 i32)
  ;; CHECK-NEXT:  (local $34 i32)
  ;; CHECK-NEXT:  (local $35 i32)
  ;; CHECK-NEXT:  (local $36 i32)
  ;; CHECK-NEXT:  (local $37 i32)
  ;; CHECK-NEXT:  (local $38 i32)
  ;; CHECK-NEXT:  (local $39 i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (local.set $0
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (br_table $out $out $out $out
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (block $block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $2
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $3
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (block $in
  ;; CHECK-NEXT:    (block $switch-in
  ;; CHECK-NEXT:     (local.set $4
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $5
  ;; CHECK-NEXT:      (local.get $4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $6
  ;; CHECK-NEXT:      (local.get $4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (br_table $in $switch-in $in
  ;; CHECK-NEXT:      (i32.const 777)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $7
  ;; CHECK-NEXT:     (local.get $6)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $7)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (i32.const 3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $in)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (local.get $5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $8)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loop-in
  ;; CHECK-NEXT:    (local.set $10
  ;; CHECK-NEXT:     (i32.const 5)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $11
  ;; CHECK-NEXT:    (local.get $10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $12
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $11)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $12)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:    (local.set $13
  ;; CHECK-NEXT:     (i32.const 7)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $13
  ;; CHECK-NEXT:     (i32.const 8)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $14
  ;; CHECK-NEXT:    (local.get $13)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $15
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $14)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $16
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (i32.const 9)
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:     (i32.const 11)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $16)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 9)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (br $out)
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 9)
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:    (local.set $17
  ;; CHECK-NEXT:     (i32.const 12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $17
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $18
  ;; CHECK-NEXT:    (local.get $17)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $19
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $18)
  ;; CHECK-NEXT:     (i32.const 9)
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $19)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:    (local.set $20
  ;; CHECK-NEXT:     (i32.const 12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $20
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $21
  ;; CHECK-NEXT:    (local.get $20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $22
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (i32.const 9)
  ;; CHECK-NEXT:     (local.get $21)
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $22)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:    (local.set $23
  ;; CHECK-NEXT:     (i32.const 12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $23
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $24
  ;; CHECK-NEXT:    (local.get $23)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $25
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (i32.const 9)
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:     (local.get $24)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $25)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:    (local.set $26
  ;; CHECK-NEXT:     (i32.const 12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $26
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $27
  ;; CHECK-NEXT:    (local.get $26)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 15)
  ;; CHECK-NEXT:    (local.set $28
  ;; CHECK-NEXT:     (i32.const 16)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $28
  ;; CHECK-NEXT:     (i32.const 17)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $29
  ;; CHECK-NEXT:    (local.get $28)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $30
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $27)
  ;; CHECK-NEXT:     (i32.const 14)
  ;; CHECK-NEXT:     (local.get $29)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 5)
  ;; CHECK-NEXT:     (local.set $31
  ;; CHECK-NEXT:      (i32.const 6)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $31
  ;; CHECK-NEXT:      (i32.const 7)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $32
  ;; CHECK-NEXT:     (local.get $31)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $32)
  ;; CHECK-NEXT:     (local.set $35
  ;; CHECK-NEXT:      (i32.const 8)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (i32.const 9)
  ;; CHECK-NEXT:       (local.set $33
  ;; CHECK-NEXT:        (i32.const 10)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $33
  ;; CHECK-NEXT:        (i32.const 11)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $34
  ;; CHECK-NEXT:       (local.get $33)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $35
  ;; CHECK-NEXT:       (local.get $34)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $36
  ;; CHECK-NEXT:    (local.get $35)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $36)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (block $temp
  ;; CHECK-NEXT:    (local.set $37
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br_if $temp
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $38
  ;; CHECK-NEXT:     (local.get $37)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $37
  ;; CHECK-NEXT:     (local.get $38)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $39
  ;; CHECK-NEXT:    (local.get $37)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $39)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test-flatten
    (block $out
      (drop (i32.add (i32.const 1) (i32.const 2)))
      (drop (i32.add (i32.const 1) (br $out)))
      (drop (i32.add (br $out) (i32.const 1)))
      (drop (i32.add (i32.const 1) (br_table $out $out $out $out (i32.const 3))))
      (drop (i32.add (i32.const 1)
        (block (result i32)
          (drop (i32.const 2))
          (drop (i32.const 3))
          (i32.const 4)
        )
      ))
      (drop (i32.add (i32.const 1)
        (block $in (result i32)
          (drop
            (block $switch-in (result i32)
              (br_table $in $switch-in $in (i32.const 2) (i32.const 777))
            )
          )
          (br $in (i32.const 3))
          (i32.const 4)
        )
      ))
      (drop (i32.add (i32.const 1)
        (loop (result i32)
          (i32.const 5)
        )
      ))
      (drop (i32.add (i32.const 1)
        (if (result i32)
          (i32.const 6)
          (i32.const 7)
          (i32.const 8)
        )
      ))
      (drop
        (select
         (i32.const 9)
         (i32.const 10)
         (i32.const 11)
        )
      )
      (drop
        (select
         (br $out)
         (i32.const 10)
         (i32.const 11)
        )
      )
      (drop
        (select
         (i32.const 9)
         (br $out)
         (i32.const 11)
        )
      )
      (drop
        (select
         (i32.const 9)
         (i32.const 10)
         (br $out)
        )
      )
      (drop
        (select
          (if (result i32)
            (i32.const 11)
            (i32.const 12)
            (i32.const 13)
          )
          (i32.const 9)
          (i32.const 10)
        )
      )
      (drop
        (select
          (i32.const 9)
          (if (result i32)
            (i32.const 11)
            (i32.const 12)
            (i32.const 13)
          )
          (i32.const 10)
        )
      )
      (drop
        (select
          (i32.const 9)
          (i32.const 10)
          (if (result i32)
            (i32.const 11)
            (i32.const 12)
            (i32.const 13)
          )
        )
      )
      (drop
        (select
          (if (result i32)
            (i32.const 11)
            (i32.const 12)
            (i32.const 13)
          )
          (i32.const 14)
          (if (result i32)
            (i32.const 15)
            (i32.const 16)
            (i32.const 17)
          )
        )
      )
      (drop (i32.add (i32.const 1) (return)))
      (drop (i32.add (i32.const 1) (unreachable)))
      (drop
        (if (result i32)
          (if (result i32)
            (i32.const 5)
            (i32.const 6)
            (i32.const 7)
          )
          (i32.const 8)
          (if (result i32)
            (i32.const 9)
            (i32.const 10)
            (i32.const 11)
          )
        )
      )
      (drop
        (block $temp (result i32)
          (br_if $temp
            (i32.const 1)
            (i32.const 2)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $flatten-return-value (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (local.set $0
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $flatten-return-value (result i32)
    (drop (i32.add (i32.const 1) (return (i32.const 2))))
    (i32.const 3)
  )
  ;; CHECK:      (func $unbug
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $432 i32)
  ;; CHECK-NEXT:  (local $430 i32)
  ;; CHECK-NEXT:  (local $431 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $433 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (local $18 i32)
  ;; CHECK-NEXT:  (local $19 i32)
  ;; CHECK-NEXT:  (local $20 i32)
  ;; CHECK-NEXT:  (local $21 i32)
  ;; CHECK-NEXT:  (local $22 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (local.set $7
  ;; CHECK-NEXT:     (local.get $12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $8
  ;; CHECK-NEXT:     (i32.eq
  ;; CHECK-NEXT:      (local.get $7)
  ;; CHECK-NEXT:      (i32.const 65535)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $8)
  ;; CHECK-NEXT:     (block $block44
  ;; CHECK-NEXT:      (block $label$78
  ;; CHECK-NEXT:       (local.set $430
  ;; CHECK-NEXT:        (i32.const 0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $9
  ;; CHECK-NEXT:       (local.get $430)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $432
  ;; CHECK-NEXT:       (local.get $9)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (block $block45
  ;; CHECK-NEXT:      (block $label$79
  ;; CHECK-NEXT:       (local.set $10
  ;; CHECK-NEXT:        (local.get $9)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $11
  ;; CHECK-NEXT:        (local.get $5)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $12
  ;; CHECK-NEXT:        (local.get $12)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $13
  ;; CHECK-NEXT:        (i32.mul
  ;; CHECK-NEXT:         (local.get $12)
  ;; CHECK-NEXT:         (i32.const 12)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $14
  ;; CHECK-NEXT:        (i32.add
  ;; CHECK-NEXT:         (local.get $11)
  ;; CHECK-NEXT:         (local.get $13)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $15
  ;; CHECK-NEXT:        (i32.load16_u offset=2
  ;; CHECK-NEXT:         (local.get $14)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $16
  ;; CHECK-NEXT:        (i32.lt_u
  ;; CHECK-NEXT:         (local.get $10)
  ;; CHECK-NEXT:         (local.get $15)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $431
  ;; CHECK-NEXT:        (local.get $16)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $17
  ;; CHECK-NEXT:       (local.get $431)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $432
  ;; CHECK-NEXT:       (local.get $17)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $433
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $18
  ;; CHECK-NEXT:    (local.get $432)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $19
  ;; CHECK-NEXT:    (local.get $433)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $20
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $18)
  ;; CHECK-NEXT:     (local.get $19)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $21
  ;; CHECK-NEXT:    (local.get $20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $22
  ;; CHECK-NEXT:   (local.get $21)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $22)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $unbug
   (local $12 i32)
   (local $432 i32)
   (local $430 i32)
   (local $431 i32)
   (local $9 i32)
   (local $5 i32)
   (local $433 i32)
   (drop
    (block (result i32)
     (if
      (i32.eq
       (local.get $12)
       (i32.const 65535)
      )
      (block
       (block $label$78
        (local.set $430
         (i32.const 0)
        )
       )
       (local.set $432
        (local.get $430)
       )
      )
      (block
       (block $label$79
        (local.set $431
         (i32.lt_u
          (local.get $9)
          (i32.load16_u offset=2
           (i32.add
            (local.get $5)
            (i32.mul
             (local.get $12)
             (i32.const 12)
            )
           )
          )
         )
        )
       )
       (local.set $432
        (local.get $431)
       )
      )
     )
     (local.set $433
      (i32.const 1)
     )
     (i32.xor
      (local.get $432)
      (local.get $433)
     )
    )
   )
  )
  ;; CHECK:      (func $outer-block-typed (param $var$0 i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (block $block
  ;; CHECK-NEXT:   (block $label$0
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (i32.const 16)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $2
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $3
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $4
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $5
  ;; CHECK-NEXT:   (local.get $4)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $outer-block-typed (type $3) (param $var$0 i32) (result i32)
   (block (result i32)
    (i32.add
     (i32.const 1)
     (block $label$0 (result i32)
      (i32.const 16)
     )
    )
   )
  )
  ;; CHECK:      (func $nested-br_if-with-value (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block $label$0
  ;; CHECK-NEXT:   (block $block
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $3
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $4
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (br_if $label$0
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $5
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $4
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $6
  ;; CHECK-NEXT:   (local.get $4)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $6)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $nested-br_if-with-value (result i32)
   (local $0 i32)
   (block $label$0 (result i32)
    (drop
     (br_if $label$0
      (i32.const 0)
      (block (result i32)
       (local.get $0)
      )
     )
    )
    (i32.const 1)
   )
  )
  ;; CHECK:      (func $switch-unreachable
  ;; CHECK-NEXT:  (block $label$3
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (br_table $label$3
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $switch-unreachable
   (block $label$3
    (br_table $label$3
     (unreachable)
    )
   )
  )
  ;; CHECK:      (func $br_if_order (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (block $outer
  ;; CHECK-NEXT:   (block $inner
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br_if $outer
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (block $block
  ;; CHECK-NEXT:     (local.set $3
  ;; CHECK-NEXT:      (i32.const -16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $4
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (call $br_if_order
  ;; CHECK-NEXT:      (local.get $4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $6
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br_if $inner
  ;; CHECK-NEXT:     (local.get $5)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $7
  ;; CHECK-NEXT:     (local.get $6)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $6
  ;; CHECK-NEXT:     (local.get $7)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (local.get $6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $1
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $9
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $br_if_order (param $x i32) (result i32)
   (block $outer (result i32)
    (block $inner (result i32)
     (br_if $inner
      (br_if $outer
       (i32.const 0)
       (i32.const 1)
      )
      (call $br_if_order
       (block (result i32)
        (i32.const -16)
       )
      )
     )
    )
   )
  )
  ;; CHECK:      (func $tees (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $2
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $3
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $4
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $tees (param $x i32) (param $y i32)
    (drop (local.tee $x (i32.const 1)))
    (drop (local.tee $x (unreachable)))
    (drop (local.tee $y (local.tee $x (i32.const 2))))
  )
  ;; CHECK:      (func $return (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.sub
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $return (param $x i32) (result i32)
    (return (i32.sub (i32.const 1) (i32.const 2)))
  )

  ;; subtypes

  ;; br_if leaves a value on the stack if not taken, which later can be the last
  ;; element of the enclosing innermost block and flow out. So in case br_if
  ;; targets an outer branch whose return type is a supertype of the br_if's
  ;; value type, we need the value to be set into two locals: one with the outer
  ;; block's type, and one with its value type.
  ;; CHECK:      (func $subtype (result anyref)
  ;; CHECK-NEXT:  (local $0 externref)
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 externref)
  ;; CHECK-NEXT:  (local $3 externref)
  ;; CHECK-NEXT:  (local $4 externref)
  ;; CHECK-NEXT:  (local $5 externref)
  ;; CHECK-NEXT:  (local $6 externref)
  ;; CHECK-NEXT:  (local $7 anyref)
  ;; CHECK-NEXT:  (block $label0
  ;; CHECK-NEXT:   (block $block
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (ref.null extern)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (ref.null extern)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br_if $label0
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $3
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $0
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $4
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (local.get $4)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $6
  ;; CHECK-NEXT:    (local.get $5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $1
  ;; CHECK-NEXT:    (local.get $6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $7
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $subtype (result anyref)
    (local $0 externref)
    (block $label0 (result anyref)
      (block (result externref)
        (local.tee $0
          (br_if $label0
            (ref.null extern)
            (i32.const 0)
          )
        )
      )
    )
  )
)
(module
 ;; CHECK:      (type $i64_f32_=>_none (func (param i64 f32)))

 ;; CHECK:      (type $none_=>_i32 (func (result i32)))

 ;; CHECK:      (export "test" (func $1))

 ;; CHECK:      (func $0 (param $0 i64) (param $1 f32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $0 (param $0 i64) (param $1 f32)
  (nop)
 )
 (func "test" (result i32)
  (call $0
   (unreachable) ;; the unreachable should be handled properly, and not be
                 ;; reordered with the return
   (return
    (i32.const -111)
   )
  )
 )
)
;; non-nullable temp vars we add must be handled properly, as non-nullable
;; locals are not allowed
;; CHECK:      (func $1 (result i32)
;; CHECK-NEXT:  (unreachable)
;; CHECK-NEXT:  (return
;; CHECK-NEXT:   (i32.const -111)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (call $0
;; CHECK-NEXT:   (unreachable)
;; CHECK-NEXT:   (unreachable)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (unreachable)
;; CHECK-NEXT: )
(module
 ;; CHECK:      (type $none_=>_none (func))
 (type $none_=>_none (func))
 ;; CHECK:      (type $none_=>_funcref (func (result funcref)))

 ;; CHECK:      (func $0 (result funcref)
 ;; CHECK-NEXT:  (local $0 (ref null $none_=>_none))
 ;; CHECK-NEXT:  (local.set $0
 ;; CHECK-NEXT:   (ref.as_non_null
 ;; CHECK-NEXT:    (ref.null $none_=>_none)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (ref.as_non_null
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $0 (result funcref)
  (ref.as_non_null
   (ref.null $none_=>_none)
  )
 )
)
