/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.xbl.OriginalEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractEvent
implements Event,
OriginalEvent,
Cloneable {
    protected String type;
    protected boolean isBubbling;
    protected boolean cancelable;
    protected EventTarget currentTarget;
    protected EventTarget target;
    protected short eventPhase;
    protected long timeStamp = System.currentTimeMillis();
    protected boolean stopPropagation = false;
    protected boolean stopImmediatePropagation = false;
    protected boolean preventDefault = false;
    protected String namespaceURI;
    protected Event originalEvent;
    protected int bubbleLimit = 0;

    public String getType() {
        return this.type;
    }

    public EventTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public short getEventPhase() {
        return this.eventPhase;
    }

    public boolean getBubbles() {
        return this.isBubbling;
    }

    public boolean getCancelable() {
        return this.cancelable;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public Event getOriginalEvent() {
        return this.originalEvent;
    }

    public void stopPropagation() {
        this.stopPropagation = true;
    }

    public void preventDefault() {
        this.preventDefault = true;
    }

    public boolean isCustom() {
        return false;
    }

    public boolean isDefaultPrevented() {
        return this.preventDefault;
    }

    public void stopImmediatePropagation() {
        this.stopImmediatePropagation = true;
    }

    public void initEvent(String string, boolean bl, boolean bl2) {
        this.type = string;
        this.isBubbling = bl;
        this.cancelable = bl2;
    }

    public void initEventNS(String string, String string2, boolean bl, boolean bl2) {
        if (this.namespaceURI != null && this.namespaceURI.length() == 0) {
            this.namespaceURI = null;
        }
        this.namespaceURI = string;
        this.type = string2;
        this.isBubbling = bl;
        this.cancelable = bl2;
    }

    boolean getStopPropagation() {
        return this.stopPropagation;
    }

    boolean getStopImmediatePropagation() {
        return this.stopImmediatePropagation;
    }

    void setEventPhase(short s) {
        this.eventPhase = s;
    }

    void stopPropagation(boolean bl) {
        this.stopPropagation = bl;
    }

    void stopImmediatePropagation(boolean bl) {
        this.stopImmediatePropagation = bl;
    }

    void preventDefault(boolean bl) {
        this.preventDefault = bl;
    }

    void setCurrentTarget(EventTarget eventTarget) {
        this.currentTarget = eventTarget;
    }

    void setTarget(EventTarget eventTarget) {
        this.target = eventTarget;
    }

    public static boolean getEventPreventDefault(Event event) {
        AbstractEvent abstractEvent = (AbstractEvent)event;
        return abstractEvent.isDefaultPrevented();
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEvent abstractEvent = (AbstractEvent)super.clone();
        abstractEvent.timeStamp = System.currentTimeMillis();
        return abstractEvent;
    }

    public AbstractEvent cloneEvent() {
        try {
            AbstractEvent abstractEvent = (AbstractEvent)this.clone();
            abstractEvent.originalEvent = this;
            return abstractEvent;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getBubbleLimit() {
        return this.bubbleLimit;
    }

    public void setBubbleLimit(int n) {
        this.bubbleLimit = n;
    }
}

