#ifndef __BACKPORT_NET_SOCK_H
#define __BACKPORT_NET_SOCK_H
#include_next <net/sock.h>
#include <linux/version.h>

#if LINUX_VERSION_IS_LESS(4,16,0)
#define sk_pacing_shift_update LINUX_BACKPORT(sk_pacing_shift_update)
static inline void sk_pacing_shift_update(struct sock *sk, int val)
{
#if LINUX_VERSION_IS_GEQ(4,15,0)
	if (!sk || !sk_fullsock(sk) || sk->sk_pacing_shift == val)
		return;
	sk->sk_pacing_shift = val;
#endif /* >= 4.15 */
}
#endif /* < 4.16 */

#if LINUX_VERSION_IS_LESS(5,14,0)
static inline void backport_sk_error_report(struct sock *sk)
{
	sk->sk_error_report(sk);
}
#define sk_error_report(sk) LINUX_BACKPORT(sk_error_report(sk))
#endif /* <= 5.14 */

#if LINUX_VERSION_IS_LESS(6,16,0)
static inline bool
sk_requests_wifi_status(struct sock *sk)
{
	return sk && sk_fullsock(sk) && sock_flag(sk, SOCK_WIFI_STATUS);
}
#endif /* < 6.15 */

#endif /* __BACKPORT_NET_SOCK_H */
