/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Modules;
import org.aspectj.internal.tools.build.Result;
import org.aspectj.internal.tools.build.Util;

public class Module {
    private static final String[] ATTS = new String[]{"exported", "kind", "path", "sourcepath"};
    public final boolean valid;
    public final File moduleDir;
    public final String name;
    private final Modules modules;
    private final Result release;
    private final Result test;
    private final Result testAll;
    private final Result releaseAll;
    private final File moduleJar;
    private final List libJars;
    private final List classpathVariables;
    private final List exportedLibJars;
    private final List srcDirs;
    private final Properties properties;
    private final List requiredModules;
    private final Messager messager;

    private static boolean outOfDate(long time, File file) {
        return null == file || !file.canRead() || file.lastModified() > time;
    }

    private static Iterator sourceFiles(File srcDir) {
        ArrayList result = new ArrayList();
        Module.sourceFiles(srcDir, result);
        return ((AbstractList)result).iterator();
    }

    private static void sourceFiles(File srcDir, List result) {
        if (null == srcDir || !srcDir.canRead() || !srcDir.isDirectory()) {
            return;
        }
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Module.sourceFiles(files[i], result);
                continue;
            }
            if (!Module.isSourceFile(files[i])) continue;
            result.add(files[i]);
        }
    }

    private static void addIfNew(List source, List sink) {
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (sink.contains(item)) continue;
            sink.add(item);
        }
    }

    static void doFindJarRequirements(Result result, List known) {
        Util.iaxIfNull(result, "result");
        Util.iaxIfNull(known, "known");
        Module.addIfNew(result.getLibJars(), known);
        Module.addIfNew(result.getExportedLibJars(), known);
        Result[] reqs = result.getRequired();
        for (int i = 0; i < reqs.length; ++i) {
            Result requiredResult = reqs[i];
            File requiredJar = requiredResult.getOutputFile();
            if (known.contains(requiredJar)) continue;
            known.add(requiredJar);
            Module.doFindJarRequirements(requiredResult, known);
        }
    }

    private static boolean isSourceFile(File file) {
        String path = file.getPath();
        return path.endsWith(".java") || path.endsWith(".aj");
    }

    Module(File moduleDir, File jarDir, String name, Modules modules, Messager messager) {
        Util.iaxIfNotCanReadDir(moduleDir, "moduleDir");
        Util.iaxIfNotCanReadDir(jarDir, "jarDir");
        Util.iaxIfNull(name, "name");
        Util.iaxIfNull(modules, "modules");
        this.moduleDir = moduleDir;
        this.libJars = new ArrayList();
        this.exportedLibJars = new ArrayList();
        this.requiredModules = new ArrayList();
        this.srcDirs = new ArrayList();
        this.classpathVariables = new ArrayList();
        this.properties = new Properties();
        this.name = name;
        this.modules = modules;
        this.messager = messager;
        this.moduleJar = new File(jarDir, name + ".jar");
        this.release = new Result(Result.RELEASE, this, jarDir);
        this.releaseAll = new Result(Result.RELEASE_ALL, this, jarDir);
        this.test = new Result(Result.TEST, this, jarDir);
        this.testAll = new Result(Result.TEST_ALL, this, jarDir);
        this.valid = this.init();
    }

    public Modules getModules() {
        return this.modules;
    }

    public static boolean outOfDate(Result result) {
        File file;
        File outputFile = result.getOutputFile();
        if (!outputFile.exists() || !outputFile.canRead()) {
            return true;
        }
        long time = outputFile.lastModified();
        Iterator iter = result.getSrcDirs().iterator();
        while (iter.hasNext()) {
            File srcDir = (File)iter.next();
            Iterator srcFiles = Module.sourceFiles(srcDir);
            while (srcFiles.hasNext()) {
                file = (File)srcFiles.next();
                if (!Module.outOfDate(time, file)) continue;
                return true;
            }
        }
        Result[] reqs = result.getRequired();
        for (int i = 0; i < reqs.length; ++i) {
            Result requiredResult = reqs[i];
            file = requiredResult.getOutputFile();
            if (!Module.outOfDate(time, file)) continue;
            return true;
        }
        Iterator iter2 = result.getLibJars().iterator();
        while (iter2.hasNext()) {
            file = (File)iter2.next();
            if (!Module.outOfDate(time, file)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public String toLongString() {
        return "Module [name=" + this.name + ", srcDirs=" + this.srcDirs + ", required=" + this.requiredModules + ", moduleJar=" + this.moduleJar + ", libJars=" + this.libJars + "]";
    }

    public Result getResult(Result.Kind kind) {
        return kind.assemble ? (kind.normal ? this.releaseAll : this.testAll) : (kind.normal ? this.release : this.test);
    }

    List srcDirs(Result result) {
        this.myResult(result);
        return this.srcDirs;
    }

    List libJars(Result result) {
        this.myResult(result);
        return this.libJars;
    }

    List classpathVariables(Result result) {
        this.myResult(result);
        return this.classpathVariables;
    }

    List exportedLibJars(Result result) {
        this.myResult(result);
        return this.exportedLibJars;
    }

    List requiredModules(Result result) {
        this.myResult(result);
        return this.requiredModules;
    }

    private void myResult(Result result) {
        if (null == result || this != result.getModule()) {
            throw new IllegalArgumentException("not my result: " + result + ": " + this);
        }
    }

    private boolean init() {
        boolean cp = this.initClasspath();
        boolean mf = this.initManifest();
        if (!cp && !mf) {
            return false;
        }
        return this.initProperties() && this.reviewInit() && this.initResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initManifest() {
        File metaInf = new File(this.moduleDir, "META-INF");
        if (!metaInf.canRead() || !metaInf.isDirectory()) {
            return false;
        }
        File file = new File(metaInf, "MANIFEST.MF");
        if (!file.exists()) {
            return false;
        }
        FileInputStream fin = null;
        Util.OSGIBundle bundle = null;
        try {
            fin = new FileInputStream(file);
            bundle = new Util.OSGIBundle(fin);
        }
        catch (IOException e) {
            boolean bl;
            try {
                this.messager.logException("IOException reading " + file, e);
                bl = false;
            }
            catch (Throwable throwable) {
                Util.closeSilently(fin);
                throw throwable;
            }
            Util.closeSilently(fin);
            return bl;
        }
        Util.closeSilently(fin);
        Util.OSGIBundle.RequiredBundle[] bundles = bundle.getRequiredBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Util.OSGIBundle.RequiredBundle required = bundles[i];
            this.update("src", "/" + required.name, required.text, false);
        }
        String[] libs = bundle.getClasspath();
        for (int i = 0; i < libs.length; ++i) {
            this.update("lib", libs[i], libs[i], false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initClasspath() {
        File file = new File(this.moduleDir, ".classpath");
        if (!file.exists()) {
            return false;
        }
        FileReader fin = null;
        try {
            String line;
            fin = new FileReader(file);
            BufferedReader reader = new BufferedReader(fin);
            XMLItem item = new XMLItem("classpathentry", new ICB());
            while (null != (line = reader.readLine())) {
                if ((line = line.trim()).startsWith("<?xml") || line.startsWith("<!--")) continue;
                item.acceptLine(line);
            }
            boolean bl = 0 < this.srcDirs.size() + this.libJars.size();
            return bl;
        }
        catch (IOException e) {
            this.messager.logException("IOException reading " + file, e);
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private boolean update(String kind, String path, String toString, boolean exported) {
        String libPath = null;
        if ("src".equals(kind)) {
            if (path.startsWith("/")) {
                String moduleName = path.substring(1);
                Module req = this.modules.getModule(moduleName);
                if (null != req) {
                    this.requiredModules.add(req);
                    return true;
                }
                this.messager.error("update unable to create required module: " + moduleName);
            } else {
                String fullPath = this.getFullPath(path);
                File srcDir = new File(fullPath);
                if (srcDir.canRead() && srcDir.isDirectory()) {
                    this.srcDirs.add(srcDir);
                    return true;
                }
                this.messager.error("not a src dir: " + srcDir);
            }
        } else if ("lib".equals(kind)) {
            libPath = path;
        } else if ("var".equals(kind)) {
            String JAVA_HOME = "JAVA_HOME/";
            if (path.startsWith("JAVA_HOME/")) {
                File f;
                path = path.substring("JAVA_HOME/".length());
                String home = System.getProperty("java.home");
                if (null != home && !(f = new File(libPath = Util.path(home, path))).exists() && home.endsWith("jre")) {
                    f = new File(home).getParentFile();
                    libPath = Util.path(f.getPath(), path);
                }
            }
            if (null == libPath) {
                this.warnVariable(path, toString);
                this.classpathVariables.add(path);
            }
        } else if ("con".equals(kind)) {
            if (path.equals("org.eclipse.ajdt.core.ASPECTJRT_CONTAINER")) {
                this.classpathVariables.add("ASPECTJRT_LIB");
            } else if (-1 == path.indexOf("JRE")) {
                this.messager.log("cannot handle con yet: " + toString);
            }
        } else if (!"out".equals(kind) && !"output".equals(kind)) {
            this.messager.log("unrecognized kind " + kind + " in " + toString);
        }
        if (null != libPath) {
            File libJar = new File(libPath);
            if (!libJar.exists()) {
                libJar = new File(this.getFullPath(libPath));
            }
            if (libJar.canRead() && libJar.isFile()) {
                this.libJars.add(libJar);
                if (exported) {
                    this.exportedLibJars.add(libJar);
                }
                return true;
            }
            this.messager.error("no such library jar " + libJar + " from " + toString);
        }
        return false;
    }

    private void warnVariable(String path, String toString) {
        String[] known = new String[]{"JRE_LIB", "ASPECTJRT_LIB", "JRE15_LIB"};
        for (int i = 0; i < known.length; ++i) {
            if (!known[i].equals(path)) continue;
            return;
        }
        this.messager.log("Module cannot handle var yet: " + toString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initProperties() {
        File file = new File(this.moduleDir, this.name + ".properties");
        if (!Util.canReadFile(file)) {
            return true;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            this.properties.load(fin);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.messager.logException("IOException reading " + file, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected boolean reviewInit() {
        try {
            ListIterator iter = this.srcDirs.listIterator();
            while (iter.hasNext()) {
                File srcDir = (File)iter.next();
                String lcname = srcDir.getName().toLowerCase();
                if (Util.JAVA5_VM || !"java5-src".equals(lcname) && !"java5-testsrc".equals(lcname)) continue;
                iter.remove();
            }
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    protected boolean initResults() {
        return true;
    }

    public String getFullPath(String path) {
        String fullPath = path.startsWith("/") ? this.modules.baseDir.getAbsolutePath() + path : this.moduleDir.getAbsolutePath() + "/" + path;
        File testFile = new File(fullPath);
        if (!testFile.exists() && (testFile = new File(path)).exists() && testFile.isAbsolute()) {
            fullPath = path;
        }
        return fullPath;
    }

    public static class XMLItem {
        static final String START_NAME = "classpathentry";
        static final String ATT_STARTED = "STARTED";
        final ICallback callback;
        final StringBuffer input = new StringBuffer();
        final String[] attributes = new String[Module.access$100().length];
        final String targetEntity;
        String entityName;
        String attributeName;

        XMLItem(String targetEntity, ICallback callback) {
            this.callback = callback;
            this.targetEntity = targetEntity;
            this.reset();
        }

        private void reset() {
            this.input.setLength(0);
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = null;
            }
            this.entityName = null;
            this.attributeName = null;
        }

        String[] tokenize(String line) {
            String DELIM = " \n\t\\<>\"=";
            StringTokenizer st = new StringTokenizer(line, " \n\t\\<>\"=", true);
            ArrayList<String> result = new ArrayList<String>();
            StringBuffer quote = new StringBuffer();
            boolean inQuote = false;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (1 == s.length() && -1 != " \n\t\\<>\"=".indexOf(s)) {
                    if ("\"".equals(s)) {
                        if (inQuote) {
                            inQuote = false;
                            quote.append("\"");
                            result.add(quote.toString());
                            quote.setLength(0);
                            continue;
                        }
                        quote.append("\"");
                        inQuote = true;
                        continue;
                    }
                    result.add(s);
                    continue;
                }
                if (inQuote) {
                    quote.append(s);
                    continue;
                }
                result.add(s);
            }
            return result.toArray(new String[0]);
        }

        public void acceptLine(String line) {
            String[] tokens = this.tokenize(line);
            for (int i = 0; i < tokens.length; ++i) {
                this.next(tokens[i]);
            }
        }

        private Properties attributesToProperties() {
            Properties result = new Properties();
            for (int i = 0; i < this.attributes.length; ++i) {
                String a = this.attributes[i];
                if (null == a) continue;
                result.setProperty(ATTS[i], a);
            }
            return result;
        }

        void errorIfNotNull(String name, String value) {
            if (null != value) {
                this.error("Did not expect " + name + ": " + value);
            }
        }

        void errorIfNull(String name, String value) {
            if (null == value) {
                this.error("expected value for " + name);
            }
        }

        boolean activeEntity() {
            return this.targetEntity.equals(this.entityName);
        }

        public void next(String s) {
            if (null == s || 0 == s.length()) {
                return;
            }
            this.input.append(s);
            s = s.trim();
            if (0 == s.length()) {
                return;
            }
            if ("<".equals(s)) {
                this.errorIfNotNull("entityName", this.entityName);
                this.errorIfNotNull("attributeName", this.attributeName);
            } else if (">".equals(s)) {
                this.errorIfNull("entityName", this.entityName);
                if ("/".equals(this.attributeName)) {
                    this.attributeName = null;
                } else {
                    this.errorIfNotNull("attributeName", this.attributeName);
                }
                if (this.activeEntity()) {
                    this.callback.end(this.attributesToProperties());
                }
                this.entityName = null;
            } else if ("=".equals(s)) {
                this.errorIfNull("entityName", this.entityName);
                this.errorIfNull("attributeName", this.attributeName);
            } else if (s.startsWith("\"")) {
                this.errorIfNull("entityName", this.entityName);
                this.errorIfNull("attributeName", this.attributeName);
                this.writeAttribute(this.attributeName, s);
                this.attributeName = null;
            } else if (null == this.entityName) {
                this.reset();
                this.entityName = s;
            } else if (null == this.attributeName) {
                this.attributeName = s;
            } else {
                System.out.println("unknown state - not value, attribute, or entity: " + s);
            }
        }

        void readAttribute(String s) {
            for (int i = 0; i < ATTS.length; ++i) {
                if (!s.equals(ATTS[i])) continue;
                this.attributes[i] = ATT_STARTED;
                break;
            }
        }

        void writeAttribute(String name, String value) {
            for (int i = 0; i < ATTS.length; ++i) {
                if (!name.equals(ATTS[i])) continue;
                if (!value.startsWith("\"") || !value.endsWith("\"")) {
                    this.error("bad attribute value: " + value);
                }
                this.attributes[i] = value = value.substring(1, value.length() - 1);
                return;
            }
        }

        void error(String s) {
            throw new Error(s + " at input " + this.input);
        }

        public static interface ICallback {
            public void end(Properties var1);
        }
    }

    class ICB
    implements XMLItem.ICallback {
        ICB() {
        }

        public void end(Properties attributes) {
            String kind = attributes.getProperty("kind");
            String path = attributes.getProperty("path");
            String exp = attributes.getProperty("exported");
            boolean exported = "true".equals(exp);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            attributes.list(new PrintStream(bout));
            Module.this.update(kind, path, bout.toString(), exported);
        }
    }
}

