/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class EnclosingMethodAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "EnclosingMethod";
    private static final int LENGTH = 4;
    private int classInfoIndex;
    private int methodInfoIndex;

    public int getClassInfoIndex() {
        return this.classInfoIndex;
    }

    public int getMethodInfoIndex() {
        return this.methodInfoIndex;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.classInfoIndex = dataInput.readUnsignedShort();
        this.methodInfoIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.classInfoIndex);
        dataOutput.writeShort(this.methodInfoIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 4;
    }

    protected void debug(String string) {
        super.debug(string + "EnclosingMethod attribute with class index " + this.classInfoIndex + " and method index " + this.methodInfoIndex);
    }
}

