#include <sys/types.h>
#include <stdio.h>
#include <db2/db_cxx.h>


#define DATABASE "access.db"

int main(void)
{
  Db *dbp;
  Dbt key, data;
  int ret, t_ret, openBad;
  int getBad, putBad, delBad;
  int result = 0;
  
  // create a dbp

  openBad = Db::open(DATABASE, DB_BTREE, DB_CREATE, 0600, NULL, NULL, &dbp);

  if(! openBad) 
    {
      //      // open (creating if necessary) the file name DATABASE
      //      ret = dbp->open(dbp, DATABASE, NULL, DB_BTREE, DB_CREATE, 0664);
      
      // set key to "fruit"
      key.set_data((void*) "fruit");
      key.set_size(sizeof("fruit"));
      
      // set data to "apple"
      data.set_data((void*) "apple");
      data.set_size(sizeof("apple"));
      
      // try to put it in the database

      putBad = dbp->put(NULL, &key, &data, 0);

      if (! putBad)
	printf("db: %s: key stored.\n", (char*) key.get_data());
      else 
	{
	  printf("DB->put\n");
	  goto err;
	}

      // try to get it back

      getBad = dbp->get(NULL, &key, &data, 0);

      if (! getBad)
	printf
	  (
	    "db: %s: key retrieved: data was %s.\n",
	    (char *)key.get_data(), 
	    (char *)data.get_data()
	  );
      else 
	{
	  printf("DB->get\n");
	  goto err;
	}

      // remove the key

      delBad = dbp->del(NULL, &key, 0);

      if (! delBad)
	printf("db: %s: key was deleted.\n", (char *)key.get_data());
      else 
	{
	  printf("DB->del\n");
	  goto err;
	}
      
    err: 
      t_ret = dbp->close(0);

      if (t_ret != 0 && ret == 0)
	result = t_ret; 
    }
  else
    {
      fprintf(stderr, "db_create: %s\n", "couldn't open");
      result = 1;
    }
  
  return result;
}
