/*
 *  acm : an aerial combat simulator for X
 *  Module implementing the ADF indicator.
 *
 *  Copyright (C) 2007  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _adf_h
#define _adf_h

#include "pm.h"

#ifdef adf_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Allocates and enables the ADF for this particular viewer.
 * If u->adf is NULL, instantiate with a pointer to internal data.
 */
EXTERN void adf_enable(viewer *u);

/**
 * Disables and releases the ADF for this particular viewer, leaving u->adf set
 * to NULL, or does nothing if already NULL.
 */
EXTERN void adf_disable(viewer *u);

/**
 * Increments station frequency. ADF channels ranges from 200 up to 415 KHz.
 * Implements an auto-repeat detection feature that speeds-up this otherwise
 * very slow interface. If the auto-repeat gets detected, the increment actually
 * applied gets multiplied by a factor that ranges from 2 up to 20.
 * @param u
 * @param step Either +1 or -1.
 */
EXTERN void adf_frq_inc(viewer *u, int step);

/**
 * Increment heading pointer by 'step' DEG.
 * Implements an auto-repeat detection feature that speeds-up this otherwise
 * very slow interface. If the auto-repeat gets detected, the increment actually
 * applied gets multiplied by a factor that ranges from 2 up to 20.
 * @param u
 * @param step Either +1 or -1.
 */
EXTERN void adf_hdg_inc(viewer *u, int step);

/**
 * Draws the ADF instrument in the TEWS panel. If no ADF active in this viewer,
 * does nothing.
 * @param u
 */
EXTERN void adf_panel_draw(viewer * u);

/**
 * Draws the ADF compass card and OBS pointer. If no ADF active in this viewer,
 * does nothing.
 * @param u
 */
EXTERN void adf_draw(viewer * u);

#undef EXTERN
#endif
