#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kathy Rain series:
# - Kathy Rain
# - Kathy Rain 2: Soothsayer
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250531.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_ORIGINAL='kathy-rain-1'
GAME_NAME_ORIGINAL='Kathy Rain'

GAME_ID_SOOTHSAYER='kathy-rain-2'
GAME_NAME_SOOTHSAYER='Kathy Rain 2: Soothsayer'

ARCHIVE_BASE_ORIGINAL_0_NAME='kathy_rain_director_s_cut_v_1_0_3_5225_53868.sh'
ARCHIVE_BASE_ORIGINAL_0_MD5='0bcbe5aa3508431c685b8ecd1617d560'
ARCHIVE_BASE_ORIGINAL_0_SIZE='842486'
ARCHIVE_BASE_ORIGINAL_0_VERSION='1.0.3.5225-gog53868'
ARCHIVE_BASE_ORIGINAL_0_URL='https://www.gog.com/game/kathy_rain_directors_cut'

ARCHIVE_BASE_SOOTHSAYER_0_NAME='kathy_rain_2_soothsayer_4089_82456.sh'
ARCHIVE_BASE_SOOTHSAYER_0_MD5='886b73b2d10088df60ed5102adb32a56'
ARCHIVE_BASE_SOOTHSAYER_0_SIZE='3224799'
ARCHIVE_BASE_SOOTHSAYER_0_VERSION='1.0.3.4089-gog82456'
ARCHIVE_BASE_SOOTHSAYER_0_URL='https://www.gog.com/game/kathy_rain_2_soothsayer'

UNITY3D_NAME_ORIGINAL='KathyRainDirectorsCut'
UNITY3D_NAME_SOOTHSAYER='KathyRain2'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME0_BIN_FILES_ORIGINAL="
${UNITY3D_NAME_ORIGINAL}.x64"
CONTENT_GAME0_BIN_FILES_SOOTHSAYER="
${UNITY3D_NAME_SOOTHSAYER}.x64"

## These games use a non-standard binary name.
APP_MAIN_EXE_ORIGINAL="${UNITY3D_NAME_ORIGINAL}.x64"
APP_MAIN_EXE_SOOTHSAYER="${UNITY3D_NAME_SOOTHSAYER}.x64"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'
## Easier upgrades from pre-20250531.1 packages.
PKG_BIN_PROVIDES_ORIGINAL="${PKG_BIN_PROVIDES_ORIGINAL:-}
kathy-rain"

PKG_DATA_ID_ORIGINAL="${GAME_ID_ORIGINAL}-data"
PKG_DATA_ID_SOOTHSAYER="${GAME_ID_SOOTHSAYER}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20250531.1 packages.
PKG_DATA_PROVIDES_ORIGINAL="${PKG_DATA_PROVIDES_ORIGINAL:-}
kathy-rain-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent inclusion of shipped Steam library.
	rm --recursive "$(unity3d_name)_Data/Plugins"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
