#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Terra Nil
###

script_version=20231225.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='terra-nil'
GAME_NAME='Terra Nil'

GAME_ID_DEMO='terra-nil-demo'
GAME_NAME_DEMO='Terra Nil Prototype'

ARCHIVE_BASE_0_NAME='terra_nil_1_04_linux_68121.sh'
ARCHIVE_BASE_0_MD5='d71c5f1da5d78d3a61c048240c2ecdb5'
ARCHIVE_BASE_0_SIZE='2092001'
ARCHIVE_BASE_0_VERSION='1.04-gog68121'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/terra_nil'

ARCHIVE_BASE_DEMO_0_NAME='Terra Nil 0.41 Linux.zip'
ARCHIVE_BASE_DEMO_0_MD5='0179d82ebf76eed15c519d419ecdcab1'
ARCHIVE_BASE_DEMO_0_SIZE='167423'
ARCHIVE_BASE_DEMO_0_VERSION='0.41-itch.2020.09.03'
ARCHIVE_BASE_DEMO_0_URL='https://vfqd.itch.io/terra-nil'

UNITY3D_NAME='Terra Nil'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_PATH_DEFAULT_DEMO='.'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Full game only - Drop duplicated files.
	case "$(current_archive)" in
		('ARCHIVE_BASE_DEMO_'*) ;;
		(*)
			find . -name 'PaxHeader' -exec rm --recursive {} +
		;;
	esac

	## Full game only - Do not include the shipped Steam libraries.
	case "$(current_archive)" in
		('ARCHIVE_BASE_DEMO_'*) ;;
		(*)
			rm --recursive "$(unity3d_name)_Data/Plugins"
		;;
	esac
)

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
