#!/bin/bash
CUR_PATH=$(dirname  $(realpath $0))
source "$CUR_PATH/../test_utils/test_utils.sh"

app_name="memory"

APP_DIR="."
[ -n "$BUILD_DIR" ] && APP_DIR="$BUILD_DIR"
APP_PATH="${APP_DIR}/$app_name"
TRACE_DIRNAME="${APP_PATH}_trace"
trace_filename="${TRACE_DIRNAME}/eztrace_log.otf2"

EZTRACE_TEST_OPTION="$EZTRACE_TEST_OPTION -o ${TRACE_DIRNAME}"
[ -n "$EZTRACE_PATH" ] || EZTRACE_PATH=eztrace

run_and_check_command "$EZTRACE_PATH" $EZTRACE_TEST_OPTION -t "memory" "${APP_PATH}"

trace_check_integrity "$trace_filename" || exit 1
trace_check_enter_leave_parity  "$trace_filename" 

trace_check_nb_enter "$trace_filename" "realloc" 10
trace_check_nb_leave "$trace_filename" "realloc" 10

trace_check_nb_enter "$trace_filename" "calloc" 10
trace_check_nb_leave "$trace_filename" "calloc" 10

trace_check_nb_enter "$trace_filename" "malloc" 30
trace_check_nb_leave "$trace_filename" "malloc" 30

echo PASS: $nb_pass, FAILED:$nb_failed, TOTAL: $nb_test

exit $nb_failed
