/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright © CNRS, INRIA, Université Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#define _GNU_SOURCE 1
#define _REENTRANT

#include <unistd.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <dlfcn.h>
#include <string.h>

#include "mpi.h"
#include "mpi_eztrace.h"
#include "mpi_ev_codes.h"
#include "eztrace.h"

#ifdef USE_MPI3
static void MPI_Iallgatherv_prolog (CONST void *sendbuf __attribute__((unused)),
				    int sendcount __attribute__((unused)),
				    MPI_Datatype sendtype __attribute__((unused)),
				    void *recvbuf __attribute__((unused)),
				    CONST int *recvcounts __attribute__((unused)),
				    CONST int *displs __attribute__((unused)),
				    MPI_Datatype recvtype __attribute__((unused)),
				    MPI_Comm comm __attribute__((unused)),
				    MPI_Request *r)
{
 int rank = -1;
  int size = -1;
  libMPI_Comm_size(comm, &size);
  libMPI_Comm_rank(comm, &rank);

  EZTRACE_EVENT_PACKED_4(EZTRACE_MPI_IALLGATHERV, (app_ptr)comm, size, rank, (app_ptr)r);
}

static int MPI_Iallgatherv_core (CONST void *sendbuf __attribute__((unused)),
				 int sendcount,
				 MPI_Datatype sendtype,
				 void *recvbuf __attribute__((unused)),
				 CONST int *recvcounts __attribute__((unused)),
				 CONST int *displs __attribute__((unused)),
				 MPI_Datatype recvtype,
				 MPI_Comm comm,
				 MPI_Request *r)
{
  return libMPI_Iallgatherv (sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm, r);
}

static void MPI_Iallgatherv_epilog (CONST void *sendbuf __attribute__((unused)),
				    int sendcount __attribute__((unused)),
				    MPI_Datatype sendtype __attribute__((unused)),
				    void *recvbuf __attribute__((unused)),
				    CONST int *recvcounts __attribute__((unused)),
				    CONST int *displs __attribute__((unused)),
				    MPI_Datatype recvtype __attribute__((unused)),
				    MPI_Comm comm __attribute__((unused)),
				    MPI_Request *r)
{
  EZTRACE_EVENT_PACKED_1(EZTRACE_MPI_STOP_IALLGATHERV, (app_ptr)r);
}


int MPI_Iallgatherv (CONST void *sendbuf, int sendcount, MPI_Datatype sendtype,
		    void *recvbuf, CONST int *recvcounts, CONST int *displs,
		     MPI_Datatype recvtype, MPI_Comm comm, MPI_Request *r)
{
  FUNCTION_ENTRY;

  MPI_Iallgatherv_prolog (sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm, r);
  int ret = MPI_Iallgatherv_core (sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm, r);
  MPI_Iallgatherv_epilog (sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm, r);
  return ret;
}


void mpif_iallgatherv_(void *sbuf, int *scount, MPI_Fint *sd,
		      void *rbuf, int *rcount, int *displs,
		       MPI_Fint *rd, MPI_Fint *c, MPI_Fint *r, int *error)
{
  FUNCTION_ENTRY;
  MPI_Datatype c_stype = MPI_Type_f2c(*sd);
  MPI_Datatype c_rtype = MPI_Type_f2c(*rd);
  MPI_Comm c_comm = MPI_Comm_f2c(*c);
  MPI_Request c_req = MPI_Request_f2c(*r);

  MPI_Iallgatherv_prolog(sbuf, *scount, c_stype, rbuf, rcount, displs, c_rtype, c_comm, r);
  *error = MPI_Iallgatherv_core(sbuf, *scount, c_stype, rbuf, rcount, displs, c_rtype, c_comm, &c_req);
  *r = MPI_Request_c2f(c_req);
  MPI_Iallgatherv_epilog(sbuf, *scount, c_stype, rbuf, rcount, displs, c_rtype, c_comm, r);
}
#endif
