/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.OperationInfo;

public class XFireProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog((Class)XFireProxy.class);
    private Client client;

    XFireProxy(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        String methodName = method.getName();
        Class[] parameterTypes = method.getParameterTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method [" + methodName + "] " + (args == null ? "" : Arrays.asList(args).toString())));
        }
        if ((result = this.handleCanonicalMethods(methodName, parameterTypes, args)) == null) {
            result = this.handleRequest(method, args);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result [" + String.valueOf(result) + "]"));
        }
        return result;
    }

    private Object handleRequest(Method m, Object[] args) throws Exception {
        OperationInfo op = this.client.getService().getServiceInfo().getOperation(m);
        if (op == null) {
            op = this.client.getService().getServiceInfo().getOperation(m.getName());
        }
        try {
            Object[] response = this.client.invoke(op, args);
            if (response != null && response.length > 0) {
                return response[0];
            }
            return null;
        }
        catch (Exception e) {
            if (this.isDeclared(e, m)) {
                throw e;
            }
            throw new XFireRuntimeException("Could not invoke service.", e);
        }
    }

    private boolean isDeclared(Exception e, Method m) {
        Class<?>[] types = m.getExceptionTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    private Object handleCanonicalMethods(String methodName, Class[] params, Object[] args) {
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object other = args[0];
            if (other == null || !Proxy.isProxyClass(other.getClass()) || !(Proxy.getInvocationHandler(other) instanceof XFireProxy)) {
                return Boolean.FALSE;
            }
            XFireProxy otherClient = (XFireProxy)Proxy.getInvocationHandler(other);
            return new Boolean(otherClient == this);
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this.hashCode());
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "XFireProxy[" + this.client.getUrl() + "]";
        }
        return null;
    }
}

