Transitioning to a New Upstream Version in a Nutshell
=====================================================

TL;DR: We're more or less using the `gbp import-orig` workflow.

Prerequisites
-------------

* Having the zsh upstream git repo configured as a git remote named
  `upstream-repo`. If that's not the case, `dpt import-orig` will
  create that remote automatically. You can also use `dpt
  upstream-repo` to create that git remote semi-automatically. Both
  commands take the upstream git repo URL from
  `debian/upstream/metadata`.

* Having the package `git-buildpackage` installed for the `gbp`
  command.

* Having the package `devscripts` installed for the `uscan` command
  (used by `gbp` and `dpt`).

* Optionally: Having the package `pkg-perl-tools` installed for the
  `dpt` command, which partially is a convenience wrapper around `gbp`.

Workflow
--------

When upstream releases a new version, we should follow these steps:

### Donwloading, Importing and Merging the New Upstream Tar-Ball

... and verifying its PGP signature.

    % gbp import-orig --uscan

or

    % dpt import-orig

(`dpt import-orig` implies `--uscan`, but will also call `dch`, so
you'll need to amend that instead of creating it in the next step. Or
undo it)

### Create a debian/changelog entry for the new upstream release

Use `gbp dch` as a base and then remove all lines which are not
debian-specific and which do not relate to a Debian bug report. Add
Debian bug report references (`Closes: #nnnnnn`) as necessary.

Use the tagged upstream commit and the merge commit where the upstream
release was merged into the debian branch as referred commit ids.

Example:

    * [9dbde9e,bf8b7f7] Import new upstream release candidate X.Y-test-Z
      + [dc2bfeee] Have V07pcre fail if PCRE was enabled by configure
        (config.modules) but failed to load for any reason. (Closes: #909114)

    [ Axel Beckert ]
    * [abcd1234] Some debian-specific change generated by gbp dch from
      the git commit message.
      
Commit it as follows:

    % git add debian/changelog
    % git commit -m "Update debian/changelog for new upstream release" -m "Gbp-Dch: Ignore"

### Remove all quilt patches which are applied upstream

All patches applied (or fixed otherwise) upstream should be removed
from `debian/patches` directory and the `debian/patches/series` file.

Example:

    % quilt push -a
    % quilt pop -a
    % git rm debian/patches/cherry*
    % $EDITOR debian/patches/series
    % git add debian/patches
    % quilt push -a
    % quilt pop -a
    % git commit -m "Remove all patches applied upstream"

### Update `debian/NEWS`

Review the upstream `NEWS` file and the list of compatibilities in the upstream
`README` file (starts at line 33) and add them to `debian/NEWS`:

    % less NEWS
    % less +33 README
    % dch --news
    % git commit -m "Add NEWS based on incompatibilities listed in upstream's README." -m "Gbp-Dch: Ignore"

### After a build, restore what the clean target removed

Use any of these three commands:

    % debian/rules restore-cleaned-files
    % make -f debian/rules restore-cleaned-files
    % git status --porcelain | egrep '^ D ' | cut -c4- | xargs --no-run-if-empty git checkout
