YUI.add("yuidoc-meta", function(Y) {
   Y.YUIDoc = { meta: {
    "classes": [
        "Anim",
        "App",
        "App.Base",
        "App.Transitions",
        "App.TransitionsNative",
        "AreaSeries",
        "AreaSplineSeries",
        "Array",
        "ArrayList",
        "ArraySort",
        "AsyncQueue",
        "Attribute",
        "AttributeCore",
        "AttributeEvents",
        "AttributeExtras",
        "AttributeLite",
        "AutoComplete",
        "AutoCompleteBase",
        "AutoCompleteFilters",
        "AutoCompleteHighlighters",
        "AutoCompleteList",
        "Axis",
        "AxisType",
        "BarSeries",
        "Base",
        "BaseCore",
        "BottomAxisLayout",
        "Button",
        "ButtonCore",
        "ButtonGroup",
        "ButtonPlugin",
        "Cache",
        "CacheOffline",
        "Calendar",
        "CalendarBase",
        "CanvasCircle",
        "CanvasDrawing",
        "CanvasEllipse",
        "CanvasGraphic",
        "CanvasPath",
        "CanvasPieSlice",
        "CanvasRect",
        "CanvasShape",
        "CartesianChart",
        "CartesianSeries",
        "CategoryAxis",
        "Chart",
        "ChartBase",
        "ChartLegend",
        "Circle",
        "ClassNameManager",
        "ClickableRail",
        "ColumnSeries",
        "ComboSeries",
        "ComboSplineSeries",
        "Console",
        "Controller",
        "Cookie",
        "CurveUtil",
        "CustomEvent",
        "DD.DDM",
        "DD.Delegate",
        "DD.Drag",
        "DD.Drop",
        "DD.Scroll",
        "DOM",
        "DOMEventFacade",
        "DataSchema.Array",
        "DataSchema.Base",
        "DataSchema.JSON",
        "DataSchema.Text",
        "DataSchema.XML",
        "DataSource.Function",
        "DataSource.Get",
        "DataSource.IO",
        "DataSource.Local",
        "DataSourceArraySchema",
        "DataSourceCache",
        "DataSourceCacheExtension",
        "DataSourceJSONSchema",
        "DataSourceTextSchema",
        "DataSourceXMLSchema",
        "DataTable",
        "DataTable.Base",
        "DataTable.BodyView",
        "DataTable.ColumnWidths",
        "DataTable.Core",
        "DataTable.HeaderView",
        "DataTable.Message",
        "DataTable.Mutable",
        "DataTable.Scrollable",
        "DataTable.Sortable",
        "DataType.Date",
        "DataType.Date.Locale",
        "DataType.Number",
        "DataType.XML",
        "Dial",
        "Do",
        "Do.AlterArgs",
        "Do.AlterReturn",
        "Do.Error",
        "Do.Halt",
        "Do.Method",
        "Do.Prevent",
        "Drawing",
        "Easing",
        "EditorBase",
        "EditorSelection",
        "Ellipse",
        "EllipseGroup",
        "Escape",
        "Event",
        "EventFacade",
        "EventHandle",
        "EventTarget",
        "ExecCommand",
        "Features",
        "File",
        "FileFlash",
        "FileHTML5",
        "Fills",
        "Frame",
        "Get",
        "Get.Transaction",
        "GetNodeJS",
        "Graph",
        "Graphic",
        "GraphicBase",
        "Gridlines",
        "GroupCircle",
        "GroupDiamond",
        "GroupRect",
        "Handlebars",
        "Highlight",
        "Histogram",
        "HistoryBase",
        "HistoryHTML5",
        "HistoryHash",
        "HorizontalLegendLayout",
        "IO",
        "ImgLoadGroup",
        "ImgLoadImgObj",
        "Intl",
        "JSON",
        "JSONPRequest",
        "Lang",
        "LeftAxisLayout",
        "LineSeries",
        "Lines",
        "Loader",
        "MarkerSeries",
        "Matrix",
        "Model",
        "ModelList",
        "Node",
        "NodeList",
        "NumericAxis",
        "Object",
        "Overlay",
        "Panel",
        "Parallel",
        "Path",
        "PieChart",
        "PieSeries",
        "Pjax",
        "PjaxBase",
        "Plots",
        "Plugin.Align",
        "Plugin.AutoComplete",
        "Plugin.Base",
        "Plugin.Cache",
        "Plugin.CalendarNavigator",
        "Plugin.ConsoleFilters",
        "Plugin.CreateLinkBase",
        "Plugin.DDConstrained",
        "Plugin.DDNodeScroll",
        "Plugin.DDProxy",
        "Plugin.DDWindowScroll",
        "Plugin.DataTableDataSource",
        "Plugin.Drag",
        "Plugin.Drop",
        "Plugin.EditorBR",
        "Plugin.EditorBidi",
        "Plugin.EditorLists",
        "Plugin.EditorPara",
        "Plugin.EditorParaBase",
        "Plugin.EditorParaIE",
        "Plugin.EditorTab",
        "Plugin.ExecCommand",
        "Plugin.Flick",
        "Plugin.Host",
        "Plugin.NodeFX",
        "Plugin.Pjax",
        "Plugin.Resize",
        "Plugin.ResizeConstrained",
        "Plugin.ResizeProxy",
        "Plugin.ScrollViewList",
        "Plugin.ScrollViewPaginator",
        "Plugin.ScrollViewScrollbars",
        "Plugin.Shim",
        "Plugin.SortScroll",
        "Plugin.WidgetAnim",
        "Pollable",
        "Profiler",
        "QueryString",
        "Queue",
        "Record",
        "Recordset",
        "RecordsetFilter",
        "RecordsetIndexer",
        "RecordsetSort",
        "Rect",
        "Renderer",
        "Resize",
        "RightAxisLayout",
        "Router",
        "SVGCircle",
        "SVGDrawing",
        "SVGEllipse",
        "SVGGraphic",
        "SVGPath",
        "SVGPieSlice",
        "SVGRect",
        "SVGShape",
        "SWF",
        "SWFDetect",
        "ScrollView",
        "Selector",
        "Shape",
        "ShapeGroup",
        "Slider",
        "SliderBase",
        "SliderValueRange",
        "Sortable",
        "SplineSeries",
        "StackedAreaSeries",
        "StackedAreaSplineSeries",
        "StackedAxis",
        "StackedBarSeries",
        "StackedColumnSeries",
        "StackedComboSeries",
        "StackedComboSplineSeries",
        "StackedLineSeries",
        "StackedMarkerSeries",
        "StackedSplineSeries",
        "StackingUtil",
        "State",
        "StyleSheet",
        "Subscriber",
        "SynthRegistry",
        "SyntheticEvent",
        "SyntheticEvent.Notifier",
        "Tab",
        "TabView",
        "Test.ArrayAssert",
        "Test.Assert",
        "Test.AssertionError",
        "Test.ComparisonFailure",
        "Test.Console",
        "Test.CoverageFormat",
        "Test.DateAssert",
        "Test.EventTarget",
        "Test.Mock",
        "Test.Mock.Value",
        "Test.ObjectAssert",
        "Test.Reporter",
        "Test.Results",
        "Test.Runner",
        "Test.ShouldError",
        "Test.ShouldFail",
        "Test.TestCase",
        "Test.TestFormat",
        "Test.TestNode",
        "Test.TestRunner",
        "Test.TestSuite",
        "Test.UnexpectedError",
        "Test.UnexpectedValue",
        "Test.Wait",
        "Text.AccentFold",
        "Text.WordBreak",
        "TimeAxis",
        "ToggleButton",
        "TopAxisLayout",
        "Transition",
        "UA",
        "Uploader",
        "Uploader.Queue",
        "UploaderFlash",
        "UploaderHTML5",
        "VMLCircle",
        "VMLDrawing",
        "VMLEllipse",
        "VMLGraphic",
        "VMLPath",
        "VMLPieSlice",
        "VMLRect",
        "VMLShape",
        "ValueChange",
        "VerticalLegendLayout",
        "View",
        "View.NodeMap",
        "Widget",
        "WidgetAutohide",
        "WidgetButtons",
        "WidgetChild",
        "WidgetModality",
        "WidgetParent",
        "WidgetPosition",
        "WidgetPositionAlign",
        "WidgetPositionConstrain",
        "WidgetStack",
        "WidgetStdMod",
        "YQL",
        "YQLRequest",
        "YUI",
        "YUI~substitute",
        "config",
        "plugin.NodeFocusManager",
        "plugin.NodeMenuNav"
    ],
    "modules": [
        "align-plugin",
        "anim",
        "anim-base",
        "anim-color",
        "anim-curve",
        "anim-easing",
        "anim-node-plugin",
        "anim-scroll",
        "anim-shape-transform",
        "anim-xy",
        "app",
        "app-base",
        "app-transitions",
        "app-transitions-native",
        "array-extras",
        "array-invoke",
        "arraylist",
        "arraylist-add",
        "arraylist-filter",
        "arraysort",
        "async-queue",
        "attribute",
        "attribute-base",
        "attribute-complex",
        "attribute-core",
        "attribute-events",
        "attribute-extras",
        "autocomplete",
        "autocomplete-base",
        "autocomplete-filters",
        "autocomplete-filters-accentfold",
        "autocomplete-highlighters",
        "autocomplete-highlighters-accentfold",
        "autocomplete-list",
        "autocomplete-list-keys",
        "autocomplete-plugin",
        "autocomplete-sources",
        "base",
        "base-base",
        "base-build",
        "base-core",
        "base-pluginhost",
        "button",
        "button-core",
        "button-group",
        "button-plugin",
        "cache",
        "cache-base",
        "cache-offline",
        "cache-plugin",
        "calendar",
        "calendar-base",
        "calendarnavigator",
        "charts",
        "charts-legend",
        "classnamemanager",
        "clickable-rail",
        "collection",
        "console",
        "console-filters",
        "cookie",
        "createlink-base",
        "dataschema",
        "dataschema-array",
        "dataschema-base",
        "dataschema-json",
        "dataschema-text",
        "dataschema-xml",
        "datasource",
        "datasource-arrayschema",
        "datasource-cache",
        "datasource-function",
        "datasource-get",
        "datasource-io",
        "datasource-jsonschema",
        "datasource-local",
        "datasource-polling",
        "datasource-textschema",
        "datasource-xmlschema",
        "datatable",
        "datatable-base",
        "datatable-base-deprecated",
        "datatable-body",
        "datatable-column-widths",
        "datatable-core",
        "datatable-datasource",
        "datatable-datasource-deprecated",
        "datatable-deprecated",
        "datatable-head",
        "datatable-message",
        "datatable-mutable",
        "datatable-scroll",
        "datatable-scroll-deprecated",
        "datatable-sort",
        "datatable-sort-deprecated",
        "datatype",
        "datatype-date",
        "datatype-date-format",
        "datatype-date-math",
        "datatype-date-parse",
        "datatype-number",
        "datatype-number-format",
        "datatype-number-parse",
        "datatype-xml",
        "datatype-xml-format",
        "datatype-xml-parse",
        "dd",
        "dd-constrain",
        "dd-ddm",
        "dd-ddm-base",
        "dd-ddm-drop",
        "dd-delegate",
        "dd-drag",
        "dd-drop",
        "dd-drop-plugin",
        "dd-plugin",
        "dd-proxy",
        "dd-scroll",
        "dial",
        "dom",
        "dom-base",
        "dom-screen",
        "dom-style",
        "dump",
        "editor",
        "editor-base",
        "editor-bidi",
        "editor-br",
        "editor-lists",
        "editor-para",
        "editor-para-base",
        "editor-para-ie",
        "editor-tab",
        "escape",
        "event",
        "event-base",
        "event-contextmenu",
        "event-custom",
        "event-custom-base",
        "event-custom-complex",
        "event-delegate",
        "event-flick",
        "event-focus",
        "event-gestures",
        "event-hover",
        "event-key",
        "event-mouseenter",
        "event-mousewheel",
        "event-move",
        "event-outside",
        "event-resize",
        "event-simulate",
        "event-synthetic",
        "event-touch",
        "event-valuechange",
        "exec-command",
        "features",
        "file",
        "file-flash",
        "file-html5",
        "frame",
        "get",
        "get-nodejs",
        "graphics",
        "handlebars",
        "handlebars-base",
        "handlebars-compiler",
        "highlight",
        "highlight-accentfold",
        "highlight-base",
        "history",
        "history-base",
        "history-hash",
        "history-hash-ie",
        "history-html5",
        "imageloader",
        "intl",
        "io",
        "io-base",
        "io-form",
        "io-queue",
        "io-upload-iframe",
        "io-xdr",
        "json",
        "json-parse",
        "json-stringify",
        "jsonp",
        "jsonp-url",
        "loader",
        "loader-base",
        "matrix",
        "model",
        "model-list",
        "node",
        "node-base",
        "node-core",
        "node-data",
        "node-deprecated",
        "node-event-delegate",
        "node-event-html5",
        "node-event-simulate",
        "node-flick",
        "node-focusmanager",
        "node-load",
        "node-menunav",
        "node-pluginhost",
        "node-screen",
        "node-style",
        "oop",
        "overlay",
        "panel",
        "parallel",
        "pjax",
        "pjax-base",
        "pjax-plugin",
        "plugin",
        "pluginhost",
        "pluginhost-base",
        "pluginhost-config",
        "profiler",
        "querystring",
        "querystring-parse",
        "querystring-parse-simple",
        "querystring-stringify",
        "querystring-stringify-simple",
        "queue-promote",
        "range-slider",
        "recordset",
        "recordset-base",
        "recordset-filter",
        "recordset-indexer",
        "recordset-sort",
        "resize",
        "resize-contrain",
        "resize-plugin",
        "resize-proxy",
        "rollup",
        "router",
        "scrollview",
        "scrollview-base",
        "scrollview-base-ie",
        "scrollview-list",
        "scrollview-paginator",
        "scrollview-scrollbars",
        "selection",
        "selector-css2",
        "selector-css3",
        "selector-native",
        "shim-plugin",
        "slider",
        "slider-base",
        "slider-value-range",
        "sortable",
        "sortable-scroll",
        "stylesheet",
        "substitute",
        "swf",
        "swfdetect",
        "tabview",
        "test",
        "test-console",
        "text",
        "text-accentfold",
        "text-wordbreak",
        "transition",
        "uploader",
        "uploader-deprecated",
        "uploader-flash",
        "uploader-html5",
        "uploader-queue",
        "view",
        "view-node-map",
        "widget",
        "widget-anim",
        "widget-autohide",
        "widget-base",
        "widget-base-ie",
        "widget-buttons",
        "widget-child",
        "widget-htmlparser",
        "widget-locale",
        "widget-modality",
        "widget-parent",
        "widget-position",
        "widget-position-align",
        "widget-position-constrain",
        "widget-skin",
        "widget-stack",
        "widget-stdmod",
        "widget-uievents",
        "yql",
        "yui",
        "yui-base",
        "yui-later",
        "yui-log",
        "yui-throttle",
        "yui3"
    ],
    "allModules": [
        {
            "displayName": "align-plugin",
            "name": "align-plugin",
            "description": "Provides advanced positioning support for Node via a Plugin\nfor centering and alignment."
        },
        {
            "displayName": "anim",
            "name": "anim",
            "description": "The Animation Utility provides an API for creating advanced transitions."
        },
        {
            "displayName": "anim-base",
            "name": "anim-base",
            "description": "Provides the base Anim class, for animating numeric properties."
        },
        {
            "displayName": "anim-color",
            "name": "anim-color",
            "description": "Adds support for color properties in <code>to</code>\nand <code>from</code> attributes."
        },
        {
            "displayName": "anim-curve",
            "name": "anim-curve",
            "description": "Adds support for the <code>curve</code> property for the <code>to</code> \nattribute.  A curve is zero or more control points and an end point."
        },
        {
            "displayName": "anim-easing",
            "name": "anim-easing",
            "description": "The easing module provides methods for customizing\nhow an animation behaves during each run."
        },
        {
            "displayName": "anim-node-plugin",
            "name": "anim-node-plugin",
            "description": "Binds an Anim instance to a Node instance"
        },
        {
            "displayName": "anim-scroll",
            "name": "anim-scroll",
            "description": "Adds support for the <code>scroll</code> property in <code>to</code>\nand <code>from</code> attributes."
        },
        {
            "displayName": "anim-shape-transform",
            "name": "anim-shape-transform",
            "description": "Adds support for the <code>transform</code> attribute of <code>Graphic</code>\n<code>Shape</code> instances."
        },
        {
            "displayName": "anim-xy",
            "name": "anim-xy",
            "description": "Adds support for the <code>xy</code> property in <code>from</code> and \n<code>to</code> attributes."
        },
        {
            "displayName": "app",
            "name": "app",
            "description": "The App Framework provides simple MVC-like building blocks (models, model lists,\nviews, and URL-based routing) for writing single-page JavaScript applications."
        },
        {
            "displayName": "app-base",
            "name": "app-base",
            "description": "Provides a top-level application component which manages navigation and views."
        },
        {
            "displayName": "app-transitions",
            "name": "app-transitions",
            "description": "Provides view transitions for `Y.App` in browsers which support native CSS3\ntransitions."
        },
        {
            "displayName": "app-transitions-native",
            "name": "app-transitions-native",
            "description": "Provides the implementation of view transitions for `Y.App.Transitions` in\nbrowsers which support native CSS3 transitions."
        },
        {
            "displayName": "array-extras",
            "name": "array-extras",
            "description": "Adds additional utility methods to the `Y.Array` class."
        },
        {
            "displayName": "array-invoke",
            "name": "array-invoke"
        },
        {
            "displayName": "arraylist",
            "name": "arraylist",
            "description": "Collection utilities beyond what is provided in the YUI core"
        },
        {
            "displayName": "arraylist-add",
            "name": "arraylist-add",
            "description": "Collection utilities beyond what is provided in the YUI core"
        },
        {
            "displayName": "arraylist-filter",
            "name": "arraylist-filter",
            "description": "Collection utilities beyond what is provided in the YUI core"
        },
        {
            "displayName": "arraysort",
            "name": "arraysort",
            "description": "Provides a case-insenstive comparator which can be used for array sorting."
        },
        {
            "displayName": "async-queue",
            "name": "async-queue",
            "description": "<p>AsyncQueue allows you create a chain of function callbacks executed\nvia setTimeout (or synchronously) that are guaranteed to run in order.\nItems in the queue can be promoted or removed.  Start or resume the\nexecution chain with run().  pause() to temporarily delay execution, or\nstop() to halt and clear the queue.</p>"
        },
        {
            "displayName": "attribute",
            "name": "attribute",
            "description": "The attribute module provides an augmentable Attribute implementation, which \nadds configurable attributes and attribute change events to the class being \naugmented. It also provides a State class, which is used internally by Attribute,\nbut can also be used independently to provide a name/property/value data structure to\nstore state."
        },
        {
            "displayName": "attribute-base",
            "name": "attribute-base",
            "description": "The attribute-base submodule provides core attribute handling support, with everything\naside from complex attribute handling in the provider's constructor."
        },
        {
            "displayName": "attribute-complex",
            "name": "attribute-complex",
            "description": "Adds support for attribute providers to handle complex attributes in the constructor"
        },
        {
            "displayName": "attribute-core",
            "name": "attribute-core",
            "description": "The attribute-core submodule provides the lightest level of attribute handling support \nwithout Attribute change events, or lesser used methods such as reset(), modifyAttrs(),\nand removeAttr()."
        },
        {
            "displayName": "attribute-events",
            "name": "attribute-events",
            "description": "The attribute-events submodule provides augmentable attribute change event support \nfor AttributeCore based implementations."
        },
        {
            "displayName": "attribute-extras",
            "name": "attribute-extras",
            "description": "The attribute-extras submodule provides less commonly used attribute methods, and can \nbe augmented/mixed into an implemention which used attribute-core."
        },
        {
            "displayName": "autocomplete",
            "name": "autocomplete",
            "description": "Provides automatic input completion or suggestions for text input fields and\ntextareas."
        },
        {
            "displayName": "autocomplete-base",
            "name": "autocomplete-base",
            "description": "`Y.Base` extension that provides core autocomplete logic (but no UI\nimplementation) for a text input field or textarea. Must be mixed into a\n`Y.Base`-derived class to be useful."
        },
        {
            "displayName": "autocomplete-filters",
            "name": "autocomplete-filters",
            "description": "Provides pre-built result matching filters for AutoComplete."
        },
        {
            "displayName": "autocomplete-filters-accentfold",
            "name": "autocomplete-filters-accentfold",
            "description": "Provides pre-built accent-folding result matching filters for AutoComplete.\n\nThese filters are similar to the ones provided by the `autocomplete-filters`\nmodule, but use accent-aware comparisons. For example, \"resume\" and \"résumé\"\nwill be considered equal when using the accent-folding filters."
        },
        {
            "displayName": "autocomplete-highlighters",
            "name": "autocomplete-highlighters",
            "description": "Provides pre-built result highlighters for AutoComplete."
        },
        {
            "displayName": "autocomplete-highlighters-accentfold",
            "name": "autocomplete-highlighters-accentfold",
            "description": "Provides pre-built accent-folding result highlighters for AutoComplete.\n\nThese highlighters are similar to the ones provided by the `autocomplete-\nhighlighters` module, but use accent-aware comparisons. For example, \"resume\"\nand \"résumé\" will be considered equal when using the accent-folding\nhighlighters."
        },
        {
            "displayName": "autocomplete-list",
            "name": "autocomplete-list",
            "description": "Traditional autocomplete dropdown list widget, just like Mom used to make."
        },
        {
            "displayName": "autocomplete-list-keys",
            "name": "autocomplete-list-keys",
            "description": "Mixes keyboard support into AutoCompleteList. By default, this module is not\nloaded for iOS and Android devices."
        },
        {
            "displayName": "autocomplete-plugin",
            "name": "autocomplete-plugin",
            "description": "Binds an AutoCompleteList instance to a Node instance."
        },
        {
            "displayName": "autocomplete-sources",
            "name": "autocomplete-sources",
            "description": "Mixes support for JSONP and YQL result sources into AutoCompleteBase."
        },
        {
            "displayName": "base",
            "name": "base",
            "description": "The base module provides the Base class, which objects requiring attribute and custom event support can extend. \nThe module also provides two ways to reuse code - It augments Base with the Plugin.Host interface which provides \nplugin support and also provides the BaseCore.build method which provides a way to build custom classes using extensions."
        },
        {
            "displayName": "base-base",
            "name": "base-base",
            "description": "The base-base submodule provides the Base class without the Plugin support, provided by Plugin.Host, \nand without the extension support provided by BaseCore.build."
        },
        {
            "displayName": "base-build",
            "name": "base-build",
            "description": "The base-build submodule provides Base.build functionality, which\ncan be used to create custom classes, by aggregating extensions onto \na main class."
        },
        {
            "displayName": "base-core",
            "name": "base-core",
            "description": "<p>The base-core module provides the BaseCore class, the lightest version of Base, \nwhich provides Base's basic lifecycle management and ATTRS construction support, \nbut doesn't fire init/destroy or attribute change events.</p> \n\n<p>It mixes in AttributeCore, which is the lightest version of Attribute</p>"
        },
        {
            "displayName": "base-pluginhost",
            "name": "base-pluginhost",
            "description": "The base-pluginhost submodule adds Plugin support to Base, by augmenting Base with \nPlugin.Host and setting up static (class level) Base.plug and Base.unplug methods."
        },
        {
            "displayName": "button",
            "name": "button",
            "description": "A Button Widget"
        },
        {
            "displayName": "button-core",
            "name": "button-core",
            "description": "Provides an interface for working with button-like DOM nodes"
        },
        {
            "displayName": "button-group",
            "name": "button-group",
            "description": "A Widget to create groups of buttons"
        },
        {
            "displayName": "button-plugin",
            "name": "button-plugin",
            "description": "A Button Plugin"
        },
        {
            "displayName": "cache",
            "name": "cache",
            "description": "The Cache utility provides a common configurable interface for components to\ncache and retrieve data from a local JavaScript struct."
        },
        {
            "displayName": "cache-base",
            "name": "cache-base",
            "description": "Provides the base class for the YUI Cache utility."
        },
        {
            "displayName": "cache-offline",
            "name": "cache-offline",
            "description": "Provides a Cache subclass which uses HTML5 `localStorage` for persistence."
        },
        {
            "displayName": "cache-plugin",
            "name": "cache-plugin",
            "description": "Provides support to use Cache as a Plugin to a Base-based class."
        },
        {
            "displayName": "calendar",
            "name": "calendar",
            "description": "The Calendar component is a UI widget that allows users\nto view dates in a two-dimensional month grid, as well as\nto select one or more dates, or ranges of dates. Calendar\nis generated dynamically and relies on the developer to\nprovide for a progressive enhancement alternative."
        },
        {
            "displayName": "calendar-base",
            "name": "calendar-base",
            "description": "The CalendarBase submodule is a basic UI calendar view that displays\na range of dates in a two-dimensional month grid, with one or more\nmonths visible at a single time. CalendarBase supports custom date\nrendering, multiple calendar panes, and selection."
        },
        {
            "displayName": "calendarnavigator",
            "name": "calendarnavigator",
            "description": "Provides a plugin which adds navigation controls to Calendar."
        },
        {
            "displayName": "charts",
            "name": "charts",
            "description": "The Charts widget provides an api for displaying data\ngraphically."
        },
        {
            "displayName": "charts-legend",
            "name": "charts-legend",
            "description": "Adds legend functionality to charts."
        },
        {
            "displayName": "classnamemanager",
            "name": "classnamemanager",
            "description": "Contains a singleton (ClassNameManager) that enables easy creation and caching of \nprefixed class names."
        },
        {
            "displayName": "clickable-rail",
            "name": "clickable-rail",
            "description": "Adds support for mouse interaction with the Slider rail triggering thumb\nmovement."
        },
        {
            "displayName": "collection",
            "name": "collection"
        },
        {
            "displayName": "console",
            "name": "console",
            "description": "Console creates a visualization for messages logged through calls to a YUI\ninstance's <code>Y.log( message, category, source )</code> method.  The\ndebug versions of YUI modules will include logging statements to offer some\ninsight into the steps executed during that module's operation.  Including\nlog statements in your code will cause those messages to also appear in the\nConsole.  Use Console to aid in developing your page or application.\n\nEntry categories &quot;info&quot;, &quot;warn&quot;, and &quot;error&quot;\nare also referred to as the log level, and entries are filtered against the\nconfigured logLevel."
        },
        {
            "displayName": "console-filters",
            "name": "console-filters",
            "description": "<p>Provides Plugin.ConsoleFilters plugin class.</p>\n\n<p>This plugin adds the ability to control which Console entries display by filtering on category and source. Two groups of checkboxes are added to the Console footer, one for categories and the other for sources.  Only those messages that match a checked category or source are displayed.</p>"
        },
        {
            "displayName": "cookie",
            "name": "cookie",
            "description": "Utilities for cookie management"
        },
        {
            "displayName": "createlink-base",
            "name": "createlink-base",
            "description": "Adds prompt style link creation. Adds an override for the <a href=\"Plugin.ExecCommand.html#method_COMMANDS.createlink\">createlink execCommand</a>."
        },
        {
            "displayName": "dataschema",
            "name": "dataschema",
            "description": "The DataSchema utility provides a common configurable interface for widgets to\napply a given schema to a variety of data."
        },
        {
            "displayName": "dataschema-array",
            "name": "dataschema-array",
            "description": "Provides a DataSchema implementation which can be used to work with data\nstored in arrays."
        },
        {
            "displayName": "dataschema-base",
            "name": "dataschema-base",
            "description": "Provides the base DataSchema implementation, which can be extended to \ncreate DataSchemas for specific data formats, such XML, JSON, text and\narrays."
        },
        {
            "displayName": "dataschema-json",
            "name": "dataschema-json",
            "description": "Provides a DataSchema implementation which can be used to work with JSON data."
        },
        {
            "displayName": "dataschema-text",
            "name": "dataschema-text",
            "description": "Provides a DataSchema implementation which can be used to work with\ndelimited text data."
        },
        {
            "displayName": "dataschema-xml",
            "name": "dataschema-xml",
            "description": "Provides a DataSchema implementation which can be used to work with XML data."
        },
        {
            "displayName": "datasource",
            "name": "datasource",
            "description": "The DataSource utility provides a common configurable interface for widgets to\naccess a variety of data, from JavaScript arrays to online database servers."
        },
        {
            "displayName": "datasource-arrayschema",
            "name": "datasource-arrayschema",
            "description": "Extends DataSource with schema-parsing on array data."
        },
        {
            "displayName": "datasource-cache",
            "name": "datasource-cache",
            "description": "Plugs DataSource with caching functionality."
        },
        {
            "displayName": "datasource-function",
            "name": "datasource-function",
            "description": "Provides a DataSource implementation which can be used to retrieve data from a custom function."
        },
        {
            "displayName": "datasource-get",
            "name": "datasource-get",
            "description": "Provides a DataSource implementation which can be used to retrieve data via the Get Utility."
        },
        {
            "displayName": "datasource-io",
            "name": "datasource-io",
            "description": "Provides a DataSource implementation which can be used to retrieve data via the IO Utility."
        },
        {
            "displayName": "datasource-jsonschema",
            "name": "datasource-jsonschema",
            "description": "Extends DataSource with schema-parsing on JSON data."
        },
        {
            "displayName": "datasource-local",
            "name": "datasource-local",
            "description": "Provides the base DataSource implementation, which can be extended to\ncreate DataSources for specific data protocols, such as the IO Utility, the\nGet Utility, or custom functions."
        },
        {
            "displayName": "datasource-polling",
            "name": "datasource-polling",
            "description": "Extends DataSource with polling functionality."
        },
        {
            "displayName": "datasource-textschema",
            "name": "datasource-textschema",
            "description": "Extends DataSource with schema-parsing on text data."
        },
        {
            "displayName": "datasource-xmlschema",
            "name": "datasource-xmlschema",
            "description": "Extends DataSource with schema-parsing on XML data."
        },
        {
            "displayName": "datatable",
            "name": "datatable",
            "description": "A Widget for displaying tabular data.  The base implementation of DataTable\nprovides the ability to dynamically generate an HTML table from a set of column\nconfigurations and row data.\n\nTwo classes are included in the `datatable-base` module: `Y.DataTable` and\n`Y.DataTable.Base`."
        },
        {
            "displayName": "datatable-base",
            "name": "datatable-base",
            "description": "A Widget for displaying tabular data.  The base implementation of DataTable\nprovides the ability to dynamically generate an HTML table from a set of column\nconfigurations and row data.\n\nTwo classes are included in the `datatable-base` module: `Y.DataTable` and\n`Y.DataTable.Base`."
        },
        {
            "displayName": "datatable-base-deprecated",
            "name": "datatable-base-deprecated",
            "description": "Provides the base DataTable implementation, which can be extended to add\nadditional functionality, such as sorting or scrolling.\n\nDEPRECATED. As of YUI 3.5.0, DataTable has been rebuilt.  This module\ncorresponds to the 3.4.1 version of DataTable and will be removed from the\nlibrary in a future version.\n\nSee http://yuilibrary.com/yui/docs/migration.html for help upgrading to the\nlatest version.\n\nFor complete API docs for the classes in this and other deprecated\nDataTable-related modules, refer to the static API doc files in the 3.4.1\ndownload at http://yui.zenfs.com/releases/yui3/yui_3.4.1.zip"
        },
        {
            "displayName": "datatable-body",
            "name": "datatable-body",
            "description": "View class responsible for rendering the `<tbody>` section of a table. Used as\nthe default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes."
        },
        {
            "displayName": "datatable-column-widths",
            "name": "datatable-column-widths",
            "description": "Adds basic, programmatic column width support to DataTable via column\nconfiguration property `width` and method `table.setColumnWidth(id, width);`."
        },
        {
            "displayName": "datatable-core",
            "name": "datatable-core",
            "description": "The core implementation of the `DataTable` and `DataTable.Base` Widgets."
        },
        {
            "displayName": "datatable-datasource",
            "name": "datatable-datasource",
            "description": "Plugs DataTable with DataSource integration."
        },
        {
            "displayName": "datatable-datasource-deprecated",
            "name": "datatable-datasource-deprecated",
            "description": "Plugs DataTable with DataSource integration.\n\nDEPRECATED. As of YUI 3.5.0, DataTable has been rebuilt.  This module\nis designed to work with `datatable-base-deprecated` (effectively the 3.4.1\nversion of DataTable) and will be removed from the library in a future version.\n\nSee http://yuilibrary.com/yui/docs/migration.html for help upgrading to the\nlatest version.\n\nFor complete API docs for the classes in this and other deprecated\nDataTable-related modules, refer to the static API doc files in the 3.4.1\ndownload at http://yui.zenfs.com/releases/yui3/yui_3.4.1.zip"
        },
        {
            "displayName": "datatable-deprecated",
            "name": "datatable-deprecated",
            "description": "The DataTable widget provides a progressively enhanced DHTML control for\ndisplaying tabular data across A-grade browsers.\n\nDEPRECATED. As of YUI 3.5.0, DataTable has been rebuilt.  This module\ncorresponds to the 3.4.1 version of DataTable and will be removed from the\nlibrary in a future version.\n\nSee http://yuilibrary.com/yui/docs/migration.html for help upgrading to the\nlatest version.\n\nFor complete API docs for the classes in this and other deprecated\nDataTable-related modules, refer to the static API doc files in the 3.4.1\ndownload at http://yui.zenfs.com/releases/yui3/yui_3.4.1.zip"
        },
        {
            "displayName": "datatable-head",
            "name": "datatable-head",
            "description": "View class responsible for rendering the `<thead>` section of a table. Used as\nthe default `headerView` for `Y.DataTable.Base` and `Y.DataTable` classes."
        },
        {
            "displayName": "datatable-message",
            "name": "datatable-message",
            "description": "Adds support for a message container to appear in the table.  This can be used\nto indicate loading progress, lack of records, or any other communication\nneeded."
        },
        {
            "displayName": "datatable-mutable",
            "name": "datatable-mutable",
            "description": "Adds mutation convenience methods such as `table.addRow(data)` to `Y.DataTable`. (or other built class)."
        },
        {
            "displayName": "datatable-scroll",
            "name": "datatable-scroll",
            "description": "Adds the ability to make the table rows scrollable while preserving the header\nplacement."
        },
        {
            "displayName": "datatable-scroll-deprecated",
            "name": "datatable-scroll-deprecated",
            "description": "Extends DataTable base to enable x,y, and xy scrolling.\n\nDEPRECATED. As of YUI 3.5.0, DataTable has been rebuilt.  This module\nis designed to work with `datatable-base-deprecated` (effectively the 3.4.1\nversion of DataTable) and will be removed from the library in a future version.\n\nSee http://yuilibrary.com/yui/docs/migration.html for help upgrading to the\nlatest version.\n\nFor complete API docs for the classes in this and other deprecated\nDataTable-related modules, refer to the static API doc files in the 3.4.1\ndownload at http://yui.zenfs.com/releases/yui3/yui_3.4.1.zip"
        },
        {
            "displayName": "datatable-sort",
            "name": "datatable-sort",
            "description": "Adds support for sorting the table data by API methods `table.sort(...)` or\n`table.toggleSort(...)` or by clicking on column headers in the rendered UI."
        },
        {
            "displayName": "datatable-sort-deprecated",
            "name": "datatable-sort-deprecated",
            "description": "Plugs DataTable with sorting functionality.\n\nDEPRECATED. As of YUI 3.5.0, DataTable has been rebuilt.  This module\nis designed to work with `datatable-base-deprecated` (effectively the 3.4.1\nversion of DataTable) and will be removed from the library in a future version.\n\nSee http://yuilibrary.com/yui/docs/migration.html for help upgrading to the\nlatest version.\n\nFor complete API docs for the classes in this and other deprecated\nDataTable-related modules, refer to the static API doc files in the 3.4.1\ndownload at http://yui.zenfs.com/releases/yui3/yui_3.4.1.zip"
        },
        {
            "displayName": "datatype",
            "name": "datatype",
            "description": "The DataType Utility provides type-conversion and string-formatting\nconvenience methods for various JavaScript object types."
        },
        {
            "displayName": "datatype-date",
            "name": "datatype-date",
            "description": "Date submodule."
        },
        {
            "displayName": "datatype-date-format",
            "name": "datatype-date-format",
            "description": "Format date submodule implements strftime formatters for javascript based on the\nOpen Group specification defined at\nhttp://www.opengroup.org/onlinepubs/007908799/xsh/strftime.html\nThis implementation does not include modified conversion specifiers (i.e., Ex and Ox)"
        },
        {
            "displayName": "datatype-date-math",
            "name": "datatype-date-math",
            "description": "Datatype Date Math submodule."
        },
        {
            "displayName": "datatype-date-parse",
            "name": "datatype-date-parse",
            "description": "Parse number submodule."
        },
        {
            "displayName": "datatype-number",
            "name": "datatype-number",
            "description": "Number submodule."
        },
        {
            "displayName": "datatype-number-format",
            "name": "datatype-number-format",
            "description": "Format number submodule."
        },
        {
            "displayName": "datatype-number-parse",
            "name": "datatype-number-parse",
            "description": "Parse number submodule."
        },
        {
            "displayName": "datatype-xml",
            "name": "datatype-xml",
            "description": "XML submodule."
        },
        {
            "displayName": "datatype-xml-format",
            "name": "datatype-xml-format",
            "description": "Format XML submodule."
        },
        {
            "displayName": "datatype-xml-parse",
            "name": "datatype-xml-parse",
            "description": "Parse XML submodule."
        },
        {
            "displayName": "dd",
            "name": "dd",
            "description": "The Drag & Drop Utility allows you to create a draggable interface efficiently, buffering you from browser-level abnormalities and enabling you to focus on the interesting logic surrounding your particular implementation. This component enables you to create a variety of standard draggable objects with just a few lines of code and then, using its extensive API, add your own specific implementation logic."
        },
        {
            "displayName": "dd-constrain",
            "name": "dd-constrain",
            "description": "The Drag & Drop Utility allows you to create a draggable interface efficiently, buffering you from browser-level abnormalities and enabling you to focus on the interesting logic surrounding your particular implementation. This component enables you to create a variety of standard draggable objects with just a few lines of code and then, using its extensive API, add your own specific implementation logic."
        },
        {
            "displayName": "dd-ddm",
            "name": "dd-ddm",
            "description": "Extends the dd-ddm-base Class to add support for the viewport shim to allow a draggable node to drag to be dragged over an iframe or any other node that traps mousemove events.\nIt is also required to have Drop Targets enabled, as the viewport shim will contain the shims for the Drop Targets."
        },
        {
            "displayName": "dd-ddm-base",
            "name": "dd-ddm-base",
            "description": "Provides the base Drag Drop Manger required for making a Node draggable."
        },
        {
            "displayName": "dd-ddm-drop",
            "name": "dd-ddm-drop",
            "description": "Extends the dd-ddm Class to add support for the placement of Drop Target shims inside the viewport shim. It also handles all Drop Target related events and interactions."
        },
        {
            "displayName": "dd-delegate",
            "name": "dd-delegate",
            "description": "Provides the ability to drag multiple nodes under a container element using only one Y.DD.Drag instance as a delegate."
        },
        {
            "displayName": "dd-drag",
            "name": "dd-drag",
            "description": "Provides the ability to drag a Node."
        },
        {
            "displayName": "dd-drop",
            "name": "dd-drop",
            "description": "Provides the ability to create a Drop Target."
        },
        {
            "displayName": "dd-drop-plugin",
            "name": "dd-drop-plugin",
            "description": "Simple Drop plugin that can be attached to a Node via the plug method."
        },
        {
            "displayName": "dd-plugin",
            "name": "dd-plugin",
            "description": "Simple Drag plugin that can be attached to a Node or Widget via the plug method."
        },
        {
            "displayName": "dd-proxy",
            "name": "dd-proxy",
            "description": "Plugin for dd-drag for creating a proxy drag node, instead of dragging the original node."
        },
        {
            "displayName": "dd-scroll",
            "name": "dd-scroll",
            "description": "Base scroller class used to create the Plugin.DDNodeScroll and Plugin.DDWinScroll.\nThis class should not be called on it's own, it's designed to be a plugin."
        },
        {
            "displayName": "dial",
            "name": "dial",
            "description": "Create a circular dial value range input visualized as a draggable handle on a\nbackground element."
        },
        {
            "displayName": "dom",
            "name": "dom",
            "description": "The DOM utility provides a cross-browser abtraction layer\nnormalizing DOM tasks, and adds extra helper functionality\nfor other common tasks."
        },
        {
            "displayName": "dom-base",
            "name": "dom-base",
            "description": "The DOM utility provides a cross-browser abtraction layer\nnormalizing DOM tasks, and adds extra helper functionality\nfor other common tasks."
        },
        {
            "displayName": "dom-screen",
            "name": "dom-screen",
            "description": "Adds position and region management functionality to DOM."
        },
        {
            "displayName": "dom-style",
            "name": "dom-style",
            "description": "Add style management functionality to DOM."
        },
        {
            "displayName": "dump",
            "name": "dump",
            "description": "Returns a simple string representation of the object or array.\nOther types of objects will be returned unprocessed.  Arrays\nare expected to be indexed.  Use object notation for\nassociative arrays.\n\nIf included, the dump method is added to the YUI instance."
        },
        {
            "displayName": "editor",
            "name": "editor",
            "description": "Base class for Editor. Handles the business logic of Editor, no GUI involved only utility methods and events.\n\n     var editor = new Y.EditorBase({\n         content: 'Foo'\n     });\n     editor.render('#demo');"
        },
        {
            "displayName": "editor-base",
            "name": "editor-base",
            "description": "Base class for Editor. Handles the business logic of Editor, no GUI involved only utility methods and events.\n\n     var editor = new Y.EditorBase({\n         content: 'Foo'\n     });\n     editor.render('#demo');"
        },
        {
            "displayName": "editor-bidi",
            "name": "editor-bidi",
            "description": "Plugin for Editor to support BiDirectional (bidi) text operations."
        },
        {
            "displayName": "editor-br",
            "name": "editor-br",
            "description": "Plugin for Editor to normalize BR's."
        },
        {
            "displayName": "editor-lists",
            "name": "editor-lists",
            "description": "Handles list manipulation inside the Editor. Adds keyboard manipulation and execCommand support. Adds overrides for the <a href=\"Plugin.ExecCommand.html#method_COMMANDS.insertorderedlist\">insertorderedlist</a> and <a href=\"Plugin.ExecCommand.html#method_COMMANDS.insertunorderedlist\">insertunorderedlist</a> execCommands."
        },
        {
            "displayName": "editor-para",
            "name": "editor-para",
            "description": "Plugin for Editor to paragraph auto wrapping and correction."
        },
        {
            "displayName": "editor-para-base",
            "name": "editor-para-base",
            "description": "Base Plugin for Editor to paragraph auto wrapping and correction."
        },
        {
            "displayName": "editor-para-ie",
            "name": "editor-para-ie",
            "description": "Extends EditorParaBase with IE support"
        },
        {
            "displayName": "editor-tab",
            "name": "editor-tab",
            "description": "Handles tab and shift-tab indent/outdent support."
        },
        {
            "displayName": "escape",
            "name": "escape",
            "description": "Provides utility methods for escaping strings."
        },
        {
            "displayName": "event",
            "name": "event",
            "description": "The event utility provides functions to add and remove event listeners,\nevent cleansing.  It also tries to automatically remove listeners it\nregisters during the unload event."
        },
        {
            "displayName": "event-base",
            "name": "event-base",
            "description": "DOM event listener abstraction layer"
        },
        {
            "displayName": "event-contextmenu",
            "name": "event-contextmenu",
            "description": "Provides extended keyboard support for the \"contextmenu\" event such that:\n<ul>\n<li>The browser's default context menu is suppressed regardless of how the event is triggered.</li>\n<li>On Windows the \"contextmenu\" event is fired consistently regardless of whether the user pressed the Menu key or Shift + F10.</li>\n<li>When the \"contextmenu\" event is fired via the keyboard, the pageX, pageY, clientX and clientY properties reference the center of the event target. This makes it easy for \"contextmenu\" event listeners to position an overlay in response to the event by not having to worry about special handling of the x and y coordinates based on the device that fired the event.</li>\n<li>For Webkit and Gecko on the Mac it enables the use of the Shift + Control + Option + M keyboard shortcut to fire the \"contextmenu\" event, which (by default) is only available when VoiceOver (the screen reader on the Mac) is enabled.</li>\n<li>For Opera on the Mac it ensures the \"contextmenu\" event is fired when the user presses Shift + Command + M (Opera's context menu keyboard shortcut).</li>\n</ul>"
        },
        {
            "displayName": "event-custom",
            "name": "event-custom",
            "description": "Custom event engine, DOM event listener abstraction layer, synthetic DOM\nevents."
        },
        {
            "displayName": "event-custom-base",
            "name": "event-custom-base",
            "description": "Custom event engine, DOM event listener abstraction layer, synthetic DOM\nevents."
        },
        {
            "displayName": "event-custom-complex",
            "name": "event-custom-complex",
            "description": "Adds event facades, preventable default behavior, and bubbling.\nevents."
        },
        {
            "displayName": "event-delegate",
            "name": "event-delegate",
            "description": "Adds event delegation support to the library."
        },
        {
            "displayName": "event-flick",
            "name": "event-flick",
            "description": "Adds support for a \"flick\" event, which is fired at the end of a touch or mouse based flick gesture, and provides \nvelocity of the flick, along with distance and time information."
        },
        {
            "displayName": "event-focus",
            "name": "event-focus",
            "description": "Adds bubbling and delegation support to DOM events focus and blur."
        },
        {
            "displayName": "event-gestures",
            "name": "event-gestures",
            "description": "The gestures module provides gesture events such as \"flick\", which normalize user interactions\nacross touch and mouse or pointer based input devices. This layer can be used by application developers\nto build input device agnostic components which behave the same in response to either touch or mouse based  \ninteraction.\n\n<p>Documentation for events added by this module can be found in the event document for the <a href=\"YUI.html#events\">YUI</a> global.</p>"
        },
        {
            "displayName": "event-hover",
            "name": "event-hover",
            "description": "Adds support for a \"hover\" event.  The event provides a convenience wrapper\nfor subscribing separately to mouseenter and mouseleave.  The signature for\nsubscribing to the event is</p>\n\n<pre><code>node.on(\"hover\", overFn, outFn);\nnode.delegate(\"hover\", overFn, outFn, \".filterSelector\");\nY.on(\"hover\", overFn, outFn, \".targetSelector\");\nY.delegate(\"hover\", overFn, outFn, \"#container\", \".filterSelector\");\n</code></pre>\n\n<p>Additionally, for compatibility with a more typical subscription\nsignature, the following are also supported:</p>\n\n<pre><code>Y.on(\"hover\", overFn, \".targetSelector\", outFn);\nY.delegate(\"hover\", overFn, \"#container\", outFn, \".filterSelector\");\n</code></pre>"
        },
        {
            "displayName": "event-key",
            "name": "event-key",
            "description": "Functionality to listen for one or more specific key combinations."
        },
        {
            "displayName": "event-mouseenter",
            "name": "event-mouseenter",
            "description": "<p>Adds subscription and delegation support for mouseenter and mouseleave\nevents.  Unlike mouseover and mouseout, these events aren't fired from child\nelements of a subscribed node.</p>\n\n<p>This avoids receiving three mouseover notifications from a setup like</p>\n\n<pre><code>div#container > p > a[href]</code></pre>\n\n<p>where</p>\n\n<pre><code>Y.one('#container').on('mouseover', callback)</code></pre>\n\n<p>When the mouse moves over the link, one mouseover event is fired from\n#container, then when the mouse moves over the p, another mouseover event is\nfired and bubbles to #container, causing a second notification, and finally\nwhen the mouse moves over the link, a third mouseover event is fired and\nbubbles to #container for a third notification.</p>\n\n<p>By contrast, using mouseenter instead of mouseover, the callback would be\nexecuted only once when the mouse moves over #container.</p>"
        },
        {
            "displayName": "event-mousewheel",
            "name": "event-mousewheel",
            "description": "Adds mousewheel event support"
        },
        {
            "displayName": "event-move",
            "name": "event-move",
            "description": "Adds lower level support for \"gesturemovestart\", \"gesturemove\" and \"gesturemoveend\" events, which can be used to create drag/drop\ninteractions which work across touch and mouse input devices. They correspond to \"touchstart\", \"touchmove\" and \"touchend\" on a touch input\ndevice, and \"mousedown\", \"mousemove\", \"mouseup\" on a mouse based input device."
        },
        {
            "displayName": "event-outside",
            "name": "event-outside",
            "description": "Outside events are synthetic DOM events that fire when a corresponding native\nor synthetic DOM event occurs outside a bound element.\n\nThe following outside events are pre-defined by this module:\n<ul>\n  <li>blur</li>\n  <li>change</li>\n  <li>click</li>\n  <li>dblclick</li>\n  <li>focus</li>\n  <li>keydown</li>\n  <li>keypress</li>\n  <li>keyup</li>\n  <li>mousedown</li>\n  <li>mousemove</li>\n  <li>mouseout</li>\n  <li>mouseover</li>\n  <li>mouseup</li>\n  <li>select</li>\n  <li>submit</li>\n</ul>\n\nDefine new outside events with\n<code>Y.Event.defineOutside(eventType);</code>.\nBy default, the created synthetic event name will be the name of the event\nwith \"outside\" appended (e.g. \"click\" becomes \"clickoutside\"). If you want\na different name for the created Event, pass it as a second argument like so:\n<code>Y.Event.defineOutside(eventType, \"yonderclick\")</code>.\n\nThis module was contributed by Brett Stimmerman, promoted from his\ngallery-outside-events module at\nhttp://yuilibrary.com/gallery/show/outside-events"
        },
        {
            "displayName": "event-resize",
            "name": "event-resize",
            "description": "Adds a window resize event that has its behavior normalized to fire at the\nend of the resize rather than constantly during the resize."
        },
        {
            "displayName": "event-simulate",
            "name": "event-simulate",
            "description": "Simulate user interaction by generating native DOM events."
        },
        {
            "displayName": "event-synthetic",
            "name": "event-synthetic",
            "description": "Define new DOM events that can be subscribed to from Nodes."
        },
        {
            "displayName": "event-touch",
            "name": "event-touch",
            "description": "Adds touch event facade normalization properties (touches, changedTouches, targetTouches etc.) to the DOM event facade"
        },
        {
            "displayName": "event-valuechange",
            "name": "event-valuechange",
            "description": "Adds a synthetic `valueChange` event that fires when the `value` property of an\n`<input>` or `<textarea>` node changes as a result of a keystroke, mouse\noperation, or input method editor (IME) input event.\n\nUsage:\n\n    YUI().use('event-valuechange', function (Y) {\n        Y.one('#my-input').on('valueChange', function (e) {\n            Y.log('previous value: ' + e.prevVal);\n            Y.log('new value: ' + e.newVal);\n        });\n    });"
        },
        {
            "displayName": "exec-command",
            "name": "exec-command",
            "description": "Plugin for the frame module to handle execCommands for Editor"
        },
        {
            "displayName": "features",
            "name": "features",
            "description": "Contains the core of YUI's feature test architecture."
        },
        {
            "displayName": "file",
            "name": "file",
            "description": "The File class provides a wrapper for a file pointer, either through an HTML5 \nimplementation or as a reference to a file pointer stored in Flash. The File wrapper \nalso implements the mechanics for uploading a file and tracking its progress."
        },
        {
            "displayName": "file-flash",
            "name": "file-flash",
            "description": "The FileFlash class provides a wrapper for a file pointer stored in Flash. The File wrapper \nalso implements the mechanics for uploading a file and tracking its progress."
        },
        {
            "displayName": "file-html5",
            "name": "file-html5",
            "description": "The FileHTML5 class provides a wrapper for a file pointer in an HTML5 The File wrapper \nalso implements the mechanics for uploading a file and tracking its progress."
        },
        {
            "displayName": "frame",
            "name": "frame",
            "description": "Creates a wrapper around an iframe. It loads the content either from a local\nfile or from script and creates a local YUI instance bound to that new window and document."
        },
        {
            "displayName": "get",
            "name": "get",
            "description": "Provides dynamic loading of remote JavaScript and CSS resources."
        },
        {
            "displayName": "get-nodejs",
            "name": "get-nodejs",
            "description": "NodeJS specific Get module used to load remote resources. It contains the same signature as the default Get module so there is no code change needed."
        },
        {
            "displayName": "graphics",
            "name": "graphics",
            "description": "<p>The `Graphics` module provides a JavaScript API for creating shapes in a variety of formats across \n a <a href=\"http://developer.yahoo.com/yui/articles/gbs\">browser test baseline</a>. \n Based on device and browser capabilities, `Graphics` leverages <a href=\"http://www.w3.org/TR/SVG/\">SVG</a>, \n <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> and <a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> \n to render its graphical elements.</p>\n\n <p>The `Graphics` module features a <a href=\"../classes/Graphic.html\">`Graphic`</a> class that allows you to easily create and manage shapes. \n Currently, a <a href=\"../classes/Graphic.html\">`Graphic`</a> instance can be used to create predifined shapes and free-form polygons with fill \n and stroke properties.</p>  \n\n <p>The `Graphics` module normalizes an API through the use of alias and implementation classes that share\n interfaces. Each alias class points to an appropriate implementation class dependent on the browser's \n capabilities. There should rarely, if ever, be a need to interact directly with an implementation class.</p>\n\n <p>Below is a list of available classes. \n     <ul>\n         <li><a href=\"../classes/Graphic.html\">`Graphic`</a>\n         <li><a href=\"../classes/Shape.html\">`Shape`</a>\n         <li><a href=\"../classes/Circle.html\">`Circle`</a>\n         <li><a href=\"../classes/Ellipse.html\">`Ellipse`</a>\n         <li><a href=\"../classes/Rect.html\">`Rect`</a>\n         <li><a href=\"../classes/Path.html\">`Path`</a>\n     </ul>\n You can also extend the `Shape` class to create your own custom shape classes.</p>"
        },
        {
            "displayName": "handlebars",
            "name": "handlebars",
            "description": "Handlebars is a simple template language inspired by Mustache.\n\nThis is a YUI port of the original Handlebars project, which can be found at\n<https://github.com/wycats/handlebars.js>."
        },
        {
            "displayName": "handlebars-base",
            "name": "handlebars-base",
            "description": "Provides basic Handlebars template rendering functionality. Use this module when\nyou only need to render pre-compiled templates."
        },
        {
            "displayName": "handlebars-compiler",
            "name": "handlebars-compiler",
            "description": "Handlebars parser and compiler. Use this module when you need to compile\nHandlebars templates."
        },
        {
            "displayName": "highlight",
            "name": "highlight"
        },
        {
            "displayName": "highlight-accentfold",
            "name": "highlight-accentfold",
            "description": "Adds accent-folding highlighters to `Y.Highlight`."
        },
        {
            "displayName": "highlight-base",
            "name": "highlight-base",
            "description": "Provides methods for highlighting strings within other strings by wrapping\nthem in HTML."
        },
        {
            "displayName": "history",
            "name": "history",
            "description": "Provides browser history management functionality using a simple\nadd/replace/get paradigm. This can be used to ensure that the browser's back\nand forward buttons work as the user expects and to provide bookmarkable URLs\nthat return the user to the current application state, even in an Ajax\napplication that doesn't perform full-page refreshes."
        },
        {
            "displayName": "history-base",
            "name": "history-base",
            "description": "Provides global state management backed by an object, but with no browser\nhistory integration. For actual browser history integration and back/forward\nsupport, use the history-html5 or history-hash modules."
        },
        {
            "displayName": "history-hash",
            "name": "history-hash",
            "description": "Provides browser history management backed by\n<code>window.location.hash</code>, as well as convenience methods for working\nwith the location hash and a synthetic <code>hashchange</code> event that\nnormalizes differences across browsers."
        },
        {
            "displayName": "history-hash-ie",
            "name": "history-hash-ie",
            "description": "Improves IE6/7 support in history-hash by using a hidden iframe to create\nentries in IE's browser history. This module is only needed if IE6/7 support\nis necessary; it's not needed for any other browser."
        },
        {
            "displayName": "history-html5",
            "name": "history-html5",
            "description": "Provides browser history management using the HTML5 history API."
        },
        {
            "displayName": "imageloader",
            "name": "imageloader",
            "description": "The ImageLoader Utility is a framework to dynamically load images according to certain triggers,\nenabling faster load times and a more responsive UI."
        },
        {
            "displayName": "intl",
            "name": "intl",
            "description": "Provides utilities to support the management of localized resources (strings and formatting patterns)."
        },
        {
            "displayName": "io",
            "name": "io",
            "description": "The IO class is a utility that brokers HTTP requests through a simplified\ninterface.  Specifically, it allows JavaScript to make HTTP requests to\na resource without a page reload.  The underlying transport for making\nsame-domain requests is the XMLHttpRequest object.  IO can also use\nFlash, if specified as a transport, for cross-domain requests.\n\n    Y.io('/some/url', {\n        on: {\n            success: function(id, e) {\n                Y.log(e.responseText);\n            }\n        }\n    });"
        },
        {
            "displayName": "io-base",
            "name": "io-base",
            "description": "Base IO functionality. Provides basic XHR transport support."
        },
        {
            "displayName": "io-form",
            "name": "io-form",
            "description": "Extends IO to enable HTML form data serialization, when specified\nin the transaction's configuration object."
        },
        {
            "displayName": "io-queue",
            "name": "io-queue",
            "description": "Extends IO to implement Queue for synchronous\ntransaction processing."
        },
        {
            "displayName": "io-upload-iframe",
            "name": "io-upload-iframe",
            "description": "Extends the IO  to enable file uploads, with HTML forms \nusing an iframe as the transport medium."
        },
        {
            "displayName": "io-xdr",
            "name": "io-xdr",
            "description": "Extends IO to provide an alternate, Flash transport, for making\ncross-domain requests."
        },
        {
            "displayName": "json",
            "name": "json",
            "description": "<p>The JSON module adds support for serializing JavaScript objects into\nJSON strings and parsing JavaScript objects from strings in JSON format.</p>\n\n<p>The JSON namespace is added to your YUI instance including static methods\nY.JSON.parse(..) and Y.JSON.stringify(..).</p>\n\n<p>The functionality and method signatures follow the ECMAScript 5\nspecification.  In browsers with native JSON support, the native\nimplementation is used.</p>\n\n<p>The <code>json</code> module is a rollup of <code>json-parse</code> and\n<code>json-stringify</code>.</p>\n\n<p>As their names suggest, <code>json-parse</code> adds support for parsing\nJSON data (Y.JSON.parse) and <code>json-stringify</code> for serializing\nJavaScript data into JSON strings (Y.JSON.stringify).  You may choose to\ninclude either of the submodules individually if you don't need the\ncomplementary functionality, or include the rollup for both.</p>"
        },
        {
            "displayName": "json-parse",
            "name": "json-parse",
            "description": "Provides Y.JSON.parse method to accept JSON strings and return native\nJavaScript objects."
        },
        {
            "displayName": "json-stringify",
            "name": "json-stringify",
            "description": "Provides Y.JSON.stringify method for converting objects to JSON strings."
        },
        {
            "displayName": "jsonp",
            "name": "jsonp",
            "description": "<p>Provides a JSONPRequest class for repeated JSONP calls, and a convenience\nmethod Y.jsonp(url, callback) to instantiate and send a JSONP request.</p>\n\n<p>Both the constructor as well as the convenience function take two\nparameters: a url string and a callback.</p>\n\n<p>The url provided must include the placeholder string\n&quot;{callback}&quot; which will be replaced by a dynamically\ngenerated routing function to pass the data to your callback function.\nAn example url might look like\n&quot;http://example.com/service?callback={callback}&quot;.</p>\n\n<p>The second parameter can be a callback function that accepts the JSON\npayload as its argument, or a configuration object supporting the keys:</p>\n<ul>\n  <li>on - map of callback subscribers\n     <ul>\n        <li>success - function handler for successful transmission</li>\n        <li>failure - function handler for failed transmission</li>\n        <li>timeout - function handler for transactions that timeout</li>\n     </ul>\n </li>\n <li>format  - override function for inserting the proxy name in the url</li>\n <li>timeout - the number of milliseconds to wait before giving up</li>\n <li>context - becomes <code>this</code> in the callbacks</li>\n <li>args    - array of subsequent parameters to pass to the callbacks</li>\n <li>allowCache - use the same proxy name for all requests? (boolean)</li>\n</ul>"
        },
        {
            "displayName": "jsonp-url",
            "name": "jsonp-url",
            "description": "Adds support for parsing complex callback identifiers from the jsonp url.\nThis includes callback=foo[1]bar.baz[\"goo\"] as well as referencing methods\nin the YUI instance."
        },
        {
            "displayName": "loader",
            "name": "loader",
            "description": "Loader dynamically loads script and css files.  It includes the dependency\ninformation for the version of the library in use, and will automatically pull in\ndependencies for the modules requested. It can also load the\nfiles from the Yahoo! CDN, and it can utilize the combo service provided on\nthis network to reduce the number of http connections required to download\nYUI files."
        },
        {
            "displayName": "loader-base",
            "name": "loader-base",
            "description": "Loader dynamically loads script and css files.  It includes the dependency\ninformation for the version of the library in use, and will automatically pull in\ndependencies for the modules requested. It can also load the\nfiles from the Yahoo! CDN, and it can utilize the combo service provided on\nthis network to reduce the number of http connections required to download\nYUI files."
        },
        {
            "displayName": "matrix",
            "name": "matrix",
            "description": "Matrix is a class that allows for the manipulation of a transform matrix.\nThis class is a work in progress."
        },
        {
            "displayName": "model",
            "name": "model",
            "description": "Attribute-based data model with APIs for getting, setting, validating, and\nsyncing attribute values, as well as events for being notified of model changes."
        },
        {
            "displayName": "model-list",
            "name": "model-list",
            "description": "Provides an API for managing an ordered list of Model instances."
        },
        {
            "displayName": "node",
            "name": "node",
            "description": "The Node Utility provides a DOM-like interface for interacting with DOM nodes."
        },
        {
            "displayName": "node-base",
            "name": "node-base"
        },
        {
            "displayName": "node-core",
            "name": "node-core",
            "description": "The Node Utility provides a DOM-like interface for interacting with DOM nodes."
        },
        {
            "displayName": "node-data",
            "name": "node-data",
            "description": "Provides methods for managing custom Node data."
        },
        {
            "displayName": "node-deprecated",
            "name": "node-deprecated"
        },
        {
            "displayName": "node-event-delegate",
            "name": "node-event-delegate",
            "description": "Functionality to make the node a delegated event container"
        },
        {
            "displayName": "node-event-html5",
            "name": "node-event-html5",
            "description": "Adds HTML5 event support to Node."
        },
        {
            "displayName": "node-event-simulate",
            "name": "node-event-simulate",
            "description": "Adds functionality to simulate events."
        },
        {
            "displayName": "node-flick",
            "name": "node-flick",
            "description": "Provide a simple Flick plugin, which can be used along with the \"flick\" gesture event, to \nanimate the motion of the host node in response to a (mouse or touch) flick gesture. \n\n<p>The current implementation is designed to move the node, relative to the bounds of a parent node and is suitable\nfor scroll/carousel type implementations. Future versions will remove that constraint, to allow open ended movement within\nthe document.</p>"
        },
        {
            "displayName": "node-focusmanager",
            "name": "node-focusmanager",
            "description": "<p>The Focus Manager Node Plugin makes it easy to manage focus among\na Node's descendants.  Primarily intended to help with widget development,\nthe Focus Manager Node Plugin can be used to improve the keyboard\naccessibility of widgets.</p>\n\n<p>\nWhen designing widgets that manage a set of descendant controls (i.e. buttons\nin a toolbar, tabs in a tablist, menuitems in a menu, etc.) it is important to\nlimit the number of descendants in the browser's default tab flow.  The fewer\nnumber of descendants in the default tab flow, the easier it is for keyboard\nusers to navigate between widgets by pressing the tab key.  When a widget has\nfocus it should provide a set of shortcut keys (typically the arrow keys)\nto move focus among its descendants.\n</p>\n\n<p>\nTo this end, the Focus Manager Node Plugin makes it easy to define a Node's\nfocusable descendants, define which descendant should be in the default tab\nflow, and define the keys that move focus among each descendant.\nAdditionally, as the CSS\n<a href=\"http://www.w3.org/TR/CSS21/selector.html#x38\"><code>:focus</code></a>\npseudo class is not supported on all elements in all\n<a href=\"http://developer.yahoo.com/yui/articles/gbs/\">A-Grade browsers</a>,\nthe Focus Manager Node Plugin provides an easy, cross-browser means of\nstyling focus.\n</p>"
        },
        {
            "displayName": "node-load",
            "name": "node-load",
            "description": "Extended Node interface with a basic IO API."
        },
        {
            "displayName": "node-menunav",
            "name": "node-menunav",
            "description": "<p>The MenuNav Node Plugin makes it easy to transform existing list-based \nmarkup into traditional, drop down navigational menus that are both accessible \nand easy to customize, and only require a small set of dependencies.</p>\n\n\n<p>To use the MenuNav Node Plugin, simply pass a reference to the plugin to a \nNode instance's <code>plug</code> method.</p>\n\n<p>\n<code>\n&#60;script type=\"text/javascript\"&#62; <br>\n<br>\n\t\t//\tCall the \"use\" method, passing in \"node-menunav\".  This will <br>\n\t\t//\tload the script and CSS for the MenuNav Node Plugin and all of <br>\n\t\t//\tthe required dependencies. <br>\n<br>\n\t\tYUI().use(\"node-menunav\", function(Y) { <br>\n<br>\n\t\t\t//\tUse the \"contentready\" event to initialize the menu when <br>\n\t\t\t//\tthe subtree of element representing the root menu <br>\n\t\t\t//\t(&#60;div id=\"menu-1\"&#62;) is ready to be scripted. <br>\n<br>\n\t\t\tY.on(\"contentready\", function () { <br>\n<br>\n\t\t\t\t//\tThe scope of the callback will be a Node instance <br>\n\t\t\t\t//\trepresenting the root menu (&#60;div id=\"menu-1\"&#62;). <br>\n\t\t\t\t//\tTherefore, since \"this\" represents a Node instance, it <br>\n\t\t\t\t//\tis possible to just call \"this.plug\" passing in a <br>\n\t\t\t\t//\treference to the MenuNav Node Plugin. <br>\n<br>\n\t\t\t\tthis.plug(Y.Plugin.NodeMenuNav); <br>\n<br>\n\t\t\t}, \"#menu-1\"); <br>\n<br>\t\t\n\t\t}); <br>\n<br>\t\n\t&#60;/script&#62; <br>\n</code>\n</p>\n\n<p>The MenuNav Node Plugin has several configuration properties that can be \nset via an object literal that is passed as a second argument to a Node \ninstance's <code>plug</code> method.\n</p>\n\n<p>\n<code>\n&#60;script type=\"text/javascript\"&#62; <br>\n<br>\n\t\t//\tCall the \"use\" method, passing in \"node-menunav\".  This will <br>\n\t\t//\tload the script and CSS for the MenuNav Node Plugin and all of <br>\n\t\t//\tthe required dependencies. <br>\n<br>\n\t\tYUI().use(\"node-menunav\", function(Y) { <br>\n<br>\n\t\t\t//\tUse the \"contentready\" event to initialize the menu when <br>\n\t\t\t//\tthe subtree of element representing the root menu <br>\n\t\t\t//\t(&#60;div id=\"menu-1\"&#62;) is ready to be scripted. <br>\n<br>\n\t\t\tY.on(\"contentready\", function () { <br>\n<br>\n\t\t\t\t//\tThe scope of the callback will be a Node instance <br>\n\t\t\t\t//\trepresenting the root menu (&#60;div id=\"menu-1\"&#62;). <br>\n\t\t\t\t//\tTherefore, since \"this\" represents a Node instance, it <br>\n\t\t\t\t//\tis possible to just call \"this.plug\" passing in a <br>\n\t\t\t\t//\treference to the MenuNav Node Plugin. <br>\n<br>\n\t\t\t\tthis.plug(Y.Plugin.NodeMenuNav, { mouseOutHideDelay: 1000 });\n<br><br>\n\t\t\t}, \"#menu-1\"); <br>\n<br>\t\t\n\t\t}); <br>\n<br>\t\n\t&#60;/script&#62; <br>\n</code>\n</p>"
        },
        {
            "displayName": "node-pluginhost",
            "name": "node-pluginhost"
        },
        {
            "displayName": "node-screen",
            "name": "node-screen",
            "description": "Extended Node interface for managing regions and screen positioning.\nAdds support for positioning elements and normalizes window size and scroll detection."
        },
        {
            "displayName": "node-style",
            "name": "node-style",
            "description": "Extended Node interface for managing node styles."
        },
        {
            "displayName": "oop",
            "name": "oop",
            "description": "Adds object inheritance and manipulation utilities to the YUI instance. This\nmodule is required by most YUI components."
        },
        {
            "displayName": "overlay",
            "name": "overlay",
            "description": "Provides a basic Overlay widget, with Standard Module content support. The Overlay widget\nprovides Page XY positioning support, alignment and centering support along with basic \nstackable support (z-index and shimming)."
        },
        {
            "displayName": "panel",
            "name": "panel",
            "description": "Provides a Panel widget, a widget that mimics the functionality of a regular OS\nwindow. Comes with Standard Module support, XY Positioning, Alignment Support,\nStack (z-index) support, modality, auto-focus and auto-hide functionality, and\nheader/footer button support."
        },
        {
            "displayName": "parallel",
            "name": "parallel",
            "description": "A concurrent parallel processor to help in running several async functions."
        },
        {
            "displayName": "pjax",
            "name": "pjax",
            "description": "Provides seamless, gracefully degrading Pjax (pushState + Ajax) functionality,\nwhich makes it easy to progressively enhance standard links on the page so that\nthey can be loaded normally in old browsers, or via Ajax (with HTML5 history\nsupport) in newer browsers."
        },
        {
            "displayName": "pjax-base",
            "name": "pjax-base",
            "description": "`Y.Router` extension that provides the core plumbing for enhanced navigation\nimplemented using the pjax technique (HTML5 pushState + Ajax)."
        },
        {
            "displayName": "pjax-plugin",
            "name": "pjax-plugin",
            "description": "Node plugin that provides seamless, gracefully degrading pjax functionality."
        },
        {
            "displayName": "plugin",
            "name": "plugin",
            "description": "Provides the base Plugin class, which plugin developers should extend, when creating custom plugins"
        },
        {
            "displayName": "pluginhost",
            "name": "pluginhost",
            "description": "Provides the augmentable PluginHost interface, which can be added to any class."
        },
        {
            "displayName": "pluginhost-base",
            "name": "pluginhost-base",
            "description": "Provides the augmentable PluginHost interface, which can be added to any class."
        },
        {
            "displayName": "pluginhost-config",
            "name": "pluginhost-config",
            "description": "Adds pluginhost constructor configuration and static configuration support"
        },
        {
            "displayName": "profiler",
            "name": "profiler",
            "description": "The YUI JavaScript profiler."
        },
        {
            "displayName": "querystring",
            "name": "querystring",
            "description": "The QueryString module adds support for serializing JavaScript objects into\nquery strings and parsing JavaScript objects from query strings format.\n\nThe QueryString namespace is added to your YUI instance including static methods\n`Y.QueryString.parse(..)` and `Y.QueryString.stringify(..)`.\n\nThe `querystring` module is a alias for `querystring-parse` and\n`querystring-stringify`.\n\nAs their names suggest, `querystring-parse` adds support for parsing\nQuery String data (`Y.QueryString.parse`) and `querystring-stringify` for serializing\nJavaScript data into Query Strings (`Y.QueryString.stringify`).  You may choose to\ninclude either of the submodules individually if you don't need the\ncomplementary functionality, or include the rollup for both."
        },
        {
            "displayName": "querystring-parse",
            "name": "querystring-parse",
            "description": "Provides Y.QueryString.parse method to accept Query Strings and return native\nJavaScript objects."
        },
        {
            "displayName": "querystring-parse-simple",
            "name": "querystring-parse-simple",
            "description": "<p>Provides Y.QueryString.stringify method for converting objects to Query Strings.\nThis is a simpler implementation than the full querystring-stringify.</p>\n<p>Because some things may require basic query string escaping functionality,\nthis module provides the bare minimum functionality (decoding a hash of simple values),\nwithout the additional support for arrays, objects, and so on.</p>\n<p>This provides a friendly way to deserialize basic query strings, without necessitating\na lot of code for simple use-cases.</p>"
        },
        {
            "displayName": "querystring-stringify",
            "name": "querystring-stringify",
            "description": "Provides Y.QueryString.stringify method for converting objects to Query Strings."
        },
        {
            "displayName": "querystring-stringify-simple",
            "name": "querystring-stringify-simple",
            "description": "<p>Provides Y.QueryString.stringify method for converting objects to Query Strings.\nThis is a subset implementation of the full querystring-stringify.</p>\n<p>This module provides the bare minimum functionality (encoding a hash of simple values),\nwithout the additional support for nested data structures.  Every key-value pair is\nencoded by encodeURIComponent.</p>\n<p>This module provides a minimalistic way for io to handle  single-level objects\nas transaction data.</p>"
        },
        {
            "displayName": "queue-promote",
            "name": "queue-promote",
            "description": "Adds methods promote, remove, and indexOf to Queue instances."
        },
        {
            "displayName": "range-slider",
            "name": "range-slider",
            "description": "Create a sliding value range input visualized as a draggable thumb on a\nbackground rail element."
        },
        {
            "displayName": "recordset",
            "name": "recordset",
            "description": "The Recordset utility provides a standard way for dealing with\na collection of similar objects."
        },
        {
            "displayName": "recordset-base",
            "name": "recordset-base",
            "description": "The Recordset utility provides a standard way for dealing with\na collection of similar objects."
        },
        {
            "displayName": "recordset-filter",
            "name": "recordset-filter",
            "description": "Plugin that provides the ability to filter through a recordset.\nUses the filter methods available on Y.Array (see arrayextras submodule) to filter the recordset."
        },
        {
            "displayName": "recordset-indexer",
            "name": "recordset-indexer",
            "description": "Provides the ability to store multiple custom hash tables referencing records in the recordset."
        },
        {
            "displayName": "recordset-sort",
            "name": "recordset-sort",
            "description": "Adds default and custom sorting functionality to the Recordset utility"
        },
        {
            "displayName": "resize",
            "name": "resize",
            "description": "The Resize Utility allows you to make an HTML element resizable."
        },
        {
            "displayName": "resize-contrain",
            "name": "resize-contrain",
            "description": "A Resize plugin that will attempt to constrain the resize node to the boundaries."
        },
        {
            "displayName": "resize-plugin",
            "name": "resize-plugin",
            "description": "The Resize Plugin allows you to make a Node or a Widget resizable. It supports all the functionality of\nthe standalone Resize utility. Additionally, resizing a widget updates the widget's height,width and x,y\nattributes, if they exist.\n\n\n       var overlay = new Y.Overlay({\n          width: \"200px\",\n          srcNode: \"#overlay\",\n          visible: false,\n          align: {node:\".example\", points:[\"tc\", \"bc\"]}\n       });\n       overlay.plug(Y.Plugin.Resize);"
        },
        {
            "displayName": "resize-proxy",
            "name": "resize-proxy",
            "description": "Adds a `proxyNode` attribute and resizes it instead of the actual node. __very similar to DDProxy__\n\n    var resize = new Y.Resize({\n        //Selector of the node to resize\n        node: '#demo'\n    });\n    resize.plug(Y.Plugin.ResizeProxy);"
        },
        {
            "displayName": "rollup",
            "name": "rollup",
            "description": "Optional automatic rollup logic for reducing http connections\nwhen not using a combo service."
        },
        {
            "displayName": "router",
            "name": "router",
            "description": "Provides URL-based routing using HTML5 `pushState()` or the location hash."
        },
        {
            "displayName": "scrollview",
            "name": "scrollview",
            "description": "<p>\nThe scrollview module does not add any new classes. It simply plugs the ScrollViewScrollbars plugin into the \nbase ScrollView class implementation provided by the scrollview-base module, so that all scrollview instances \nhave scrollbars enabled.\n</p>\n\n<ul>\n    <li><a href=\"../classes/ScrollView.html\">ScrollView API documentation</a></li>\n    <li><a href=\"scrollview-base.html\">scrollview-base Module documentation</a></li>\n</ul>"
        },
        {
            "displayName": "scrollview-base",
            "name": "scrollview-base",
            "description": "The scrollview-base module provides a basic ScrollView Widget, without scrollbar indicators"
        },
        {
            "displayName": "scrollview-base-ie",
            "name": "scrollview-base-ie",
            "description": "IE specific support for the scrollview-base module."
        },
        {
            "displayName": "scrollview-list",
            "name": "scrollview-list",
            "description": "Provides a plugin, which adds support for a scroll indicator to ScrollView instances"
        },
        {
            "displayName": "scrollview-paginator",
            "name": "scrollview-paginator",
            "description": "Provides a plugin, which adds pagination support to ScrollView instances"
        },
        {
            "displayName": "scrollview-scrollbars",
            "name": "scrollview-scrollbars",
            "description": "Provides a plugin, which adds support for a scroll indicator to ScrollView instances"
        },
        {
            "displayName": "selection",
            "name": "selection",
            "description": "Wraps some common Selection/Range functionality into a simple object"
        },
        {
            "displayName": "selector-css2",
            "name": "selector-css2",
            "description": "The selector module provides helper methods allowing CSS2 Selectors to be used with DOM elements."
        },
        {
            "displayName": "selector-css3",
            "name": "selector-css3",
            "description": "The selector css3 module provides support for css3 selectors."
        },
        {
            "displayName": "selector-native",
            "name": "selector-native",
            "description": "The selector-native module provides support for native querySelector"
        },
        {
            "displayName": "shim-plugin",
            "name": "shim-plugin",
            "description": "Provides shimming support for Node via a Plugin.\nThis fixes SELECT bleedthrough for IE6 & Mac scrollbars"
        },
        {
            "displayName": "slider",
            "name": "slider",
            "description": "Create a sliding value range input visualized as a draggable thumb on a\nbackground rail element."
        },
        {
            "displayName": "slider-base",
            "name": "slider-base",
            "description": "Create a sliding value range input visualized as a draggable thumb on a\nbackground element."
        },
        {
            "displayName": "slider-value-range",
            "name": "slider-value-range",
            "description": "Adds value support for Slider as a range of integers between a configured\nminimum and maximum value.  For use with <code>Y.Base.build(..)</code> to\nadd the plumbing to <code>Y.SliderBase</code>."
        },
        {
            "displayName": "sortable",
            "name": "sortable",
            "description": "The class allows you to create a Drag & Drop reordered list."
        },
        {
            "displayName": "sortable-scroll",
            "name": "sortable-scroll",
            "description": "Plugin for sortable to handle scrolling lists."
        },
        {
            "displayName": "stylesheet",
            "name": "stylesheet",
            "description": "The StyleSheet component is a module for creating and modifying CSS\nstylesheets."
        },
        {
            "displayName": "substitute",
            "name": "substitute",
            "description": "String variable substitution and string formatting.\nIf included, the substitute method is added to the YUI instance."
        },
        {
            "displayName": "swf",
            "name": "swf",
            "description": "Embed a Flash applications in a standard manner and communicate with it\nvia External Interface."
        },
        {
            "displayName": "swfdetect",
            "name": "swfdetect",
            "description": "Utility for Flash version detection"
        },
        {
            "displayName": "tabview",
            "name": "tabview",
            "description": "The TabView module"
        },
        {
            "displayName": "test",
            "name": "test",
            "description": "YUI Test Framework"
        },
        {
            "displayName": "test-console",
            "name": "test-console",
            "description": "Provides a specialized log console widget that's pre-configured to display YUI\nTest output with no extra configuration."
        },
        {
            "displayName": "text",
            "name": "text",
            "description": "Text utilities."
        },
        {
            "displayName": "text-accentfold",
            "name": "text-accentfold",
            "description": "Provides a basic accent folding implementation that converts common accented\nletters (like \"á\") to their non-accented forms (like \"a\")."
        },
        {
            "displayName": "text-wordbreak",
            "name": "text-wordbreak",
            "description": "Provides utility methods for splitting strings on word breaks and determining\nwhether a character index represents a word boundary."
        },
        {
            "displayName": "transition",
            "name": "transition",
            "description": "Provides the transition method for Node.\nTransition has no API of its own, but adds the transition method to Node."
        },
        {
            "displayName": "uploader",
            "name": "uploader",
            "description": "Provides UI for selecting multiple files and functionality for \nuploading multiple files to the server with support for either\nhtml5 or Flash transport mechanisms, automatic queue management,\nupload progress monitoring, and error events."
        },
        {
            "displayName": "uploader-deprecated",
            "name": "uploader-deprecated",
            "description": "Attention: this is the 3.4.1 `uploader` module has been deprecated in favor of a new \nuploader with an HTML5 layer. Please refer to the new Uploader User Guide for migration \ninformation.\n\nThis module uses Flash player transport to upload files to the server, with support for \nfile filtering, multiple file uploads and progress monitoring."
        },
        {
            "displayName": "uploader-flash",
            "name": "uploader-flash",
            "description": "This module provides a UI for file selection and multiple file upload capability using\nFlash as a transport engine.\nThe supported features include: automatic upload queue management, upload progress\ntracking, file filtering, server response retrieval and error reporting."
        },
        {
            "displayName": "uploader-html5",
            "name": "uploader-html5",
            "description": "This module provides a UI for file selection and multiple file upload capability using\nHTML5 XMLHTTPRequest Level 2 as a transport engine.\nThe supported features include: automatic upload queue management, upload progress\ntracking, drag-and-drop support, server response retrieval and error reporting."
        },
        {
            "displayName": "uploader-queue",
            "name": "uploader-queue",
            "description": "The class manages a queue of files that should be uploaded to the server.\nIt initializes the required number of uploads, tracks them as they progress,\nand automatically advances to the next upload when a preceding one has completed."
        },
        {
            "displayName": "view",
            "name": "view",
            "description": "Represents a logical piece of an application's user interface, and provides a\nlightweight, overridable API for rendering content and handling delegated DOM\nevents on a container element."
        },
        {
            "displayName": "view-node-map",
            "name": "view-node-map",
            "description": "View extension that adds a static `getByNode()` method that returns the nearest\nView instance associated with the given Node (similar to Widget's `getByNode()`\nmethod)."
        },
        {
            "displayName": "widget",
            "name": "widget",
            "description": "Provides the base Widget class, with HTML Parser support"
        },
        {
            "displayName": "widget-anim",
            "name": "widget-anim",
            "description": "Provides a plugin which can be used to animate widget visibility changes."
        },
        {
            "displayName": "widget-autohide",
            "name": "widget-autohide",
            "description": "A widget-level extension that provides ability to hide widget when\ncertain events occur."
        },
        {
            "displayName": "widget-base",
            "name": "widget-base",
            "description": "Provides the base Widget class"
        },
        {
            "displayName": "widget-base-ie",
            "name": "widget-base-ie",
            "description": "IE specific support for the widget-base module."
        },
        {
            "displayName": "widget-buttons",
            "name": "widget-buttons",
            "description": "Provides header/body/footer button support for Widgets that use the\n`WidgetStdMod` extension."
        },
        {
            "displayName": "widget-child",
            "name": "widget-child",
            "description": "Extension enabling a Widget to be a child of another Widget."
        },
        {
            "displayName": "widget-htmlparser",
            "name": "widget-htmlparser",
            "description": "Adds HTML Parser support to the base Widget class"
        },
        {
            "displayName": "widget-locale",
            "name": "widget-locale",
            "description": "Provides string support for widget with BCP 47 language tag lookup. This module has been deprecated. It's replaced by the \"intl\" module which provides generic internationalization and BCP 47 language tag support with externalization."
        },
        {
            "displayName": "widget-modality",
            "name": "widget-modality",
            "description": "Provides modality support for Widgets, though an extension"
        },
        {
            "displayName": "widget-parent",
            "name": "widget-parent",
            "description": "Extension enabling a Widget to be a parent of another Widget."
        },
        {
            "displayName": "widget-position",
            "name": "widget-position",
            "description": "Provides basic XY positioning support for Widgets, though an extension"
        },
        {
            "displayName": "widget-position-align",
            "name": "widget-position-align",
            "description": "Provides extended/advanced XY positioning support for Widgets, through an\nextension.\n\nIt builds on top of the `widget-position` module, to provide alignment and\ncentering support. Future releases aim to add constrained and fixed positioning\nsupport."
        },
        {
            "displayName": "widget-position-constrain",
            "name": "widget-position-constrain",
            "description": "Provides constrained xy positioning support for Widgets, through an extension.\n\nIt builds on top of the widget-position module, to provide constrained positioning support."
        },
        {
            "displayName": "widget-skin",
            "name": "widget-skin",
            "description": "Provides skin related utlility methods."
        },
        {
            "displayName": "widget-stack",
            "name": "widget-stack",
            "description": "Provides stackable (z-index) support for Widgets through an extension."
        },
        {
            "displayName": "widget-stdmod",
            "name": "widget-stdmod",
            "description": "Provides standard module support for Widgets through an extension."
        },
        {
            "displayName": "widget-uievents",
            "name": "widget-uievents",
            "description": "Support for Widget UI Events (Custom Events fired by the widget, which wrap the underlying DOM events - e.g. widget:click, widget:mousedown)"
        },
        {
            "displayName": "yql",
            "name": "yql",
            "description": "This class adds a sugar class to allow access to YQL (http://developer.yahoo.com/yql/)."
        },
        {
            "displayName": "yui",
            "name": "yui"
        },
        {
            "displayName": "yui-base",
            "name": "yui-base",
            "description": "The YUI module contains the components required for building the\nYUI seed file.  This includes the script loading mechanism, a\nsimple queue, and the core utilities for the library."
        },
        {
            "displayName": "yui-later",
            "name": "yui-later",
            "description": "Provides a setTimeout/setInterval wrapper. This module is a `core` YUI module, <a href=\"../classes/YUI.html#method_later\">it's documentation is located under the YUI class</a>."
        },
        {
            "displayName": "yui-log",
            "name": "yui-log",
            "description": "Provides console log capability and exposes a custom event for\nconsole implementations. This module is a `core` YUI module, <a href=\"../classes/YUI.html#method_log\">it's documentation is located under the YUI class</a>."
        },
        {
            "displayName": "yui-throttle",
            "name": "yui-throttle",
            "description": "Throttles a call to a method based on the time between calls. This method is attached\nto the `Y` object and is <a href=\"../classes/YUI.html#method_throttle\">documented there</a>.\n\n    var fn = Y.throttle(function() {\n        counter++;\n    });\n\n    for (i; i< 35000; i++) {\n        out++;\n        fn();\n    }"
        },
        {
            "displayName": "yui3",
            "name": "yui3",
            "description": "YUI 3 module metadata"
        }
    ]
} };
});