/* SPDX-License-Identifier: BSD-2-Clause */
/*
 * Copyright (c) 2023 Infineon Technologies AG
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE
 */
#ifndef TCTI_I2C_FTDI_H
#define TCTI_I2C_FTDI_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdint.h>
#include <sys/time.h>

#include "tcti-common.h"
#include "tss2_tcti_i2c_helper.h"
#include "mpsse/mpsse.h"

/* The default 7-bit I2C device address defined by TCG */
#define I2C_DEV_ADDR_DEFAULT 0x2E

typedef struct {
    struct timeval timeout;
    struct mpsse_context *mpsse;
} PLATFORM_USERDATA;

#endif /* TCTI_I2C_FTDI_H */
