#ifndef INCLUDE_PBBCMD_H
#define INCLUDE_PBBCMD_H
/* ----------------------------------------------------------------------------
 * pbbcmd.h
 * prototypes and definitions for pbbcmd
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

/* short options for optarg */
#define ARG_ALL			"hvi"
#define ARG_HELP		'h'
#define ARG_VERSION		'v'
#define ARG_IGNORE		'i'

#define CMD_FLAGS		1
#define CMD_QUERY		2
#define CMD_CONFIG		3
#define CMD_LISTCLIENTS	4

struct tagtable {
	char *tagname;
	long tag;
};

/* public prototypes */

/* private prototypes */
void print_usage (char *prgname);
void print_cmds ();
void print_tags ();
int evaluate_args(int argc, char *argv[], struct tagitem *taglist);
int read_message (char *buffer, int bufferlen);
long identifytag (char *name);
long identifycmd (char *name);
char *identifytagname (long tag, char *defname);
char *identifyerror (long error, char *deferror);

#endif    /* INCLUDE_PBBCMD_H */
