/* ----------------------------------------------------------------------------
 * taglist.c
 * funtions to handle taglists
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include "pbbtaglist.h"

/* This function searches for a named 'tag' in 'taglist'. If the tag
   was found its data otherwise 'val' would be returned. */

tag_t
tagfind (struct tagitem *taglist, tag_t tag, tag_t val)
{
	while (taglist->tag != TAG_END) {
		if (taglist->tag == tag) {
			val = taglist->data;
			break;
		} else
			taglist++;
	}
	return val;
}

/* This function replaces a given Tag with TAG_SKIP. As result this Tag is
    deleted from the taglist. If taglist didn't contain Tag, nothing would be
    done*/

void
tagskip (struct tagitem *taglist, tag_t tag)
{
	while (taglist->tag != TAG_END) {
		if (taglist->tag == tag) {
			taglist->data = taglist->tag;
			taglist->tag = TAG_SKIP;
			break;
		} else
			taglist++;
	}
}

int
tagerror (struct tagitem *tag, int error)
{
	tag->data = (tag_t) error;
	tag->tag |= FLG_ERROR;
	return error;
}

/* This function initializes a taglist. */

void
taglist_init (struct tagitem *taglist)
{
	taglist->tag = TAG_END;
	taglist->data = 0;
}

/* This function adds a tagitem to an existing taglist. The taglist must be
   long enough for the new tag. No boundary checks are performed. */

void
taglist_add (struct tagitem *taglist, tag_t tag, tag_t val)
{
	while (taglist->tag != TAG_END)
		taglist++;     /* find end of taglist */

	taglist->tag = tag;     /* add tagitem */
	taglist->data = val;
	taglist++;
	taglist->tag = TAG_END;   /* mark end of taglist again */
	taglist->data = 0;
}

struct tagitem*
find_tagitem (struct tagitem *taglist, tag_t tag)
{
	while (taglist->tag != TAG_END && taglist->tag != tag)
		taglist++;
	if (taglist->tag == TAG_END)
		return 0;
	else
		return taglist;
}

int
taglist_count (struct tagitem *taglist)
{
	int n = 0;
	while (taglist->tag != TAG_END) {
		n++; taglist++;
	}
	return n;
}
