/*
 * Copyright 2015 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 *
 */

#ifndef VisualBenchmarkStream_DEFINED
#define VisualBenchmarkStream_DEFINED

#include "Benchmark.h"
#include "gm.h"
#include "SkCommandLineFlags.h"
#include "SkPicture.h"

DECLARE_string(match);

class VisualBenchmarkStream {
public:
    VisualBenchmarkStream(const SkSurfaceProps&, bool justSKP = false);

    static bool ReadPicture(const char* path, SkAutoTUnref<SkPicture>* pic);

    Benchmark* next();
    Benchmark* current() { return fBenchmark.get(); }

private:
    Benchmark* innerNext();

    SkSurfaceProps fSurfaceProps;
    const BenchRegistry* fBenches;
    const skiagm::GMRegistry* fGMs;
    SkTArray<SkString> fSKPs;
    SkAutoTUnref<Benchmark> fBenchmark;

    const char* fSourceType;  // What we're benching: bench, GM, SKP, ...
    const char* fBenchType;   // How we bench it: micro, playback, ...
    int fCurrentSKP;
    bool fIsWarmedUp;
};

#endif
