/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <cstring>

#include "FB2Token.h"

using std::strlen;

namespace libebook
{
namespace
{

#include "FB2Token.inc"

}
}

namespace libebook
{

const FB2TokenData *getFB2Token(const char *const str, const unsigned length)
{
  if (!str)
    return 0;
  return reinterpret_cast<const FB2TokenData *>(Perfect_Hash::in_word_set(str, length));
}

const FB2TokenData *getFB2Token(const char *const str)
{
  if (!str)
    return 0;
  return getFB2Token(str, (unsigned) strlen(str));
}

const FB2TokenData *getFB2Token(const unsigned char *const str)
{
  if (!str)
    return 0;
  return getFB2Token(reinterpret_cast<const char *>(str));
}

int getFB2TokenID(const FB2TokenData &token)
{
  return getFB2TokenID(&token);
}

int getFB2TokenID(const FB2TokenData *const token)
{
  return token ? token->id : INVALID_TOKEN;
}

int getFB2TokenID(const char *str, const unsigned length)
{
  return getFB2TokenID(getFB2Token(str, length));
}

int getFB2TokenID(const char *str)
{
  if (!str)
    return 0;
  return getFB2TokenID(str, (unsigned) strlen(str));
}

int getFB2TokenID(const unsigned char *str)
{
  return getFB2TokenID(reinterpret_cast<const char *>(str));
}

const char *getFB2TokenName(const FB2TokenData &token)
{
  return getFB2TokenName(&token);
}

const char *getFB2TokenName(const FB2TokenData *const token)
{
  return token ? token->name : 0;
}

const char *getFB2TokenName(const char *str, const unsigned length)
{
  return getFB2TokenName(getFB2Token(str, length));
}

const char *getFB2TokenName(const char *str)
{
  return getFB2TokenName(str, (unsigned) strlen(str));
}

const char *getFB2TokenName(const unsigned char *str)
{
  return getFB2TokenName(reinterpret_cast<const char *>(str));
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
