/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef IMPPARSER_H_INCLUDED
#define IMPPARSER_H_INCLUDED

#include <boost/shared_ptr.hpp>

#include "IMPCollector.h"
#include "IMPHeader.h"

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

class IMPParser
{
  // disable copying
  IMPParser(const IMPParser &);
  IMPParser &operator=(const IMPParser &);

public:
  IMPParser(WPXInputStream *input, WPXDocumentInterface *document);

  bool parse();

private:
  void createTextStream();

  boost::shared_ptr<WPXInputStream> getFileStream(const char *name) const;

private:
  const IMPHeader m_header;
  WPXInputStream *const m_input;
  IMPCollector m_collector;
  boost::shared_ptr<WPXInputStream> m_resources;
  boost::shared_ptr<WPXInputStream> m_text;
};

}

#endif // IMPPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
