/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.*;
import com.sun.star.uno.*;


/**
 */
public class ToolTip extends Component implements javax.accessibility.Accessible {
    protected ToolTip(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    /** Creates the AccessibleContext associated with this object */
    public javax.accessibility.AccessibleContext createAccessibleContext() {
        return new AccessibleToolTip();
    }

    protected class AccessibleToolTip extends AccessibleUNOComponent {

        /*
        * AccessibleContext
        */

        /** Gets the role of this object */
        public javax.accessibility.AccessibleRole getAccessibleRole() {
            return javax.accessibility.AccessibleRole.TOOL_TIP;
        }

        /** Gets the AccessibleText associated with this object presenting text on the display */
        public javax.accessibility.AccessibleText getAccessibleText() {

            if (disposed)
                return null;

            try {
                XAccessibleText unoAccessibleText = UnoRuntime.queryInterface(XAccessibleText.class,
                        unoAccessibleComponent);

                if (unoAccessibleText != null) {
                    return new AccessibleTextImpl(unoAccessibleText);
                } else {
                    return null;
                }
            } catch (com.sun.star.uno.RuntimeException e) {
                return null;
            }
        }

        /** Returns the relation set of this object */

        /*
                        public javax.accessibility.AccessibleRelationSet getAccessibleRelationSet() {
                                try {
                                        XAccessibleRelationSet unoAccessibleRelationSet = unoAccessibleContext.getAccessibleRelationSet();
                                        if (unoAccessibleRelationSet == null) {
                                                return null;
                                        }

                                        javax.accessibility.AccessibleRelationSet relationSet = new javax.accessibility.AccessibleRelationSet();
                                        int count = unoAccessibleRelationSet.getRelationCount();
                                        for (int i = 0; i < count; i++) {
                                                AccessibleRelation unoAccessibleRelation = unoAccessibleRelationSet.getRelation(i);
                                                switch (unoAccessibleRelation.RelationType) {
                                                        case AccessibleRelationType.LABEL_FOR:
                                                                relationSet.add(new javax.accessibility.AccessibleRelation(
                                                                        javax.accessibility.AccessibleRelation.LABEL_FOR,
                                                                        getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                                                                break;
                                                        case AccessibleRelationType.MEMBER_OF:
                                                                relationSet.add(new javax.accessibility.AccessibleRelation(
                                                                        javax.accessibility.AccessibleRelation.MEMBER_OF,
                                                                        getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                                                                break;
                                                        default:
                                                                break;
                                                }
                                        }
                                        return relationSet;
                                } catch (com.sun.star.lang.IndexOutOfBoundsException e) {
                                        return null;
                                } catch (com.sun.star.uno.RuntimeException e) {
                                        return null;
                                }
                        }
        */
    }
}
