/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.xml.sax.SAXParseException;

public class Logger {
    private String m_aFileName;
    private String m_aEntryName;
    private PrintStream m_aOut;
    private int m_nErrors;
    private int m_nWarnings;
    private LogLevel m_nLevel;
    private Logger m_aParentLogger;
    private InputStream m_aEntryContent;
    private static final String INFO_PREFIX = "Info:";
    private static final String WARNING_PREFIX = "Warning:";
    private static final String ERROR_PREFIX = "Error:";
    private static final String FATAL_PREFIX = "Fatal:";
    private static boolean m_isHTMLEnabled;

    Logger(String aFileName, String aEntryName, PrintStream aOut, LogLevel nLevel) {
        this.m_aFileName = aFileName;
        this.m_aEntryName = aEntryName;
        this.m_aOut = aOut;
        this.m_nLevel = nLevel;
        this.m_nErrors = 0;
        this.m_nWarnings = 0;
        this.m_aParentLogger = null;
    }

    Logger(String aEntryName, Logger aParentLogger) {
        this.m_aFileName = aParentLogger.m_aFileName;
        this.m_aEntryName = aEntryName;
        this.m_aOut = aParentLogger.m_aOut;
        this.m_nLevel = aParentLogger.m_nLevel;
        this.m_nErrors = 0;
        this.m_nWarnings = 0;
        this.m_aParentLogger = aParentLogger;
    }

    static void enableHTML(boolean isHTMLEnabled) {
        m_isHTMLEnabled = isHTMLEnabled;
    }

    public PrintStream getOutputStream() {
        return this.m_aOut;
    }

    public void setOutputStream(PrintStream aOut) {
        this.m_aOut = aOut;
    }

    public void setInputStream(InputStream aIn) {
        if (aIn != null && aIn.markSupported()) {
            aIn.mark(Integer.MAX_VALUE);
        }
        this.m_aEntryContent = aIn;
    }

    boolean hasError() {
        return this.m_nErrors > 0;
    }

    boolean hasWarning() {
        return this.m_nWarnings > 0;
    }

    int getErrorCount() {
        return this.m_nErrors;
    }

    int getWarningCount() {
        return this.m_nWarnings;
    }

    void logWarning(String aMsg) {
        if (this.m_nLevel.compareTo(LogLevel.WARNING) >= 0) {
            if (m_isHTMLEnabled) {
                this.m_aOut.print("<span class='warning'>");
            }
            this.logMessage(WARNING_PREFIX, aMsg);
        }
        this.incWarnings();
    }

    void logFatalError(String aMsg) {
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='fatalError'>");
        }
        this.logMessage(FATAL_PREFIX, aMsg);
        this.incErrors();
    }

    void logError(String aMsg) {
        if (this.m_nLevel.compareTo(LogLevel.ERROR) >= 0) {
            if (m_isHTMLEnabled) {
                this.m_aOut.print("<span class='error'>");
            }
            this.logMessage(ERROR_PREFIX, aMsg);
        }
        this.incErrors();
    }

    void logInfo(String aMsg, boolean bForceOutput) {
        if (this.m_nLevel.compareTo(LogLevel.INFO) >= 0 || bForceOutput) {
            if (m_isHTMLEnabled) {
                this.m_aOut.print("<span class='info'>");
            }
            this.logMessage(INFO_PREFIX, aMsg);
        }
    }

    void logWarning(SAXParseException e) {
        if (this.m_nLevel.compareTo(LogLevel.WARNING) >= 0) {
            if (m_isHTMLEnabled) {
                this.m_aOut.print("<span class='warning'>");
            }
            this.logMessage(WARNING_PREFIX, e);
        }
        this.incWarnings();
    }

    void logFatalError(SAXParseException e) {
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='fatalError'>");
        }
        this.logMessage(FATAL_PREFIX, e);
        this.incErrors();
    }

    void logError(SAXParseException e) {
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='error'>");
        }
        if (this.m_nLevel.compareTo(LogLevel.ERROR) >= 0) {
            this.logMessage(ERROR_PREFIX, e);
        }
        this.incErrors();
    }

    void logSummaryInfo() {
        this.logInfo((this.hasError() ? Integer.valueOf(this.getErrorCount()) : "no") + " errors, " + (this.hasWarning() ? Integer.valueOf(this.getWarningCount()) : "no") + " warnings", false);
    }

    private void printFileEntryPrefix() {
        this.m_aOut.print(this.m_aFileName);
        if (this.m_aEntryName != null && this.m_aEntryName.length() > 0) {
            this.m_aOut.print("/");
            this.m_aOut.print(this.m_aEntryName);
        }
    }

    private void logMessage(String aPrefix, SAXParseException e) {
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='filePath'>");
        }
        this.printFileEntryPrefix();
        this.m_aOut.print("[");
        this.m_aOut.print(e.getLineNumber());
        this.m_aOut.print(",");
        this.m_aOut.print(e.getColumnNumber());
        this.m_aOut.print("]:  ");
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span>");
        }
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='messageType'>");
        }
        this.m_aOut.print(aPrefix);
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span>");
        }
        this.m_aOut.print(" " + e.getMessage());
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span></br>");
        }
        this.m_aOut.println();
        if (this.m_aEntryContent != null) {
            try {
                this.m_aEntryContent.reset();
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_aEntryContent));
                for (int l = 0; l < e.getLineNumber() - 1; ++l) {
                    reader.readLine();
                }
                String errorLine = reader.readLine();
                int len = errorLine.length();
                if (len > 80) {
                    this.m_aOut.println(errorLine.substring(Math.max(0, e.getColumnNumber() - 40), Math.min(len - 1, e.getColumnNumber() + 39)));
                    this.m_aOut.println(String.format("%1$38s", "----^"));
                } else {
                    this.m_aOut.println(errorLine);
                    this.m_aOut.println(String.format("%1$" + Math.max(0, e.getColumnNumber() - 2) + "s", "----^"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void logMessage(String aPrefix, String aMsg) {
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='filePath'>");
        }
        this.printFileEntryPrefix();
        this.m_aOut.print(":  ");
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span>");
        }
        if (m_isHTMLEnabled) {
            this.m_aOut.print("<span class='messageType'>");
        }
        this.m_aOut.print(aPrefix);
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span>");
        }
        this.m_aOut.print(" " + aMsg);
        if (m_isHTMLEnabled) {
            this.m_aOut.print("</span></br>");
        }
        this.m_aOut.println();
    }

    private void incErrors() {
        ++this.m_nErrors;
        if (this.m_aParentLogger != null) {
            this.m_aParentLogger.incErrors();
        }
    }

    private void incWarnings() {
        ++this.m_nWarnings;
        if (this.m_aParentLogger != null) {
            this.m_aParentLogger.incWarnings();
        }
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO;

    }
}

