/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi;

import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

class SystemPropertyLogConfigurator {
    private static Category jiapiRoot = Category.getInstance((String)"alt.jiapi");
    private static boolean initialized = false;

    SystemPropertyLogConfigurator() {
    }

    static void configure() {
        if (initialized) {
            return;
        }
        jiapiRoot.addAppender(SystemPropertyLogConfigurator.getAppender());
        jiapiRoot.setPriority(Priority.FATAL);
        if (System.getProperty("alt.jiapi.debug") != null) {
            SystemPropertyLogConfigurator.initialize(System.getProperty("alt.jiapi.debug"), Priority.DEBUG);
        }
        if (System.getProperty("alt.jiapi.trace") != null) {
            SystemPropertyLogConfigurator.initialize(System.getProperty("alt.jiapi.trace"), Priority.INFO);
        }
        initialized = true;
    }

    static Appender getAppender() {
        ConsoleAppender ca = new ConsoleAppender((Layout)new PatternLayout("[%c] %-5p : %m\n"));
        ca.setName("ConsoleAppender");
        ca.setTarget("System.out");
        return ca;
    }

    static Category getJiapiRoot() {
        return jiapiRoot;
    }

    private static void initialize(String categoryNames, Priority logLevel) {
        if (categoryNames.trim().equals("")) {
            jiapiRoot.setPriority(logLevel);
        } else {
            StringTokenizer st = new StringTokenizer(categoryNames, ",");
            while (st.hasMoreTokens()) {
                String c = st.nextToken().trim();
                Category cat = Category.getInstance((String)c);
                cat.setPriority(logLevel);
            }
        }
    }
}

