; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-64
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-64
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-aix \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-32
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-aix \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-64

define dso_local signext i32 @test_builtin_ppc_mulhw(i32 %a, i32%b) {
; CHECK-32-LABEL: test_builtin_ppc_mulhw:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mulhw 3, 3, 4
; CHECK-32-NEXT:    blr
;
; CHECK-64-LABEL: test_builtin_ppc_mulhw:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mulhw 3, 3, 4
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
entry:
  %0 = call i32 @llvm.ppc.mulhw(i32 %a, i32 %b)
  ret i32 %0
}

declare i32 @llvm.ppc.mulhw(i32, i32)

define dso_local zeroext i32 @test_builtin_ppc_mulhwu(i32 %a, i32%b) {
; CHECK-32-LABEL: test_builtin_ppc_mulhwu:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    mulhwu 3, 3, 4
; CHECK-32-NEXT:    blr
;
; CHECK-64-LABEL: test_builtin_ppc_mulhwu:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    mulhwu 3, 3, 4
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    blr
entry:
  %0 = call i32 @llvm.ppc.mulhwu(i32 %a, i32 %b)
  ret i32 %0
}

declare i32 @llvm.ppc.mulhwu(i32, i32)
