/* SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright(c) 2020-2021 Xilinx, Inc.
 */

#ifndef	_SYS_EFX_REGS_COUNTERS_PKT_FORMAT_H
#define	_SYS_EFX_REGS_COUNTERS_PKT_FORMAT_H

/*
 * Packetiser packet format definition.
 * SF-122415-TC - OVS Counter Design Specification section 7
 * Primary copy of the header is located in the smartnic_registry repo:
 * src/ovs_counter/packetiser_packet_format.h
 */

/*------------------------------------------------------------*/
/*
 * ER_RX_SL_PACKETISER_HEADER_WORD(160bit):
 *
 */
#define	ER_RX_SL_PACKETISER_HEADER_WORD_SIZE 20

#define	ERF_SC_PACKETISER_HEADER_VERSION_LBN 0
#define	ERF_SC_PACKETISER_HEADER_VERSION_WIDTH 8
/* Deprecated, use ERF_SC_PACKETISER_HEADER_VERSION_2 instead */
#define	ERF_SC_PACKETISER_HEADER_VERSION_VALUE 2
#define	ERF_SC_PACKETISER_HEADER_VERSION_2 2
#define	ERF_SC_PACKETISER_HEADER_IDENTIFIER_LBN 8
#define	ERF_SC_PACKETISER_HEADER_IDENTIFIER_WIDTH 8
#define	ERF_SC_PACKETISER_HEADER_IDENTIFIER_AR 0
#define	ERF_SC_PACKETISER_HEADER_IDENTIFIER_CT 1
#define	ERF_SC_PACKETISER_HEADER_HEADER_OFFSET_LBN 16
#define	ERF_SC_PACKETISER_HEADER_HEADER_OFFSET_WIDTH 8
#define	ERF_SC_PACKETISER_HEADER_HEADER_OFFSET_DEFAULT 0x4
#define	ERF_SC_PACKETISER_HEADER_PAYLOAD_OFFSET_LBN 24
#define	ERF_SC_PACKETISER_HEADER_PAYLOAD_OFFSET_WIDTH 8
#define	ERF_SC_PACKETISER_HEADER_PAYLOAD_OFFSET_DEFAULT 0x14
#define	ERF_SC_PACKETISER_HEADER_INDEX_LBN 32
#define	ERF_SC_PACKETISER_HEADER_INDEX_WIDTH 16
#define	ERF_SC_PACKETISER_HEADER_COUNT_LBN 48
#define	ERF_SC_PACKETISER_HEADER_COUNT_WIDTH 16
#define	ERF_SC_PACKETISER_HEADER_RESERVED_0_LBN 64
#define	ERF_SC_PACKETISER_HEADER_RESERVED_0_WIDTH 32
#define	ERF_SC_PACKETISER_HEADER_RESERVED_1_LBN 96
#define	ERF_SC_PACKETISER_HEADER_RESERVED_1_WIDTH 32
#define	ERF_SC_PACKETISER_HEADER_RESERVED_2_LBN 128
#define	ERF_SC_PACKETISER_HEADER_RESERVED_2_WIDTH 32


/*------------------------------------------------------------*/
/*
 * ER_RX_SL_PACKETISER_PAYLOAD_WORD(128bit):
 *
 */
#define	ER_RX_SL_PACKETISER_PAYLOAD_WORD_SIZE 16

#define	ERF_SC_PACKETISER_PAYLOAD_COUNTER_INDEX_LBN 0
#define	ERF_SC_PACKETISER_PAYLOAD_COUNTER_INDEX_WIDTH 24
#define	ERF_SC_PACKETISER_PAYLOAD_RESERVED_LBN 24
#define	ERF_SC_PACKETISER_PAYLOAD_RESERVED_WIDTH 8
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_OFST 4
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_SIZE 6
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_LBN 32
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_WIDTH 48
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_LO_OFST 4
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_LO_SIZE 4
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_LO_LBN 32
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_LO_WIDTH 32
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_HI_OFST 8
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_HI_SIZE 2
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_HI_LBN 64
#define	ERF_SC_PACKETISER_PAYLOAD_PACKET_COUNT_HI_WIDTH 16
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_OFST 10
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_SIZE 6
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_LBN 80
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_WIDTH 48
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_LO_OFST 10
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_LO_SIZE 2
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_LO_LBN 80
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_LO_WIDTH 16
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_HI_OFST 12
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_HI_SIZE 4
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_HI_LBN 96
#define	ERF_SC_PACKETISER_PAYLOAD_BYTE_COUNT_HI_WIDTH 32


#endif /* _SYS_EFX_REGS_COUNTERS_PKT_FORMAT_H */
