// Copyright Gautam Sewani 2008
// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Test data generated by Mathematica, 104 values are commented out because they have only a low
// absolute error, not a low relative error.
//
#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
  static const boost::array<boost::array<T, 8>, 398-105> hypergeometric_test_data = {{
     //{{SC_(1.0),SC_(1.0),SC_(2.0),SC_(1.0),SC_(0.5),SC_(1.0),SC_(0.e-40)}},
     {{SC_(5.0),SC_(4.0),SC_(6.0),SC_(3.0),SC_(0.6666666666666666666666666666666666666667),SC_(0.6666666666666666666666666666666666666667),SC_(0.3333333333333333333333333333333333333333)}},
     //{{SC_(5.0),SC_(3.0),SC_(13.0),SC_(3.0),SC_(0.03496503496503496503496503496503496503497),SC_(1.0),SC_(0.e-40)}},
     {{SC_(5.0),SC_(3.0),SC_(13.0),SC_(1.0),SC_(0.4895104895104895104895104895104895104895),SC_(0.6853146853146853146853146853146853146853),SC_(0.3146853146853146853146853146853146853147)}},
     {{SC_(5.0),SC_(3.0),SC_(13.0),SC_(1.0),SC_(0.4895104895104895104895104895104895104895),SC_(0.6853146853146853146853146853146853146853),SC_(0.3146853146853146853146853146853146853147)}},
     //{{SC_(1.0),SC_(3.0),SC_(13.0),SC_(1.0),SC_(0.2307692307692307692307692307692307692308),SC_(1.0),SC_(0.e-40)}},
     {{SC_(11.0),SC_(9.0),SC_(13.0),SC_(7.0),SC_(0.4615384615384615384615384615384615384615),SC_(0.4615384615384615384615384615384615384615),SC_(0.5384615384615384615384615384615384615385)}},
     {{SC_(11.0),SC_(9.0),SC_(13.0),SC_(8.0),SC_(0.4615384615384615384615384615384615384615),SC_(0.9230769230769230769230769230769230769231),SC_(0.0769230769230769230769230769230769230769)}},
     {{SC_(3.0),SC_(9.0),SC_(13.0),SC_(1.0),SC_(0.1888111888111888111888111888111888111888),SC_(0.2027972027972027972027972027972027972028),SC_(0.7972027972027972027972027972027972027972)}},
     //{{SC_(3.0),SC_(9.0),SC_(13.0),SC_(3.0),SC_(0.2937062937062937062937062937062937062937),SC_(1.0),SC_(0.e-40)}},
     {{SC_(3.0),SC_(9.0),SC_(13.0),SC_(1.0),SC_(0.1888111888111888111888111888111888111888),SC_(0.2027972027972027972027972027972027972028),SC_(0.7972027972027972027972027972027972027972)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(14.0),SC_(0.3401288366805608184918529746115953012505),SC_(0.5445497031703928255652393583428066186687),SC_(0.4554502968296071744347606416571933813313)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(14.0),SC_(0.3401288366805608184918529746115953012505),SC_(0.5445497031703928255652393583428066186687),SC_(0.4554502968296071744347606416571933813313)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(17.0),SC_(0.02400909435392194012883668056081849185297),SC_(0.9984438549955791335101679929266136162688),SC_(0.0015561450044208664898320070733863837312)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(12.0),SC_(0.03126436781609195402298850574712643678161),SC_(0.03126436781609195402298850574712643678161),SC_(0.9687356321839080459770114942528735632184)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(13.0),SC_(0.1731564986737400530503978779840848806366),SC_(0.2044208664898320070733863837312113174182),SC_(0.7955791335101679929266136162687886825818)}},
     {{SC_(24.0),SC_(18.0),SC_(30.0),SC_(13.0),SC_(0.1731564986737400530503978779840848806366),SC_(0.2044208664898320070733863837312113174182),SC_(0.7955791335101679929266136162687886825818)}},
     {{SC_(4.0),SC_(18.0),SC_(30.0),SC_(3.0),SC_(0.357307060755336617405582922824302134647),SC_(0.8883415435139573070607553366174055829228),SC_(0.1116584564860426929392446633825944170772)}},
     {{SC_(4.0),SC_(18.0),SC_(30.0),SC_(3.0),SC_(0.357307060755336617405582922824302134647),SC_(0.8883415435139573070607553366174055829228),SC_(0.1116584564860426929392446633825944170772)}},
     {{SC_(4.0),SC_(18.0),SC_(30.0),SC_(2.0),SC_(0.3684729064039408866995073891625615763547),SC_(0.5310344827586206896551724137931034482759),SC_(0.4689655172413793103448275862068965517241)}},
     {{SC_(4.0),SC_(18.0),SC_(30.0),SC_(0.0),SC_(0.01806239737274220032840722495894909688013),SC_(0.01806239737274220032840722495894909688013),SC_(0.9819376026272577996715927750410509031199)}},
     //{{SC_(8.0),SC_(26.0),SC_(30.0),SC_(8.0),SC_(0.2669220945083014048531289910600255427842),SC_(1.0),SC_(0.e-40)}},
     {{SC_(8.0),SC_(26.0),SC_(30.0),SC_(6.0),SC_(0.236015325670498084291187739463601532567),SC_(0.2835249042145593869731800766283524904215),SC_(0.7164750957854406130268199233716475095785)}},
     {{SC_(8.0),SC_(26.0),SC_(30.0),SC_(4.0),SC_(0.002554278416347381864623243933588761174968),SC_(0.002554278416347381864623243933588761174968),SC_(0.997445721583652618135376756066411238825)}},
     {{SC_(8.0),SC_(26.0),SC_(30.0),SC_(5.0),SC_(0.04495530012771392081736909323116219667944),SC_(0.04750957854406130268199233716475095785441),SC_(0.9524904214559386973180076628352490421456)}},
     {{SC_(17.0),SC_(26.0),SC_(30.0),SC_(14.0),SC_(0.3225688742930122240467068053274949826674),SC_(0.4094143404488232074438970990695128626163),SC_(0.5905856595511767925561029009304871373837)}},
     //{{SC_(17.0),SC_(26.0),SC_(30.0),SC_(17.0),SC_(0.02609012953840540047436599160737091771575),SC_(1.0),SC_(0.e-40)}},
     {{SC_(17.0),SC_(26.0),SC_(30.0),SC_(15.0),SC_(0.3870826491516146688560481663929939792009),SC_(0.7964969896004378762999452654625068418172),SC_(0.2035030103995621237000547345374931581828)}},
     {{SC_(17.0),SC_(26.0),SC_(30.0),SC_(14.0),SC_(0.3225688742930122240467068053274949826674),SC_(0.4094143404488232074438970990695128626163),SC_(0.5905856595511767925561029009304871373837)}},
     {{SC_(34.0),SC_(4.0),SC_(52.0),SC_(3.0),SC_(0.3978649921507064364207221350078492935636),SC_(0.8286970172684458398744113029827315541601),SC_(0.1713029827315541601255886970172684458399)}},
     {{SC_(34.0),SC_(4.0),SC_(52.0),SC_(3.0),SC_(0.3978649921507064364207221350078492935636),SC_(0.8286970172684458398744113029827315541601),SC_(0.1713029827315541601255886970172684458399)}},
     {{SC_(34.0),SC_(4.0),SC_(52.0),SC_(3.0),SC_(0.3978649921507064364207221350078492935636),SC_(0.8286970172684458398744113029827315541601),SC_(0.1713029827315541601255886970172684458399)}},
     {{SC_(34.0),SC_(4.0),SC_(52.0),SC_(0.0),SC_(0.01130298273155416012558869701726844583987),SC_(0.01130298273155416012558869701726844583987),SC_(0.9886970172684458398744113029827315541601)}},
     {{SC_(9.0),SC_(4.0),SC_(52.0),SC_(1.0),SC_(0.4102650290885585003232062055591467356173),SC_(0.8661150614091790562378797672915319974144),SC_(0.1338849385908209437621202327084680025856)}},
     //{{SC_(9.0),SC_(4.0),SC_(52.0),SC_(4.0),SC_(0.0004654169360051712992889463477698771816419),SC_(1.0),SC_(0.e-40)}},
     {{SC_(9.0),SC_(4.0),SC_(52.0),SC_(1.0),SC_(0.4102650290885585003232062055591467356173),SC_(0.8661150614091790562378797672915319974144),SC_(0.1338849385908209437621202327084680025856)}},
     {{SC_(9.0),SC_(4.0),SC_(52.0),SC_(1.0),SC_(0.4102650290885585003232062055591467356173),SC_(0.8661150614091790562378797672915319974144),SC_(0.1338849385908209437621202327084680025856)}},
     //{{SC_(49.0),SC_(9.0),SC_(52.0),SC_(9.0),SC_(0.5584162895927601809954751131221719457014),SC_(1.0),SC_(0.e-40)}},
     {{SC_(49.0),SC_(9.0),SC_(52.0),SC_(8.0),SC_(0.3677375565610859728506787330316742081448),SC_(0.4415837104072398190045248868778280542986),SC_(0.5584162895927601809954751131221719457014)}},
     {{SC_(49.0),SC_(9.0),SC_(52.0),SC_(7.0),SC_(0.0700452488687782805429864253393665158371),SC_(0.07384615384615384615384615384615384615385),SC_(0.9261538461538461538461538461538461538462)}},
     {{SC_(5.0),SC_(9.0),SC_(52.0),SC_(1.0),SC_(0.4273594053005817711700064641241111829347),SC_(0.7977375565610859728506787330316742081448),SC_(0.2022624434389140271493212669683257918552)}},
     {{SC_(5.0),SC_(9.0),SC_(52.0),SC_(0.0),SC_(0.3703781512605042016806722689075630252101),SC_(0.3703781512605042016806722689075630252101),SC_(0.6296218487394957983193277310924369747899)}},
     {{SC_(5.0),SC_(9.0),SC_(52.0),SC_(2.0),SC_(0.1709437621202327084680025856496444731739),SC_(0.9686813186813186813186813186813186813187),SC_(0.0313186813186813186813186813186813186813)}},
     {{SC_(5.0),SC_(9.0),SC_(52.0),SC_(0.0),SC_(0.3703781512605042016806722689075630252101),SC_(0.3703781512605042016806722689075630252101),SC_(0.6296218487394957983193277310924369747899)}},
     {{SC_(5.0),SC_(9.0),SC_(52.0),SC_(2.0),SC_(0.1709437621202327084680025856496444731739),SC_(0.9686813186813186813186813186813186813187),SC_(0.0313186813186813186813186813186813186813)}},
     //{{SC_(12.0),SC_(72.0),SC_(86.0),SC_(12.0),SC_(0.1004778059022558548188756178036665047061),SC_(1.0),SC_(0.e-40)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(5.0),SC_(0.0003140501443388029590935440038063406068305),SC_(0.0003350533679592531664393366671417525299769),SC_(0.99966494663204074683356066333285824747)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(9.0),SC_(0.2026205005326647239781309831965353100365),SC_(0.3036691452411089490209598247926760739435),SC_(0.6963308547588910509790401752073239260565)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(10.0),SC_(0.3191272883389469402655562985345431133076),SC_(0.622796433580055889286516123327219187251),SC_(0.377203566419944110713483876672780812749)}},
     //{{SC_(12.0),SC_(72.0),SC_(86.0),SC_(12.0),SC_(0.1004778059022558548188756178036665047061),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(12.0),SC_(72.0),SC_(86.0),SC_(12.0),SC_(0.1004778059022558548188756178036665047061),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(12.0),SC_(72.0),SC_(86.0),SC_(12.0),SC_(0.1004778059022558548188756178036665047061),SC_(1.0),SC_(0.e-40)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(6.0),SC_(0.003068531618643720579476502870524453012573),SC_(0.00340358498660297374591583953766620554255),SC_(0.9965964150133970262540841604623337944575)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(9.0),SC_(0.2026205005326647239781309831965353100365),SC_(0.3036691452411089490209598247926760739435),SC_(0.6963308547588910509790401752073239260565)}},
     {{SC_(12.0),SC_(72.0),SC_(86.0),SC_(8.0),SC_(0.0783571466903664362259178411580351394282),SC_(0.1010486447084442250428288415961407639069),SC_(0.8989513552915557749571711584038592360931)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(1.0),SC_(0.00004023970159105609317922988205868082117935),SC_(0.00004087842701313634862651924526596146913458),SC_(0.9999591215729868636513734807547340385309)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(1.0),SC_(0.00004023970159105609317922988205868082117935),SC_(0.00004087842701313634862651924526596146913458),SC_(0.9999591215729868636513734807547340385309)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(4.0),SC_(0.06969394377081245471693587603223946468199),SC_(0.08179779051923329544306930881020774343356),SC_(0.9182022094807667045569306911897922565664)}},
     //{{SC_(7.0),SC_(72.0),SC_(86.0),SC_(7.0),SC_(0.2741586880704895589163232624200716649924),SC_(1.0),SC_(0.e-40)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(1.0),SC_(0.00004023970159105609317922988205868082117935),SC_(0.00004087842701313634862651924526596146913458),SC_(0.9999591215729868636513734807547340385309)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(1.0),SC_(0.00004023970159105609317922988205868082117935),SC_(0.00004087842701313634862651924526596146913458),SC_(0.9999591215729868636513734807547340385309)}},
     {{SC_(7.0),SC_(72.0),SC_(86.0),SC_(0.0),SC_(6.387254220802554472893632072806479552278e-7),SC_(6.387254220802554472893632072806479552278e-7),SC_(0.999999361274577919744552710636792719352)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(0.0),SC_(1.696181522741228947391422166807067244121e-10),SC_(1.696181522741228947391422166807067244121e-10),SC_(0.999999999830381847725877105260857783319)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(3.0),SC_(0.0001737059497439292565023555441027117564704),SC_(0.0001783905204128200739835594202237384083541),SC_(0.9998216094795871799260164405797762615916)}},
     //{{SC_(77.0),SC_(8.0),SC_(86.0),SC_(8.0),SC_(0.3965686153374173505799193458109659077391),SC_(1.0),SC_(0.e-40)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(1.0),SC_(5.224239090042985157965580273765767111892e-8),SC_(5.241200905270397447439494495433837784333e-8),SC_(0.9999999475879909472960255256050550456616)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(2.0),SC_(4.632158659838113506729481176072313505878e-6),SC_(4.684570668890817481203876121026651883721e-6),SC_(0.9999953154293311091825187961238789733481)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(5.0),SC_(0.03127865135055686145419082164142829694844),SC_(0.0346706019412323727734679586275522028515),SC_(0.9653293980587676272265320413724477971485)}},
     {{SC_(77.0),SC_(8.0),SC_(86.0),SC_(2.0),SC_(4.632158659838113506729481176072313505878e-6),SC_(4.684570668890817481203876121026651883721e-6),SC_(0.9999953154293311091825187961238789733481)}},
     //{{SC_(77.0),SC_(8.0),SC_(86.0),SC_(8.0),SC_(0.3965686153374173505799193458109659077391),SC_(1.0),SC_(0.e-40)}},
     {{SC_(29.0),SC_(8.0),SC_(86.0),SC_(7.0),SC_(0.00167666525814056836712273646335578512841),SC_(0.9999191082550897094208844293811538875596),SC_(0.0000808917449102905791155706188461124404)}},
     {{SC_(29.0),SC_(8.0),SC_(86.0),SC_(4.0),SC_(0.1768152862443455901937477083421502969112),SC_(0.9184671960045507939629798985816090795823),SC_(0.0815328039954492060370201014183909204177)}},
     {{SC_(29.0),SC_(8.0),SC_(86.0),SC_(5.0),SC_(0.06548714305346132970138804012672233218935),SC_(0.9839543390580121236643679387083314117717),SC_(0.0160456609419878763356320612916685882283)}},
     //{{SC_(29.0),SC_(8.0),SC_(86.0),SC_(8.0),SC_(0.00008089174491029057911557061884611244040574),SC_(1.0),SC_(0.e-40)}},
     {{SC_(29.0),SC_(8.0),SC_(86.0),SC_(2.0),SC_(0.2776654865466760379338852901373026884828),SC_(0.4533069814232723951455820812507213754005),SC_(0.5466930185767276048544179187492786245995)}},
     //{{SC_(29.0),SC_(8.0),SC_(86.0),SC_(8.0),SC_(0.00008089174491029057911557061884611244040574),SC_(1.0),SC_(0.e-40)}},
     {{SC_(29.0),SC_(8.0),SC_(86.0),SC_(6.0),SC_(0.01428810393893701738939375420946669065949),SC_(0.9982424429969491410537616929177981024312),SC_(0.0017575570030508589462383070822018975688)}},
     //{{SC_(29.0),SC_(8.0),SC_(86.0),SC_(8.0),SC_(0.00008089174491029057911557061884611244040574),SC_(1.0),SC_(0.e-40)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(23.0),SC_(0.000805225301249190134657693037802553099772),SC_(0.9997230974788395286912976093894277642599),SC_(0.0002769025211604713087023906105722357401)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(3.0),SC_(1.549234238041493564944898578804393139565e-6),SC_(1.682815234186091880242156421991560710112e-6),SC_(0.9999983171847658139081197578435780084393)}},
     //{{SC_(48.0),SC_(41.0),SC_(135.0),SC_(38.0),SC_(9.373176834116244931418259196234568800165e-21),SC_(0.999999999999999999999914730022392732307),SC_(8.5269977607267693e-23)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(9.0),SC_(0.01430556344702512505400957461643023189953),SC_(0.02185170684715481437694029566249789236978),SC_(0.9781482931528451856230597043375021076302)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(10.0),SC_(0.03188096996765599297750705200233023109039),SC_(0.05373267681481080735444734766482812346016),SC_(0.9462673231851891926455526523351718765398)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(24.0),SC_(0.0002156853485488902146404534922685410088675),SC_(0.9999387828273884189059380628816963052688),SC_(0.0000612171726115810940619371183036947312)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(18.0),SC_(0.0635028350807540704799954651407904540509),SC_(0.9365369229858498785790860909202020989164),SC_(0.0634630770141501214209139090797979010836)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(9.0),SC_(0.01430556344702512505400957461643023189953),SC_(0.02185170684715481437694029566249789236978),SC_(0.9781482931528451856230597043375021076302)}},
     {{SC_(48.0),SC_(41.0),SC_(135.0),SC_(13.0),SC_(0.1300253853961174254303683370155485660567),SC_(0.3391819549842814566474689251368779362798),SC_(0.6608180450157185433525310748631220637202)}},
     //{{SC_(48.0),SC_(41.0),SC_(135.0),SC_(33.0),SC_(8.636981288535222466738786964411319271682e-13),SC_(0.999999999999960542990943845719644284854),SC_(3.9457009056154280355715146e-14)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(26.0),SC_(0.1353717947518808788868865115924511455337),SC_(0.3675844037299293748321620979742237536539),SC_(0.6324155962700706251678379020257762463461)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(26.0),SC_(0.1353717947518808788868865115924511455337),SC_(0.3675844037299293748321620979742237536539),SC_(0.6324155962700706251678379020257762463461)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(20.0),SC_(0.002601025216711084794471493458275384237955),SC_(0.003669860896139999028261909741374497034297),SC_(0.9963301391038600009717380902586255029657)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(11.0),SC_(1.93986120352085451724740385260254674247e-10),SC_(2.076207498565016728508626957499799991182e-10),SC_(0.99999999979237925014349832714913730425)}},
     //{{SC_(90.0),SC_(41.0),SC_(135.0),SC_(41.0),SC_(9.871386192011484832340215364891496674834e-10),SC_(1.0),SC_(0.e-40)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(5.0),SC_(5.265522477647327144962051848320365887239e-19),SC_(5.340712956939061505668577772335340177878e-19),SC_(0.999999999999999999465928704306093849433)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(14.0),SC_(2.096844946871957002598423844522410926464e-7),SC_(2.367952089112490528616878029677703261355e-7),SC_(0.9999997632047910887509471383121970322297)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(17.0),SC_(0.00004767458915445746777441479423811721061273),SC_(0.00005862101992951723721804793182698319474578),SC_(0.9999413789800704827627819520681730168053)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(31.0),SC_(0.05619306850133692963805588101436302213345),SC_(0.9529831764435915951450981856574752470032),SC_(0.0470168235564084048549018143425247529968)}},
     {{SC_(90.0),SC_(41.0),SC_(135.0),SC_(8.0),SC_(3.014074819429380864488976694771446531001e-14),SC_(3.119347726178191980534406891165469850373e-14),SC_(0.999999999999968806522738218080194655931)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(7.0),SC_(8.3970164850884401343928334487887643969e-11),SC_(8.927961958486883651568950241339169425435e-11),SC_(0.999999999910720380415131163484310497587)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(33.0),SC_(0.0003595819872236781592078611557174049533041),SC_(0.9999039697629104515431345759907356363719),SC_(0.0000960302370895484568654240092643636281)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(5.0),SC_(2.393818102005960349308582656633598143507e-13),SC_(2.482393183146904332230217371930142105031e-13),SC_(0.999999999999751760681685309566776978263)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(15.0),SC_(0.0004844924451188653694926716107374844941183),SC_(0.0006420609332055323751720513070835264424829),SC_(0.9993579390667944676248279486929164735575)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(12.0),SC_(5.112991279710625036105384102461015315585e-6),SC_(6.04695804755021374402590977118762910851e-6),SC_(0.9999939530419524497862559740902288123709)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(34.0),SC_(0.0000794274737684955357674027042641086571524),SC_(0.9999833972366789470789019786949997450291),SC_(0.0000166027633210529210980213050002549709)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(15.0),SC_(0.0004844924451188653694926716107374844941183),SC_(0.0006420609332055323751720513070835264424829),SC_(0.9993579390667944676248279486929164735575)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(4.0),SC_(8.626371538760217474985883447328281598224e-15),SC_(8.857508114094398292163471529654396152329e-15),SC_(0.999999999999991142491885905601707836528)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(7.0),SC_(8.3970164850884401343928334487887643969e-11),SC_(8.927961958486883651568950241339169425435e-11),SC_(0.999999999910720380415131163484310497587)}},
     {{SC_(79.0),SC_(41.0),SC_(135.0),SC_(7.0),SC_(8.3970164850884401343928334487887643969e-11),SC_(8.927961958486883651568950241339169425435e-11),SC_(0.999999999910720380415131163484310497587)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(3.0),SC_(6.152384498844700046293430599130067996074e-8),SC_(6.559527871268261826381145800763758401006e-8),SC_(0.9999999344047212873173817361885419923624)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(24.0),SC_(0.002435879224170002072554350678507310792143),SC_(0.9989694012942478450720205139920977765768),SC_(0.0010305987057521549279794860079022234232)}},
     //{{SC_(54.0),SC_(41.0),SC_(135.0),SC_(40.0),SC_(3.554068272074300682345953314464372175913e-21),SC_(0.999999999999999999999985017477925612704),SC_(1.4982522074387296e-23)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(1.0),SC_(1.55063168540157534381013950848901736085e-10),SC_(1.579347086983085998325142091979554719385e-10),SC_(0.999999999842065291301691400167485790802)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(23.0),SC_(0.006705215928898070221224879287073887771922),SC_(0.9965335220700778429994661633135904657847),SC_(0.0034664779299221570005338366864095342153)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(11.0),SC_(0.01823473249213186654280669169437045377003),SC_(0.02931881828357703434749249880639845194241),SC_(0.9706811817164229656525075011936015480576)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(31.0),SC_(2.757809697383381560858776246614371038894e-8),SC_(0.9999999970047528896827388455462192076308),SC_(2.9952471103172611544537807923692e-9)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(12.0),SC_(0.03769680274815722410291767994509276500534),SC_(0.06701562103173425845041017875149121694776),SC_(0.9329843789682657415495898212485087830522)}},
     {{SC_(54.0),SC_(41.0),SC_(135.0),SC_(0.0),SC_(2.871540158151065451500258349053735853427e-12),SC_(2.871540158151065451500258349053735853427e-12),SC_(0.999999999997128459841848934548499741651)}},
     //{{SC_(54.0),SC_(41.0),SC_(135.0),SC_(40.0),SC_(3.554068272074300682345953314464372175913e-21),SC_(0.999999999999999999999985017477925612704),SC_(1.4982522074387296e-23)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(116.0),SC_(0.03699807022436664481783952519965912389076),SC_(0.9635080874490526119281455020839353389893),SC_(0.0364919125509473880718544979160646610107)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(118.0),SC_(0.009841004885312583962103221803148815989297),SC_(0.993692760577393009137664759110828345608),SC_(0.006307239422606990862335240889171654392)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(93.0),SC_(7.420345119545524228030410375733923745618e-9),SC_(8.629428155628070366684594092408534645516e-9),SC_(0.9999999913705718443719296333154059075915)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(116.0),SC_(0.03699807022436664481783952519965912389076),SC_(0.9635080874490526119281455020839353389893),SC_(0.0364919125509473880718544979160646610107)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(125.0),SC_(6.362260373408836591756882525560844973285e-7),SC_(0.9999999340626449078905563129419058105376),SC_(6.59373550921094436870580941894624e-8)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(106.0),SC_(0.03277124114580619708729686499120687204395),SC_(0.06807317418727831275448495227415103489184),SC_(0.9319268258127216872455150477258489651082)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(81.0),SC_(1.927651715813821829732323304283668466216e-24),SC_(1.927651715813821829732323304283668466216e-24),SC_(0.999999999999999999999998072348284186178)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(83.0),SC_(1.584612299767214748630852792482552076016e-20),SC_(1.609996181751797246335059654726033846867e-20),SC_(0.999999999999999999983900038182482027537)}},
     //{{SC_(309.0),SC_(128.0),SC_(356.0),SC_(128.0),SC_(1.173952568854174209634781519975835814629e-10),SC_(1.0),SC_(0.e-40)}},
     {{SC_(309.0),SC_(128.0),SC_(356.0),SC_(95.0),SC_(2.523134664906021391827654571209586578814e-7),SC_(3.068494487409635672940571726868111070252e-7),SC_(0.9999996931505512590364327059428273131889)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(116.0),SC_(0.05814205100844658174163343144704930895785),SC_(0.1043915443995216378549656982347843287219),SC_(0.8956084556004783621450343017652156712781)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(123.0),SC_(0.05076509679421834647006131590934390373976),SC_(0.9700817477211100887338137165315562065958),SC_(0.0299182522788899112661862834684437934042)}},
     //{{SC_(332.0),SC_(128.0),SC_(356.0),SC_(128.0),SC_(0.00001429619718722787470213743464779523575631),SC_(1.0),SC_(0.e-40)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(111.0),SC_(0.0002843459681667381617853471866947621470982),SC_(0.0003493978946605080858095590072982928343876),SC_(0.9996506021053394919141904409927017071656)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(111.0),SC_(0.0002843459681667381617853471866947621470982),SC_(0.0003493978946605080858095590072982928343876),SC_(0.9996506021053394919141904409927017071656)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(107.0),SC_(9.579183829301927913411085922401851443934e-8),SC_(1.02232247914434649321062443067360391674e-7),SC_(0.9999998977677520855653506789375569326396)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(104.0),SC_(4.818676800586903535709507078965008419799e-12),SC_(4.818676800586903535709507078965008419799e-12),SC_(0.999999999995181323199413096464290492921)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(127.0),SC_(0.0002142337451666538101705668255513510450897),SC_(0.9999857038028127721252978625653522047642),SC_(0.0000142961971872278747021374346477952358)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(127.0),SC_(0.0002142337451666538101705668255513510450897),SC_(0.9999857038028127721252978625653522047642),SC_(0.0000142961971872278747021374346477952358)}},
     {{SC_(332.0),SC_(128.0),SC_(356.0),SC_(107.0),SC_(9.579183829301927913411085922401851443934e-8),SC_(1.02232247914434649321062443067360391674e-7),SC_(0.9999998977677520855653506789375569326396)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(15.0),SC_(0.04679452269585690471083072959542901135324),SC_(0.09056570871796626116701178400232098743809),SC_(0.9094342912820337388329882159976790125619)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(28.0),SC_(0.000298951885315799196874009458588841772301),SC_(0.9999386636890326949093956874669061116592),SC_(0.0000613363109673050906043125330938883408)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(29.0),SC_(0.00005380987713192179234513841074135180836722),SC_(0.9999924735661646167017408258776474634675),SC_(7.5264338353832982591741223525365325e-6)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(7.0),SC_(5.539221092900167316408177848276345535105e-6),SC_(6.521697570783084325510247379750509166008e-6),SC_(0.9999934783024292169156744897526202494908)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(22.0),SC_(0.08339487616491457455896412662508815268296),SC_(0.9048093964852138052663323971816424450912),SC_(0.0951906035147861947336676028183575549088)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(18.0),SC_(0.1367815914435279497255477933577629138181),SC_(0.4132934993458208547924177892997570052706),SC_(0.5867065006541791452075822107002429947294)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(16.0),SC_(0.07652092602950428411941997725346277295996),SC_(0.167086634747470545286431761255783760398),SC_(0.832913365252529454713568238744216239602)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(3.0),SC_(8.391903427243916808702614270899070307974e-10),SC_(8.86774565639802428482912964915152805778e-10),SC_(0.999999999113225434360197571517087035085)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(4.0),SC_(1.096192385183736633136778989136191058979e-8),SC_(1.184869841747716875985070285627706339557e-8),SC_(0.9999999881513015825228312401492971437229)}},
     {{SC_(212.0),SC_(32.0),SC_(356.0),SC_(17.0),SC_(0.1094252731548223597804382346862103310545),SC_(0.2765119079022929050668699959419940914525),SC_(0.7234880920977070949331300040580059085475)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(18.0),SC_(0.1149860948225087377801588778243991092637),SC_(0.8139797862076808205438951894721148396458),SC_(0.1860202137923191794561048105278851603542)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(23.0),SC_(0.005515378538316167868190393516984294288754),SC_(0.9973673088529809564406684123791833504191),SC_(0.0026326911470190435593315876208166495809)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(20.0),SC_(0.05242653830457308957769036352760793090822),SC_(0.9495830439377785233938827643656391993988),SC_(0.0504169560622214766061172356343608006012)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(4.0),SC_(3.115784275573278454202364527915266129805e-6),SC_(3.511702493933144179504137478969140648129e-6),SC_(0.9999964882975060668558204958625210308594)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(25.0),SC_(0.0005570282759059586733846587479596807625565),SC_(0.9998335066229194347607343611907145176662),SC_(0.0001664933770805652392656388092854823338)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(2.0),SC_(3.042225654186898343697223959477332443125e-8),SC_(3.208447458210828825149684238665300316634e-8),SC_(0.999999967915525417891711748503157613347)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(20.0),SC_(0.05242653830457308957769036352760793090822),SC_(0.9495830439377785233938827643656391993988),SC_(0.0504169560622214766061172356343608006012)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(27.0),SC_(0.00002669789459104237581847089156469130772006),SC_(0.999995264454853397390693331886665294413),SC_(4.735545146602609306668113334705587e-6)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(3.0),SC_(3.638337437777574370502761086672215151575e-7),SC_(3.959182183598657253017729510538745183239e-7),SC_(0.9999996040817816401342746982270489461255)}},
     {{SC_(179.0),SC_(32.0),SC_(356.0),SC_(21.0),SC_(0.02869473180869921253994068089807112225269),SC_(0.9782777757464777359338234452637103216515),SC_(0.0217222242535222640661765547362896783485)}},
     //{{SC_(425.0),SC_(962.0),SC_(973.0),SC_(425.0),SC_(0.001730269182885526599913793807137295644412),SC_(1.0),SC_(0.e-40)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(424.0),SC_(0.01503533165425620233196465808246627720748),SC_(0.9982697308171144734000862061928627043556),SC_(0.0017302691828855265999137938071372956444)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(419.0),SC_(0.1823616267560499554057729478613706085216),SC_(0.3325506178235432762157463639395714148864),SC_(0.6674493821764567237842536360604285851136)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(424.0),SC_(0.01503533165425620233196465808246627720748),SC_(0.9982697308171144734000862061928627043556),SC_(0.0017302691828855265999137938071372956444)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(417.0),SC_(0.03847426474600563431124947675865412641384),SC_(0.04986136290207192990264822548745200782154),SC_(0.9501386370979280700973517745125479921785)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(421.0),SC_(0.2168069260267343633382269830226402084104),SC_(0.7851250755848850819000083724115550528855),SC_(0.2148749244151149180999916275884449471145)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(422.0),SC_(0.1389722120621602968791241680275454416469),SC_(0.9240972876470453787791325404391004945324),SC_(0.0759027123529546212208674595608995054676)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(421.0),SC_(0.2168069260267343633382269830226402084104),SC_(0.7851250755848850819000083724115550528855),SC_(0.2148749244151149180999916275884449471145)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(417.0),SC_(0.03847426474600563431124947675865412641384),SC_(0.04986136290207192990264822548745200782154),SC_(0.9501386370979280700973517745125479921785)}},
     {{SC_(425.0),SC_(962.0),SC_(973.0),SC_(422.0),SC_(0.1389722120621602968791241680275454416469),SC_(0.9240972876470453787791325404391004945324),SC_(0.0759027123529546212208674595608995054676)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(529.0),SC_(0.001469618832174530213229780392268924311856),SC_(0.001469618832174530213229780392268924311856),SC_(0.9985303811678254697867702196077310756881)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(535.0),SC_(0.1895661732555605465573127760069913903602),SC_(0.8361800421215626051684275771149104259661),SC_(0.1638199578784373948315724228850895740339)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(533.0),SC_(0.2106816860607503576873231401676103114642),SC_(0.4096561522965513754144738310991797976557),SC_(0.5903438477034486245855261689008202023443)}},
     //{{SC_(540.0),SC_(962.0),SC_(973.0),SC_(540.0),SC_(0.0001262256511272454676003572709234773890586),SC_(1.0),SC_(0.e-40)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(535.0),SC_(0.1895661732555605465573127760069913903602),SC_(0.8361800421215626051684275771149104259661),SC_(0.1638199578784373948315724228850895740339)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(529.0),SC_(0.001469618832174530213229780392268924311856),SC_(0.001469618832174530213229780392268924311856),SC_(0.9985303811678254697867702196077310756881)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(529.0),SC_(0.001469618832174530213229780392268924311856),SC_(0.001469618832174530213229780392268924311856),SC_(0.9985303811678254697867702196077310756881)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(538.0),SC_(0.01126643745784983506727998182414638859487),SC_(0.998101243928788030944820157648023435871),SC_(0.001898756071211969055179842351976564129)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(538.0),SC_(0.01126643745784983506727998182414638859487),SC_(0.998101243928788030944820157648023435871),SC_(0.001898756071211969055179842351976564129)}},
     {{SC_(540.0),SC_(962.0),SC_(973.0),SC_(530.0),SC_(0.0132071594295231837841763094497677103724),SC_(0.01467677826169771399740608984203663468425),SC_(0.9853232217383022860025939101579633653157)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(252.0),SC_(0.00006625796823677690729314300617452992326649),SC_(0.0001348401906870167680027021434814934503861),SC_(0.9998651598093129832319972978565185065496)}},
     //{{SC_(797.0),SC_(334.0),SC_(973.0),SC_(322.0),SC_(6.983850717054883225806592315521964705242e-21),SC_(0.999999999999999999999173818250410551486),SC_(8.26181749589448514e-22)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(294.0),SC_(0.00008908450711833519340856244713611142471579),SC_(0.9999171648613243361673307688374104919183),SC_(0.0000828351386756638326692311625895080817)}},
     //{{SC_(797.0),SC_(334.0),SC_(973.0),SC_(315.0),SC_(4.477512056168159048537745352957006933488e-15),SC_(0.999999999999999011103714625815853985649),SC_(9.88896285374184146014351e-16)}},
     //{{SC_(797.0),SC_(334.0),SC_(973.0),SC_(320.0),SC_(4.669717243593948437260963126450566810095e-19),SC_(0.999999999999999999932590227929891823175),SC_(6.7409772070108176825e-20)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(236.0),SC_(6.727393238319958780368559514417208047046e-11),SC_(9.987409104666421473936613845778962623697e-11),SC_(0.999999999900125908953335785260633861542)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(293.0),SC_(0.0001723748999525510246442102635641830819704),SC_(0.9998280803542060009739222063902743804936),SC_(0.0001719196457939990260777936097256195064)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(240.0),SC_(4.208099135331936814529085955012549745131e-9),SC_(6.631352233586740245027290009470364897932e-9),SC_(0.9999999933686477664132597549727099905296)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(226.0),SC_(2.837277830784060952227181395283153835467e-16),SC_(3.753858052411669554994217970061448093714e-16),SC_(0.999999999999999624614194758833044500578)}},
     {{SC_(797.0),SC_(334.0),SC_(973.0),SC_(184.0),SC_(1.837052002163276359154130471333208458286e-54),SC_(1.93670704001299800120056217810738417905e-54),SC_(1.0)}},
     {{SC_(453.0),SC_(334.0),SC_(973.0),SC_(28.0),SC_(6.793193827561028202902976635003367877227e-75),SC_(7.118636331915467986484970086981805616095e-75),SC_(1.0)}},
     {{SC_(453.0),SC_(334.0),SC_(973.0),SC_(53.0),SC_(7.809780788870239982842609746744039778707e-47),SC_(8.790962431354454536711420041061177586564e-47),SC_(1.0)}},
     //{{SC_(453.0),SC_(334.0),SC_(973.0),SC_(320.0),SC_(3.131175927803977169916713432405745219695e-126),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(453.0),SC_(334.0),SC_(973.0),SC_(206.0),SC_(3.60219857522415158547703220100375407042e-12),SC_(0.999999999997753146803152633354062788882),SC_(2.246853196847366645937211118e-12)}},
     {{SC_(453.0),SC_(334.0),SC_(973.0),SC_(15.0),SC_(4.27439806904807633594722300172024102612e-94),SC_(4.367988093148506690674156367666866626417e-94),SC_(1.0)}},
     {{SC_(453.0),SC_(334.0),SC_(973.0),SC_(152.0),SC_(0.04826841874430430687609539751074516400646),SC_(0.3424802704976019616108159408843983798306),SC_(0.6575197295023980383891840591156016201694)}},
     //{{SC_(453.0),SC_(334.0),SC_(973.0),SC_(288.0),SC_(5.01196899862618170032413245887252273368e-77),SC_(1.0),SC_(0.e-40)}},
     {{SC_(453.0),SC_(334.0),SC_(973.0),SC_(158.0),SC_(0.05093523942943842194436856352296911381224),SC_(0.6577681435125240236827321826001806186743),SC_(0.3422318564874759763172678173998193813257)}},
     //{{SC_(453.0),SC_(334.0),SC_(973.0),SC_(240.0),SC_(5.625853848826174111387936567286920206281e-31),SC_(0.999999999999999999999999999999864966466),SC_(1.35033534e-31)}},
     //{{SC_(453.0),SC_(334.0),SC_(973.0),SC_(307.0),SC_(1.115893441169970912376476440179941658041e-103),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(290.0),SC_(1.006620133234272771163677015430335203943e-130),SC_(1.0),SC_(0.e-40)}},
     {{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(91.0),SC_(0.000249746343620639318300239691547389701761),SC_(0.0006387097424328087819071799019558425578344),SC_(0.9993612902575671912180928200980441574422)}},
     //{{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(161.0),SC_(2.626291609603155449015480586249378996646e-10),SC_(0.99999999980295295962658198502303195079),SC_(1.9704704037341801497696804921e-10)}},
     {{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(121.0),SC_(0.03842277275961047991159275112715017088171),SC_(0.8138423545996981671290697197982014986511),SC_(0.1861576454003018328709302802017985013489)}},
     {{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(110.0),SC_(0.04348498418098799613741149657597115317029),SC_(0.2735425234591600571117362990553155570651),SC_(0.7264574765408399428882637009446844429349)}},
     //{{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(227.0),SC_(1.88229016834885594756235286696744970181e-51),SC_(1.0),SC_(0.e-40)}},
     {{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(134.0),SC_(0.00194550241359619551975486688720863879117),SC_(0.9959039509551882259961399094904303046884),SC_(0.0040960490448117740038600905095696953116)}},
     //{{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(297.0),SC_(3.099170124790288236133811018964458572526e-143),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(315.0),SC_(8.745337833902361187545389118026512656014e-183),SC_(1.0),SC_(0.e-40)}},
     {{SC_(437.0),SC_(318.0),SC_(1209.0),SC_(184.0),SC_(1.307228949356826879223900266059585713681e-20),SC_(0.999999999999999999994796180432579251579),SC_(5.203819567420748421e-21)}},
     {{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(37.0),SC_(3.320625863326094090483393792106638864492e-86),SC_(3.486813684143416952377418163000021290702e-86),SC_(1.0)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(295.0),SC_(8.028270602773348094175158677072201916994e-59),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(217.0),SC_(7.446847405448950069716275639243476085211e-7),SC_(0.9999992151368775059138538229355824721045),SC_(7.848631224940861461770644175278955e-7)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(234.0),SC_(8.655813341764919370257475355332168675631e-13),SC_(0.999999999999492800168053859053519679115),SC_(5.07199831946140946480320885e-13)}},
     {{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(44.0),SC_(2.225193268385278826382154176975169922062e-77),SC_(2.368395859994222444389160292498856150859e-77),SC_(1.0)}},
     {{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(129.0),SC_(2.38378427332930781600974503246401822634e-12),SC_(3.934973888947151527521600631524818827246e-12),SC_(0.999999999996065026111052848472478399368)}},
     {{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(107.0),SC_(5.883202459583277063909486057329520787237e-23),SC_(7.99788786613398647632239208434936393405e-23),SC_(0.999999999999999999999920021121338660135)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(291.0),SC_(3.387447252601386063089573439124401793154e-54),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(303.0),SC_(3.436705085016389481492195392327629935159e-69),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(690.0),SC_(318.0),SC_(1209.0),SC_(232.0),SC_(5.823171654984571450723327045719220660975e-12),SC_(0.999999999996359036982781341520668192317),SC_(3.640963017218658479331807683e-12)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(10.0),SC_(7.014731528920930361951810768762429681404e-57),SC_(7.215660108865651017830678595247908240443e-57),SC_(1.0)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(21.0),SC_(2.887208079689564214747175904058519741897e-42),SC_(3.0923605955326645813810452988173375984e-42),SC_(1.0)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(20.0),SC_(1.92340807552262283205625921172736368573e-43),SC_(2.051525158431003666338693947588178565032e-43),SC_(1.0)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(66.0),SC_(1.510579165415947337341767267500824992875e-8),SC_(2.407486958664755543046601156111483971513e-8),SC_(0.9999999759251304133524445695339884388852)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(115.0),SC_(0.0006608966357000263070197349769408621428164),SC_(0.9992317108820617655465532119624578489362),SC_(0.0007682891179382344534467880375421510638)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(1.0),SC_(1.758547036970495437785096784555337943894e-73),SC_(1.76298878766787314424996140415173293321e-73),SC_(1.0)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(101.0),SC_(0.0611596896401622665249392682773787940425),SC_(0.7356135902796048313964729794636385680193),SC_(0.2643864097203951686035270205363614319807)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(110.0),SC_(0.00711037858146964825555095885784703561601),SC_(0.9877367207638833770260247624792821273585),SC_(0.0122632792361166229739752375207178726415)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(0.0),SC_(4.441750697377706464864619596394989315789e-76),SC_(4.441750697377706464864619596394989315789e-76),SC_(1.0)}},
     {{SC_(754.0),SC_(157.0),SC_(1209.0),SC_(48.0),SC_(3.336274865105840654390318803892947594077e-18),SC_(4.231951398640858500408212031832569592048e-18),SC_(0.999999999999999995768048601359141499592)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(23.0),SC_(1.256916204055012846327346469934583088434e-86),SC_(1.280543104857283708622078393598734379004e-86),SC_(1.0)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(11.0),SC_(1.746441258293646773567310499714837545838e-109),SC_(1.758881956444457902473727074497955667871e-109),SC_(1.0)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(156.0),SC_(3.911317894313098707233226403260859259024e-15),SC_(0.999999999999999914224101648539639734948),SC_(8.5775898351460360265052e-17)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(49.0),SC_(2.903655345315729957508557380199650891209e-49),SC_(3.097571274031110857392766478316885711407e-49),SC_(1.0)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(146.0),SC_(1.966253266445107381180160844299205213212e-6),SC_(0.9999992988002280865167638533917395359396),SC_(7.011997719134832361466082604640604e-7)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(120.0),SC_(0.03419666194773366390271416862729435096174),SC_(0.1100591220477970962195724476748588700464),SC_(0.8899408779522029037804275523251411299536)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(84.0),SC_(7.531982350445872263147888523308276049073e-17),SC_(9.506181734656504965593219627111945819999e-17),SC_(0.999999999999999904938182653434950344068)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(144.0),SC_(0.00001981485176354782268456402679318085722013),SC_(0.9999907950124211715622293660375036107191),SC_(9.2049875788284377706339624963892809e-6)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(108.0),SC_(0.00007133191038860805379624854022655094047227),SC_(0.0001312867330986177479712388439732547077734),SC_(0.9998687132669013822520287611560267452922)}},
     {{SC_(972.0),SC_(157.0),SC_(1209.0),SC_(3.0),SC_(2.005087090102681754797772599049082315503e-128),SC_(2.008411383539907780338312125871301296826e-128),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(354.0),SC_(7.903260705042764488301445082606473361127e-173),SC_(8.417880629333124464958707448513829976282e-173),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(525.0),SC_(2.162810631124519549340581709730147751517e-30),SC_(3.209393798589136518333848434941341569445e-30),SC_(0.999999999999999999999999999996790606201)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(663.0),SC_(0.001447152885700053794735373991082805537555),SC_(0.9961287857259508667199771183279835477078),SC_(0.0038712142740491332800228816720164522922)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(384.0),SC_(1.100043121328119195202410338419197081057e-138),SC_(1.202354725833875441303984179115024934866e-138),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(457.0),SC_(2.028627530496037837927999765314022991323e-72),SC_(2.458531324056423604246901969344101625399e-72),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(332.0),SC_(1.039890390494686469133943817352555412314e-200),SC_(1.091134024815476999807915065508065049447e-200),SC_(1.0)}},
     //{{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(723.0),SC_(9.584044850067058477290355360579073950829e-22),SC_(0.999999999999999999999587791549423554272),SC_(4.12208450576445728e-22)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(235.0),SC_(5.287293166825105514181323250483161211397e-360),SC_(5.3343535872986423431564523183866543041e-360),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(367.0),SC_(1.669523421668577782334312791674566033975e-157),SC_(1.796733056974522462455948368840646736733e-157),SC_(1.0)}},
     {{SC_(786.0),SC_(2598.0),SC_(3198.0),SC_(384.0),SC_(1.100043121328119195202410338419197081057e-138),SC_(1.202354725833875441303984179115024934866e-138),SC_(1.0)}},
     {{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(1812.0),SC_(2.076831972632489091686388421038171046837e-6),SC_(5.354493333876393887982629292665925446059e-6),SC_(0.9999946455066661236061120173707073340746)}},
     {{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(1848.0),SC_(0.03043400366814929190463430046897554723115),SC_(0.2426930943591920127852170607127364214983),SC_(0.7573069056408079872147829392872635785017)}},
     {{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(1692.0),SC_(1.612952941179119319800540847339295957404e-84),SC_(1.65445368566756829784568201999579763927e-84),SC_(1.0)}},
     {{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(1762.0),SC_(1.477889118594974267435908555057207374771e-23),SC_(2.147014310066440005194093427131433710863e-23),SC_(0.9999999999999999999999785298568993356)}},
     //{{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(2206.0),SC_(1.413250104820905541938131192149992173614e-253),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(2207.0),SC_(3.743653749455626400814053262752372357763e-255),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(2276.0),SC_(3.355132738483096581505327776882771453977e-391),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(2073.0),SC_(2.568226642878234234731469207214275586921e-96),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(2120.0),SC_(1.300039280970278491399563360418008519226e-141),SC_(1.0),SC_(0.e-40)}},
     {{SC_(2284.0),SC_(2598.0),SC_(3198.0),SC_(1870.0),SC_(0.0137996710604292526669597574510970453016),SC_(0.9332289351942023401992097275568239112338),SC_(0.0667710648057976598007902724431760887662)}},
     {{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2153.0),SC_(0.0007602068090348631169150843040670180316801),SC_(0.00221724930017410584273440242818094113795),SC_(0.9977827506998258941572655975718190588621)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2275.0),SC_(2.389273478584848197542682700197857941686e-30),SC_(0.999999999999999999999999999999056225002),SC_(9.43774998e-31)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2311.0),SC_(4.496875877106921733455038361783686733759e-53),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2481.0),SC_(5.427452315078316521316606761519937268639e-252),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2523.0),SC_(3.28760233821461751336472689613619049464e-332),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2361.0),SC_(3.921679538081295786093131327204110370691e-95),SC_(1.0),SC_(0.e-40)}},
     {{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2158.0),SC_(0.004023946386086623057595170070984435297238),SC_(0.01407047793206240235127460830155934874536),SC_(0.9859295220679375976487253916984406512546)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2444.0),SC_(5.297510662712953060252841619712357096826e-194),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2226.0),SC_(1.024254921782787513607818489358590331848e-9),SC_(0.999999998983989155511863183091944810876),SC_(1.016010844488136816908055189124e-9)}},
     //{{SC_(2714.0),SC_(2564.0),SC_(3198.0),SC_(2355.0),SC_(1.978929781286286216878147108631004914241e-89),SC_(1.0),SC_(0.e-40)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(420.0),SC_(7.52805744911035547937873348821232511921e-61),SC_(9.451617680125119619555226733383820418426e-61),SC_(1.0)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(517.0),SC_(1.035415089580412942515641975689141390427e-12),SC_(2.039063402388744610887027882654444741063e-12),SC_(0.999999999997960936597611255389112972117)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(611.0),SC_(0.0009740308940664704470710407807024893489785),SC_(0.9975545460464081603943666566696536662421),SC_(0.0024454539535918396056333433303463337579)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(279.0),SC_(1.595304181815312276176972504209173730097e-199),SC_(1.678177738130090668227067442053093761348e-199),SC_(1.0)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(420.0),SC_(7.52805744911035547937873348821232511921e-61),SC_(9.451617680125119619555226733383820418426e-61),SC_(1.0)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(504.0),SC_(5.550807487053911812822058829445386689796e-17),SC_(9.849409209415822224424654722895977955379e-17),SC_(0.999999999999999901505907905841777755753)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(372.0),SC_(1.605546354870612178740781050646539186862e-98),SC_(1.845937605823900204504036820035159735218e-98),SC_(1.0)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(571.0),SC_(0.01343296248841276379815843094254576483911),SC_(0.07353198708249211486109185562092974993258),SC_(0.9264680129175078851389081443790702500674)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(368.0),SC_(4.384983235539954445467700700515092170797e-102),SC_(5.013351380094734022335274851001595308115e-102),SC_(1.0)}},
     {{SC_(730.0),SC_(2564.0),SC_(3198.0),SC_(158.0),SC_(6.235660560187736802444553036433270953835e-402),SC_(6.280258997482568173440303376158993204012e-402),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(70.0),SC_(2.075900101560929841792553796613471100774e-17),SC_(2.460459266799689492021057206125120932409e-17),SC_(0.999999999999999975395407332003105079789)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(31.0),SC_(9.871285170348988309256098933733531664211e-61),SC_(1.02277976167625044026478937816407960646e-60),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(63.0),SC_(2.267197108749237594778606213605575779119e-23),SC_(2.578750935327152372426021552106352357734e-23),SC_(0.999999999999999999999974212490646728476)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(42.0),SC_(6.007346576998807709658897241840197510143e-46),SC_(6.360318241570135121802589412647726196011e-46),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(106.0),SC_(0.1116804690473795095104669373988381764272),SC_(0.7584676353906888096439200728313197090907),SC_(0.2415323646093111903560799271686802909093)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(100.0),SC_(0.0503742119970223819663542994283390181172),SC_(0.1287616578083579316935823220930883355539),SC_(0.8712383421916420683064176779069116644461)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(8.0),SC_(1.136161661575578777389109430583966945594e-100),SC_(1.143856400465436699424699529942978060397e-100),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(39.0),SC_(9.175753504734590818744774120376180805312e-50),SC_(9.650802483228010632797337380631125909948e-50),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(38.0),SC_(4.526030374578030397726435764033594085953e-51),SC_(4.750489784934198140525632602549451046364e-51),SC_(1.0)}},
     {{SC_(116.0),SC_(4934.0),SC_(5494.0),SC_(19.0),SC_(1.14288295995607625399252341664345765015e-79),SC_(1.164114085538017085528413782178340874898e-79),SC_(1.0)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2706.0),SC_(1.301464585707490814792535362994737105742e-71),SC_(1.48066685396468895689159213319649073755e-71),SC_(1.0)}},
     //{{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(3014.0),SC_(2.778928853125489940813034129923433306267e-30),SC_(0.999999999999999999999999999998477829012),SC_(1.522170988e-30)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2775.0),SC_(2.980705983079855228190799398729048352087e-26),SC_(4.568054515761335768661592313440449747617e-26),SC_(0.999999999999999999999999954319454842387)}},
     //{{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(3004.0),SC_(5.378089066435558496049070834586693555302e-26),SC_(0.999999999999999999999999966307286850134),SC_(3.3692713149866e-26)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2769.0),SC_(4.575321018475226387137075375185371548035e-29),SC_(6.770307181230632452986350148326352876378e-29),SC_(0.999999999999999999999999999932296928188)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2964.0),SC_(1.832217460276038557251397001240443135099e-12),SC_(0.999999999997907478272135988382633698282),SC_(2.092521727864011617366301718e-12)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2863.0),SC_(0.003192814456943264796090309312301672830727),SC_(0.01529732399678425733294970091036265409296),SC_(0.984702676003215742667050299089637345907)}},
     {{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2925.0),SC_(0.0001126567239667587485681805535995818729655),SC_(0.9997091506136263206825603745115894853285),SC_(0.0002908493863736793174396254884105146715)}},
     //{{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(2978.0),SC_(1.493072631611316664630886611666164517391e-16),SC_(0.999999999999999863933229779127230838208),SC_(1.36066770220872769161792e-16)}},
     //{{SC_(3215.0),SC_(4934.0),SC_(5494.0),SC_(3135.0),SC_(1.364144802642130452748715021650473092386e-115),SC_(1.0),SC_(0.e-40)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(59.0),SC_(0.02177554343769504321391071983139287817981),SC_(0.9889720983037576750038011653281528633075),SC_(0.0110279016962423249961988346718471366925)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(34.0),SC_(2.291834910217138046227257852037994292793e-9),SC_(2.826079121524902134800638171700742220719e-9),SC_(0.9999999971739208784750978651993618282993)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(20.0),SC_(5.589240186641653949455334785805795497732e-22),SC_(6.041538257297753020668486984071999814492e-22),SC_(0.999999999999999999999395846174270224698)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(38.0),SC_(8.869462684596912381586295236545550772373e-7),SC_(1.172966728086824690764634534551048866175e-6),SC_(0.9999988270332719131753092353654654489511)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(51.0),SC_(0.08430051884656719121900050667329876824698),SC_(0.2161351933502864992680720821496335588975),SC_(0.7838648066497135007319279178503664411025)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(28.0),SC_(4.353757770671806099525426427856956157503e-14),SC_(4.999772155653313226775586682549807872326e-14),SC_(0.999999999999950002278443466867732244133)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(59.0),SC_(0.02177554343769504321391071983139287817981),SC_(0.9889720983037576750038011653281528633075),SC_(0.0110279016962423249961988346718471366925)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(54.0),SC_(0.1419850808354917019613239285390612426154),SC_(0.6036890800491267250430218325034504954109),SC_(0.3963109199508732749569781674965495045891)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(3.0),SC_(7.136954483641043093561093598618884335191e-47),SC_(7.193910796612041799520506176766000163643e-47),SC_(1.0)}},
     {{SC_(4679.0),SC_(63.0),SC_(5494.0),SC_(36.0),SC_(5.137428541711846166022551383288380953976e-8),SC_(6.540826512244440138867446454619929204767e-8),SC_(0.9999999345917348775555986113255354538007)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(55.0),SC_(0.07515584769838484415224427111536446726427),SC_(0.9064496805743194682928292408977067592803),SC_(0.0935503194256805317071707591022932407197)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(36.0),SC_(3.006028587230163412087950484735104776256e-6),SC_(4.134445889095858247521380401532958569624e-6),SC_(0.9999958655541109041417524786195984670414)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(7.0),SC_(1.180925335910771625584177682408114761433e-34),SC_(1.211941484403213408973968966482121921302e-34),SC_(0.999999999999999999999999999999999878806)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(61.0),SC_(0.0003058214478756612288237352875129947033387),SC_(0.9999528980850807036913573016612812428566),SC_(0.0000471019149192963086426983387187571434)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(30.0),SC_(5.434404923577365920603519544002198527592e-10),SC_(6.688363101915135304240265747428239721706e-10),SC_(0.999999999331163689808486469575973425257)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(1.0),SC_(1.107542894346697539367034550776316964086e-45),SC_(1.111193352974940834453276796961305989348e-45),SC_(1.0)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(52.0),SC_(0.1308264751086438221424092026318742903987),SC_(0.6067495681363828513659178756682145346319),SC_(0.3932504318636171486340821243317854653681)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(3.0),SC_(1.612844731098380416414479224652978509006e-41),SC_(1.629469137307708933371779117639634427735e-41),SC_(1.0)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(7.0),SC_(1.180925335910771625584177682408114761433e-34),SC_(1.211941484403213408973968966482121921302e-34),SC_(0.999999999999999999999999999999999878806)}},
     {{SC_(4498.0),SC_(63.0),SC_(5494.0),SC_(31.0),SC_(2.681268904938900886084410840737050460789e-9),SC_(3.35010521513041441650843741547987443296e-9),SC_(0.9999999966498947848695855834915625845201)}},
     {{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(1006.0),SC_(6.339234104612103924818478600804223240535e-190),SC_(9.381728684405531114969361200221656280534e-190),SC_(1.0)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(3075.0),SC_(3.677152045501920304167491485472390252599e-444),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(1930.0),SC_(7.021619514016001433795351034994363459872e-7),SC_(0.9999961074340315071158318618094539709261),SC_(3.8925659684928841681381905460290739e-6)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(3670.0),SC_(3.023889360679502938528761389063297095916e-974),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(3396.0),SC_(1.518102375990395835193698956978291603351e-701),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(4252.0),SC_(3.59537869952930700205997971685748921757e-1747),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(2892.0),SC_(3.296953405682328274817830825632043002187e-325),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(4634.0),SC_(2.939967325749253243319695099153624196492e-2452),SC_(1.0),SC_(0.e-40)}},
     {{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(566.0),SC_(9.658759281646508651392504855467279628581e-481),SC_(1.121789646189748754673629264448480612184e-480),SC_(1.0)}},
     {{SC_(4927.0),SC_(5709.0),SC_(15582.0),SC_(578.0),SC_(1.539338296002620482584150731931745370605e-470),SC_(1.796125390374408977243663785953386517648e-470),SC_(1.0)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(3478.0),SC_(1.006405922085765327249426805877543752218e-434),SC_(1.189508163301917338844808154550173850989e-434),SC_(1.0)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(3102.0),SC_(1.801588237261977931271087511792575138713e-806),SC_(1.926905984951753467315647688105897884209e-806),SC_(1.0)}},
     //{{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(4836.0),SC_(1.279500290415770784796394928901921281391e-30),SC_(0.999999999999999999999999999997992139054),SC_(2.007860946e-30)}},
     //{{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(5672.0),SC_(8.211075716556983834494281939126325961014e-631),SC_(1.0),SC_(0.e-40)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(2739.0),SC_(7.942740543104711231249902212637227645973e-1338),SC_(8.056526098952320234215083963959077928992e-1338),SC_(1.0)}},
     //{{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(5691.0),SC_(2.469075354107191191986179778263512079e-668),SC_(1.0),SC_(0.e-40)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(2722.0),SC_(9.779333008745284830383984850117446014205e-1370),SC_(9.901538457186077459455392963727220943833e-1370),SC_(1.0)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(3463.0),SC_(5.30615834698657866630857578903211416722e-447),SC_(6.238314045857898958032074360456653750184e-447),SC_(1.0)}},
     {{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(3065.0),SC_(3.401470422855740308061231647970018418367e-851),SC_(3.613018073107107137747060327519176948069e-851),SC_(1.0)}},
     //{{SC_(12463.0),SC_(5709.0),SC_(15582.0),SC_(5669.0),SC_(2.357007720699358431877989506299284244468e-625),SC_(1.0),SC_(0.e-40)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(3263.0),SC_(4.435321459779290899993711683502778935079e-45),SC_(9.740316269301809627744830862498348157159e-45),SC_(1.0)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(2797.0),SC_(1.633335582290992118308319188940666290148e-251),SC_(2.142953554897797330733201509747662022608e-251),SC_(1.0)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(2691.0),SC_(5.495849840533559961957052425968731722353e-322),SC_(6.836845529230566706607480161453931176945e-322),SC_(1.0)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(2431.0),SC_(1.993828118934155932497960035027714551599e-533),SC_(2.263920531776472531722580833266889159382e-533),SC_(1.0)}},
     //{{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(4311.0),SC_(1.179187250020158315490073292121582351995e-305),SC_(1.0),SC_(0.e-40)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(2326.0),SC_(3.299330524432867192121564820200580059945e-635),SC_(3.650095231694719949668862317327622630577e-635),SC_(1.0)}},
     //{{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(3779.0),SC_(2.811813909295360559735426635527205346905e-20),SC_(0.999999999999999999947768931875694491675),SC_(5.2231068124305508325e-20)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(2273.0),SC_(2.121966223891087340540365503793597463055e-690),SC_(2.320974324298723210214732910188800714753e-690),SC_(1.0)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(1704.0),SC_(4.26047773610794944627559108769983951047e-1481),SC_(4.328185563225618905397135819823042898001e-1481),SC_(1.0)}},
     {{SC_(4438.0),SC_(12575.0),SC_(15582.0),SC_(3187.0),SC_(2.702643231114555571113233202034373770661e-67),SC_(5.150995278963108588055631364450502244211e-67),SC_(1.0)}},
     {{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(8946.0),SC_(1.703165566721353814922501297682510774634e-56),SC_(3.075137845246061197300125409500262963551e-56),SC_(1.0)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(10716.0),SC_(4.143757744937962174939769535710512245796e-865),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(11146.0),SC_(3.445253481408347317737434293597176336291e-1499),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(10556.0),SC_(1.244863949482443666518124566788365799282e-682),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(10713.0),SC_(1.872268680237180672431400271923629604662e-861),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(11404.0),SC_(2.623521946917958826310697056679792248359e-2035),SC_(1.0),SC_(0.e-40)}},
     {{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(8611.0),SC_(5.902950421727860032307027070001849738945e-266),SC_(6.527272372809071671043471044598854410339e-266),SC_(1.0)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(9382.0),SC_(8.350769503138113607048006351288674200386e-8),SC_(0.9999996811470715898090812142957207291651),SC_(3.188529284101909187857042792708349e-7)}},
     //{{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(10093.0),SC_(1.525454564673778577778516320623498508002e-283),SC_(1.0),SC_(0.e-40)}},
     {{SC_(11491.0),SC_(12575.0),SC_(15582.0),SC_(8616.0),SC_(6.463719063528862326901595813952505767646e-261),SC_(7.180069731161748312282673058422249863972e-261),SC_(1.0)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(2123.0),SC_(1.051598000012254716392485236070905585228e-268),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(1391.0),SC_(6.397691613869390399471557572785519528862e-23),SC_(0.999999999999999999999847139456387039014),SC_(1.52860543612960986e-22)}},
     {{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(802.0),SC_(9.63468927291374065983956254885634959026e-36),SC_(2.470316012686340183657552031377716990407e-35),SC_(0.999999999999999999999999999999999975297)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(1822.0),SC_(1.14085183245777964221003544061732820553e-135),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(1909.0),SC_(1.206331285434620553935142382532461215726e-169),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(2836.0),SC_(1.705760756379935137738292356686227831161e-756),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(4456.0),SC_(1.711211733109732363933699044037411967215e-2965),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(1920.0),SC_(3.348573725136031902872466248413502832256e-174),SC_(1.0),SC_(0.e-40)}},
     {{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(999.0),SC_(2.138122084622344367578512770528568747903e-7),SC_(1.25417155689383511127926419540770446068e-6),SC_(0.9999987458284431061648887207358045922955)}},
     {{SC_(4716.0),SC_(7375.0),SC_(30916.0),SC_(874.0),SC_(2.821590510628816486988008063151194817168e-22),SC_(9.004100327904705235159583716808495439711e-22),SC_(0.999999999999999999999099589967209529476)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(2191.0),SC_(2.413371615050103770980626165031023930979e-368),SC_(3.556509829562483740914436969008727592467e-368),SC_(1.0)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(1005.0),SC_(9.894980874153372595761820694699023799935e-1236),SC_(1.096258863414571957167577684620602424505e-1235),SC_(1.0)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(2746.0),SC_(4.118337082904282114829472199943034115996e-148),SC_(8.174104688972092189023381983494630349758e-148),SC_(1.0)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(3194.0),SC_(3.183471994948445071033289373223870925742e-44),SC_(1.024132845469072232573725203929695789012e-43),SC_(1.0)}},
     //{{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(7300.0),SC_(6.77164027932829532370109212260862859305e-2502),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(6833.0),SC_(4.1396195968933323171054600327897582287e-1727),SC_(1.0),SC_(0.e-40)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(219.0),SC_(1.881993729177212164637026875271803426257e-2271),SC_(1.913288470864454992848774406953287553205e-2271),SC_(1.0)}},
     {{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(1946.0),SC_(6.059304806185264237722374088214508359474e-500),SC_(8.202297432646816246455573369592948373176e-500),SC_(1.0)}},
     //{{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(4530.0),SC_(4.852465934382930186442067232117977677403e-107),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(15559.0),SC_(7375.0),SC_(30916.0),SC_(5431.0),SC_(6.278064131566577219092533432665204627255e-475),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23921.0),SC_(5.01571344812621193474425641386483940301e-149),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23731.0),SC_(3.894076550564398247369316726697188054062e-29),SC_(0.999999999999999999999999999973526541057),SC_(2.6473458943e-29)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23948.0),SC_(9.022982528814208465718080395862041827201e-174),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23785.0),SC_(6.501467887055533489989990433122758223866e-54),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(24127.0),SC_(1.211500213651858537165259088551713152938e-408),SC_(1.0),SC_(0.e-40)}},
     {{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23574.0),SC_(0.002023261955389159984206469053893655644769),SC_(0.008763296757879097076121904722363852118327),SC_(0.9912367032421209029238780952776361478817)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(24103.0),SC_(1.502246684732592841317797329598945415434e-366),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23909.0),SC_(1.089392278845805508791127031194856769452e-138),SC_(1.0),SC_(0.e-40)}},
     {{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23557.0),SC_(9.957825121836800401583387727523356183938e-6),SC_(0.00002883229031890871323816650314839586412251),SC_(0.9999711677096810912867618334968516041359)}},
     //{{SC_(24162.0),SC_(30197.0),SC_(30916.0),SC_(23936.0),SC_(1.630337789888062205675224945299028404172e-162),SC_(1.0),SC_(0.e-40)}},
     //{{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10705.0),SC_(4.214045751475557604377397079532975048913e-35),SC_(0.999999999999999999999999999999999980825),SC_(1.9175e-35)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10582.0),SC_(0.006534800831460427393593310723134559529149),SC_(0.9658894847256837655400445750384213508154),SC_(0.0341105152743162344599554249615786491846)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10101.0),SC_(5.964481460925906600293895095971574740803e-313),SC_(6.002643903347307383282629300548537979569e-313),SC_(1.0)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10521.0),SC_(0.0003201276134018164345968425589560100704715),SC_(0.001414856594141071402937765727589764302753),SC_(0.9985851434058589285970622342724102356972)}},
     //{{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10794.0),SC_(1.798503936868023925360898291540942571343e-107),SC_(1.0),SC_(0.e-40)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10167.0),SC_(2.21474798565952254789052561462298471985e-210),SC_(2.353519890373409235647877343002777258109e-210),SC_(1.0)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10226.0),SC_(1.723644214696431707714898254406246310588e-147),SC_(1.951895832131084667079719129033853235618e-147),SC_(1.0)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10176.0),SC_(1.32687759331156231792363873935966188326e-199),SC_(1.422254878584869415443690163035370486592e-199),SC_(1.0)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10264.0),SC_(6.680128539884872883498465278631658091013e-115),SC_(7.965521820715383925417088201148941207152e-115),SC_(1.0)}},
     {{SC_(10811.0),SC_(30197.0),SC_(30916.0),SC_(10443.0),SC_(7.641514565676484825234423253217707077378e-20),SC_(1.528376558915782740567832769458233142503e-19),SC_(0.999999999999999999847162344108421725943)}}
  }};
#undef SC_

