#!/usr/bin/perl
# Create jis2000.mys from jis-0213-1.mys and jis-0213-2.mys
# Gaspar Sinai gsinai@yudit.org
# Tokyo 2002-03-07
# The input for this program is 2 files:
# jis-0213-1.mys
# jis-0213-2.mys

print "NAME=shift-jis-0213.mys\n";
print "COMM= Shift_JISX0313 -> Unicode with JIS X 0213 and JIS X 0201\n";
print "COMM= Generated by $0 from jis-0213-1.mys and jis-0213-2.mys\n";
print "COMM= ". `date`;
#
#
#
$men = 0;
@JIS0201=();
while (<DATA>) 
{
  chomp;
  push (@JIS0201, $_ . "\n");
}
while (<>)
{
  chomp;
  # two files are cat here.
 
  next if (/NAME=/);
  if ($men == 0) 
  {
     printf ("%s\n", $_);
  }
  # New file :)
  if (/VALUE_LENGTH=/)
  {
    $men++;
    if ($men ==1)
    {
       print join ('', @JIS0201);
       print "\n";
    }
    print "# MEN 1 of JIS X 0213\n" if ($men ==1);
    print "# MEN 2 of JIS X 0213\n" if ($men ==2);
  } 
  if (/^(....) -> (........)(.*)$/) 
  {
     $jis = hex ($1);
     $unic = hex ($2);
     $comment = $3;
     $sjis = &jis2sjis ($men, $jis);
     die "BAD LINE $men: $_" if ($sjis==0);
     printf ("%04X -> %08X%s\n", $sjis, $unic, $comment);
  }
}
exit (0);

#
# Shift_JISX0213 conversion. 
# Input parameter is jis code
# Returns a Shift_JISX0213 code or zero.
#
sub
jis2sjis 
{
  my ($phex, $jis) = @_;
  my ($m, $k, $t) = ($phex, ($jis>>8)-0x20, ($jis&0xff)-0x20);
  my ($s1, $s2) = (0,0);
  if ($m==1)
  {
    if ($k>=1 && $k<=62)
    {
      $s1 = ($k + 0x101)/2;
    } 
    elsif ($k>=63 && $k<=94)
    {
      $s1 = ($k + 0x181)/2;
    }
    else 
    {
       printf (STDERR "NONJIS kuten=%d\n", $k);
       return (0);
    }
  }
  elsif ($m==2)
  {
    if ($k==1||$k==3||$k==4||$k==5||$k==8||$k==12||$k==13||$k==14||$k==15)
    {
      $s1 = ($k + 0x1df)/2 - (int($k/8)) * 3;
    }
    elsif ($k>=78 && $k<= 94)
    {
      $s1 = ($k + 0x19b)/2;
    }
    else 
    {
       printf (STDERR "NONJIS men=%d kuten=%d JIS=%X\n", $m, $k, $jis);
       return (0);
    }
  }
  else
  {
    printf (STDERR "NONJIS men=%d JIS=%X\n", $m, $jis);
    return (0);
  }
  # odd 
  if (($k%2) == 1)
  {
    $s2 = $t + 0x3f if ($t >= 1 && $t <= 63);
    $s2 = $t + 0x40 if ($t >= 64 && $t <= 94);
  }
  # odd
  else
  {
    $s2 = $t + 0x9e;
  }
  return (($s1 << 8) + $s2);
}
__DATA__
# START JIS 0213
0020 -> 00000020 # SPACE
0021 -> 00000021 # EXCLAMATION MARK
0022 -> 00000022 # QUOTATION MARK
0023 -> 00000023 # NUMBER SIGN
0024 -> 00000024 # DOLLAR SIGN
0025 -> 00000025 # PERCENT SIGN
0026 -> 00000026 # AMPERSAND
0027 -> 00000027 # APOSTROPHE
0028 -> 00000028 # LEFT PARENTHESIS
0029 -> 00000029 # RIGHT PARENTHESIS
002A -> 0000002A # ASTERISK
002B -> 0000002B # PLUS SIGN
002C -> 0000002C # COMMA
002D -> 0000002D # HYPHEN-MINUS
002E -> 0000002E # FULL STOP
002F -> 0000002F # SOLIDUS
0030 -> 00000030 # DIGIT ZERO
0031 -> 00000031 # DIGIT ONE
0032 -> 00000032 # DIGIT TWO
0033 -> 00000033 # DIGIT THREE
0034 -> 00000034 # DIGIT FOUR
0035 -> 00000035 # DIGIT FIVE
0036 -> 00000036 # DIGIT SIX
0037 -> 00000037 # DIGIT SEVEN
0038 -> 00000038 # DIGIT EIGHT
0039 -> 00000039 # DIGIT NINE
003A -> 0000003A # COLON
003B -> 0000003B # SEMICOLON
003C -> 0000003C # LESS-THAN SIGN
003D -> 0000003D # EQUALS SIGN
003E -> 0000003E # GREATER-THAN SIGN
003F -> 0000003F # QUESTION MARK
0040 -> 00000040 # COMMERCIAL AT
0041 -> 00000041 # LATIN CAPITAL LETTER A
0042 -> 00000042 # LATIN CAPITAL LETTER B
0043 -> 00000043 # LATIN CAPITAL LETTER C
0044 -> 00000044 # LATIN CAPITAL LETTER D
0045 -> 00000045 # LATIN CAPITAL LETTER E
0046 -> 00000046 # LATIN CAPITAL LETTER F
0047 -> 00000047 # LATIN CAPITAL LETTER G
0048 -> 00000048 # LATIN CAPITAL LETTER H
0049 -> 00000049 # LATIN CAPITAL LETTER I
004A -> 0000004A # LATIN CAPITAL LETTER J
004B -> 0000004B # LATIN CAPITAL LETTER K
004C -> 0000004C # LATIN CAPITAL LETTER L
004D -> 0000004D # LATIN CAPITAL LETTER M
004E -> 0000004E # LATIN CAPITAL LETTER N
004F -> 0000004F # LATIN CAPITAL LETTER O
0050 -> 00000050 # LATIN CAPITAL LETTER P
0051 -> 00000051 # LATIN CAPITAL LETTER Q
0052 -> 00000052 # LATIN CAPITAL LETTER R
0053 -> 00000053 # LATIN CAPITAL LETTER S
0054 -> 00000054 # LATIN CAPITAL LETTER T
0055 -> 00000055 # LATIN CAPITAL LETTER U
0056 -> 00000056 # LATIN CAPITAL LETTER V
0057 -> 00000057 # LATIN CAPITAL LETTER W
0058 -> 00000058 # LATIN CAPITAL LETTER X
0059 -> 00000059 # LATIN CAPITAL LETTER Y
005A -> 0000005A # LATIN CAPITAL LETTER Z
005B -> 0000005B # LEFT SQUARE BRACKET
005C -> 000000A5 # YEN SIGN
005D -> 0000005D # RIGHT SQUARE BRACKET
005E -> 0000005E # CIRCUMFLEX ACCENT
005F -> 0000005F # LOW LINE
0060 -> 00000060 # GRAVE ACCENT
0061 -> 00000061 # LATIN SMALL LETTER A
0062 -> 00000062 # LATIN SMALL LETTER B
0063 -> 00000063 # LATIN SMALL LETTER C
0064 -> 00000064 # LATIN SMALL LETTER D
0065 -> 00000065 # LATIN SMALL LETTER E
0066 -> 00000066 # LATIN SMALL LETTER F
0067 -> 00000067 # LATIN SMALL LETTER G
0068 -> 00000068 # LATIN SMALL LETTER H
0069 -> 00000069 # LATIN SMALL LETTER I
006A -> 0000006A # LATIN SMALL LETTER J
006B -> 0000006B # LATIN SMALL LETTER K
006C -> 0000006C # LATIN SMALL LETTER L
006D -> 0000006D # LATIN SMALL LETTER M
006E -> 0000006E # LATIN SMALL LETTER N
006F -> 0000006F # LATIN SMALL LETTER O
0070 -> 00000070 # LATIN SMALL LETTER P
0071 -> 00000071 # LATIN SMALL LETTER Q
0072 -> 00000072 # LATIN SMALL LETTER R
0073 -> 00000073 # LATIN SMALL LETTER S
0074 -> 00000074 # LATIN SMALL LETTER T
0075 -> 00000075 # LATIN SMALL LETTER U
0076 -> 00000076 # LATIN SMALL LETTER V
0077 -> 00000077 # LATIN SMALL LETTER W
0078 -> 00000078 # LATIN SMALL LETTER X
0079 -> 00000079 # LATIN SMALL LETTER Y
007A -> 0000007A # LATIN SMALL LETTER Z
007B -> 0000007B # LEFT CURLY BRACKET
007C -> 0000007C # VERTICAL LINE
007D -> 0000007D # RIGHT CURLY BRACKET
007E -> 0000203E # OVERLINE
00A1 -> 0000FF61 # HALFWIDTH IDEOGRAPHIC FULL STOP
00A2 -> 0000FF62 # HALFWIDTH LEFT CORNER BRACKET
00A3 -> 0000FF63 # HALFWIDTH RIGHT CORNER BRACKET
00A4 -> 0000FF64 # HALFWIDTH IDEOGRAPHIC COMMA
00A5 -> 0000FF65 # HALFWIDTH KATAKANA MIDDLE DOT
00A6 -> 0000FF66 # HALFWIDTH KATAKANA LETTER WO
00A7 -> 0000FF67 # HALFWIDTH KATAKANA LETTER SMALL A
00A8 -> 0000FF68 # HALFWIDTH KATAKANA LETTER SMALL I
00A9 -> 0000FF69 # HALFWIDTH KATAKANA LETTER SMALL U
00AA -> 0000FF6A # HALFWIDTH KATAKANA LETTER SMALL E
00AB -> 0000FF6B # HALFWIDTH KATAKANA LETTER SMALL O
00AC -> 0000FF6C # HALFWIDTH KATAKANA LETTER SMALL YA
00AD -> 0000FF6D # HALFWIDTH KATAKANA LETTER SMALL YU
00AE -> 0000FF6E # HALFWIDTH KATAKANA LETTER SMALL YO
00AF -> 0000FF6F # HALFWIDTH KATAKANA LETTER SMALL TU
00B0 -> 0000FF70 # HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
00B1 -> 0000FF71 # HALFWIDTH KATAKANA LETTER A
00B2 -> 0000FF72 # HALFWIDTH KATAKANA LETTER I
00B3 -> 0000FF73 # HALFWIDTH KATAKANA LETTER U
00B4 -> 0000FF74 # HALFWIDTH KATAKANA LETTER E
00B5 -> 0000FF75 # HALFWIDTH KATAKANA LETTER O
00B6 -> 0000FF76 # HALFWIDTH KATAKANA LETTER KA
00B7 -> 0000FF77 # HALFWIDTH KATAKANA LETTER KI
00B8 -> 0000FF78 # HALFWIDTH KATAKANA LETTER KU
00B9 -> 0000FF79 # HALFWIDTH KATAKANA LETTER KE
00BA -> 0000FF7A # HALFWIDTH KATAKANA LETTER KO
00BB -> 0000FF7B # HALFWIDTH KATAKANA LETTER SA
00BC -> 0000FF7C # HALFWIDTH KATAKANA LETTER SI
00BD -> 0000FF7D # HALFWIDTH KATAKANA LETTER SU
00BE -> 0000FF7E # HALFWIDTH KATAKANA LETTER SE
00BF -> 0000FF7F # HALFWIDTH KATAKANA LETTER SO
00C0 -> 0000FF80 # HALFWIDTH KATAKANA LETTER TA
00C1 -> 0000FF81 # HALFWIDTH KATAKANA LETTER TI
00C2 -> 0000FF82 # HALFWIDTH KATAKANA LETTER TU
00C3 -> 0000FF83 # HALFWIDTH KATAKANA LETTER TE
00C4 -> 0000FF84 # HALFWIDTH KATAKANA LETTER TO
00C5 -> 0000FF85 # HALFWIDTH KATAKANA LETTER NA
00C6 -> 0000FF86 # HALFWIDTH KATAKANA LETTER NI
00C7 -> 0000FF87 # HALFWIDTH KATAKANA LETTER NU
00C8 -> 0000FF88 # HALFWIDTH KATAKANA LETTER NE
00C9 -> 0000FF89 # HALFWIDTH KATAKANA LETTER NO
00CA -> 0000FF8A # HALFWIDTH KATAKANA LETTER HA
00CB -> 0000FF8B # HALFWIDTH KATAKANA LETTER HI
00CC -> 0000FF8C # HALFWIDTH KATAKANA LETTER HU
00CD -> 0000FF8D # HALFWIDTH KATAKANA LETTER HE
00CE -> 0000FF8E # HALFWIDTH KATAKANA LETTER HO
00CF -> 0000FF8F # HALFWIDTH KATAKANA LETTER MA
00D0 -> 0000FF90 # HALFWIDTH KATAKANA LETTER MI
00D1 -> 0000FF91 # HALFWIDTH KATAKANA LETTER MU
00D2 -> 0000FF92 # HALFWIDTH KATAKANA LETTER ME
00D3 -> 0000FF93 # HALFWIDTH KATAKANA LETTER MO
00D4 -> 0000FF94 # HALFWIDTH KATAKANA LETTER YA
00D5 -> 0000FF95 # HALFWIDTH KATAKANA LETTER YU
00D6 -> 0000FF96 # HALFWIDTH KATAKANA LETTER YO
00D7 -> 0000FF97 # HALFWIDTH KATAKANA LETTER RA
00D8 -> 0000FF98 # HALFWIDTH KATAKANA LETTER RI
00D9 -> 0000FF99 # HALFWIDTH KATAKANA LETTER RU
00DA -> 0000FF9A # HALFWIDTH KATAKANA LETTER RE
00DB -> 0000FF9B # HALFWIDTH KATAKANA LETTER RO
00DC -> 0000FF9C # HALFWIDTH KATAKANA LETTER WA
00DD -> 0000FF9D # HALFWIDTH KATAKANA LETTER N
00DE -> 0000FF9E # HALFWIDTH KATAKANA VOICED SOUND MARK
00DF -> 0000FF9F # HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
# END JIS 0213
