target=dist1 dist2 dist3

\integer{n=\confparm1=?randint(5..6)}
\integer{n=\confparm1=1?randint(5..6)}
\integer{n=\confparm1=2?randint(7..9)}
\integer{n=\confparm1=3?randint(10..12)}
#if #TARGET (dist1)
 \title{Matrice des distances}
 \author{Romain BOILLAUD}
\email{Romain.Boillaud@wanadoo.fr}
#endif

#if #TARGET (dist2)
\author{Bernadette PERRIN-RIOU}
\email{bpr@math.u-psud.fr}
 \title{Distance maximale}
#endif

#if #TARGET (dist3)
\author{Bernadette PERRIN-RIOU}
\email{bpr@math.u-psud.fr}
 \title{Distance de deux sommets}
#endif

\language{fr}
\range{-30..30}
\computeanswer{no}
\format{html}
\precision{10000}

\integer{m=randint(\n, min(2*\n, \n*(\n-1)/2))}
\text{liste=wims(values 1 for x=1 to \m)}
\text{liste0=wims(values 0 for x=1 to \n*(\n-1)/2 -\m)}
\text{liste=shuffle(\liste,\liste0)}
\text{G=pari(n=\n; liste=[\liste];
M=matrix(n,n,i,j,if(i<j, liste[n*(n-1)/2-(n-i+1)*(n-i)/2 +j-i]));
M=matrix(n,n,i,j,if(i<j,M[i,j],M[j,i]));print(M))}
\text{dessin=slib(graph/draw [\G],blue,blue)}
\matrix{D=slib(graph/distance [\G])}

#if #TARGET (dist1)
\text{diam=pari(vecmax([\D]))}
\text{diam=-1 isin \D ?inf:\diam}
\text{listrep=oui,non}
\text{brep=\diam issametext inf?item(2,\listrep):item(1,\listrep)}
\text{mrep=\diam issametext inf?item(1,\listrep):item(2,\listrep)}

\statement{On considre le graphe reprsent ci-dessous.  
<center> \draw{200,200}{\dessin} </center>
<ul><li>Donner la matrice des distances de ce graphe, c&#39;est--dire la matrice dont le terme situ  l&#39;intersection des \(i)-ime ligne et \(j)-ime colonne est gal  la distance du sommet \(i) au sommet \(j). (les distances infinies sont notes -1.)
</li><li>
En dduire le diamtre du graphe (rpondre "inf" si ce diamtre est infini).
</li><li>
Dire enfin si ce graphe est connexe.
</li></ul>
<p> Consigne : Pour crire la matrice, numrer successivement les coefficients de chaque ligne en les sparant par des virgules, et passer  la ligne  la fin de chaque ligne de la matrice.
}

\answer{Matrice des distances}{\D}{type = matrix}
\answer{Diamtre du graphe}{\diam, inf}{type = function}
\choice{Connexit}{\brep}{\listrep}

#endif

#if #TARGET (dist2)
\text{diam=pari(vecmax([\D]))}
\text{diam=-1 isin \D ?-1:\diam}
\text{test=0}
\for{i = 1 to  \n}{
	\for{j = 1 to \n }{
		\if{\D[\i;\j]=\diam and \test=0}{
			\text{rep1=\i,\j}
			\text{test=1}}
			}}


\statement{On considre le graphe reprsent ci-dessous.  
<center> \draw{200,200}{\dessin} </center>
Donner deux points qui sont  la plus grande distance (ventuellement 
infinie)  sur ce graphe.
}
\answer{Points  distance maximale}{\rep}{type=set}
\text{repa=item(1,\rep)}
\text{repb=item(2,\rep)}
\text{S=\D[\rep[1];\rep[2]] =\diam ? 1:0}
\condition{Points  distance maximale ?}{\S=1}

\feedback{\S=0}{Le diamtre du graphe est \if{\diam =-1}{infinie}{\diam} et les points \rep1[1] et \rep1[2] sont  distance maximale }
#endif 

#if #TARGET (dist3)
\text{diam=pari(vecmax([\D]))}
\text{diam=-1 isin \D ?-1:\diam}
\text{test=0}
\for{i = 1 to  \n}{
	\for{j = 1 to \n }{
		\if{\D[\i;\j]=\diam and \test=0}{
			\text{A=\i}
			\text{rep1=\j}
			\text{test=1}}
			}}


\statement{On considre le graphe reprsent ci-dessous.  
<center> \draw{200,200}{\dessin} </center>
Trouver un point qui est  la plus grande distance du point  \A . 
}
\answer{Point}{\rep}{type=numeric}

\text{S=\D[\A;\rep] =\diam ? 1:0}
\condition{}{\S=1}

\feedback{\S=0}{Un point qui est  la plus grande distance du point  \A est par exemple \rep1. Il est  la distance \if{\diam =-1}{infinie}{\diam}. }
#endif 




